(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*      	Development of Warshall's Algorithm (proof)                  *)
(*									     *)
(*      	Christine Paulin-Mohring                                     *)
(*      	after F. Pfenning                                            *)
(*      	Program Development through Proof Transformation             *)
(*****************************************************************************)

Require Warshall_def.

Lemma build_matrix : (P:V->V->Prop)((x,y:V){(P x y)}+{~(P x y)})->(repr_matrix P).
Goal. 
Red ; Auto.
Save.
Hint build_matrix.

Lemma acces_matrix : (P:V->V->Prop)(repr_matrix P)->(x,y:V){(P x y)}+{~(P x y)}.
Goal. 
Unfold repr_matrix ; Intros P H x y.
Apply (acces [v:V]({(P x v)}+{~(P x v)}) allV) ; Auto.
Apply (acces [v:V](array [v0:V]({(P v v0)}+{~(P v v0)}) allV) allV) ;
   Auto.
Save.
Hint acces_matrix.

(************************************)
(*      New specification           *)
(************************************)

Lemma warshall_rep : (repr_matrix (connected allV)).
Goal. 
Elim finit_V ; Auto.
Save.
Hint warshall_rep.

Theorem warshall2 : (x,y:V){(connected allV x y)}+{~(connected allV x y)}.
Goal. 
Auto.
Save.

Provide Warshall_proof.
