(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(* 	                 						     *)
(*  A tautology checker, following Boyer and Moore : a Computational Logic   *)
(*		               (proof)	   				     *)
(* 	                 						     *)
(*****************************************************************************)
(* 	                 						     *)
(* 	C. Paulin - B. Werner - April 1992				     *)
(* 	                 						     *)
(*****************************************************************************)

Require Tauto_def.

Theorem Norm_prog : (F:IFExpr){G:IFExpr | (Normal G) & (Equiv F G)}.
Goal. 
Intro; Pattern F; Apply IFExpr_norm_rec.
Exists Tr; Auto.
Exists Fa; Auto.
Intro; Exists (Var n); Auto.
Induction 1; Intros nY NormY EquivY.
Exists nY; Auto.
Induction 1; Intros nZ NormZ EquivZ.
Exists nZ; Auto.
Induction 1; Intros nY NormY EquivY.
Induction 1; Intros nZ NormZ EquivZ.
Exists (IfE (Var n) nY nZ); Auto.
Induction 1; Intros nF NormF EquivF.
Exists nF; Trivial.
Apply Equiv_trans with (IfE X (IfE T Y Z) (IfE U Y Z)); Auto.
Save.


Provide Tauto_proof.
