(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                     QUICKSORT for lists (program)                         *)
(*                                                                           *)
(*****************************************************************************)

Require List.
Require Inlist.

(*****************************)
(* A decidable relation on A *)
(*****************************)

Variable   inf : A -> A -> Prop.
Definition sup  [x,y:A]~(inf x y).

Hypothesis inf_sup : (x,y:A){(inf x y)}+{(sup x y)}.
Hypothesis inf_sup_sym : (x,y:A)(sup x y)->(inf y x).
Hypothesis inf_tran : (x,y,z:A)(inf x y)->(inf y z)->(inf x z).

Immediate inf_sup_sym.

Lemma inf_sup_tran : (x,y,z:A)(sup y x)->(inf y z)->(inf x z).
Goal. 
Intros x y z H H0 ; Apply inf_tran with y ; Auto.
Save.

(*****************************)
(* Equivalence of two lists  *)
(*****************************)

Inductive Definition permut : list->list->Prop =
    permut_refl  : (l:list)(permut l l)
   |permut_tran  : (l,m,n:list)(permut l m)->(permut m n)->(permut l n)
   |permut_mil   : (a:A)(l,m:list)
                   (permut (cons a (app l m)) (app l (cons a m)))
   |permut_app   : (l,l',m,m':list)(permut l l')->(permut m m')->
                                   (permut (app l m) (app l' m')).
Hint permut_refl permut_mil permut_app.


(******************************)
(* if l eq m then a:l eq a:m  *)
(******************************)

Lemma permut_cons : (a:A)(l,m:list)(permut l m)->(permut (cons a l) (cons a m)).
Goal. 
	Intros a l m H.
	Change (permut (app (cons a nil) l) (app (cons a nil) m)).
        Auto.
Save.
Hint permut_cons.

(********************************************)
(* if l eq m then (incl l m) and (incl m l) *)
(********************************************)

Lemma permut_in : (m,n:list)(permut m n)->(incl m n).
Goal. 
	Intros m n H ; Elim H ; Auto.
        Intros a l p; Apply incl_cons; Auto.
        Apply incl_app; Auto.
Save.
Immediate permut_in.

Lemma permut_in_sym : (m,n:list)(permut m n)->(incl n m).
Goal. 
	Intros m n H ; Elim H ; Auto.
        Intros a l p; Apply incl_app; Auto.
        Apply incl_cons; Auto.
Save.
Immediate permut_in_sym.

(********************************************************)
(* Each element of a list satisfies a given predicate R *)
(********************************************************)

Section Rlist.

Variable R : A->Prop.

Definition Rlist [l:list](a:A)(In a l)->(R a).

Lemma Rnil : (Rlist nil).
Goal. 
	Red ; Intros a H.
	Elim H.
Save.
Hint Rnil.

Lemma Rcons : (x:A)(l:list)(R x)->(Rlist l)->(Rlist (cons x l)).
Goal. 
	Unfold Rlist ; Simpl ; Intros x l H H0 a H1.
	Elim H1 ; Auto ; Intro H2.
	Elim H2 ; Auto.
Save.
Hint Rcons.

Lemma Rlist_app : (m,n:list)(Rlist m)->(Rlist n)->(Rlist (app m n)).
Goal. 
	Unfold Rlist ; Intros m n H H0 a H1.
	Elim (in_app_or m n a H1) ; Auto.
Save.
Hint Rlist_app.

Lemma Rincl : (m,n:list)(incl m n)->(Rlist n)->(Rlist m).
Goal. 
	Unfold Rlist incl ; Auto.
Save.

End Rlist.

Hint Rnil Rcons Rlist_app.


(*******************************************)
(* particularisation to some predicates    *)
(*******************************************)
(* (inf_list x l) == (inf x a) for a in l  *)
(* (sup_list x l) == (sup x a) for a in l  *)
(* (infl l m) == (inf_list a m) for a in l *)
(*******************************************)

    Definition inf_list [x:A](Rlist (inf x)).
    Definition sup_list [x:A](Rlist (sup x)).
    Definition infl [l,m:list](Rlist [a:A](inf_list a m) l).

Hint Unfold  inf_list sup_list infl.

(**************************************)
(* properties of these relations      *)
(**************************************)

(* l <= nil *)
Lemma infl_nil : (l:list)(infl l nil).
Goal. 
	Unfold infl Rlist ; Auto.
Save.
Hint infl_nil.

(*   (a > m) => (m <= l) => (m <= a:l)  *)
Lemma infl_cons : (a:A)(l,m:list)(sup_list a m)->(infl m l)->(infl m (cons a l)).
Goal. 
	Unfold infl inf_list sup_list Rlist ; Simpl.
	Intros a  l m H H0 a0 H1 a1 H2.
	Elim H2 ; Auto ; Intro H3.
	Elim H3 ; Apply inf_sup_sym ; Auto.
Save.
Hint infl_cons.

(*   (a > m) => (a <= l) => (m <= l) *)
Lemma sup_inf_infl : (a:A)(l,m:list)(sup_list a l)->(inf_list a m)->(infl l m).
Goal. 
       Unfold infl inf_list sup_list Rlist ; Intros a l m H H0 a0 H1 a1 H2.
       Apply inf_sup_tran with a ; Auto.
Save.


(**************************************************)
(* The process of splitting a list into two parts *)
(**************************************************)

Inductive Definition Lem_spec [a:A;l:list] : Set =
    Lem_exist : (l1,l2:list)
    (sup_list a l1)->(inf_list a l2)->(permut l (app l1 l2))
                   ->(lel l1 l)->(lel l2 l)->(Lem_spec a l).


Lemma Splitting : (a:A)(l:list)(Lem_spec a l).
Goal. 
Realizer [a:A][l:list]
                (<Lem_spec>Match l with
		   (Lem_exist a nil nil nil)
                   [a0:A][y:list][H:Lem_spec]
                      (<Lem_spec>let (l1,l2:list) = H in
                           (<Lem_spec>if (inf_sup a a0) then
                              (Lem_exist a (cons a0 y) l1 (cons a0 l2))
			      else
                              (Lem_exist a (cons a0 y) (cons a0 l1) l2)))).
Program_all.
Apply permut_tran with (cons a0 (app l1 l2)) ; Auto.
Simpl ; Auto.
Save.

(**************************************)
(* Definition for a list to be sorted *)
(**************************************)

Inductive Definition sort : list->Prop =
     sort_nil : (sort nil)
   | sort_cons : (a:A)(l:list)(inf_list a l)->(sort l)->(sort (cons a l)).

Hint sort_nil sort_cons.

(************************************)
(* Proof of the induction principle *)
(************************************)

Lemma induction : (l:list)(P:list->Set)
         (P nil)->((a:A)(m:list)((n:list)(lel n m)->(P n))->(P (cons a m)))
         ->(P l).
Goal. 
Intros.
Cut (n:list)(lel n l)->(P n).
Intro H1; Auto.
Realizer (<list->P>Match l with
         	[n:list](eq_rec list nil P H n)
                [a:A][m:list][H1:list->P][n:list]
                     (<P>Match n with
			     H
                             [b:A][p:list][H2:P](H0 b p [no:list](H1 no)))).
Program_all.
Apply lel_trans with y0 ; Auto.
Apply (lel_tail a0 a) ; Auto.
Save.

(***************************)
(* Quicksort development   *)
(***************************)


Lemma sort_append : (l,p:list)(infl l p)->(sort p)->{m:list|(sort m)&(permut (app l p) m)}.
Goal. 
Realizer [l:list](induction l list->(sig2 list) 
		    [p:list](exist2 list p)
                    [a:A][m:list][H:list->list->(sig2 list)][p:list]
                        (<(sig2 list)>Match (Splitting a m) with
                           [l1:list][l2:list]
                             (<(sig2 list)>Match (H l2 p) with
                                [q:list]
                                 (<(sig2 list)>Match (H l1 (cons a q)) with
                                    [r:list](exist2 list r))))).
Program_all.
Apply permut_tran with (app l1 (cons a x)) ; Auto.
Apply permut_tran with (cons a (app l1 x)) ; Auto.
Apply permut_tran with (cons a (app m p)); Auto.
Apply permut_cons.
Apply permut_tran with (app l1 (app l2 p)) ; Auto.
Elim app_ass ; Auto.
Apply infl_cons ; Auto.
Apply (sup_inf_infl a) ; Auto.
Unfold inf_list ; Apply Rincl with (app l2 p) ; Auto.
Apply Rlist_app ; Auto.
Unfold infl in H0.
Unfold Rlist in H0.
Unfold inf_list in H0.
Apply H0; Auto.
Cut (inf_list a x).
Auto.
Unfold inf_list ; Apply Rincl with (app l2 p) ; Auto.
Apply Rlist_app ; Auto.
Unfold infl in H0.
Unfold Rlist in H0.
Unfold inf_list in H0.
Apply H0; Auto.
Unfold infl ; Apply Rincl with (cons a m) ; Auto.
Apply incl_tran with (app l1 l2) ; Auto.
Apply incl_tl; Auto.
Save.


Theorem Quicksort : (l:list){m:list|(sort m) & (permut l m)}.
Goal. 
Realizer [l:list]
          (eq_rec list (app l nil) (sig2 list) (sort_append l nil) l).
Program_all.
Save.

Provide Quick_prog.