(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                     QUICKSORT for lists (proof)                           *)
(*                                                                           *)
(*                      Christine Paulin-Mohring                             *)
(*                                                                           *)
(*****************************************************************************)

Require Quick2_def.

(***************************)
(* Quicksort Setification *)
(***************************)

(**********************)
(* Proof of Quicksort *)
(**********************)

Theorem Quicksort : (l:list){m:list|(sort m)&(permut l m)}.
Goal. 
	Intro l.
	Pattern l; Apply (induction l).
	Exists nil ; Auto.
	Intros a m h ; Elim (Splitting a m) ; Intros l1 l2 s i p l0 l3.
	Elim (h l1 l0) ; Intros x p0 q.
	Elim (h l2 l3) ; Intros x0 p1 q0.
	Exists (mil a x x0).
	Apply sort_mil ; Auto.
	Unfold sup_list ; Apply Rpermut with l1 ; Auto.
	Unfold inf_list ; Apply Rpermut with l2 ; Auto.
	Apply permut_cmil.
	Apply permut_app with l1 l2 ; Auto.
Save.

(* End Quicksort*)

Provide Quick2_proof.
