(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                     QUICKSORT for lists (definitions)                     *)
(*                                                                           *)
(*                        Christine Paulin-Mohring                           *)
(*                                                                           *)
(*****************************************************************************)

Require List.
Require Gt.

(* Chapter Quicksort *)

(*****************************)
(* A decidable relation on A *)
(*****************************)

Variable   inf : A -> A -> Prop.
Definition sup  [x,y:A]~(inf x y).

Hypothesis inf_sup : (x,y:A){(inf x y)}+{(sup x y)}.


(******************************)
(* mil a l m = app l a.m      *)
(******************************)

Definition mil.
Body [a:A][l,m:list](app l (cons a m)) : A->list->list->list.

Lemma mil_app : (a:A)(l,m,n:list)<list>(mil a l (app m n))=(app (mil a l m) n).
Goal.
	Intros.
	Unfold mil.
	Elim (ass_app l (cons a m) n).
	Auto.
Save.

(*****************************)
(* Equivalence of two lists  *)
(*****************************)

Inductive Definition permut : list->list->Prop =
    permut_nil  : (permut nil nil)
   |permut_tran : (l,m,n:list)(permut l m)->(permut m n)->(permut l n)
   |permut_cmil : (a:A)(l,m,n:list)
         (permut l (app m n))->(permut (cons a l) (mil a m n))
   |permut_milc : (a:A)(l,m,n:list)
         (permut (app m n) l)->(permut (mil a m n) (cons a l)).

Hint permut_nil permut_cmil permut_milc.

(******************************)
(* if l eq m then a.l eq a.m  *)
(******************************)


Lemma permut_cons : (a:A)(l,m:list)(permut l m)->(permut (cons a l) (cons a m)).
Goal.
	Intros.
	Change (permut (cons a l) (mil a nil m)).
	Auto.
Save.
Hint permut_cons.

(*****************************)
(* l eq l                    *)
(*****************************)

Lemma permut_refl : (l:list)(permut l l).
Goal.
	Induction l ; Auto.
Save.
Hint permut_refl.

(**********************************)
(* if l eq m then m eq l      *)
(**********************************)

Lemma permut_sym : (l,m:list)(permut l m)->(permut m l).
Goal. 
	Intros l m h1 ; Elim h1 ; Auto.
	Intros l0 m0 n h2 h3 h4 h5.
	Apply permut_tran with m0 ; Auto.
Save.
Immediate permut_sym.


(***************************************************************)
(*  if m1 eq n1  and m2 eq n2 then (app m1 m2) eq (app n1 n2)  *)
(*  and if m eq (app m1 m2) then m eq (app n1 n2)              *)
(***************************************************************)

Lemma permut_app1 : (m1,n1,l:list)(permut m1 n1)->(permut (app l m1) (app l n1)).
Goal. 
	Intros ; Elim l ; Simpl ; Auto.
Save.
Hint permut_app1.

(* A technical lemma *)
Lemma permut_app_mil : (a:A)(l1,m1,l2,m2,n2:list)
     (permut (app l1 m1) (app (app l2 m2) n2))
		-> (permut (app (cons a l1) m1) (app (mil a l2 m2) n2)).
Goal. 
	Intros ; Simpl.
	Elim (mil_app a l2 m2 n2).
	Apply permut_cmil.
	Elim (app_ass l2 m2 n2) ; Auto.
Save.
Hint permut_app_mil.

Lemma permut_app_app : (m1,m2,n1,n2 :list)
     (permut m1 n1)->(permut m2 n2)->(permut (app m1 m2) (app n1 n2)).
Goal. 
	Intros m1 m2 n1 n2 h1 h2.
	Elim h1 ; Intros.
	Exact h2.
	Apply permut_tran with (app m n2) ; Auto.
	Apply permut_tran with (app m m2) ; Auto.
	Auto.
	Apply permut_sym ; Auto.
Save.
Hint permut_app_app.

Lemma permut_app : (m,m1,m2,n1,n2 :list)(permut m1 n1)->(permut m2 n2)->
     (permut m (app m1 m2))->(permut m (app n1 n2)).
Goal. 
	Intros.
	Apply permut_tran with (app m1 m2) ; Auto.
	Save.

(*****************************************************)
(* Each element of a list satisfies a given relation *)
(*****************************************************)

Section Rlist.

Variable R : A->Prop.

Inductive Definition Rlist  : list -> Prop =
    Rnil : (Rlist nil)
   |Rcons : (x:A)(l:list)(R x)->(Rlist l)->(Rlist (cons x l)).

Hint Rnil Rcons.

Lemma Rlist_app : (m,n:list)(Rlist m)->(Rlist n)->(Rlist (app m n)).
Goal. 
	Intros m n h1 h2 ; Elim h1 ; Simpl ; Auto.
Save.
Hint Rlist_app.

Local inverse = [l:list]
    (<Prop> Match l with True [a:A][l:list][H:Prop](R a)/\(Rlist l)).

Section Rlist_cons.

Variable a : A.
Variable l : list.
Hypothesis Rc : (Rlist (cons a l)).

Lemma Rlist_cons : (R a)/\(Rlist l).
Goal. 
    Change (inverse (cons a l)).
    Elim Rc; Simpl; Auto.
Save.

End Rlist_cons.

Section Rlist_append.
Variable n,m : list.

Lemma Rlist_appd : (Rlist (app n m))->((Rlist n)/\(Rlist m)).
Goal. 
Elim n ; Simpl; Auto.
Intros a y h1 h2.
Elim (Rlist_cons a (app y m)) ; Auto.
Intros h3 h4; Elim h1 ; Auto.
Save.

End Rlist_append.
Hint Rlist_appd.

(****************************************)
(* if l eq m then (Rlist l)=>(Rlist m)  *)
(****************************************)

Lemma Rpermut : (m,n:list)(permut m n)->(Rlist m)->(Rlist n).
Goal. 
	Intros m n h1 ; Elim h1 ; Unfold mil ; Auto.
	Intros a l m0 n0 h2 h3 h4.
	Elim (Rlist_cons a l); Auto.
        Intros h5 h6; Elim (Rlist_appd m0 n0); Auto.
	Intros a l m0 n0 h2 h3 h4.
	Elim (Rlist_appd m0 (cons a n0)) ; Auto.
        Intros h5 h6; Elim (Rlist_cons a n0) ; Auto.
Save.

End Rlist.
Hint Rnil Rcons Rlist_app.

Section Inf_Sup.
(******************************************)
(* (inf_list x l) == (inf x a) for a in l *)
(* (sup_list x l) == (sup x a) for a in l *)
(******************************************)

Hypothesis x : A.
Hypothesis l : list.

    Definition inf_list (Rlist (inf x) l).
    Definition sup_list (Rlist (sup x) l).

End Inf_Sup.

Hint Unfold  inf_list sup_list.

(**************************************************)
(* The process of splitting a list into two parts *)
(**************************************************)

Inductive Definition Lem_spec [a:A;l:list] : Set =
    Lem_exist : (l1,l2:list)
    (sup_list a l1)->(inf_list a l2)->(permut l (app l1 l2))
    ->(lel l1 l)->(lel l2 l)->(Lem_spec a l).

Lemma Splitting : (a:A)(l:list)(Lem_spec a l).
Goal. 
	Intros a l ; Elim l.
	Apply Lem_exist with nil nil ; Auto.
	Intros a0 y h.
	Elim h ; Intros l1 l2 s i p l0 l3.
        Elim (inf_sup a a0) ; Intro a1.
	Apply Lem_exist with l1 (cons a0 l2) ; Auto.
        Change (permut (cons a0 y) (mil a0 l1 l2)) ; Auto.
        Apply Lem_exist with (cons a0 l1) l2 ; Simpl ; Auto.
Save.


(**************************************)
(* Definition for a list to be sorted *)
(**************************************)

Inductive Definition sort : list->Prop =
     sort_nil : (sort nil)
   | sort_mil : (a:A)(l,m:list)(sup_list a l)->(inf_list a m)
        ->(sort l)->(sort m)->(sort (mil a l m)).

Hint sort_nil sort_mil.

(************************************)
(* Proof of the induction principle *)
(************************************)

Lemma induction : (l:list)(P:list->Set)
         (P nil)->((a:A)(m:list)((n:list)(lel n m)->(P n))->(P (cons a m)))
         ->(P l).
Goal. 
	Intros l P H H0.
	Cut (n:list)(lel n l)->(P n) ; Auto.
	Elim l.
	Intros n H1 ; Replace n with nil; Auto.
	Induction n ; Auto.
	Intros b l' H2 H3; Apply H0.
	Intros m H4 ; Apply H1.
	Apply lel_trans with l' ; Auto.
	Apply (lel_tail b a) ; Auto.
Save.

Lemma permutapp : (a0:A)(y,l1,l2:list)(permut y (app l1 l2))->(permut (cons a0 y) (app l1 (cons a0 l2))).
Goal. 
Intros.
Exact (permut_cmil a0 y l1 l2 H).
Save.
Hint permutapp.

Lemma sortmil : (a:A)(x,x0,l1,l2:list)(sup_list a l1)->(inf_list a l2)->(sort x)->(sort x0)->(permut l1 x)->(permut l2 x0)->(sort (mil a x x0)).
Goal. 
Intros.
Apply sort_mil ; Auto.
Unfold sup_list ; Apply Rpermut with l1 ; Auto. 
Unfold inf_list ; Apply Rpermut with l2 ; Auto.
Save.
(*Hint sortmil.*)


Lemma permutmil : (a:A)(m,x,x0,l1,l2:list)(permut l1 x)->(permut l2 x0)->(permut m (app l1 l2))->(permut (cons a m) (mil a x x0)).
Goal. 
Intros.
Apply permut_cmil.
Apply permut_app with l1 l2 ; Auto.
Save.
(*Hint permutmil.*)

Definition ltl [l,m:list](gt (length m) (length l)).

Hint Unfold ltl.

Lemma ltl_cons : (a,a0:A)(l1,y:list)(ltl l1 (cons a y))->(ltl l1 (cons a (cons a0 y))).
Goal. 
Unfold ltl; Simpl; Auto.
Save.
Hint ltl_cons.

Lemma ltl_cons_cons : (a,a0:A)(l2,y:list)(ltl l2 (cons a y))->(ltl (cons a0 l2) (cons a (cons a0 y))).
Goal. 
Unfold ltl; Simpl; Auto.
Save.
Hint ltl_cons_cons.

Provide Quick2_def.