(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                    MERGESORT for lists (definitions)                      *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                           Benjamin WERNER                                 *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                      BEWARE : GENERAL RECURSION                           *)
(*                                                                           *)
(*****************************************************************************)

(*  realizes well_founded_recursion by :                                     *)
(*   [x,f](let rec F = [y] (f y  F) in (F x))                                *)

Require List.
Require Inlist.
Require Wf_nat.
Require Gt.

Variable   inf : A -> A -> Prop.

Hypothesis inf_total : (x,y:A){(inf x y)}+{(inf y x)}.
Hypothesis inf_tran : (x,y,z:A)(inf x y)->(inf y z)->(inf x z).
Hypothesis inf_refl : (x:A)(inf x x).

(*******************************)
(* addition of natural numbers *)
(*******************************)

Definition add [n,m:nat](<nat> Match m with 
                               (* O *) n 
                             (* S p *) [p:nat][q:nat](S q)).

Lemma eq_ad_O : (n:nat)(<nat> (add O n)=n).
Goal.
Induction n; Simpl; Auto.
Save.

Hint eq_ad_O.

Lemma sym_add : (n:nat)(m:nat)(<nat>(add n m)=(add m n)).
Goal.
Induction n; Simpl; Auto.
Intros.
Elim (H m).
Elim m; Simpl; Auto.
Save.

Hint sym_add.

Lemma add_ass : (n,m,p:nat)<nat>(add n (add m p))=(add (add n m) p).
Goal.
Induction p; Intros; Simpl; Auto.
Save.

Hint add_ass.

Lemma ass_add : (n,m,p:nat)<nat>(add (add n m) p)=(add n (add m p)).
Goal.
Auto.
Save.

Hint ass_add.

Lemma add_simpl_d : (n,m,p:nat)(<nat>n=m)-><nat>(add n p)=(add m p).
Goal.
Induction p;Intros;Simpl;Auto.
Save.

Hint add_simpl_d.


Lemma add_simpl_g : (n,m,p:nat)(<nat>n=m)-><nat>(add p n)=(add p m).
Goal.
Intros.
Elim (sym_add n p).
Elim (sym_add m p).
Auto.
Save.

Hint add_simpl_g.

Lemma add_simpl : (n,m,p,q:nat)(<nat>n=m)->(<nat>p=q)-><nat>(add n p)=(add m q).
Goal.
Intros.
Elim H.
Elim H0.
Auto.
Save.

Hint add_simpl.

Definition eq_fun [f1:A->nat][f2:A->nat]((a:A)(<nat>(f1 a)=(f2 a))).

Definition fun_add [f1:A->nat][f2:A->nat][a:A](add (f1 a)(f2 a)).

(***************************)
(* Characteristic function *)
(***************************)

Variable carac : A->A->nat.

(**********************)
(* Contents of a list *)
(**********************)

Definition list_content 
   [l:list](<A->nat> Match l with 
     (* nil *) [a:A]O
(* cons a l *) [a:A][l:list][f:A->nat](fun_add (carac a) f)).
(*****************)
(* low for lists *)
(*****************)

Inductive Definition list_Lowert [a:A] : list -> Prop =
      nil_low : (list_Lowert a nil)
    | cons_low : (b:A)(l:list)(inf a b)->(list_Lowert a (cons b l)).

Hint nil_low cons_low.


Definition list_Lowert2 =
   [a:A][l:list](<Prop> Match l with (* nil *) True 
                                (* cons b l *) [b:A][l:list][H:Prop](inf a b)).

Lemma low2_low : (a:A)(l:list)(list_Lowert2 a l)->(list_Lowert a l).
Goal.
Induction l; Simpl; Auto.
Save.

Lemma low_low2 : (a:A)(l:list)(list_Lowert a l)->(list_Lowert2 a l).
Goal.
Induction 1; Intros; Simpl; Auto.
Save.

Lemma lowert_cons_inf : (a,b:A)(l:list)(list_Lowert a (cons b l))->(inf a b).
Goal.
Intros a b l; Exact (low_low2 a (cons b l)).
Save.

Lemma Lowert_cons_cons : (a,b:A)(l,m:list)(list_Lowert a (cons b l))->(list_Lowert a (cons b m)).
Goal.
Intros a b l m H.
Apply cons_low.
Apply lowert_cons_inf with l;Auto.
Save.


(**************************************)
(* definition for a list to be sorted *)
(**************************************)

Inductive Definition sort : list -> Prop =
      nil_sort : (sort nil)
    | cons_sort : (a:A)(l:list)(sort l)->(list_Lowert a l)->(sort (cons a l)).
Hint nil_sort cons_sort.

Definition sort_inv
[l:list](<Prop>Match l with 
     (* nil *) True 
(* cons a l *) [a:A][l:list][H:Prop](sort l)/\(list_Lowert a l)).

Lemma sort_sort_inv : (l:list)(sort l)->(sort_inv l).
Goal.
Induction 1;Simpl;Auto.
Save.

Lemma sort_rec : (P:list->Set)
        (P nil)->
         ((a:A)
           (l:list)(sort l)->(P l)->(list_Lowert a l)->(P (cons a l)))
         ->(y:list)(sort y)->(P y).
Goal.
Induction y; Trivial.
Intros a l Pl Pc; Elim (sort_sort_inv (cons a l)); Auto.
Save.

(****************************)
(* merging two sorted lists *)
(****************************)
Inductive Definition merge_lem [l1:list;l2:list]:Set =
merge_exist : (l:list)(sort l)->
                        (eq_fun(list_content l)
                               (fun_add(list_content l1)
                                       (list_content l2)))->
                            ((a:A)(list_Lowert a l1)->(list_Lowert a l2)->
                                    (list_Lowert a l))->
                                            (merge_lem l1 l2).


Lemma merge : (l1:list)(sort l1)->(l2:list)(sort l2)->(merge_lem l1 l2).
Goal.
Induction 1;Intros.
Apply merge_exist with l2;Auto.
Unfold eq_fun fun_add;Auto.
Elim H3;Intros.
Apply merge_exist with (cons a l);Auto.
Unfold eq_fun fun_add;Auto.
Elim (inf_total a a0);Intros.
Elim (H1 (cons a0 l0)); Intros; Auto.
Apply merge_exist with (cons a l3);Auto.
Simpl; Unfold eq_fun fun_add;Intros.
Elim add_ass.
Apply add_simpl_g.
Exact (e a2).
Intros.
Apply Lowert_cons_cons with l; Auto.
Elim H5;Intros.
Apply merge_exist with (cons a0 l3).
Auto.
Simpl;Unfold eq_fun fun_add;Intros.
Elim (sym_add (list_content l3 a1) (carac a0 a1)).
Elim (sym_add (list_content l0 a1) (carac a0 a1)).
Elim ass_add.
Apply add_simpl_d.
Exact (e a1).
Intros;Apply Lowert_cons_cons with l0; Auto.
Save.


(*****************)
(* list of lists *)
(*****************)
Inductive Definition list_list : Set =
   list_nil : list -> list_list
 | cons_list : list->list_list->list_list.

Hint list_nil cons_list.


Definition Sort = 
  [L:list_list](<Prop>Match L with 
                (* list_nil l *) [l:list](sort l)
             (* cons_list l L *) [l:list][L:list_list][p:Prop]
                                 (p/\(sort l))).

Lemma Sort_Cons : (L:list_list)(l:list)(Sort L)->(sort l)->(Sort (cons_list l L)).
Goal.
Intros;Simpl;Auto.
Save.
Hint Sort_Cons.

Lemma Sort_nil : (l:list)(Sort (list_nil l))->(sort l).
Goal.
Induction 1;Auto.
Save.

Lemma Sort_tl : (l:list)(L:list_list)(Sort(cons_list l L))->(Sort L).
Goal.
Induction 1;Auto.
Save.

Lemma Sort_hd : (l:list)(L:list_list)(Sort(cons_list l L))->(sort l).
Goal.
Induction 1;Auto.
Save.

Hint (*Sort_tl Sort_hd*) Sort_nil.

Definition list_list_content = 
    [ll:list_list] (<A->nat> Match ll with 
       (* list_nil l *) [l:list](list_content l)
    (* cons_list l L *) [l:list][L:list_list][f:A->nat]
                                 (fun_add (list_content l) f)).

Inductive Set single_lem [l:list] =
  ex_single : (L:list_list)
              (Sort L)->(eq_fun (list_content l)(list_list_content L))->
              (single_lem l).

(*Hint ex_single.*)

Lemma split : (l:list)(single_lem l).
Goal.
Induction l.
Apply ex_single with (list_nil nil);Simpl;Auto.
Unfold eq_fun;Simpl;Auto.
Intro; Intro.
Elim y;Intros.
Apply ex_single with (list_nil (cons a nil));Simpl;Auto.
Unfold eq_fun;Simpl;Auto.
Elim H0;Intros.
Apply ex_single with (cons_list (cons a nil) L);Auto.
Simpl.
Unfold eq_fun;Intros;Simpl.
Unfold fun_add;Simpl.Unfold fun_add;Simpl.
Unfold fun_add;Simpl.
Apply add_simpl_g.
Apply (e a1).
Save.


Definition Length 
[ll:list_list](<nat>Match ll with 
      (* list_nil l *) [l:list]O 
   (* cons_list l L *) [l:list][L:list_list][n:nat](S n)).

Definition Lel [L1,L2:list_list](gt (Length L2)(Length L1)).



Inductive Set Single_Lem [L:list_list] =
   Ex_single : (L1:list_list)
               (Sort L1)->
               (Sort L)->
               (eq_fun (list_list_content L1) (list_list_content L))->
               (le (Length L1)(Length L))->
                   (Single_Lem L).


Lemma gt_SSn_n : (n:nat)(gt (S (S n)) n).
Goal.
Auto.
Save.

Lemma constr_list : (L:list_list)(Sort L)->(Single_Lem L).
Goal.
Intro; Pattern L.
Apply (well_founded_induction list_list Lel).
Exact (well_founded_gtof list_list  Length).
Induction x.
Intros l R S.
Apply Ex_single with (list_nil l);Auto.
Unfold eq_fun;Auto.
Induction y;Intros.
Elim merge with l l0; Auto.
Intros l1 Sl1 eql1 ll1; Apply Ex_single with (list_nil l1);Auto.
Apply Sort_hd with (list_nil l0); Auto.
Apply Sort_nil; Apply Sort_tl with l; Auto.
Elim (H1 y0).
Intros L1 SL1 Sy0 eqL1 leL1.
Elim merge with l l0.
Intros l1 Sl1 eql1 ll; Apply Ex_single with (cons_list l1 L1);Simpl;Auto.
Unfold eq_fun fun_add; Intro.
Elim (eqL1 a).
Elim ass_add.
Apply add_simpl_d.
Apply (eql1 a).
Apply Sort_hd with (cons_list l0 y0); Auto.
Apply Sort_hd with y0.
Apply Sort_tl with l; Auto.
Unfold Lel; Simpl; Auto.
Apply Sort_tl with l0.
Apply Sort_tl with l; Auto.
Save.

Lemma mergesort_L :(L:list_list)(Sort L)->
            {l:list|(sort l)&(eq_fun (list_content l) (list_list_content L))}.
Goal.
Intro; Pattern L.
Apply (well_founded_induction list_list Lel).
Exact (well_founded_gtof list_list  Length).
Induction x.
Intros.
Exists l;Auto.
Unfold eq_fun;Simpl;Auto.
Induction y;Intros.
Elim merge with l l0.
Intros.
Exists l1;Auto.
Apply Sort_hd with (list_nil l0); Auto.
Apply Sort_nil.
Apply Sort_tl with l; Auto.
Elim merge with l l0; Intros.
Elim (constr_list y0); Intros.
Elim (H1 (cons_list l1 L1)); Intros.
Exists x0;Auto.
Simpl; Unfold eq_fun fun_add; Intro.
Elim (e0 a).
Elim ass_add.
Replace (add (list_content l a) (list_content l0 a)) with (list_content l1 a).
Exact (q a).
Exact (e a).
Unfold Lel; Simpl.
Apply le_S_gt; Auto.
Auto.
Apply Sort_tl with l0.
Apply Sort_tl with l; Auto.
Apply Sort_hd with (cons_list l0 y0); Auto.
Apply Sort_hd with y0.
Apply Sort_tl with l; Auto.
Save.

Provide Mergesort_def.