(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                      HEAPSORT for lists (definitions)                     *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                           Benjamin WERNER                                 *)
(*                                                                           *)
(*****************************************************************************)

Require List.

Inductive Definition Tree : Set =
      Tree_Leaf : Tree
    | Tree_Node : A -> Tree -> Tree -> Tree.

(*****************************)
(* A decidable relation on A *)
(*****************************)

Variable   inf : A -> A -> Prop.

Hypothesis inf_total : (x,y:A){(inf x y)}+{(inf y x)}.
Hypothesis inf_tran : (x,y,z:A)(inf x y)->(inf y z)->(inf x z).
Hypothesis inf_refl : (x:A)(inf x x).

Hint inf_refl inf_total.

Definition Tree_Lowert
  [a:A][t:Tree](<Prop>Match t with
        (* Tree_Leaf *) True
(* Tree_node b T1 T2 *) [b:A][T1:Tree][H1:Prop][T2:Tree][H2:Prop](inf a b)).

Lemma nil_is_low : (a:A)(Tree_Lowert a Tree_Leaf).
Goal.
Simpl;Auto.
Save.

Lemma node_is_low : (a:A)(b:A)(T1:Tree)(T2:Tree)
     (inf a b)->(Tree_Lowert a (Tree_Node b T1 T2)).
Goal.
Simpl;Auto.
Save.

Hint nil_is_low node_is_low.

Require Plus.

(* Qq lemmes arithmetiques supplementaires *)

Lemma plus_simpl_g : (n,m,p:nat)(<nat>n=m)-><nat>(plus p n)=(plus p m).
Goal.
Induction 1; Trivial.
Save.
Hint plus_simpl_g.

Lemma plus_simpl_d : (n,m,p:nat)(<nat>n=m)-><nat>(plus n p)=(plus m p).
Goal.
Induction 1; Trivial.
Save.
Hint plus_simpl_d.

Lemma plus_simpl : (n,m,p,q:nat)
             (<nat>n=m)->(<nat>p=q)-><nat>(plus n p)=(plus m q).
Goal.
Induction 1; Induction 1; Trivial.
Save.
Hint plus_simpl.


Definition eq_fun [f1:A->nat][f2:A->nat]((a:A)(<nat>(f1 a)=(f2 a))).

Definition fun_plus [f1:A->nat][f2:A->nat][a:A](plus (f1 a)(f2 a)).

(****************************)
(*    The heap property     *)
(****************************)

Inductive Definition is_heap : Tree -> Prop =
      nil_is_heap : (is_heap Tree_Leaf)
    | node_is_heap : (a:A)(T1:Tree)(T2:Tree)
                                (Tree_Lowert a T1)->
                                (Tree_Lowert a T2)->
                                (is_heap T1)->(is_heap T2)->
                                        (is_heap (Tree_Node a T1 T2)).

Hint nil_is_heap node_is_heap.

Definition heap_inv
  [t:Tree](<Prop>Match t with 
      (* Tree_Leaf *) True
(* Tree_node a G D *) [a:A][G:Tree][hG:Prop][D:Tree][hD:Prop]
                      (Tree_Lowert a G)/\(Tree_Lowert a D)
                      /\(is_heap G)/\(is_heap D)).


Lemma is_heap_inv : (T:Tree)(is_heap T)->(heap_inv T).
Goal.
Induction 1;Simpl;Auto.
Save.

Lemma is_heap_rec : (P:Tree->Set)
        (P Tree_Leaf)->
         ((a:A)
           (T1:Tree)
            (T2:Tree)
             (Tree_Lowert a T1)->
              (Tree_Lowert a T2)->
               (is_heap T1)->
                (P T1)->(is_heap T2)->(P T2)->(P (Tree_Node a T1 T2)))
         ->(y:Tree)(is_heap y)->(P y).
Goal.
Induction y; Trivial.
Intros a G PG D PD PN.
Elim (is_heap_inv (Tree_Node a G D)); Trivial.
Induction 2.
Induction 2; Auto.
Save.

Lemma low_trans : (T:Tree)(a:A)(b:A)(inf a b)->(Tree_Lowert b T)->(Tree_Lowert a T).
Goal.
Intro.
Elim T;Intros;Auto.
Simpl.
Apply inf_tran with b;Auto.
Save.
(*Hint low_trans.*)

(**************************)
(* caracteristic function *)
(**************************)

Variable carac : A->A->nat.

Definition content 
   [t:Tree](<A->nat>Match t with 
            (* Tree_Leaf *) [a:A]O
    (* Tree_Node a T1 T2 *) [a:A][T1:Tree][f1:A->nat][T1:Tree][f2:A->nat]
                            (fun_plus f1 (fun_plus f2 (carac a)))).

(****************************)
(* equivalence of two trees *)
(****************************)

Definition equiv_Tree [T1:Tree][T2:Tree]
                        (a:A)(<nat>(content T1 a)=(content T2 a)).



(**********************************)
(* induction principle over trees *)
(**********************************)

Inductive Definition Lem_spec [a:A;T:Tree] : Set =
    Lem_exist : (T1:Tree)(is_heap T1)->
                            (eq_fun (content T1)
                                    (fun_plus (content T)(carac a)))->
                                ((b:A)(inf b a)->(Tree_Lowert b T)->
                                            (Tree_Lowert b T1))->
                                    (Lem_spec a T).
Lemma insert : (T:Tree)(is_heap T)->(a:A)(Lem_spec a T).
Goal.
Induction 1; Intros.
Apply Lem_exist with (Tree_Node a Tree_Leaf Tree_Leaf); Auto.
Simpl;Intros.
Unfold eq_fun; Unfold fun_plus;Auto.
Elim (inf_total a a0);Intros.
Elim (H3 a0);Intros.
Apply Lem_exist with (Tree_Node a T2 T0);Intros.
Apply node_is_heap;Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Intros.
Elim plus_assoc_r.
Elim (plus_sym (content T0 a2)(content T2 a2)).
Elim (plus_assoc_l (content T0 a2)(content T2 a2)(carac a a2)).
Elim (plus_sym (carac a0 a2)
              (plus (content T1 a2) (plus (content T2 a2) (carac a a2)))).
Elim (plus_assoc_r (carac a0 a2)(content T1 a2)(plus (content T2 a2) (carac a a2))).
Apply plus_simpl_d.
Elim (plus_sym (content T1 a2)(carac a0 a2)).
Exact (e a2).
Auto.
Elim (H3 a);Intros.
Apply Lem_exist with (Tree_Node a0 T2 T0);Intros.
Apply node_is_heap;Auto.
Apply low_trans with a;Auto.
Apply t;Auto.
Apply low_trans with a;Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Intros.
Elim plus_assoc_r.
Apply plus_simpl_d.
Elim plus_assoc_r.
Elim (plus_sym (content T2 a1) (content T1 a1)).
Elim plus_assoc_l.
Apply plus_simpl_g.
Exact (e a1).
Auto.
Save.

(**********************)
(* contents of a list *)
(**********************)

Definition list_content 
     [l:list](<A->nat> Match l with 
               (* nil *) [a:A]O
          (* cons a l *) [a:A][l:list][f:A->nat](fun_plus (carac a) f)).

(*******************************)
(* building a heap from a list *)
(*******************************)

Inductive Definition build_heap [l:list] : Set =
heap_exist : (T:Tree)(is_heap T)->(eq_fun (list_content l)(content T))->
                                             (build_heap l).


Lemma list_to_heap : (l:list)(build_heap l).
Goal.
Intro.
Elim l.
Apply (heap_exist nil Tree_Leaf);Auto.
Simpl;Unfold eq_fun;Auto.
Intros.
Elim H.
Intros.
Elim (insert T i a);Intros.
Apply heap_exist with T1;Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Intros.
Rewrite -> (e a0).
Elim (plus_sym (content T a0)(carac a a0)).
Symmetry.
Exact (e0 a0).
Save.

(*****************)
(* low for lists *)
(*****************)

Inductive Definition list_Lowert [a:A] : list -> Prop =
      nil_low : (list_Lowert a nil)
    | cons_low : (b:A)(l:list)(inf a b)->(list_Lowert a (cons b l)).
Hint nil_low cons_low.


Definition list_Lowert2 =
   [a:A][l:list](<Prop> Match l with 
                    (* nil *) True 
               (* cons b l *) [b:A][l:list][H:Prop](inf a b)).

(* #(plus_tac_search "list_Lowert" ("list_Lowert",1,simpl)).  *)

Lemma low2_low : (a:A)(l:list)(list_Lowert2 a l)->(list_Lowert a l).
Goal.
Do 2 Intro.
Elim l;Simpl;Auto.
Save.

Lemma low_low2 : (a:A)(l:list)(list_Lowert a l)->(list_Lowert2 a l).
Goal.
Intros a l p.
Elim p;Intros;Simpl;Auto.
Save.


(**************************************)
(* definition for a list to be sorted *)
(**************************************)

Inductive Definition sort : list -> Prop =
      nil_sort : (sort nil)
    | cons_sort : (a:A)(l:list)(sort l)->(list_Lowert a l)->(sort (cons a l)).
Hint nil_sort cons_sort.

Definition sort_inv
[l:list](<Prop>Match l with 
     (* nil *) True 
(* cons a l *) [a:A][l:list][H:Prop](sort l) /\ (list_Lowert a l)).

Lemma sort_sort_inv : (l:list)(sort l)->(sort_inv l).
Goal.
Induction 1;Simpl;Auto.
Save.

Lemma sort_rec : (P:list->Set)
        (P nil)->
         ((a:A)
           (l:list)(sort l)->(P l)->(list_Lowert a l)->(P (cons a l)))
         ->(y:list)(sort y)->(P y).
Goal.
Induction y; Trivial.
Intros a l Pl Pc; Elim (sort_sort_inv (cons a l)); Auto.
Save.

(****************************)
(* merging two sorted lists *)
(****************************)
Inductive Definition merge_lem [l1:list;l2:list]:Set =
merge_exist : (l:list)(sort l)->
                        (eq_fun(list_content l)
                               (fun_plus(list_content l1)
                                       (list_content l2)))->
                            ((a:A)(list_Lowert a l1)->(list_Lowert a l2)->
                                    (list_Lowert a l))->
                                            (merge_lem l1 l2).


Lemma merge : (l1:list)(sort l1)->(l2:list)(sort l2)->(merge_lem l1 l2).
Goal.
Intros l1 s;Elim s;Intros.
Apply merge_exist with l2;Auto.
Simpl.
Unfold eq_fun fun_plus;Auto.
Elim H2;Intros.
Apply merge_exist with (cons a l);Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Auto.
Elim (inf_total a a0);Intros.
Cut (merge_lem l (cons a0 l0));Auto.
Intro H_mg; Elim H_mg; Intros.
Apply merge_exist with (cons a l3);Auto.
Simpl; Unfold eq_fun; Unfold fun_plus;Intros.
Elim (plus_assoc_l (carac a a2)
                 (list_content l a2) (plus (carac a0 a2) (list_content l0 a2))).

Apply plus_simpl_g.
Exact (e a2).
Intros.
Apply low2_low.
Simpl.
Cut (list_Lowert2 a2 (cons a l)).
Simpl.
Auto.
Apply low_low2.
Assumption.
Elim H4;Intros.
Apply merge_exist with (cons a0 l3).
Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Intros.
Elim (plus_sym (list_content l3 a1) (carac a0 a1)).
Elim (plus_sym (list_content l0 a1) (carac a0 a1)).
Elim (plus_assoc_r (plus (carac a a1) (list_content l a1)) (list_content l0 a1)
                 (carac a0 a1)).
Apply plus_simpl_d.
Exact (e a1).
Intros;Apply low2_low.
Simpl.
Cut (list_Lowert2 a1 (cons a0 l0));Auto.
Apply low_low2.
Assumption.
Save.

(****************************)
(* building the sorted list *)
(****************************)

Inductive Definition flat_lem [T:Tree] : Set =
flat_exist : (l:list)(sort l)->((a:A)(Tree_Lowert a T)->(list_Lowert a l))->
                                  (eq_fun (content T)(list_content l))->
                                     (flat_lem T).


Lemma heap_to_list : (T:Tree)(is_heap T)->(flat_lem T).
Goal.
Intros T h;Elim h;Intros.
Apply flat_exist with nil;Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Auto.
Elim H2;Intros;Elim H4;Intros.
Elim (merge l s l1 s0);Intros.
Apply flat_exist with (cons a l3);Auto.
Simpl;Unfold eq_fun; Unfold fun_plus;Intro.
Elim (plus_sym (list_content l3 a0) (carac a a0)).
Elim (plus_assoc_r (content T1 a0) (content T2 a0) (carac a a0)).
Apply plus_simpl_d.
Replace (list_content l3 a0) 
    with (plus (list_content l a0) (list_content l1 a0)).
Apply plus_simpl.
Exact (e a0).
Exact (e0 a0).
Symmetry.
Exact (e1 a0).
Save.

Provide Heap_def.
