(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                  Floyd's Shorthest Path Algorithm (proof)                 *)
(*                                                                           *)
(*                        E. Fleury ENS Lyon  - July 199O                    *)
(*                                                                           *)
(*****************************************************************************)

Require Floyd_def.

Theorem build_floyd_matrix : (Q:set)((x,y:V)(In F x)->(In F y)->(floyd Q x y))->(floyd_matrix Q).
Goal.
Unfold floyd_matrix; Auto.
Save.
Hint build_floyd_matrix.

Theorem acces_floyd_matrix : (Q:set)(floyd_matrix Q)->((x,y:V)(In F x)->(In F y)->(floyd Q x y)).
Goal.
Unfold floyd_matrix.
Intros Q H x y Fx Fy.
Apply (acces (floyd Q x) F); Auto.
Apply (acces [x:V](array (floyd Q x) F) F); Auto.
Save.
Hint acces_floyd_matrix.

Theorem Floyd_2 : (floyd_matrix F).
Goal.
Apply F_induction; Auto.
Save.
Provide Floyd_proof.
