(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                  Floyd's Shorthest Path Algorithm (program)               *)
(*                                                                           *)
(*****************************************************************************)

Require Plus.
Require Compare.
Require SetTheory.

(* Some arithmetical lemma *)

Lemma lemme1 : (p,q,n,m:nat) (le (plus p q) n)->(le (plus p m) (plus n m)).
Goal.
Intros p q n m H.
Apply le_reg_r.
Apply le_trans with (plus p q); Auto.
Save.

Lemma lemme2 : (p,q,m,n:nat) (le (plus p q) n)->(le (plus p (plus q m)) (plus n m)).
Goal.
Intros p q m H; Elim (plus_assoc_r p q m); Auto.
Save.
Hint lemme2.

(************************************************************************)
(*  On met une relation logique entre deux sommets,                     *)
(*  et il y a une et une seule arete entre deux sommets                *)
(************************************************************************)

Variable E : V->V->nat->Prop.

Axiom Edge_un : (x,y:V) (n,m:nat) (E x y n)->(E x y m)->(<nat> n=m).

(************************************************************************)
(*  Deux sommets sont relies soit par un arc de cout n                  *)
(*  soit par un un arc de cout infini <--> non relies                   *)
(************************************************************************)

Inductive Definition binding [x,y:V] : Set
   = Poids : (n:nat) (E x y n) -> (binding x y)
   | Infini: ((n:nat) ~(E x y n))-> (binding x y).
Hint (*Poids*) Infini.

(************************************************************************)
(*  Pour tout x,y on a binding x y                                      *)
(************************************************************************)

Axiom dec_E : (x,y:V) (binding x y).
Hint dec_E.

(************************************************************************)
(*  Definition d un chemin de cout n entre deux sommets                 *)
(************************************************************************)

Inductive Definition path [W:set;x:V] : V->nat->Set
   = Edge : (y:V) (n:nat) (E x y n) -> (path W x y n)
   | Composed : (y,z:V) (n,m:nat) (path W x y n)->(In W y)->(E y z m)->
                                         (path W x z (plus n m)).
Hint Edge.

(************************************************************************)
(* 	Si path W x y n  &  W incl W' then path W' x y n                    *)
(************************************************************************)


Lemma Path_inclusion : (W,W':set) (x,y:V) (n:nat)(incl W W')->(path W x y n)->(path W' x y n).
Goal.
Realizer [x:V][y:V][n:nat][H0:path]
                       (<path>Match H0 with
			  [y0:V][n0:nat](Edge x y0 n0)
                          [z:V][t:V][m:nat][p:nat][P1:path][P2:path]
				(Composed x z t m p P2)).
Program_all.
(*Apply H; Auto.*)
Save.

(************************************************************************)
(* 	Si path W x y n alors path (W+u) x y n                              *)
(************************************************************************)

Lemma Path_add : (W:set) (x,y,u:V) (n:nat) (path W x y n)->(path (add W u) x y n).
Goal.
Realizer [x:V][y:V][u:V][n:nat][H:path](Path_inclusion x y n H).
Program_all.
Save.
Hint Path_add.

(************************************************************************)
(* 	Si path False x y n alors E x y n                                      *)
(************************************************************************)

Lemma Path_empty : (x,y:V) (n:nat)(path empty x y n)->(E x y n).
Goal.
Intros x y n H.
Elim H; Auto.
Intros z t m p P1 E I; Elim I.
Save.
Immediate Path_empty.

(************************************************************************)
(* 	Si path W x y n et path W y z m et in W y alors path W x z n+m      *)
(************************************************************************)

Lemma Path_transitive : (W:set) (x,y,z:V) (n,m:nat)
     (path W y z m)->(path W x y n)->(In W y)->(path W x z (plus n m)).
Goal.
Realizer [x:V][y:V][z:V][n:nat][m:nat][H:path]
             (<path->path>Match H with
                  [t:V][p:nat][P:path](Composed x y t n p P)
                  [t:V][u:V][p:nat][q:nat][P:path][H0:path->path][P0:path]
                  	(eq_rec nat (plus (plus n p) q) path
                                (Composed x t u (plus n p) q (H0 P0))
                                (plus n (plus p q)))).
Program_all.
Save.


(************************************************************************)
(*  Si path (W+y) x z n alors path W x z n ou                           *)
(*              (path W x y p  &  path W y z q & p+q<=n)                *)
(************************************************************************)

Inductive Definition step [W:set;y,x,z:V;n:nat] : Set
    = Direct : (p:nat) (path W x z p)->(le p n)-> (step W y x z n)
    | Indirect : (p,q:nat) (path W x y p)->(path W y z q)->(le (plus p q) n)->
                 (step W y x z n).

Lemma Step_edge : (W:set) (y,x,z:V) (n:nat) (E x z n)->(step W y x z n).
Goal.
Realizer [x:V][y:V][z:V][n:nat](Direct x y z n n (Edge y z n)).
Program_all.
Save.
Hint Step_edge.

Lemma Path_step : (W:set) (y,x,z:V) (n:nat) (path (add W y)  x z n)->(step W y x z n).
Goal.
Realizer [{W:set}][y:V][x:V][z:V][n:nat][H:path]
            (<step>Match H with
		[y0:V][n0:nat](Step_edge y x y0 n0)
                [t:V][u:V][m:nat][p:nat][P:path][S:step]
                	(<step>Match S with
                               [q:nat][P0:path]
                                 (<step>Match (add_null t y) (: (In (add W y) t)->({(<V>y=t)}+{(In W t)}) :) with
                                    [{H':(<V>y=t)}](eq_rec V t step
                                       (Indirect t x u (plus m p) q p
                                          P0 (Edge t u p))
                                       y)
                                    (Direct y x u (plus m p) (plus q p)
                                       (Composed x t u q p P0)))
                               [r:nat][s:nat][P0:path][P1:path]
                                   (<step>Match (add_null t y) (: (In (add W y) t)->({(<V>y=t)}+{(In W t)}) :) with
                                      (Indirect y x u (plus m p) r p P0
                                         (eq_rec V t path (Edge t u p)
                                            y))
                                      (Indirect y x u (plus m p) r
                                         (plus s p) P0
                                         (Composed y t u s p P1))))).
Program_all.
Apply lemme1 with q ; Auto.
Save.
Hint Path_step.

(************************************************************************)
(*  Setification                                                       *)
(************************************************************************)

Inductive Definition floyd [W:set;x,y:V] : Set 
 = Min_path : (n:nat) (path W x y n)->((m:nat) (path W x y m)->(le n m))->
                      (floyd W x y)
|  No_path : ((n:nat) (path W x y n)->False)->(floyd W x y).

(************************************************************************)
(* On utilise un ensemble F fini de sommets                             *)
(************************************************************************)

Variable F : set.

(* cas de base *)
Lemma floyd_empty : (x,y:V)(floyd empty x y).
Goal.
Realizer [x:V][y:V]
                  (<floyd>Match (dec_E x y) with
                     [n:nat](Min_path x y n (Edge x y n)) 
		     (No_path x y)).
Program_all.
Intros m H; Replace m with n; Auto.
Apply (Edge_un x y); Auto.
Intros; Elim (n n0); Auto.
Save.
Hint floyd_empty.

Lemma floyd_ind : (y:V)(Q:set)(In F y)->(~(In Q y))->
     ((x,z:V)(In F x)->(In F z)->(floyd Q x z))->
      (x,z:V)(In F x)->(In F z)->(floyd (add Q y) x z).
Goal.
Realizer [y:V][H0:V->V->floyd][x:V][z:V]
                  (<floyd>Match (H0 x z) with
                     [n:nat][Pxz:path]
                       (<floyd>Match (H0 x y) with
                          [m:nat][Pxy:path]
                            (<floyd>Match (H0 y z) with
                               [p:nat][Pyz:path]
                                 (<floyd>Match (le_dec n (plus m p)) with
                                    (Min_path x z n
                                       (Path_add x z y n Pxz))
                                    (Min_path x z (plus m p)
                                       (Path_transitive x y z m p
                                          (Path_add y z y p Pyz)
                                          (Path_add x y y m Pxy))))
                               (Min_path x z n (Path_add x z y n Pxz)))
                          (Min_path x z n (Path_add x z y n Pxz)))
                     (<floyd>Match (H0 x y) with
                        [m:nat][Pxy:path]
                          (<floyd>Match (H0 y z) with
                             [p:nat][Pyz:path]
                               (Min_path x z (plus m p)
                                  (Path_transitive x y z m p
                                     (Path_add y z y p Pyz)
                                     (Path_add x y y m Pxy)))
                             (No_path x z))
                        (No_path x z))).
Program_all.
(* (m:nat)(path (add Q y) x z m)->(le n m) *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_trans with (plus n0 n1); Auto.
Apply le_plus_plus; Auto.

(* (m:nat)(path (add Q y) x z m)->(le (plus n0 n1) m) *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Apply le_trans with n ; Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_plus_plus; Auto.

(* (m:nat)(path (add Q y) x z m)->(le n m) *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr Pyzs.
Elim (f s); Auto.

(* (m:nat)(path (add Q y) x z m)->(le n m) *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr.
Elim (f r); Auto.

(* (m:nat)(path (add Q y) x z m)->(le (plus n n0) m) *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Elim (f r); Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_plus_plus; Auto.

(* (n0:nat)(path (add Q y) x z n0)->False *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply (f r); Auto.
Intros r s Pxyr Pyzs le.
Apply (f0 s); Auto.

(* (n:nat)(path (add Q y) x z n)->False *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply (f r); Auto.
Intros r s Pxyr Pyzs le.
Apply (f0 r); Auto.

Save.
Hint floyd_ind.

(* Preuve pour tout ensemble fini par recurrence *)
Axiom F_finit : (enumerate F).

(* the induction principle *)
Lemma F_induction : (P:set->Set)(P empty)->
         ((y:V)(Q:set)(In F y)->(~(In Q y))->(P Q)->(P (add Q y)))
         ->(P F).
Goal.
Realizer [P:Data][Pemp:P]
                  (<(V->P->P)->P>Match F_finit with
		     [H:V->P->P]Pemp
                     [y:V][y0:enumerate][H:(V->P->P)->P][H0:V->P->P]
			(H0 y (H [y1:V][H3:P](H0 y1 H3)))).
Program_all.
Save.

(*********************************************************)
(*  Preuve de Floyd                                      *)
(*********************************************************)

Lemma Floyd_1 : (x,y:V)(In F x)->(In F y)->(floyd F x y).
Goal.
Realizer (F_induction V->V->floyd [x:V][y:V](floyd_empty x y)
               [y:V][H1:V->V->floyd][x:V][y0:V](floyd_ind y H1 x y0)).
Pattern 3 F.
Program_all.
Save.


(************************************)
(*      Arrays on V	            *)
(************************************)

Section Array.
Variable A: V->Set.

Inductive Definition array : set->Set =
    empty_array : (array empty)
   | add_array  : (P:set)(y:V)(A y)->(array P)->(array (add P y)).

End Array.
Hint empty_array add_array.

(***************)
(* Access      *)
(***************)

Lemma acces : (A:V->Set)(P:set)(array A P)->(x:V)(In P x)->(A x).
Goal.
Realizer [A:Data]
           [H:(array A)]
            (<V->A>Match H with
	       [x:V](False_rec A)
	       [{P':set}][y:V][ay:A][Arr:(array A)][accP:V->A][x:V]
  		    (<A>Match (add_null x y) (: (In (add P' y) x)->({(<V>y=x)}+{(In P' x)}) :) with
			(eq_rec V y A ay x)
			(accP x))).

Program_all.
Save.


Lemma acces_F : (A:V->Set)(array A F)->(x:V)(In F x)->(A x).
Goal.
Realizer [A:Data][H:(array A)][x:V](acces A H x).
Program_all.
Save.

(*******************)
(* Initialisation  *)
(*******************)

Lemma array_init : (A:V->Set)((y:V)(In F y)->(A y))->(array A F).
Goal.
Realizer [A:Data](<(V->A)->(array A)>Match F_finit with
                   [H:V->A](empty_array A)
                   [y:V][y0:enumerate][H:(V->A)->(array A)][H0:V->A]
			(add_array A y (H0 y) (H [y1:V](H0 y1)))).
Program_all.
Save.
Hint array_init.

(*********************************************************)
(* Representation de Floyd par une matrice               *)
(*********************************************************)

Definition floyd_matrix [Q:set]
    (array [x:V](array (floyd Q x) F) F).


Theorem build_floyd_matrix : 
       (Q:set)((x,y:V)(In F x)->(In F y)->(floyd Q x y))->(floyd_matrix Q).
Goal.
Realizer [H:V->V->floyd]
           (array_init (array floyd)
               [y:V](array_init floyd [y0:V](H y y0))).
Program_all.
Save.

Theorem acces_floyd_matrix : 
    (Q:set)(floyd_matrix Q)->(x,y:V)(In F x)->(In F y)->(floyd Q x y).
Goal.
Realizer [{Q:set}]
           [H:(array (array floyd))]
           [x,y:V](acces_F floyd 
                     (acces_F (array floyd) H x (:(array (floyd Q x) F):)) y).
Program_all.
Save.

(*Theorem acces_floyd_matrix : 
    (Q:set)(floyd_matrix Q)->(x,y:V)(In F x)->(In F y)->(floyd Q x y).
Goal.
Realizer [H:(array (array floyd))]
           [x,y:V](acces floyd 
                     (acces (array floyd) H x) y).
Program_all.
Save.*)

Theorem Floyd_2 : (floyd_matrix F).
Goal.
Realizer (F_induction floyd_matrix
           (build_floyd_matrix [x:V][y:V](floyd_empty x y))
              [y:V]
                [H1:floyd_matrix]
                 (build_floyd_matrix
                    [x:V]
                     [y0:V]
                      (floyd_ind y
                         [x0:V][z:V](acces_floyd_matrix H1 x0 z) x y0))).
Program_all.
Save.

Provide Floyd_prog.
