(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                  Floyd's Shorthest Path Algorithm (definitions)           *)
(*                                                                           *)
(*                        E. Fleury ENS Lyon  - July 199O                    *)
(*                                                                           *)
(*****************************************************************************)

Require Plus.
Require Compare.
Require SetTheory.

(* Some arithmetical lemma *)

Lemma lemme1 : (p,q,n,m:nat) (le (plus p q) n)->(le (plus p m) (plus n m)).
Goal.
Intros p q n m H.
Apply le_reg_r.
Apply le_trans with (plus p q); Auto.
Save.

Lemma lemme2 : (p,q,m,n:nat) (le (plus p q) n)->(le (plus p (plus q m)) (plus n m)).
Goal.
Intros p q m H; Elim (plus_assoc_r p q m); Auto.
Save.
Hint lemme2.

(************************************************************************)
(*  On met une relation logique entre deux sommets,                     *)
(*  et il y a une et une seule arete entre deux sommets                *)
(************************************************************************)

Variable E : V->V->nat->Prop.

Axiom Edge_un : (x,y:V) (n,m:nat) (E x y n)->(E x y m)->(<nat> n=m).

(************************************************************************)
(*  Deux sommets sont relies soit par un arc de cout n                  *)
(*  soit par un un arc de cout infini <--> non relies                   *)
(************************************************************************)

Inductive Definition binding [x,y:V] : Set
   = Poids : (n:nat) (E x y n) -> (binding x y)
   | Infini: ((n:nat) ~(E x y n))-> (binding x y).
Hint (*Poids*) Infini.

(************************************************************************)
(*  Pour tout x,y on a binding x y                                      *)
(************************************************************************)

Axiom dec_E : (x,y:V) (binding x y).
Hint dec_E.

(************************************************************************)
(*  Definition d un chemin de cout n entre deux sommets                 *)
(************************************************************************)

Inductive Definition path [W:set;x:V] : V->nat->Set
   = Edge : (y:V) (n:nat) (E x y n) -> (path W x y n)
   | Composed : (y,z:V) (n,m:nat) (path W x y n)->(In W y)->(E y z m)->
                                         (path W x z (plus n m)).
Hint Edge.

(************************************************************************)
(* 	Si path W x y n  &  W incl W' then path W' x y n                    *)
(************************************************************************)

Lemma Path_inclusion : (W,W':set) (x,y:V) (n:nat)(incl W W')->(path W x y n)->(path W' x y n).
Goal.
Intros W W' x y n H H0.
Elim H0; Auto.
Intros z t m p P1 P2 I E.
Apply Composed with z; Auto.
(*Apply H; Auto.*)
Save.

(************************************************************************)
(* 	Si path W x y n alors path (W+u) x y n                              *)
(************************************************************************)

Lemma Path_add : (W:set) (x,y,u:V) (n:nat) (path W x y n)->(path (add W u) x y n).
Goal.
Intros W x y u n H.
Apply (Path_inclusion W); Auto.
Save.
Hint Path_add.

(************************************************************************)
(* 	Si path False x y n alors E x y n                                      *)
(************************************************************************)

Lemma Path_empty : (x,y:V) (n:nat)(path empty x y n)->(E x y n).
Goal.
Intros x y n H.
Elim H; Auto.
Intros z t m p P1 E I; Elim I.
Save.
Immediate Path_empty.

(************************************************************************)
(* 	Si path W x y n et path W y z m et in W y alors path W x z n+m      *)
(************************************************************************)

Lemma Path_transitive : (W:set) (x,y,z:V) (n,m:nat)
     (path W y z m)->(path W x y n)->(In W y)->(path W x z (plus n m)).
Goal.
Intros W x y z n m H.
Elim H.
Intros t p E P I.
Apply Composed with y; Auto.
Intros t u p q P H0 I E P0 I0.
Elim (plus_assoc_r n p q).
Apply Composed with t; Auto.
Save.


(************************************************************************)
(*  Si path (W+y) x z n alors path W x z n ou                           *)
(*              (path W x y p  &  path W y z q & p+q<=n)                *)
(************************************************************************)

Inductive Definition step [W:set;y,x,z:V;n:nat] : Set
    = Direct : (p:nat) (path W x z p)->(le p n)-> (step W y x z n)
    | Indirect : (p,q:nat) (path W x y p)->(path W y z q)->(le (plus p q) n)->
                 (step W y x z n).

Lemma Step_edge : (W:set) (y,x,z:V) (n:nat) (E x z n)->(step W y x z n).
Goal.
Intros W x y z n E.
Apply Direct with n; Auto.
Save.
Hint Step_edge.

Lemma Path_step : (W:set) (y,x,z:V) (n:nat) (path (add W y)  x z n)->(step W y x z n).
Goal.
Intros W y x z n H.
Elim H; Auto.
Intros t u m p P S I E.
Elim S.
(* Cas direct *)
Intros q P0 H0.
Elim (add_null W t y); Auto.
(* Cas ou y=t *)
Intro C; Rewrite -> C; Auto.
Apply Indirect with q p; Auto.
(* Cas ou t est dans W *)
Intro C; Apply Direct with (plus q p); Auto.
Apply Composed with t ; Auto.
(* Cas indirect *)
Intros r s P0 P1 L.
Elim (add_null W t y); Auto.
(* Cas ou y=t *)
Intro C.
Apply Indirect with r p; Auto.
Rewrite -> C; Auto.
Apply lemme1 with s ; Auto.
(* Cas ou t est dans W *)
Intro C.
Apply Indirect with r (plus s p); Auto.
Apply Composed with t ; Auto.
Save.
Hint Path_step.

(************************************************************************)
(*  Setification                                                       *)
(************************************************************************)

Inductive Definition floyd [W:set;x,y:V] : Set 
 = Min_path : (n:nat) (path W x y n)->((m:nat) (path W x y m)->(le n m))->
                      (floyd W x y)
|  No_path : ((n:nat) (path W x y n)->False)->(floyd W x y).

(************************************************************************)
(* On utilise un ensemble F fini de sommets                             *)
(************************************************************************)

Variable F : set.

(* cas de base *)
Lemma floyd_empty : (x,y:V)(floyd empty x y).
Goal.
Intros x y.
Elim (dec_E x y).
(* sous cas ou il existe un arete *)
Intros n E.
Apply Min_path with n; Auto.
(* on prouve que cette arete est bien de poids minimum *)
Intros m H; Replace m with n; Auto.
Apply (Edge_un x y); Auto.
(* sous cas ou il n existe pas d arete *)
Intros H; Apply No_path.
Intros n H0; Elim (H n); Auto.
Save.
Hint floyd_empty.

Lemma floyd_ind : (y:V)(Q:set)(In F y)->(~(In Q y))->
     ((x,z:V)(In F x)->(In F z)->(floyd Q x z))->
      (x,z:V)(In F x)->(In F z)->(floyd (add Q y) x z).
Goal.
Intros y Q InFy H H0 x z InFx InFz.
Elim (H0 x z); Trivial.
(* Chemin minimal de x a z de poids n *)
Intros n Pxz minxz.
Elim (H0 x y); Trivial.
(* Chemin minimal de x a y de poids m *)
Intros m Pxy minxy.
Elim (H0 y z); Trivial.
(* Chemin minimal de y a z de poids p *)
Intros p Pyz minyz.
Elim (le_dec n (plus m p)) ; Intro Le.
(*    -cas ou (x y n) est minimum *)
Apply Min_path with n; Auto.
(* on prouve que ce ce chemin est bien minimum ds Q+y *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_trans with (plus m p); Auto.
Apply le_plus_plus; Auto.

(*    -cas ou (x y m)+(y z p) est minimum *)
Apply Min_path with (plus m p).
Apply Path_transitive with y ; Auto.
(* on prouve que ce chemin est bien minimum *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Apply le_trans with n ; Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_plus_plus; Auto.

(* sous cas ou on a 2 chemins (x z n) (x y m) et pas de chemin (y z) *)
(*    -le chemin minimum est (x z n) *)
Intro np; Apply Min_path with n; Auto.
(* on prouve que ce chemin est bien minimum *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr Pyzs.
Elim (np s); Auto.

(* sous cas ou on a 1 chemin (x z n) et pas de chemin (x y) *)
(*    -le chemin minimum est (x z n) *)
Intro np; Apply Min_path with n; Auto.
(* on prouve que ce chemin est bien minimum *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply le_trans with r ; Auto.
Intros r s Pxyr.
Elim (np r); Auto.

(* Cas ou il n'y a pas de chemin de x a z *)
Intro npxz.
Elim (H0 x y); Trivial.
(* Chemin minimal de x a y de poids m *)
Intros m Pxy minxy.
Elim (H0 y z); Trivial.
(* Chemin minimal de y a z de poids p *)
Intros p Pyz minyz.
(*    -le chemin minimum est (x y m)+(y z p) *)
Apply Min_path with (plus m p).
Apply Path_transitive with y ; Auto.
(* on prouve que c est le chemin minimum *)
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Elim (npxz r); Auto.
Intros r s Pxyr Pyzs le.
Apply le_trans with (plus r s); Auto.
Apply le_plus_plus; Auto.
(* Pas de chemin de y a z *)
(*    -pas de chemin minimum *)
Intro npyz.
Apply No_path.
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply (npxz r); Auto.
Intros r s Pxyr Pyzs le.
Apply (npyz s); Auto.
(* Pas de chemin de x a y *)
(*    -pas de chemin minimum *)
Intro npxy.
Apply No_path.
Intros q Padd.
Elim (Path_step Q y x z q Padd).
Intros r P le_rq.
Apply (npxz r); Auto.
Intros r s Pxyr Pyzs le.
Apply (npxy r); Auto.
Save.
Hint floyd_ind.

(* Preuve pour tout ensemble fini par recurrence *)
Axiom F_finit : (enumerate F).

(* the induction principle *)
Lemma F_induction : (P:set->Set)(P empty)->
         ((y:V)(Q:set)(In F y)->(~(In Q y))->(P Q)->(P (add Q y)))
         ->(P F).
Goal.
Intros P Pemp.
Elim F_finit; Auto.
Save.

(*********************************************************)
(*  Preuve de Floyd                                      *)
(*********************************************************)

Lemma Floyd_1 : (x,y:V)(In F x)->(In F y)->(floyd F x y).
Goal.
Pattern 3 F; Apply F_induction; Auto.
Save.


(************************************)
(*      Arrays on V	            *)
(************************************)

Section Array.
Variable A: V->Set.

Inductive Definition array : set->Set =
    empty_array : (array empty)
   | add_array  : (P:set)(y:V)(A y)->(array P)->(array (add P y)).

End Array.
Hint empty_array add_array.

(***************)
(* Access      *)
(***************)

Lemma acces : (A:V->Set)(P:set)(array A P)->(x:V)(In P x)->(A x).
Goal.
Intros A P H; Elim H.
Intros x H0; Elim H0.
Intros P' y ay Arr accP x in_add_x.
Elim (add_null P' x y); Auto.
Intro C; Elim C; Auto.
Save.

Lemma acces_F : (A:V->Set)(array A F)->(x:V)(In F x)->(A x).
Goal.
Intros; Apply acces with F; Auto.
Save.

(*******************)
(* Initialisation  *)
(*******************)

Lemma array_init : (A:V->Set)((y:V)(In F y)->(A y))->(array A F).
Goal.
Intro A ; Elim F_finit ; Auto.
Save.
Hint array_init.

(*********************************************************)
(* Representation de Floyd par une matrice               *)
(*********************************************************)

Definition floyd_matrix [Q:set]
    (array [x:V](array (floyd Q x) F) F).

Provide Floyd_def.

