(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                    Euclidian division (proof)                             *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                        Christine Paulin-Mohring                           *)
(*                                                                           *)
(*****************************************************************************)

Require Euclid_def.

Lemma eucl_dev : (b:nat)(gt b O)->(a:nat)(diveucl a b).
Goal.
Intros b H a; Pattern a; Apply gt_wf_ind; Intros n H0.
Elim (le_gt_dec b n).
Intro lebn.
Elim (H0 (minus n b)); Auto.
Intros q r e g.
Apply divex with (S q) r; Simpl; Auto.
Elim plus_assoc_l.
Elim e; Auto.
Intros gtbn.
Apply divex with O n; Simpl; Auto.
Save.

Lemma quotient : (b:nat)(gt b O)->
     (a:nat){q:nat|<nat>Ex([r:nat](<nat>a=(plus (mult q b) r))/\(gt b r))}.
Goal.
Intros b H a; Pattern a; Apply gt_wf_ind; Intros n H0.
Elim (le_gt_dec b n).
Intro lebn.
Elim (H0 (minus n b)); Auto.
Intros q Hq; Exists (S q).
Elim Hq; Intros r Hr.
Exists r; Simpl; Elim Hr; Intros.
Elim plus_assoc_l.
Elim H1; Auto.
Intros gtbn.
Exists O; Exists n; Simpl; Auto.
Save.

Lemma modulo : (b:nat)(gt b O)->
     (a:nat){r:nat|<nat>Ex([q:nat](<nat>a=(plus (mult q b) r))/\(gt b r))}.
Goal.
Intros b H a; Pattern a; Apply gt_wf_ind; Intros n H0.
Elim (le_gt_dec b n).
Intro lebn.
Elim (H0 (minus n b)); Auto.
Intros r Hr; Exists r.
Elim Hr; Intros q Hq.
Elim Hq; Intros; Exists (S q); Simpl.
Elim plus_assoc_l.
Elim H1; Auto.
Intros gtbn.
Exists n; Exists O; Simpl; Auto.
Save.

Provide Euclid_proof.
