(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*                 Dijkstra's Shorthest Path Algorithm (proof)               *)
(*									     *)
(*			  E. Fleury ENS Lyon  - July 199O                    *)
(*									     *)
(*****************************************************************************)

Require Dijkstra_def.

Theorem proof_dij_spec : (CC:set)(dijkstra CC)->(dij_spec CC).
Goal.
Intros CC H ; Elim H ; Intros.
Cut (x:V) {In CC x} + {In (quo CC) x};Intros.
Cut (x:V)(In CC x)->(connect_s CC allV x).
Intro CC_connect.
Cut (specif CC (quo CC)).
Intro H_sp; Elim H_sp; Intros.
(* on est dans le cas ou pour tout x dans quo CC 
   il n y a pas de chemin de la source a x *)
Apply fin.
Apply dij_Intro;Intros.
Left;Apply Pair_s ; Auto.
Elim (s x);Intro.
Elim a ; Intros.
Apply (connect_incl CC) ; Auto.
Elim b ; Intros.
Apply No_path; Intros.
Elim (decomp CC x n H0 H1); Intros.
Apply (f y m'); Auto.
Apply (f x n); Auto.
(* on est dans le cas ou il exist un x dans quo CC *)
Cut (path_inf allV x n).
Intro pi_allV.
2: Apply (prop_dij CC); Auto.

Apply choose with x ; Auto.
Apply dij_Intro; Intro.
Elim (s x0);Intro H1.
Elim H1; Intros.
Left; Apply Pair_s ; Auto.
Elim H1;Intros.
Elim (eqV x x0) ; Intros.
Left;Apply Pair_s ; Auto.
Apply (eq_spec V x x0) ; Auto.
Apply Min_path with n; Auto.
Right; Apply Pair_s;Auto.
Elim b;Intros.
Elim (dec_E x x0); Intros.
(* Une arete entre x et x0 de poids n1 *)
Apply Min_path with (min n0 (plus n n1)).
(* le chemin depend de la valeur du min *)
Pattern (min n0 (plus n n1)); Apply min_case; Auto.
Apply Composed with x; Auto.
(* preuve de
  (path_inf (add CC x) x0 (min n0 (plus n n1))) *)
Red; Intros.
(* Il y a soit un chemin de source a x0 dans CC de poids <= m 
   soit une arete de x a x0 de poids
p avec n+p <= m *)
Elim (induc_scheme x x0 n m CC); Intros; Auto.
Apply le_trans with q; Auto.
Apply le_trans with n0; Auto.
(*Apply p2; Auto.*)
Replace n1 with q.
Apply le_trans with (plus n q); Auto.
Apply Edge_un with x x0 ; Auto.
(* Il n'y a pas d'arete entre x et x0 *)
Apply Min_path with n0; Auto.
Red;Intros.
Elim (induc_scheme x x0 n m CC); Intros; Auto.
Apply le_trans with q; Auto.
(*Apply p2; Auto.                *)
Absurd (E x x0 q); Auto.
(* cas ou il n'y a pas de chemin entre s et x0 dans CC *)
Elim (dec_E x x0); Intros.
(* s'il y a une arete de x a x0 *)
Apply Min_path with (plus n n0).
Apply Composed with x; Auto.
Red; Intros. 
Elim (induc_scheme x x0 n m CC); Intros; Auto.
Elim (f q); Auto.
Replace n0 with q; Auto.
Apply Edge_un with x x0 ; Auto.
(* s'il n'y a pas d'aretes de x a x0 *)
Apply No_path; Intros.
Elim (induc_scheme x x0 n n1 CC); Intros; Auto.
Apply (f q); Auto.
Absurd (E x x0 q); Auto.
(* preuve de (specif CC (quo CC)) *)
Apply lemme_specif; Intros.
Apply finit; Intros.
Elim (H0 x); Intros; Auto.
Right.
Red;Red;Red;Intro.
Apply H1; Auto.
(* Preuve de  (connect_s CC CC x) *)
Elim (s x); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC x); Auto.*)
Intros; Elim (s x); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC x); Auto.*)
Elim (s x); Intro H2; Elim H2; Intros; Auto.
Save. 

Theorem Dijkstra_final : (dijkstra allV).
Goal.
Apply principe_recurrence.
Apply dij_Intro; Intro.
Right; Apply Pair_s.
Red; Red; Auto.
Elim (dec_E source x); Intros.
Apply Min_path with n; Auto.
Red ; Intros.
Replace m with n ; Auto.
Apply (Edge_un source x) ; Auto.
Apply No_path; Intros.
Absurd (E source x n0); Auto.
Exact proof_dij_spec.
Save.

Theorem dijkstra_res : (x:V)(connect_s allV allV x).
Goal.
Intro.
Elim Dijkstra_final ; Intros.
Elim (s x) ; Intro H ; Elim H ; Auto.
Save.

Inductive Definition NATW : Set = cout : nat -> NATW | inf : NATW.

Theorem Dijkstra_cout : (x:V)NATW.
Goal.
Intro.
Elim (dijkstra_res x) ; Intros.
Apply (cout n).
Apply inf.
Save.

Provide Dijkstra_proof.
