(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*                  Dijkstra's Shorthest Path Algorithm (program)            *)
(*									     *)
(*****************************************************************************)

Require Arith.
Require Wf_nat.
Require Compare.
Require SetTheory.
Hint Unfold incl.
(******************************************************)
(* Definition du et logique entre une Prop et un Set *)
(******************************************************)

Inductive Definition and_s [A:Prop;B:Set] : Set =
    Pair_s : A->B->(and_s A B).
Hint Pair_s.

(*******************************************************)
(* On met une relation decidable entre deux sommets    *)
(* et il y a une et une seule arete entre deux sommets *)
(*******************************************************)

Variable E : V->V->nat->Prop.

Axiom Edge_un : (x,y:V) (n,m:nat) (E x y n)->(E x y m)->(<nat> n=m).


(*********************************************************)
(* Deux sommets sont soit relies par une arete de cout n *)
(* soit par un arc de cout infini                        *)
(*********************************************************)

Inductive Definition binding [x,y:V] : Set
   = Poids : (n:nat) (E x y n) -> (binding x y)
   | Infini: ((n:nat) ~(E x y n))-> (binding x y).
Hint (*Poids*) Infini.

Axiom dec_E : (x,y:V) (binding x y).
Hint dec_E.

(*********************************************)
(* Definition d un chemin entre deux sommets *)
(*********************************************)

Inductive Definition path [W:set;x:V] : V->nat->Set
   = Edge : (y:V) (n:nat) (E x y n) -> (path W x y n)
   | Composed : (y,z:V) (n,m:nat) (path W x y n)->(In W y)->(E y z m)
                                    ->(path W x z (plus n m)).
Hint Edge.

Lemma Path_incl : (W,W':set) (x,y:V) (n:nat) (incl W W')->(path W x y n)->(path W' x y n).
Goal.
Realizer [x:V][y:V][n:nat][H0:path]
                  (<path>Match H0 with
		     [y0:V][n0:nat](Edge x y0 n0)
                     [y0:V][z:V][n0:nat][m:nat][y1:path][H1:path]
			(Composed x y0 z n0 m H1)).
Program_all.
(*Apply H ; Auto.*)
Save.

Lemma Path_incl_add : (W:set)(x,y,z:V)(n:nat)(path W x y n)->(path (add W z) x y n).
Goal.
Realizer [x:V][y:V][z:V][n:nat][H:path](Path_incl x y n H).
Program_all.
Save.
Hint Path_incl_add.

Lemma Path_match : (W:set) (x,z:V) (n:nat) (path W x z n)->(P:Prop) 
     ((E x z n)->P)->
     ((y:V) (m,p:nat) (path W x y m)->(In W y)->(E y z p)->
                                     (<nat>(plus m p)=n)->P)
     ->P.
Goal.
Induction 1 ; Intros.
Apply H0 ; Assumption.
Apply H2 with y n0 m ; Auto.
Save.

(****************************)
(* Axiome d'extensionnalite *)
(****************************)

Axiom Ext : (V,W:set) (incl V W)->(incl W V)->(P:set->Set)(P V)->(P W).

Axiom Ext0 : (V,W:set) (incl V W)->(incl W V)->(P:set->Prop)(P V)->(P W).


(********************************)
(* Definition sur les ensembles *)
(********************************)

Definition soustr.
    Body [Q:set][x,y:V] (In Q y) /\ ~<V>x=y.
    
Definition quo.
    Body [Q:set][y:V] (~(In Q y)).

Definition inter.
    Body [P,Q:set][x:V] (In P x) /\ (In Q x).

Inductive Definition taille : set->nat->Prop
    = vide : (taille empty O)
    | non_vide : (y:V)(m:nat)(M:set)(~(In M y))
                 ->(taille M m)->(taille (add M y) (S m)).
Hint vide.


(* Proprietes de ces definitions *)

Lemma inter_incl_l : (P,Q:set) (incl (inter P Q) P).
Goal.
Red ; Intros P Q x H ; Elim H ; Auto.
Save.

Lemma inter_incl_r : (P,Q:set) (incl (inter P Q) Q).
Goal.
Red ; Intros P Q x H; Elim H ; Auto.
Save.

Lemma inter_intro : (P,Q:set)(x:V)(In P x)->(In Q x)->(In (inter P Q) x).
Goal.
Red;Red;Auto.
Save.
Hint inter_intro.

Lemma In_quo_add : (P:set)(x,y:V)(~<V>x=y)->(In (quo P) y)->(In (quo (add P x)) y).
Goal.
Red;Red;Red;Intros.
Elim H1;Intros.
Absurd (In P y);Auto.
Absurd <V>x=y;Auto.
Save.
Hint In_quo_add.

Lemma lemme_taille_1 : (Q:set) (y:V) (n:nat) (taille Q n)->(In Q y)->~<nat>n=O.
Goal.
Intros Q y n H ; Elim H ; Intros.
Elim H0.
Red ; Intro.
Apply (O_S m) ; Auto.
Save.

Lemma incl_soustr_in : (M:set)(y:V)(In M y)->(incl (soustr M y) M).
Goal.
Red;Intros.
Elim H0; Auto.
Save.
Hint incl_soustr_in.

Lemma incl_soustr : (M,M':set)(y:V)(incl M M')->(incl (soustr M y) (soustr M' y)).
Goal.
Unfold soustr; Red; Red; Intros.
Elim H0;Intros.
Apply conj;Auto.
(*Apply H;Auto.*)
Save.
Hint incl_soustr.

Lemma not_In_soustr : (M:set)(y,z:V)(~(In M y))->~(In (soustr M z) y).
Goal.
Red;Intros.
Elim H0; Intros; Apply H; Auto.
Save.
Hint not_In_soustr.

Lemma not_In_soustr_eq : (M:set)(y:V)~(In (soustr M y) y).
Goal.
Red;Intros.
Elim H; Intros.
Apply H1;Auto.
Save.
Hint not_In_soustr_eq.

Lemma S_pred_m : (m:nat)(~<nat>m=O)-><nat>(S (pred m))=m.
Goal.
Induction m;Simpl;Auto.
Intro ; Absurd <nat>O=O ;Auto.
Save.
Hint S_pred_m.

Lemma incl_soustr_add_l : (M:set)(y:V)(incl (soustr (add M y) y) M).
Goal.
Red; Intros.
Elim H; Intros.
Elim H0; Intros; Auto.
Absurd <V>y=x; Auto.
Save.
Hint incl_soustr_add_l.


Lemma incl_soustr_add_r : (M:set)(y:V)(~(In M y))->(incl M (soustr (add M y) y)). 
Goal.
Red; Intros.
Red;Red.
Apply conj;Auto.
Red;Intro; Absurd (In M x); Auto.
Elim H1; Auto.
Save.
Hint incl_soustr_add_r.

Lemma lemme_taille_2 : (Q:set) (n:nat) (taille Q (S n))->(y:V) (In Q y)->(taille (soustr Q y) n).
Goal.
Intros Q n H.
Replace n with (pred (S n));Try Reflexivity.
Elim H ; Intros.
Elim H0.
Simpl.
Elim H3 ; Intro.
Cut ~<V>y0=y.
Intro;Pattern (soustr (add M y) y0);Apply Ext0 with (add (soustr M y0) y).
Red ; Intros.
Red; Red.
Elim H6 ; Intro.
Elim H7 ; Auto.
Elim H7 ; Auto.
Red ; Intros.
Red; Red.
Unfold In soustr.
Elim H6 ; Intros.
Elim H7 ; Auto.
Replace m with (S(pred m)).
Apply non_vide ; Auto.
Cut ~<nat>m=O;Auto.
Apply (lemme_taille_1 M y0) ; Auto.
Red;Intro;Apply H0.
Elim H5; Auto.
Elim H4.
Pattern (soustr (add M y) y);Apply Ext0 with M;Auto.
Save.
Hint lemme_taille_2.


Lemma add_soustr_2 : (Q:set) (y:V) (In Q y)->(incl Q (add (soustr Q y) y)).
Goal.
Intros.
Red ; Intros.
Red; Red.
Unfold In soustr.
Elim (eqV y x) ; Intro ; Auto.
Save.
Hint add_soustr_2.

Lemma add_soustr_1 : (Q:set) (y:V) (In Q y)->(incl (add (soustr Q y) y) Q).
Goal.
Intros.
Red  ; Intros.
Elim H0 ; Intros.
Elim H1 ; Auto.
Elim H1 ; Assumption.
Save.
Hint add_soustr_1.

Lemma incl_add : (Q,Q':set)(y:V)(incl Q Q')->(incl (add Q y) (add Q' y)).
Goal.
Red;Intros.
Red;Red.
Elim H0; Auto.
(*Intro;Left;Apply H;Auto.*)
Save.
Hint incl_add.

Lemma In_not_In : (Q:set)(x,y:V)(In Q x)->(~(In Q y))->~<V>x=y.
Goal.
Red; Intros.
Apply H0; Elim H1;Auto.
Save.

Lemma not_eq_sym : (x,y:V)(~<V>x=y)->~<V>y=x.
Goal.
Red; Intros.
Apply H; Auto.
Save.
Immediate not_eq_sym.

Lemma In_not_In_sym : (Q:set)(x,y:V)(In Q x)->(~(In Q y))->~<V>y=x.
Goal.
Intros; Apply not_eq_sym; Apply (In_not_In Q); Auto.
Save.

Lemma same_size : (Q:set) (n:nat) (taille Q n)->(Q':set) (taille Q' n)->(incl Q Q')
                      ->(incl Q' Q).
Goal.
Intros Q n H ; Elim H ; Intros.
Red ; Intros.
Absurd <nat>O=O;Auto.
Apply (lemme_taille_1 Q' x) ; Auto.
Cut (In Q' y);Intros.
Pattern Q';Apply Ext0 with (add (soustr Q' y) y);Auto.
Apply incl_add; Apply H2;Auto.
Red; Red; Red; Intros.
Apply conj.
Apply H4; Auto.
Apply (In_not_In_sym M); Auto.
Apply H4; Auto.
Save.

(***************************************)
(* On travaille dans un ensemble fini  *)
(***************************************)

Axiom finit_V : (enumerate allV).

Lemma card_allV : {n:nat|(taille allV n)}.
Goal.
Realizer (<nat>Match finit_V with
		 O
                 [y:V][y0:enumerate][H:nat](S H)).
Program_all.
Apply non_vide ; Auto.
Save.

(**********************************)
(* et on choisit un sommet source *)
(**********************************)

Variable source : V.

(**********************************)
(* definition d un chemin minimum *)
(**********************************)

Definition path_inf.
    Body [W:set][x:V][n:nat]((m:nat) (path W source x m)->(le n m)).

(***********************************************)
(* Definition de la decomposition d'un chemin *)
(***********************************************)

Inductive Definition decomposed [CC:set;m:nat;x:V] : Set =
    decomp_Intro1 : (y:V) (m':nat) (In (quo CC) y)->(path CC source y m')->
                          (le m' m) ->(decomposed CC m x)
  | decomp_Intro2 : (path CC source x m)->(decomposed CC m x).
Hint decomp_Intro2.


Lemma decomp : (CC:set)(x:V)(m:nat)((x:V) {In CC x}+{In (quo CC) x})
                         ->(path allV source x m)->(decomposed CC m x).
Goal.
Realizer [x:V][m:nat][H:V->sumbool][H0:path]
              (<decomposed>Match H0 with
                  [y:V][n:nat](decomp_Intro2 n y (Edge source y n))
                  [y:V][z:V][n:nat][m0:nat][y0:path][H1:decomposed]
                       (<decomposed>Match H1 with
                           [y1:V][m':nat][p:path]
                              (decomp_Intro1 (plus n m0) z y1 m' p)
                           [p:path]
                            (<decomposed>Match (H y) with
                               (decomp_Intro2 (plus n m0) z 
					      (Composed source y z n m0 p))
                               (decomp_Intro1 (plus n m0) z y n p)))).
Program_all.
Save.

(***********************************************)
(* Definition de connection entre deux sommets *)
(* soit il existe un chemin min                 *)
(* soit il n y a pas de chemin                 *)
(***********************************************)

Inductive Definition connect_s [W,W':set;y:V] : Set 
   =  Min_path : (n:nat) (path W source y n)->(path_inf W' y n)
                         ->(connect_s W W' y)
   |  No_path : ((n:nat) (path W' source y n)->False)->(connect_s W W' y).
Hint No_path.

Lemma connect_incl : (W,W',Q:set) (y:V) (incl W W')->(connect_s W Q y)->(connect_s W' Q y).
Goal.
Realizer [y:V][H0:connect_s]
              (<connect_s>Match H0 with
                     [n:nat][p:path](Min_path y n (Path_incl source y n p))
                     (No_path y)).
Program_all.
Save.

Lemma connect_incl_add : (W,Q:set) (x,y:V) (connect_s W Q y)->(connect_s (add W x) Q y).
Goal.
Realizer [x:V][y:V][H:connect_s](connect_incl y H).
Program_all.
Save.
Hint connect_incl_add.
(*********************************************************************)
(* Demonstration de la propriete qui fait marcher l'algo de Dijkstra *)
(*********************************************************************)

Lemma prop_dij : (CC:set)(x:V)(n:nat)((x:V) {In CC x}+{In (quo CC) x})->
     (path CC source x n)->(path_inf CC x n)
     ->((y:V)(In (quo CC) y)->(path_inf CC y n))->(path_inf allV x n).
Goal.
Unfold path_inf; Intros.
Elim (decomp CC x m H H3); Intros;Auto.
Apply le_trans with m';Auto.
Apply (H2 y) ; Auto.
Save.

(*****************************)
(* Setification de dijkstra *)
(*****************************)

Inductive Definition specif [CC,P:set] : Set
    = path_end : ((x:V)(n:nat) (In P x)->(path CC source x n)->False)->(specif CC P)
    | path_min : (x:V)(n:nat)(In P x)->(path CC source x n)->
                      ((y:V) (In P y)->(path_inf CC y n))->(specif CC P).
Hint path_end.

Lemma lemme_specif : (CC,P:set) (enumerate P)->((x:V) (In P x)->(connect_s CC CC x))
     ->(specif CC P).
Goal.
Realizer [H:enumerate](<(V->connect_s)->specif>Match H with
                     [H0:V->connect_s]path_end
                     [y:V][y0:enumerate][H0:(V->connect_s)->specif]
			[H1:V->connect_s]
                         (<specif>Match (H0 [x:V](H1 x)) with
                            (<specif>Match (H1 y) with
                               [n0:nat][p:path](path_min y n0 p)
                               path_end)
                            [x:V][n0:nat][p:path]
                               (<specif>Match (H1 y) with
                                  [n1:nat][p1:path]
                                    (<specif>Match (le_dec n0 n1) with
                                       (path_min x n0 p)
                                       (path_min y n1 p1))
                                  (path_min x n0 p)))).
Program_all.
(* (y1:V)(In (add Q y) y1)->(path_inf CC y1 n0) *)
Intros; Elim H2; Intro.
Red; Intros.
Elim (f y1 m); Auto.
Elim H3 ; Auto.

(* (x:V)(n0:nat)(In (add Q y) x)->(path CC source x n0)->False *)
Intros; Elim H2; Intro.
Apply (f x n0) ; Auto.
Apply (f0 n0).
Rewrite -> H4 ; Auto.

(* (y1:V)(In (add Q y) y1)->(path_inf CC y1 n0) *)
Intros; Elim H2; Intro; Auto.
Elim H3; Red; Intros.
Apply le_trans with n1; Auto.
(*Apply p2; Auto.*)

(* (y1:V)(In (add Q y) y1)->(path_inf CC y1 n1) *)
Intros; Elim H2; Intro.
Red; Intros.
Apply le_trans with n0 ; Auto.
Apply (p0 y1 H3) ; Auto.
Elim H3 ; Auto.

(* (y1:V)(In (add Q y) y1)->(path_inf CC y1 n0) *)
Intros; Elim H2; Intro; Auto.
Elim H3; Red; Intros.
Elim (f m); Auto.

Save.

(**************************)
(* Definition de Dijkstra *)
(**************************)

Inductive Definition dijkstra [CC:set] : Set =
    dij_Intro : 
    ((x:V) ((and_s (In CC x) (connect_s CC allV x))
           +(and_s (In (quo CC) x) (connect_s CC CC x))))
    ->(dijkstra CC).

Inductive Definition specification [P:set->Set;C:set] : Set
    = ends : (P allV)->(specification P C)
    | chooses : (y:V)(In (quo C) y)->(P (add C y))->(specification P C).

Definition dij_spec (specification dijkstra).

Definition  fin (ends dijkstra).
Definition choose (chooses dijkstra).

(* Un sous-ensemble decidable d'un ens. fini est fini *)

Axiom Ext_allV : (W:set) (incl (inter allV W) W)->(incl W (inter allV W))->(P:set->Set)(P (inter allV W))->(P W).

Lemma finit : (P:set) ((x:V) {In P x}+{In (quo P) x})->(enumerate P).
Goal.
Realizer [H:V->sumbool]
           (Ext_allV enumerate
              (<enumerate>Match finit_V with
		(Ext enumerate enu_empty)
                 [y:V][y0:enumerate][H0:enumerate]
                    (<enumerate>if (H y) then
                       (Ext enumerate (enu_add y H0))
                       else (Ext enumerate H0)))).
Program_all.

(*  (incl (inter allV P) P) *)
Apply inter_incl_r.

(*(*  (incl P (inter allV P)) *)
Red ; Red; Red ;Intros. 
Auto.*)

(*  (incl (inter empty P) empty) *)
Red ; Red; Red ;Intros.
Elim H0.
Auto.

(*  (incl (add (inter Q P) y) (inter (add Q y) P)) *)
Red ; Red; Red ;Intros.
Elim H1 ; Intros.
Elim H2 ; Auto.
Elim H2 ; Auto.

(*  (incl (inter (add Q y) P) (add (inter Q P) y)) *)
Red ; Red; Red ;Intros.
Elim H1 ; Intros.
Elim H2 ; Auto.

(*  ~(In (inter Q P) y) *)
Red ; Intro.
Elim H1 ; Intros.
Apply n ; Auto.

(*  (incl (inter Q P) (inter (add Q y) P)) *)
Red ; Intros.
Elim H1 ; Auto.

(*  (incl (inter (add Q y) P) (inter Q P)) *)
Red ; Intros.
Elim H1 ; Intros.
Elim H2 ; Intros ; Auto.
Absurd (In P x);Auto.
Elim H4; Auto.
Save.
(* Le schema de preuve utilise : *)

Section Induc_scheme.
Variables x,y :V.
Variables n,m,p:nat.
Variable Q : set.

Inductive Definition Dec_add : Prop =
   Dec_add_direct : (q:nat)(path Q source y q)->(le q p)->Dec_add
 | Dec_add_edge : (q:nat)(E x y q)->(le (plus n q) p)->Dec_add.

Lemma induc_scheme : (path_inf allV x n)->((z:V)(In Q z)->(connect_s Q allV z))
     ->(path (add Q x) source y p)->Dec_add.
Goal.
Intros.
Apply (Path_match (add Q x) source y p H1); Intros.
Apply (Dec_add_direct p); Auto.
Elim H3; Intros.
Elim (H0 y0 H6).
Intros q H7 H8.
Apply (Dec_add_direct (plus q p0));Intros.
Apply Composed with y0; Auto.
Elim H5; Apply le_reg_r.
Apply H8.
Apply (Path_incl (add Q x)); Auto.
Intro H7.
Elim (H7 m).
Apply (Path_incl (add Q x)); Auto.
Apply (Dec_add_edge p0).
Rewrite -> H6; Auto.
Elim H5; Apply le_reg_r.
Apply H.
Rewrite -> H6; Auto.
Apply (Path_incl (add Q x)); Auto.
Save.
End Induc_scheme.
Hint induc_scheme.
     
Inductive Definition specif' [P:set->Set;n:nat] : Set
    = all : (P allV)->(specif' P n)
    | part : (C:set)(taille C n)->(P C)->(specif' P n).


Lemma principe_recurrence : (P:set->Set) (P empty)->((C:set) (P C)->(specification P C))->(P allV).
Goal.
Realizer [P:Data][H:P][H0:P->(specification P)]
   (<P>let (x:nat) = card_allV in
	(<P>Match (nat_rec (specif' P) (part P O H)
             [y:nat][H1:(specif' P)]
               (<(specif' P)>Match H1 with
		  [p:P](all P (S y) p)
                  [p:P](<(specif' P)>Match (H0 p) with
                      		[p0:P](all P (S y) p0)
                      		[y0:V][p0:P](part P (S y) p0))) x) with
		[p0:P]p0 
		[p0:P](Ext P p0))).
Program_all.
Apply same_size with x ; Auto.
Apply non_vide ; Auto.
Save.

Lemma Path_empty : (x,y:V) (n:nat)(path empty x y n)->(E x y n).
Goal.
Intros.
Elim H; Intros; Auto.
Elim i.
Save.
Hint Path_empty.


Theorem proof_dij_spec : (CC:set)(dijkstra CC)->(dij_spec CC).
Goal.

Realizer 
  [{CC:set}][H:dijkstra]
  (<dij_spec>Match H with 
(* dij_Intro *)
  [s:V->(connect_s+connect_s)]
   (<dij_spec>Match 
      (lemme_specif 
         (finit [x:V](<sumbool>Match (s x) with 
                      (* inl *) [H2:connect_s]right
                      (* inr *) [H2:connect_s]left))
         [x:V](<connect_s>Match (s x) with 
                (* inl *) [H2:connect_s](False_rec connect_s)
                (* inr *) [H2:connect_s]H2))
         (:(specif CC (quo CC)):) with
(* path_end *)
  (fin (dij_Intro 
           [x:V](inl connect_s connect_s
                     (<connect_s>Match (s x) with
                        (* inl *) [a:connect_s](connect_incl x a)
                        (* inr *) [b:connect_s](No_path x)))))
(* path_min *)
   [x:V][n:nat][p:path]
     (choose x
       (dij_Intro
         [x0:V]
         (<connect_s+connect_s>Match (s x0) with
   (* inl *) [H1:connect_s]
                (inl connect_s connect_s (connect_incl_add x x0 H1))
   (* inr *) [H1:connect_s]
                 (<connect_s+connect_s>Match (eqV x x0) with
                 (* left *) 
                    (inl connect_s connect_s
                         (eq_spec V x x0 connect_s
                            (Min_path x n (Path_incl_add source x x n p))))
                 (* right *) 
                    (inr connect_s connect_s
                          (<connect_s>Match H1 with
                   (* Min_path *)
                      [n0:nat][p1:path]
                       (<connect_s>Match (dec_E x x0) with
                          (* Poids *)
                             [n1:nat]
                              (Min_path x0 (min n0 (plus n n1))
                                 (min_case n0 (plus n n1) path
                                      (Path_incl_add source x0 x n0 p1)
                                      (Composed source x x0 n n1
                                              (Path_incl_add source x x n p))))
                         (* Infini *)
                            (Min_path x0 n0 (Path_incl_add source x0 x n0 p1)))
                   (* No_path *)
                    (<connect_s>Match (dec_E x x0) with 
                          (* Poids *) 
                           [n0:nat](Min_path x0 (plus n n0)
                                    (Composed source x x0 n n0
                                      (Path_incl_add source x x n p)))
                    (* Infini *) (No_path x0)))))))))).
Program_all.

(* (n:nat)(path allV source x n)->False *)
Intros.
Elim (decomp CC x n); Intros.
Apply (f y m'); Auto.
Apply (f x n); Auto.
Elim b; Auto.
Elim (s x0); Intro H2; Elim H2; Auto.
Assumption.


Apply (prop_dij CC) ; Auto.
Intro; Elim (s x1); Intro H2; Elim H2; Auto.

Red; Intros.
Elim (induc_scheme x x0 n m CC); Intros; Trivial.
Apply le_trans with q; Auto.
Apply le_trans with n0; Auto.
(*Apply p2; Auto.*)
Replace n1 with q.
Apply le_trans with (plus n q); Auto.
Apply Edge_un with x x0 ; Auto.
Apply (prop_dij CC) ; Auto.
Intro; Elim (s x1); Intro H2; Elim H2; Auto.
Elim (s z); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC z); Auto.*)


Red; Intros.
Elim (induc_scheme x x0 n m CC); Intros; Trivial.
Apply le_trans with q; Auto.
(*Apply p2; Auto.                *)
Absurd (E x x0 q); Auto.
Apply (prop_dij CC) ; Auto.
Intro; Elim (s x1); Intro H2; Elim H2; Auto.
Elim (s z); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC z); Auto.*)

Red; Intros. 
Elim (induc_scheme x x0 n m CC); Intros; Trivial.
Elim (f q); Auto.
Replace n0 with q; Auto.
Apply Edge_un with x x0 ; Auto.
Apply (prop_dij CC) ; Auto.
Intro; Elim (s x1); Intro H2; Elim H2; Auto.
Elim (s z); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC z); Auto.*)

Intros; Elim (induc_scheme x x0 n n1 CC); Intros; Trivial.
Apply (f q); Auto.
Absurd (E x x0 q); Auto.
Apply (prop_dij CC) ; Auto.
Intro; Elim (s x1); Intro H2; Elim H2; Auto.
Elim (s z); Intro H2; Elim H2; Intros; Auto.
(*Absurd (In CC z); Auto.*)

Red;Red;Red;Intro.
Elim a; Intros.
Absurd (In CC x); Auto.
Elim b; Auto.
Elim a; Intros.
Absurd (In CC x); Auto.

Save.


Theorem Dijkstra_final : (dijkstra allV).
Goal.
Realizer (principe_recurrence dijkstra
                      (dij_Intro
                         [x:V]
                          (inr connect_s connect_s
                                (<connect_s>Match (dec_E source x) with
                                   [n:nat]
                                    (Min_path x n (Edge source x n))
                                   (No_path x))))
                      proof_dij_spec).
Program_all.
Red; Red; Auto.
Red; Intros.
Replace m with n; Auto.
Apply (Edge_un source x); Auto.
Red; Red; Auto.
Intros.
Absurd (E source x n0); Auto.
Save.

Theorem dijkstra_res : (x:V)(connect_s allV allV x).
Goal.
Realizer [x:V](<connect_s>Match Dijkstra_final with
                     [s:V->(connect_s+connect_s)]
                      (<connect_s>Match (s x) with
                         [H:connect_s]H
                         [H:connect_s]H)).
Program_all.
Save.


Provide Dijkstra_prog.
