(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*                Dijkstra's Shorthest Path Algorithm (definitions)          *)
(*									     *)
(*			  E. Fleury ENS Lyon  - July 199O                    *)
(*									     *)
(*****************************************************************************)

Require Plus.
Require Compare.
Require SetTheory.


(******************************************************)
(* Definition du et logique entre une Prop et un Set *)
(******************************************************)

Inductive Definition and_s [A:Prop;B:Set] : Set =
    Pair_s : A->B->(and_s A B).
Hint Pair_s.

(*******************************************************)
(* On met une relation decidable entre deux sommets    *)
(* et il y a une et une seule arete entre deux sommets *)
(*******************************************************)

Variable E : V->V->nat->Prop.

Axiom Edge_un : (x,y:V) (n,m:nat) (E x y n)->(E x y m)->(<nat> n=m).


(*********************************************************)
(* Deux sommets sont soit relies par une arete de cout n *)
(* soit par un arc de cout infini                        *)
(*********************************************************)

Inductive Definition binding [x,y:V] : Set
   = Poids : (n:nat) (E x y n) -> (binding x y)
   | Infini: ((n:nat) ~(E x y n))-> (binding x y).
Hint (*Poids*) Infini.

Axiom dec_E : (x,y:V) (binding x y).
Hint dec_E.

(*********************************************)
(* Definition d un chemin entre deux sommets *)
(*********************************************)

Inductive Definition path [W:set;x:V] : V->nat->Set
   = Edge : (y:V) (n:nat) (E x y n) -> (path W x y n)
   | Composed : (y,z:V) (n,m:nat) (path W x y n)->(In W y)->(E y z m)
                                    ->(path W x z (plus n m)).
Hint Edge.

Lemma Path_incl : (W,W':set) (x,y:V) (n:nat) (incl W W')->(path W x y n)->(path W' x y n).
Goal.
Induction 2 ; Intros ; Auto.
Apply Composed with y0 ; Auto.
(*Apply H ; Auto.*)
Save.

Lemma Path_incl_add : (W:set)(x,y,z:V)(n:nat)(path W x y n)->(path (add W z) x y n).
Goal.
Intros; Apply (Path_incl W); Auto.
Save.
Hint Path_incl_add.

Lemma Path_match : (W:set) (x,z:V) (n:nat) (path W x z n)->(P:Prop) 
     ((E x z n)->P)->
     ((y:V) (m,p:nat) (path W x y m)->(In W y)->(E y z p)->
                                     (<nat>(plus m p)=n)->P)
     ->P.
Goal.
Induction 1 ; Intros.
Apply H0 ; Assumption.
Apply H2 with y n0 m ; Auto.
Save.

(****************************)
(* Axiome d'extensionnalite *)
(****************************)

Axiom Ext : (V,W:set) (incl V W)->(incl W V)->(P:set->Set)(P V)->(P W).

Axiom Ext0 : (V,W:set) (incl V W)->(incl W V)->(P:set->Prop)(P V)->(P W).


(********************************)
(* Definition sur les ensembles *)
(********************************)

Definition soustr.
    Body [Q:set][x,y:V] (In Q y) /\ ~<V>x=y.
    
Definition quo.
    Body [Q:set][y:V] (~(In Q y)).

Definition inter.
    Body [P,Q:set][x:V] (In P x) /\ (In Q x).

Inductive Definition taille : set->nat->Prop
    = vide : (taille empty O)
    | non_vide : (y:V)(m:nat)(M:set)(~(In M y))
                 ->(taille M m)->(taille (add M y) (S m)).
Hint vide.


(* Proprietes de ces definitions *)

Lemma inter_incl_l : (P,Q:set) (incl (inter P Q) P).
Goal.
Red ; Intros P Q x H ; Elim H ; Auto.
Save.

Lemma inter_incl_r : (P,Q:set) (incl (inter P Q) Q).
Goal.
Red ; Intros P Q x H; Elim H ; Auto.
Save.

Lemma inter_intro : (P,Q:set)(x:V)(In P x)->(In Q x)->(In (inter P Q) x).
Goal.
Red;Red;Auto.
Save.
Hint inter_intro.

Lemma In_quo_add : (P:set)(x,y:V)(~<V>x=y)->(In (quo P) y)->(In (quo (add P x)) y).
Goal.
Red;Red;Red;Intros.
Elim H1;Intros.
Absurd (In P y);Auto.
Absurd <V>x=y;Auto.
Save.
Hint In_quo_add.

Lemma lemme_taille_1 : (Q:set) (y:V) (n:nat) (taille Q n)->(In Q y)->~<nat>n=O.
Goal.
Intros Q y n H ; Elim H ; Intros.
Elim H0.
Red ; Intro.
Apply (O_S m) ; Auto.
Save.

Lemma incl_soustr_in : (M:set)(y:V)(In M y)->(incl (soustr M y) M).
Goal.
Red;Intros.
Elim H0; Auto.
Save.
Hint incl_soustr_in.

Lemma incl_soustr : (M,M':set)(y:V)(incl M M')->(incl (soustr M y) (soustr M' y)).
Goal.
Unfold soustr; Red; Red; Intros.
Elim H0;Intros.
Apply conj;Auto.
(*Apply H;Auto.*)
Save.
Hint incl_soustr.

Lemma not_In_soustr : (M:set)(y,z:V)(~(In M y))->~(In (soustr M z) y).
Goal.
Red;Intros.
Elim H0; Intros; Apply H; Auto.
Save.
Hint not_In_soustr.

Lemma not_In_soustr_eq : (M:set)(y:V)~(In (soustr M y) y).
Goal.
Red;Intros.
Elim H; Intros.
Apply H1;Auto.
Save.
Hint not_In_soustr_eq.

Lemma S_pred_m : (m:nat)(~<nat>m=O)-><nat>(S (pred m))=m.
Goal.
Induction m;Simpl;Auto.
Intro ; Absurd <nat>O=O ;Auto.
Save.
Hint S_pred_m.

Lemma incl_soustr_add_l : (M:set)(y:V)(incl (soustr (add M y) y) M).
Goal.
Red; Intros.
Elim H; Intros.
Elim H0; Intros; Auto.
Absurd <V>y=x; Auto.
Save.
Hint incl_soustr_add_l.


Lemma incl_soustr_add_r : (M:set)(y:V)(~(In M y))->(incl M (soustr (add M y) y)). 
Goal.
Red; Intros.
Red;Red.
Apply conj;Auto.
Red;Intro; Absurd (In M x); Auto.
Elim H1; Auto.
Save.
Hint incl_soustr_add_r.

Lemma lemme_taille_2 : (Q:set) (n:nat) (taille Q (S n))->(y:V) (In Q y)->(taille (soustr Q y) n).
Goal.
Intros Q n H.
Replace n with (pred (S n));Try Reflexivity.
Elim H ; Intros.
Elim H0.
Simpl.
Elim H3 ; Intro.
Cut ~<V>y0=y.
Intro;Pattern (soustr (add M y) y0);Apply Ext0 with (add (soustr M y0) y).
Red ; Intros.
Red; Red.
Elim H6 ; Intro.
Elim H7 ; Auto.
Elim H7 ; Auto.
Red ; Intros.
Red; Red.
Unfold In soustr.
Elim H6 ; Intros.
Elim H7 ; Auto.
Replace m with (S(pred m)).
Apply non_vide ; Auto.
Cut ~<nat>m=O;Auto.
Apply (lemme_taille_1 M y0) ; Auto.
Red;Intro;Apply H0.
Elim H5; Auto.
Elim H4.
Pattern (soustr (add M y) y);Apply Ext0 with M;Auto.
Save.
Hint lemme_taille_2.


Lemma add_soustr_2 : (Q:set) (y:V) (In Q y)->(incl Q (add (soustr Q y) y)).
Goal.
Intros.
Red ; Intros.
Red; Red.
Unfold In soustr.
Elim (eqV y x) ; Intro ; Auto.
Save.
Hint add_soustr_2.

Lemma add_soustr_1 : (Q:set) (y:V) (In Q y)->(incl (add (soustr Q y) y) Q).
Goal.
Intros.
Red  ; Intros.
Elim H0 ; Intros.
Elim H1 ; Auto.
Elim H1 ; Assumption.
Save.
Hint add_soustr_1.

Lemma incl_add : (Q,Q':set)(y:V)(incl Q Q')->(incl (add Q y) (add Q' y)).
Goal.
Red;Intros.
Red;Red.
Elim H0; Auto.
(*Intro;Left;Apply H;Auto.*)
Save.
Hint incl_add.

Lemma In_not_In : (Q:set)(x,y:V)(In Q x)->(~(In Q y))->~<V>x=y.
Goal.
Red; Intros.
Apply H0; Elim H1;Auto.
Save.

Lemma not_eq_sym : (x,y:V)(~<V>x=y)->~<V>y=x.
Goal.
Red; Intros.
Apply H; Auto.
Save.
Immediate not_eq_sym.

Lemma In_not_In_sym : (Q:set)(x,y:V)(In Q x)->(~(In Q y))->~<V>y=x.
Goal.
Intros; Apply not_eq_sym; Apply (In_not_In Q); Auto.
Save.

Lemma same_size : (Q:set) (n:nat) (taille Q n)->(Q':set) (taille Q' n)->(incl Q Q')
                      ->(incl Q' Q).
Goal.
Intros Q n H ; Elim H ; Intros.
Red ; Intros.
Absurd <nat>O=O;Auto.
Apply (lemme_taille_1 Q' x) ; Auto.
Cut (In Q' y);Intros.
Pattern Q';Apply Ext0 with (add (soustr Q' y) y);Auto.
Apply incl_add; Apply H2;Auto.
Red; Red; Red; Intros.
Apply conj.
Apply H4; Auto.
Apply (In_not_In_sym M); Auto.
Apply H4; Auto.
Save.

(***************************************)
(* On travaille dans un ensemble fini  *)
(***************************************)

Axiom finit_V : (enumerate allV).

Lemma card_allV : {n:nat|(taille allV n)}.
Goal.
Elim finit_V ; Intros.
Exists O ; Auto.
Elim H ; Intros.
Exists (S x).
Apply non_vide ; Auto.
Save.

(**********************************)
(* et on choisit un sommet source *)
(**********************************)

Variable source : V.

(**********************************)
(* definition d un chemin minimum *)
(**********************************)

Definition path_inf.
    Body [W:set][x:V][n:nat]((m:nat) (path W source x m)->(le n m)).

(***********************************************)
(* Definition de la decomposition d'un chemin *)
(***********************************************)

Inductive Definition decomposed [CC:set;m:nat;x:V] : Set =
    decomp_Intro1 : (y:V) (m':nat) (In (quo CC) y)->(path CC source y m')->
                          (le m' m) ->(decomposed CC m x)
  | decomp_Intro2 : (path CC source x m)->(decomposed CC m x).
Hint decomp_Intro2.


Lemma decomp : (CC:set)(x:V)(m:nat)((x:V) {In CC x}+{In (quo CC) x})
                         ->(path allV source x m)->(decomposed CC m x).
Goal.
Intros.
Elim H0;Intros.
Auto.
Elim H1;Intros.
Apply decomp_Intro1 with y1 m';Auto.
Elim (H y);Intro.
Apply decomp_Intro2.
Apply Composed with y; Auto.
Apply decomp_Intro1 with y n;Auto.
Save.


(***********************************************)
(* Definition de connection entre deux sommets *)
(* soit il existe un chemin min                 *)
(* soit il n y a pas de chemin                 *)
(***********************************************)

Inductive Definition connect_s [W,W':set;y:V] : Set 
   =  Min_path : (n:nat) (path W source y n)->(path_inf W' y n)
                         ->(connect_s W W' y)
   |  No_path : ((n:nat) (path W' source y n)->False)->(connect_s W W' y).
Hint No_path.

Lemma connect_incl : (W,W',Q:set) (y:V) (incl W W')->(connect_s W Q y)->(connect_s W' Q y).
Goal.
Intros.
Elim H0 ; Intros.
Apply Min_path with n ; Auto.
Apply (Path_incl W) ; Auto.
Auto.
Save.

Lemma connect_incl_add : (W,Q:set) (x,y:V) (connect_s W Q y)->(connect_s (add W x) Q y).
Goal.
Intros; Apply (connect_incl W); Auto.
Save.
Hint connect_incl_add.

(* Lemma ens_dec : (CC:set)(x:V)(enumerate CC)->{In CC x}+{In (quo CC) x}.
Goal.
Intros.
Elim H.
Right.
Red.
Red.
Auto.
Intros.
Elim H0.
Intro.
Auto.
Intro.
Elim (eqV x y) ; Intro.
Left.
Automatic.
Right.
Red.
Red.
Red.
Unfold In add.
Intro ; elim_last.
Intro.
Apply_unfolds y2.
Assumption.
Intro.
Apply_unfolds y3.
Automatic.
Save.*)

(*********************************************************************)
(* Demonstration de la propriete qui fait marcher l'algo de Dijkstra *)
(*********************************************************************)

Lemma prop_dij : (CC:set)(x:V)(n:nat)((x:V) {In CC x}+{In (quo CC) x})->
     (path CC source x n)->(path_inf CC x n)
     ->((y:V)(In (quo CC) y)->(path_inf CC y n))->(path_inf allV x n).
Goal.
Unfold path_inf; Intros.
Elim (decomp CC x m H H3); Intros;Auto.
Apply le_trans with m';Auto.
Apply (H2 y) ; Auto.
Save.

(*****************************)
(* Setification de dijkstra *)
(*****************************)

Inductive Definition specif [CC,P:set] : Set
    = path_end : ((x:V)(n:nat) (In P x)->(path CC source x n)->False)->(specif CC P)
    | path_min : (x:V)(n:nat)(In P x)->(path CC source x n)->
                      ((y:V) (In P y)->(path_inf CC y n))->(specif CC P).
Hint path_end.
    
Lemma lemme_specif : (CC,P:set) (enumerate P)->((x:V) (In P x)->(connect_s CC CC x))
     ->(specif CC P).
Goal.
Intros CC P H; Elim H; Intros; Auto.
Elim H0; Intros; Auto.
(* cas ou on n a pas de chemin dans Q *)
Elim (H1 y); Intros; Auto.
(*     - mais ou il y un chemin de source a y *)
Apply path_min with y n0 ; Intros; Auto.
Elim H2;Intro.
Red;Intros.
Elim (f y1 m); Auto.
Elim H3 ; Auto.
(*     - mais ou il n'y a de chemin de source a y *)
Apply path_end;Intros.
Elim H2; Intro.
Apply (f x n0) ; Auto.
Apply (f0 n0).
Rewrite -> H4 ; Auto.
(* cas ou on  a des chemins dans Q *)
Intros.
Elim (H1 y) ; Intros; Auto.
(*    - et on a un chemin de source a y de cout n0 *)
Elim (le_dec n0 n1); Intro.
(*        - on a n0<=n1                              *)
(*        - y ne permet pas de diminuer les couts  *)
Apply path_min with x n0 ; Intros; Auto.
Elim H2;Intro;Auto.
Elim H3; Red; Intros.
Apply le_trans with n1; Auto.
(*Apply p2; Auto.*)
(* on a n1<=n0*)
Apply path_min with y n1 ; Intros; Auto.
Elim H2; Intro.
Red; Intros.
Apply le_trans with n0 ; Auto.
Apply (p0 y1 H3) ; Auto.
Elim H3 ; Auto.
(*    - et on n a pas de chemin de source a y       *)
Apply path_min with x n0 ; Intros; Auto.
Elim H2; Intro; Auto.
Elim H3; Red; Intros.
Elim (f m); Auto.
Save.

(**************************)
(* Definition de Dijkstra *)
(**************************)

Inductive Definition dijkstra [CC:set] : Set =
    dij_Intro : 
    ((x:V) ((and_s (In CC x) (connect_s CC allV x))
           +(and_s (In (quo CC) x) (connect_s CC CC x))))
    ->(dijkstra CC).

Inductive Definition specification [P:set->Set;C:set] : Set
    = ends : (P allV)->(specification P C)
    | chooses : (y:V)(In (quo C) y)->(P (add C y))->(specification P C).

Definition dij_spec (specification dijkstra).

Definition  fin (ends dijkstra).
Definition choose (chooses dijkstra).

(* Un sous-ensemble decidable d'un ens. fini est fini *)

Lemma finit : (P:set) ((x:V) {In P x}+{In (quo P) x})->(enumerate P).
Goal.
Intros.
Apply (Ext (inter allV P)).
Apply inter_incl_r.
Red;Red; Red ; Auto.
Elim finit_V ; Intros.
Apply (Ext empty) ; Auto.
Apply inter_incl_l.
Elim (H y) ; Intro.
Apply (Ext (add (inter Q P) y)) ; Auto.
Red ; Red; Red ;Intros.
Elim H1 ; Intros.
Elim H2 ; Auto.
Elim H2 ; Auto.
Red ; Red; Red ;Intros.
Elim H1 ; Intros.
Elim H2 ; Auto.
Apply enu_add ; Auto.
Red ; Intro.
Elim H1 ; Intros.
Apply n ; Auto.
Apply (Ext (inter Q P)) ; Auto.
Red ; Intros.
Elim H1 ; Auto.
Red ; Intros.
Elim H1 ; Intros.
Elim H2 ; Intros ; Auto.
Absurd (In P x);Auto.
Elim H4; Auto.
Save.

(* Le schema de preuve utilise : *)

Section Induc_scheme.
Variables x,y :V.
Variables n,m,p:nat.
Variable Q : set.

Inductive Definition Dec_add : Prop =
   Dec_add_direct : (q:nat)(path Q source y q)->(le q p)->Dec_add
 | Dec_add_edge : (q:nat)(E x y q)->(le (plus n q) p)->Dec_add.

Lemma induc_scheme : (path_inf allV x n)->((z:V)(In Q z)->(connect_s Q allV z))
     ->(path (add Q x) source y p)->Dec_add.
Goal.
Intros.
Apply (Path_match (add Q x) source y p H1); Intros.
Apply (Dec_add_direct p); Auto.
Elim H3; Intros.
Elim (H0 y0 H6).
Intros q H7 H8.
Apply (Dec_add_direct (plus q p0));Intros.
Apply Composed with y0; Auto.
Elim H5; Apply le_reg_r.
Apply H8.
Apply (Path_incl (add Q x)); Auto.
Intro H7.
Elim (H7 m).
Apply (Path_incl (add Q x)); Auto.
Apply (Dec_add_edge p0).
Rewrite -> H6; Auto.
Elim H5; Apply le_reg_r.
Apply H.
Rewrite -> H6; Auto.
Apply (Path_incl (add Q x)); Auto.
Save.
End Induc_scheme.
Hint induc_scheme.
     
Inductive Definition specif' [P:set->Set;n:nat] : Set
    = all : (P allV)->(specif' P n)
    | part : (C:set)(taille C n)->(P C)->(specif' P n).


Lemma principe_recurrence : (P:set->Set) (P empty)->((C:set) (P C)->(specification P C))->(P allV).
Goal.
Intros.
Cut (n:nat) (specif' P n).
Intro; Elim card_allV ; Intros.
Elim (H1 x) ; Intros ; Auto.
Apply (Ext C allV) ; Auto.
Apply same_size with x ; Auto.
(* on prouve le cut (n:nat) (specif P n) *)
Induction n ; Intros.
Apply part with empty ; Auto.
Elim H1 ; Intros.
Apply all ; Assumption.
Elim (H0 C p) ; Intros.
Apply all ; Assumption.
Apply part with (add C y0) ; Auto.
Apply non_vide ; Auto.
Save.

Lemma Path_empty : (x,y:V) (n:nat)(path empty x y n)->(E x y n).
Goal.
Intros.
Elim H; Intros; Auto.
Elim i.
Save.
Hint Path_empty.

Provide Dijkstra_def.
