(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                           Natural numbers                                 *)
(*                       Programs for comparisons                            *)
(*                                                                           *)
(*****************************************************************************)


Require Lt.

Theorem lt_eq_lt_dec : (n,m:nat){(lt n m)}+{<nat>n=m}+{(lt m n)}.
Goal.
Realizer [n:nat]
         (<nat->(sumor sumbool)>Match n with 
          (* O *) [m:nat](<(sumor sumbool)>Match m with 
                          (* O *) (inleft sumbool right)
                        (* S p *) [p:nat][H:(sumor sumbool)](inleft sumbool left))
        (* S p *) [p:nat][H:nat->(sumor sumbool)]
		  [m:nat](<(sumor sumbool)>Match m with 
                           (* O *) (inright sumbool)
                         (* S q *) [q:nat][H':(sumor sumbool)](H q))).
Program_all.
Save.

Lemma gt_eq_gt_dec : (n,m:nat)({(gt m n)}+{<nat>n=m})+{(gt n m)}.
Proof lt_eq_lt_dec.

Lemma le_lt_dec : (n,m:nat) {le n m} + {lt m n}.
Goal.
Realizer [n:nat](<nat->sumbool>Match n with 
                 (* O *) [m:nat]left
               (* S m *) [p:nat][H:nat->sumbool][m:nat]
                         (<sumbool>Match m with 
                          (* O *) right
                        (* S q *) [q:nat][H':sumbool](H q))).
Program_all.
Save.

Lemma le_le_S_dec : (n,m:nat) {le n m} + {le (S m) n}.
Proof le_lt_dec.

Lemma le_ge_dec : (n,m:nat) {le n m} + {ge n m}.
Goal.
Realizer [n,m:nat](le_lt_dec n m).
Program_all.
Save.

Theorem le_gt_dec : (n,m:nat){(le n m)}+{(gt n m)}.
Proof le_lt_dec.


Theorem le_lt_eq_dec : (n,m:nat)(le n m)->({(lt n m)}+{<nat>n=m}).
Goal.
Realizer [n,m:nat](<sumbool>Match (lt_eq_lt_dec n m) with 
                       (* inleft b *) [b:sumbool]b
                        (* inright *) (except sumbool)).
Program_all.
Absurd (lt m n); Auto.
Save.

Provide Compare_prog.
