(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                        Insertion in AVL trees (proof)                     *)
(*                                                                           *)
(*                        C. Parent ENS Lyon  - July 199O                    *)
(*                                                                           *)
(*****************************************************************************)

Require Avl_def.

(*************************************************)
(*		Proof of insertion	  	 *)
(*************************************************)

Theorem insert : (x:a)(t:abe)(avl t)->(avl_spec x t).
Goal. 

Intros x t H.
Elim H.

(* nil tree*)
(* the height increases *)
Apply h_plus with (node x nil nil mi) ; Auto.
Apply equiv_intro ; Intros ; Auto.
Elim  (In_node_inv x0 x nil nil mi) ; Auto.

Intros l g d des avlg avlsg avld avlsd sg id bgd.

Elim (inf_dec x l) ; Intro.

(* insertion on the left *)
Elim avlsg.

(* the height of the left subtree is the same after insertion *)
Intros g' eg' avlg' hg'.
Apply h_eq with (node l g' d des); Auto.
Apply avl_node ; Auto.
Apply bal_haut with g d; Trivial.
Apply equiv_sup_g with g x ; Auto.

(* the height of the left subtree is one more after insertion *)

(* by case on the equilibre *)
Elim bgd.
(* the tree was initially left *)
Intros Hgd g' avlg'.
Elim avlg'.

(* the left subtree is left *)
(* right_rotation *)
Simpl;Intros m g'g g'd avlg'g avlg'd Hg'gd sg'g ig'd eqxg' Hg'g.
Cut <nat>(haut g'd)=(haut d).
(*la hauteur finale n'augmente pas*)
Intro Hg'dd; Apply h_eq with (rot_d l m g'g d g'd).
(* This is an avl *)
Apply avl_rotd; Auto.
Apply equiv_sup_g with g x; Auto.
(* The resulting tree is equivalent to t+x*)
Apply equiv_equiv_abe with (node l (node m g'g g'd ga) d ga); Auto.
(* the hight does not change *)
Simpl.
Rewrite -> Hgd.
Elim max_Sn_n; Elim Hg'dd; Elim max_n_n; Elim Hg'gd; Auto.
Apply eq_add_S; Elim Hgd; Apply eq_add_S; Elim Hg'g; 
        Rewrite -> Hg'gd;Auto.

(* The left son connot be in the middle *)
Simpl; Intros.
Absurd <nat>O=(haut g); Auto.
Rewrite -> Hgd; Auto.

(* the left son is right *)
(* double rotation *)
Intros m g'g g'd.
(* We decompose g'd *)
Pattern g'd; Apply abe_match.
(* g'd is not nil *)
Intros avlg'g avlg'd Hg'gg'd; Absurd <nat>(S (haut g'g))=O; Auto.
Simpl; Intros n g'd1 g'd2 eqn avlg'g avlg'd Hg'ggd sg'g ig'd eqxg' Hg'g.
Cut <nat>(haut g'g)=(haut d).
Intro Hg'gd; Apply h_eq with (rot_gd l m g'g d n g'd1 g'd2 eqn).
Apply avl_rotgd; Auto.
Elim (supt_node_inv l m g'g (node n g'd1 g'd2 eqn) dr); Auto.
Apply equiv_sup_g with g x; Auto.
(* the resulting tree is equivalent to t+x *)
Apply equiv_equiv_abe with 
                (node l (node m g'g (node n g'd1 g'd2 eqn) dr) d ga); Auto.
(* the hight does not change *)
Elim haut_rotgd; Auto.
Elim haut_node.
Rewrite -> Hgd; Auto.
Apply eq_add_S; Elim Hgd; Apply eq_add_S; Elim Hg'g; Elim Hg'ggd; Auto.

(* the heights of g and d are the same *)

Intros Hgd g' avlg' eqgg' Hg'g.
Apply h_plus with (node l g' d ga).
Apply ins_ga; Auto.
Elim Hgd; Auto.
Apply equiv_sup_g with g x; Auto.
Auto.
(* The final height increases *)
Elim haut_node; Elim haut_node; Elim Hgd; Elim max_n_n.
Rewrite -> Hg'g; Auto.

(* The height of d is more than the height of g *)
Intros Hgd g' avlg' eqgg' Hg'g.
Apply h_eq with (node l g' d mi).
Apply avl_node; Auto.
Apply bal_mi; Auto.
Elim Hgd; Auto.
Apply equiv_sup_g with g x; Auto.
Auto.
Elim  haut_node; Elim haut_node; Elim Hgd; Elim max_n_Sn.
Elim Hg'g; Auto.

(* Insertion in the right subtree *)

Elim avlsd.

(* the height of the right subtree is the same after insertion *)

Intros d' ed' avld' hd'.
Apply h_eq with (node l g d' des); Auto.
Apply avl_node ; Auto.
Apply bal_haut with g d; Trivial.
Apply equiv_inf_g with d x ; Auto.
Simpl; Elim hd'; Auto.

(* the height is one more after insertion *)

Elim bgd.
(* by case on the equilibre *)

(* The height of g is more than the height of d *)
Intros Hgd d' avld' eqdd' Hd'd.
Apply h_eq with (node l g d' mi).
Apply avl_node; Auto.
Apply bal_mi; Auto.
Rewrite -> Hd'd; Auto.
Apply equiv_inf_g with d x ; Auto.
Auto.
Simpl; Rewrite -> Hd'd.
Rewrite -> Hgd.
Elim max_Sn_n; Auto.

(* The height of g and d are the same *)
Intros Hgd d' avld' eqdd' Hd'd.
Apply h_plus with (node l g d' dr).
Apply ins_dr; Auto.
Apply trans_equal with (S (haut d)); Auto.
Apply equiv_inf_g with d x ; Auto.
Auto.
Elim haut_node; Elim haut_node; Rewrite -> Hgd.
Elim max_n_n; Rewrite -> Hd'd; Auto.

(* The height of d is more than the height of d *)

Intros Hgd d' avld'.
Elim avld'.

(* The right son is left : double rotation *)

Intros m d'g d'd.
(* We decompose d'g *)
Pattern d'g; Apply abe_match.
(* d'g is not nil *)
Intros avld'g avld'd Hd'gd'd; Absurd <nat>(S (haut d'd))=O; Auto.
Intros n d'g1 d'g2 eqn avld'g avld'd Hd'gd'd sd'g id'd eqxd'.
Elim haut_node; Elim haut_node; Intro Hd'd.
Cut <nat>(haut g)=(haut d'd).
Intro Hgd'd; Apply h_eq with (rot_gd m l g d'd n d'g1 d'g2 eqn).
Apply avl_rotgd; Auto.
Elim (inft_node_inv l m (node n d'g1 d'g2 eqn) d'd ga); Auto.
Apply equiv_inf_g with d x; Auto.
Rewrite -> Hgd'd;Auto.
(*l'arbre obtenu est equivalent a t+x*)
Apply equiv_equiv_abe with
                (node l g (node m (node n d'g1 d'g2 eqn) d'd ga) dr); Auto.
(* the height does not change *)
Elim haut_node; Elim haut_rotgd; Auto.
Elim Hgd'd; Elim Hgd; Auto.
Rewrite -> Hgd'd;Auto.
Apply eq_add_S; Rewrite -> Hgd.
Apply eq_add_S; Elim Hd'd; Simpl in Hd'gd'd;Rewrite -> Hd'gd'd;Auto.

(* the right son cannot be middle *)
Simpl; Intros m eqdd' Hd'd.
Absurd <nat>O=(haut d); Auto.
Elim Hgd; Auto.

(* the right son is right : left rotation *)

Simpl;Intros m d'g d'd avld'g avld'd Hd'gd'd sd'g id'd eqxd' Hd'd.
Cut <nat>(haut d'g)=(haut g).
Intro Hd'gg; Apply h_eq with (rot_g m l g d'd d'g).
Apply avl_rotg; Auto.
Apply equiv_inf_g with d x; Auto.
Apply equiv_equiv_abe with (node l g (node m d'g d'd dr) dr); Auto.
Elim haut_node; Elim haut_rotg; Auto.
Elim Hgd; Elim max_n_Sn; Elim Hd'gg; Auto.
Apply eq_add_S; Rewrite -> Hgd.
Apply eq_add_S; Elim Hd'd; Elim Hd'gd'd; Auto.
Save.

End trees.

Provide Avl_proof.
