(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                        Insertion in AVL trees (program)                   *)
(*                                                                           *)
(*                        C. Parent ENS Lyon  - July 199O                    *)
(*                                                                           *)
(*****************************************************************************)

Require Le.
Lemma O_S' : (m:nat) ~(<nat>(S m)=O).
Goal. 
Red; Intros m H.
Apply (O_S m).
Auto.
Save.
Hint O_S'.

Section trees.

(*************************************************)
(*		Variables		  	 *)
(*************************************************)

Variable a : Set.
Variable inf : a -> a -> Prop.
Axiom inf_dec : (x,y:a) {inf x y}+{inf y x}.
Axiom inf_trans : (x,y,z:a) (inf x y) -> (inf y z) -> (inf x z).

(*********************************************************)
(*		Definitions and5, and3		         *)
(*********************************************************)

Inductive Definition and5 [a1,a2,a3,a4,a5:Prop] : Prop
	= conj5 : a1 -> a2 -> a3 -> a4 -> a5 -> (and5 a1 a2 a3 a4 a5).

Hint conj5.

Lemma and5_rec : (A1,A2,A3,A4,A5:Prop)
     (C:Set)(A1->A2->A3->A4->A5->C)->(and5 A1 A2 A3 A4 A5)->C.
Goal. 
Intros A1 A2 A3 A4 A5 C F A.
Apply F; Elim A; Auto.
Save.

Inductive Definition and3 [a1,a2,a3:Prop] : Prop
	= conj3 : a1 -> a2 -> a3  -> (and3 a1 a2 a3).

Hint conj3.

Lemma and3_rec : (A1,A2,A3:Prop)
     (C:Set)(A1->A2->A3->C)->(and3 A1 A2 A3)->C.
Goal. 
Intros A1 A2 A3 C F A.
Apply F; Elim A; Auto.
Save.


(*************************************************)
(*		Definition max		  	 *)
(*************************************************)

Definition max.
Body [n:nat](<nat->nat>Match n with 
             (* O *) [m:nat] m
           (* S p *) [p:nat][maxp:nat->nat][m:nat]
		     (<nat>Match m with 
                      (* O *) (S p) 
                    (* S q *) [q:nat][maxSpq:nat] (S (maxp q)))).


(*************************************************)
(*		Definition equil		 *)
(*************************************************)

Inductive Definition equil : Set
	= ga : equil
	| mi : equil
	| dr : equil.

(*************************************************)
(*		Definition abe		  	 *)
(*************************************************)

Inductive Definition abe : Set
	= nil : abe
	| node : a -> abe -> abe -> equil -> abe.

(*************************************************)
(*		Definition haut		  	 *)
(*************************************************)

Definition haut.
Body [h:abe](<nat>Match h with 
             (* nil *) O
  (* node l g d des *) [l:a][g:abe][hg:nat][d:abe][hd:nat][des:equil] 
                       (S (max hg hd))).

Lemma haut_node : (l:a)(g,d:abe)(e:equil)
     <nat>(S (max (haut g) (haut d)))=(haut (node l g d e)).
Goal. 
Auto.
Save.

(*************************************************)
(*		Definition or3		  	 *)
(*************************************************)

Inductive Definition or3 [A,B,C:Prop]:Prop =
    cas1 : A -> (or3 A B C)
  | cas2 : B -> (or3 A B C)
  | cas3 : C -> (or3 A B C).

Hint cas1 cas2 cas3.

(*************************************************)
(*		Definition in		  	 *)
(*************************************************)

Inductive Definition In [x:a] : abe->Prop
 = In_left : (y:a)(g,d:abe)(e:equil)(In x g)->(In x (node y g d e))
 | In_right : (y:a)(g,d:abe)(e:equil)(In x d)->(In x (node y g d e))
 | In_node :  (g,d:abe)(e:equil)(In x (node x g d e)).

Hint In_node In_left In_right.

Lemma In_node_eq : (x,l:a)(g,d:abe)(e:equil)(<a>l=x)->(In x (node l g d e)).
Goal. 
Induction 1; Auto.
Save.
Hint In_node_eq.

Local inverse 
   [x:a][h:abe]
  (<Prop> Match h with
      (* nil *)     False  
(* node l g d eq *) [l:a][g:abe][pg:Prop][d:abe][pd:Prop][des:equil]
                            (or3 (In x g) (In x d) (<a>l=x))).

Lemma In_nil : (x:a)~(In x nil).
Goal. 
Red; Intros x H; Change (inverse x nil).
Elim H; Simpl; Auto.
Save.
Hint In_nil.

Lemma In_node_inv : (x:a)(l:a)(g,d:abe)(e:equil)
     (In x (node l g d e))->(or3 (In x g) (In x d) (<a>l=x)).
Goal. 
Intros x l g d e H; Change (inverse x (node l g d e)).
Elim H; Simpl; Auto.
Save.
(*Hint In_node_inv.*)



(*************************************************)
(*		Definition inft		  	 *)
(*************************************************)

Inductive Definition inft [x:a] : abe -> Prop
  = inft_nil : (inft x nil)
  | inft_node : (l:a)(g,d:abe)(des:equil)
                (inf x l)->(inft x g)->(inft x d)->(inft x (node l g d des)).

Hint inft_nil inft_node.

Local inverse
   [x:a][t:abe](<Prop>Match t with 
                (* nil *) True
     (* node l g d des *) [l:a][g:abe][Hg:Prop][d:abe][Hd:Prop][des:equil]
                         (and3 (inf x l) (inft x g) (inft x d))).

Lemma inft_node_inv : (x,l:a)(g,d:abe)(des:equil)
     (inft x (node l g d des))->(and3 (inf x l) (inft x g) (inft x d)).
Goal. 
Intros x l g d des H; Change (inverse x (node l g d des)); Elim H; Simpl;Auto.
Save.

Lemma inft_in_inf : (x:a)(t:abe)(inft x t)->(y:a)(In y t)->(inf x y).
Goal. 
Induction 1; Intros.
Absurd (In y nil); Auto.
Elim (In_node_inv y l g d des); Auto.
Induction 1; Auto.
Save.

Lemma in_inf_inft : (x:a)(t:abe)((y:a)(In y t)->(inf x y))->(inft x t).
Goal. 
Induction t; Auto.
Save.

(*************************************************)
(*		Definition supt		  	 *)
(*************************************************)

Inductive Definition supt [x:a] : abe -> Prop
  = supt_nil : (supt x nil)
  | supt_node : (l:a)(g,d:abe)(des:equil)
                (inf l x)->(supt x g)->(supt x d)->(supt x (node l g d des)).

Hint supt_nil supt_node.

Local inverse
   [x:a][t:abe](<Prop>Match t with 
                (* nil *) True
     (* node l g d des *) [l:a][g:abe][Hg:Prop][d:abe][Hd:Prop][des:equil]
                          (and3 (inf l x) (supt x g) (supt x d))).

Lemma supt_node_inv : (x,l:a)(g,d:abe)(des:equil)
     (supt x (node l g d des))->(and3 (inf l x) (supt x g) (supt x d)).
Goal. 
Intros x l g d des H; Change (inverse x (node l g d des)); Elim H; Simpl;Auto.
Save.

Lemma supt_in_inf : (x:a)(t:abe)(supt x t)->(y:a)(In y t)->(inf y x).
Goal. 
Induction 1; Intros.
Absurd (In y nil); Auto.
Elim (In_node_inv y l g d des); Auto.
Induction 1; Auto.
Save.

Lemma in_inf_supt : (x:a)(t:abe)((y:a)(In y t)->(inf y x))->(supt x t).
Goal. 
Induction t; Auto.
Save.


(*************************************************)
(*		Definition bal		  	 *)
(*************************************************)

Inductive Definition bal [g,d:abe] : equil->Prop
   = bal_ga : (<nat>(haut g)=(S(haut d))) -> (bal g d ga)
   | bal_mi : (<nat>(haut g)=(haut d)) -> (bal g d mi)
   | bal_dr : (<nat>(S (haut g))=(haut d)) -> (bal g d dr).

Hint bal_ga bal_mi bal_dr.

Local inverse = [g,d:abe][e:equil]
     (<Prop>Match e with 
         (* ga *)  <nat>(haut g)=(S(haut d))
         (* mi *)  <nat>(haut g)=(haut d)
	 (* dr *)  <nat>(S(haut g))=(haut d)).

Lemma bal_ga_inv : (g,d:abe)(bal g d ga)-><nat>(haut g)=(S(haut d)).
Goal. 
Intros g d H; Change (inverse g d ga); Elim H; Simpl; Auto.
Save.
Immediate bal_ga_inv.

Lemma bal_mi_inv : (g,d:abe)(bal g d mi)-><nat>(haut g)=(haut d).
Goal. 
Intros g d H; Change (inverse g d mi); Elim H; Simpl; Auto.
Save.
Immediate bal_mi_inv.


Lemma bal_dr_inv : (g,d:abe)(bal g d dr)-><nat>(S (haut g))=(haut d).
Goal. 
Intros g d H; Change (inverse g d dr); Elim H; Simpl; Auto.
Save.
Immediate bal_dr_inv.

Lemma bal_rec : (g,d:abe)(P:equil->Set)
          ((<nat>(haut g)=(S (haut d)))->(P ga))->
          ((<nat>(haut g)=(haut d))->(P mi))->
          ((<nat>(S (haut g))=(haut d))->(P dr))->
          (e:equil)(bal g d e)->(P e).
Goal. 
Realizer [g:abe][d:abe][P:Data][H:P][H0:P][H1:P][e:equil]
		(<P>Match e with
		 	H 
			H0 
			H1).
Program_all.
Save.


(*************************************************)
(*		Definition avl		  	 *)
(*************************************************)

Inductive Definition avl : abe -> Prop
= avl_nil : (avl nil)
| avl_node : (l:a)(g,d:abe)(des:equil)
             (avl g)->(avl d)->(bal g d des)->(supt l g)->(inft l d)
             ->(avl (node l g d des)).

Hint avl_nil avl_node.

Definition inverse.
Body [u:abe](<Prop> Match u with 
           (* nil *) True
(* node l g d des *) [l:a][g:abe][pg:Prop][d:abe][pd:Prop][des:equil]
    	             (and5 (avl g) (avl d) (supt l g) 
                           (inft l d) (bal g d des))).

Lemma avl_inv : (l:a)(g,d:abe)(des:equil)(avl (node l g d des))
     ->(and5 (avl g) (avl d) (supt l g) (inft l d) (bal g d des)).
Goal. 
Intros l g d des H; Change (inverse (node l g d des)).
Elim H; Simpl; Auto.
Save.

Lemma avl_rec : (t:abe)
     (P:abe->Set)
     (P nil)
     ->((l:a)(g,d:abe)(des:equil)(avl g)->(P g)->(avl d)->(P d)
         ->(supt l g)->(inft l d) ->(bal g d des)->(P (node l g d des)))
     ->(avl t)->(P t).
Goal.
Realizer [t:abe][P:Data][H0:P][H1:a->abe->abe->equil->P->P->P]
                (<P>Match t with
		   H0
                   [l:a][g:abe][Pg:P][d:abe][Pd:P][des:equil]
			(and5_rec P (H1 l g d des Pg Pd))).
Program_all.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Elim (avl_inv a0 y y0 e); Auto.
Save.

(*************************************************************)
(*    	  A special kind of avl obtained after an insertion  *)
(*        that modifies the heigth                           *)
(*************************************************************)

Inductive Definition avl_ins : abe -> Prop
  = ins_ga : (l:a)(g,d:abe)(avl g)->(avl d)->
              (<nat>(haut g)=(S (haut d)))->
              (supt l g)->(inft l d)->(avl_ins (node l g d ga))
  | ins_mil : (l:a)(avl_ins (node l nil nil mi))
  | ins_dr : (l:a)(g,d:abe)(avl g)->(avl d)->
              (<nat>(S (haut g))=(haut d))->
              (supt l g)->(inft l d)->(avl_ins (node l g d dr)).

Hint ins_ga ins_mil ins_dr.
        
Definition inverse.
Body [t:abe](<Prop>Match t with 
             (* nil *) False
  (* node l g d des *) [l:a][g:abe][pg:Prop][d:abe][pd:Prop][des:equil] 
                      (<Prop>Match des with 
                       (* ga *) (and5 (avl g) (avl d) 
                                      (<nat>(haut g)=(S (haut d)))
                                      (supt l g) (inft l d))
                       (* mi *) ((<abe>nil=g)/\ (<abe>nil=d))
                       (* dr *) (and5 (avl g) (avl d) 
                                      (<nat>(S (haut g))=(haut d))
                                      (supt l g) (inft l d)))).

Lemma avl_ins_nil_inv : ~(avl_ins nil).
Goal. 
Red; Intro H; Change (inverse nil); Elim H; Simpl; Auto.
Save.

Lemma avl_ins_ga_inv : (l:a)(g,d:abe)
     (avl_ins (node l g d ga))->
     (and5 (avl g) (avl d) (<nat>(haut g)=(S (haut d))) (supt l g) (inft l d)).
Goal. 
Intros l g d H; Change (inverse  (node l g d ga)); Elim H; Simpl;Auto.
Save.

Lemma avl_ins_mi_inv : (l:a)(g,d:abe)
     (avl_ins (node l g d mi))->((<abe>nil=g)/\ (<abe>nil=d)).
Goal. 
Intros l g d H; Change (inverse  (node l g d mi)); Elim H; Simpl;Auto.
Save.

Lemma avl_ins_dr_inv : (l:a)(g,d:abe)
     (avl_ins (node l g d dr))->
     (and5 (avl g) (avl d) (<nat>(S (haut g))=(haut d)) (supt l g) (inft l d)).
Goal. 
Intros l g d H; Change (inverse  (node l g d dr)); Elim H; Simpl;Auto.
Save.

Lemma avl_ins_avl : (t:abe)(avl_ins t)->(avl t).
Goal. 
Induction 1; Auto.
Save.
Immediate avl_ins_avl.

Lemma avl_ins_rec : (P:abe->Set)
        ((l:a)(g,d:abe)(avl g)->(avl d)->
               (<nat>(haut g)=(S (haut d)))->
               (supt l g)->(inft l d)->(P (node l g d ga)))
        ->((l:a)(P (node l nil nil mi)))->
        ((l:a)(g,d:abe)(avl g)->(avl d)->
               (<nat>(S (haut g))=(haut d))->
               (supt l g)->(inft l d)->(P (node l g d dr)))
        ->(a:abe)(avl_ins a)->(P a).
Goal. 
Realizer [P:Data][H:a->abe->abe->P][H0:a->P][H1:a->abe->abe->P][a0:abe]
             (<P>Match a0 with
		 (False_rec P)
                 [l:a][g:abe][Pg:P][d:abe][Pd:P][e:equil]
                      (<P>Match e with
			     (and5_rec P (H l g d))
                                 [{H':(avl_ins (node l g d mi))}]
					(and_rec P (eq_rec abe nil P
                                            (eq_rec abe nil P (H0 l) d) g))
                             (and5_rec P (H1 l g d)))).
Program_all.
Elim avl_ins_nil_inv; Auto.
Elim (avl_ins_ga_inv a1 y y0); Auto.
Elim (avl_ins_mi_inv a1 y y0); Auto.
Elim (avl_ins_mi_inv a1 y y0); Auto.
Elim (avl_ins_dr_inv a1 y y0); Auto.
Save.

(*************************************************)
(*		Definition equiv		 *)
(*************************************************)

Definition equiv_abe =
  [t,t':abe](((x:a)(In x t)->(In x t'))/\ ((x:a)(In x t')->(In x t))).

Inductive Definition equiv [y:a;t,t':abe] : Prop =
  equiv_intro : 
   ((x:a)(In x t)->(In x t'))->
   (In y t')->((x:a)(In x t')->((In x t)\/<a>y=x))
   -> (equiv y t t').
Hint equiv_intro.

(*************************************************)
(*    Lemmas                                     *)
(*************************************************)

Lemma equiv_equiv_abe : (x:a)(t,u,v:abe)(equiv x t u)->(equiv_abe u v)->(equiv x t v).
Goal. 
Intros x t u v H H0; Elim H; Intros H1 H2 H3; Elim H0; Intros H4 H5; Auto.
Save.

Lemma equiv_gauche : (y,l:a)(g,g',d:abe)(des,des':equil)
     (equiv y g g')->(equiv y (node l g d des) (node l g' d des')).
Goal. 
Intros.
Elim H ; Intros.
Apply equiv_intro; Auto.
Intros x H3; Elim (In_node_inv x l g d des) ; Auto.
Intros x H3; Elim (In_node_inv x l g' d des') ; Auto.
Intro H4; Elim (H2 x); Auto.
Save.

Lemma equiv_droite : (y,l:a)(g,d,d':abe)(des,des':equil)
     (equiv y d d')->(equiv y (node l g d des) (node l g d' des')).
Goal. 
Intros.
Elim H ; Intros.
Apply equiv_intro; Auto.
Intros x H3; Elim (In_node_inv x l g d des) ; Auto.
Intros x H3; Elim (In_node_inv x l g d' des') ; Auto.
Intro H4; Elim (H2 x); Auto.
Save.

Hint equiv_gauche equiv_droite.



(*************************************************)
(*		Definition avl_spec	  	 *)
(*************************************************)

Inductive Definition avl_spec [x:a;t:abe] : Set
	= h_eq : (h:abe)(avl h)->(equiv x t h)->(<nat>(haut h)=(haut t)) 
                 -> (avl_spec x t)
	| h_plus : (h:abe)(avl_ins h)->(equiv x t h)
                 -> (<nat>(haut h)=(S(haut t))) ->(avl_spec x t).

(*************************************************)
(*		Definition abe_match	  	 *)
(*************************************************)
Lemma abe_match : (P:abe->Set)
       (P nil)
     ->((l:a)(g:abe)(d:abe)(des:equil) (P (node l g d des)))
     ->(t:abe)(P t).
Goal. 
Realizer [P:Data][H:P][H0:a->abe->abe->equil->P][t:abe]
                  (<P>Match t with
		 	H
                     	[a0:a][y:abe][H1:P][y0:abe][H2:P][e:equil]
				(H0 a0 y y0 e)).
Program_all.
Save.

(*************************************************)
(*		Definition abe_case	  	 *)
(*************************************************)

Lemma abe_case : (t:abe)(P:abe->Prop)
       ((<abe>nil=t)->(P nil))
     ->((l:a)(g:abe)(d:abe)(des:equil)
         (<abe>(node l g d des)=t)->(P (node l g d des)))
     ->(P t).
Goal. 

Intro t.
Elim t ; Intros ; Auto.
Save.

Lemma equiv_sup_g : (g,g':abe)(l,x:a)
     (equiv x g g')-> (supt l g)-> (inf x l) -> (supt l g').
Goal. 
Induction 1; Intros H1 H2 H3 S I.
Apply in_inf_supt.
Intros y H4; Elim (H3 y); Trivial.
Intro H5; Apply supt_in_inf with g; Auto.
Induction 1; Auto.
Save.

Lemma bal_haut : (g,g',d,d':abe)(des:equil)
     (<nat>(haut g')=(haut g))->(<nat>(haut d')=(haut d))
      ->(bal g d des)->(bal g' d' des).
Goal. 
Intros g g' d d' des Hg Hd B;
Elim B; Elim Hg; Elim Hd; Auto.
Save.

Lemma equiv_inf_g : (g,g':abe)(l,x:a)
     (equiv x g g') -> (inft l g) -> (inf l x) -> (inft l g').
Goal. 
Induction 1; Intros H1 H2 H3 S I.
Apply in_inf_inft.
Intros y H4; Elim (H3 y); Trivial.
Intro H5; Apply inft_in_inf with g; Auto.
Induction 1; Auto.
Save.

Lemma inft_trans : (l,l':a)(t:abe)(inf l l')->(inft l' t)->(inft l t).
Goal. 
Induction 2; Auto.
Intros l0 g d des I' ITg' ITg ITd' ITd.
Cut (inf l l0); Auto.
Apply inf_trans with l'; Auto.
Save.

Lemma supt_trans : (l,l':a)(t:abe)(inf l' l)->(supt l' t)->(supt l t).
Goal. 
Induction 2; Auto.
Intros l0 g d des I' ITg' ITg ITd' ITd.
Cut (inf l0 l); Auto.
Apply inf_trans with l'; Auto.
Save.

Lemma haut_plus : (g,g':abe)(des:equil)(d:abe)(l:a)
     (<nat>(haut g)=(haut g'))->
     (<nat>(haut (node l g' d des))=(haut (node l g d des))).
Goal. 
Intros g g' des d l H; Simpl; Elim H; Auto.
Save.
Hint haut_plus.

Lemma max_n_n : (n:nat)(<nat>n=(max n n)).
Goal. 
Induction n ; Simpl ; Auto.
Save.
Hint max_n_n.

Lemma max_Sn_n : (n:nat)(<nat>(S n)=(max (S n) n)).
Goal. 
Induction n ; Simpl ; Auto.
Save.
Hint max_Sn_n.

Lemma max_n_Sn : (n:nat)(<nat>(S n)=(max n (S n))).
Goal. 
Induction n ; Simpl ; Auto.
Save.
Hint max_n_Sn.

Lemma le_max : (m,n:nat)(le n m)->(<nat>m=(max m n)).
Goal. 
Intros m n Le; Pattern n m; Apply le_elim_rel; Simpl; Auto.
Induction p; Simpl; Auto.
Save.
Hint le_max.

Lemma max_case : (n,m:nat)((<nat>n=(max n m))\/(<nat>m=(max n m))).
Goal. 
Induction n.
Simpl; Auto.
Induction m.
Simpl; Auto.
Intros p H0; Simpl; Elim (H p); Auto.
Save.

Lemma max_sym : (n,m:nat)<nat>(max m n)=(max n m).
Goal. 
Induction n;Induction m; Simpl; Auto.
Save.

(*************************************************)
(*						 *)
(*   Rotations                             	 *)
(*						 *)
(*************************************************)

Chapter rotations.

Variables l, m :a.
Variables t,v : abe.

Hypothesis avlv : (avl v).
Hypothesis avlt : (avl t).

Hypothesis inflv : (inft l v).
Hypothesis supmt : (supt m t).

Hint inflv supmt avlt avlv.

Section simple_rotations.

Variables u : abe.
Hypothesis avlu : (avl u).
Hint avlu.

Section right_rotation.

Hypothesis suplmtu : (supt l (node m t u ga)).
Hypothesis infmu : (inft m u).

Hint suplmtu infmu.

Lemma infml : (inf m l).
Goal. 
Elim (supt_node_inv l m t u ga); Auto.
Save.
Hint infml.

Lemma suptlu : (supt l u).
Goal. 
Elim (supt_node_inv l m t u ga); Auto.
Save.
Hint suptlu.

Hypothesis Htu : <nat>(haut t)=(S (haut u)).
Hypothesis Huv : <nat>(haut u)=(haut v).

Hint Huv Htu.

Definition rot_d = (node m t (node l u v mi) mi).

Lemma avl_rotd : (avl rot_d).
Goal. 
Unfold rot_d.
Apply avl_node; Auto.
Apply bal_mi; Simpl.
Elim Huv.
Elim max_n_n; Auto.
Apply inft_node; Auto.
Apply inft_trans with l; Auto.
Save.

Lemma equiv_rotd : (eql:equil)(equiv_abe (node l (node m t u ga) v eql) rot_d).
Goal. 
Intro eql; Unfold equiv_abe rot_d; Split.
Intros x H; Elim (In_node_inv x l (node m t u ga) v eql); Auto.
Intro H0; Elim (In_node_inv x m t u ga); Auto.
Intros x H; Elim (In_node_inv x m t (node l u v mi) mi); Auto.
Intro H0; Elim (In_node_inv x l u v mi); Auto.
Save.

Lemma haut_rotd : <nat>(S (haut t))=(haut rot_d).
Goal. 
Simpl.
Elim Huv.
Elim max_n_n.
Elim Htu; Auto.
Save.

End right_rotation.

Section left_rotation.

Hypothesis inftmuv : (inft m (node l u v dr)).
Hypothesis suplu : (supt l u).

Hint inftmuv suplu.

Lemma infml : (inf m l).
Goal. 
Elim (inft_node_inv m l u v dr); Auto.
Save.
Hint infml.

Lemma inftmu : (inft m u).
Goal. 
Elim (inft_node_inv m l u v dr); Auto.
Save.
Hint inftmu.

Hypothesis Hut : <nat>(haut u)=(haut t).
Hypothesis Huv : <nat>(haut v)=(S (haut u)).

Hint Huv Hut.

Definition rot_g = (node l (node m t u mi) v mi).

Lemma avl_rotg : (avl rot_g).
Goal. 
Unfold rot_g.
Apply avl_node; Auto.
Apply bal_mi; Simpl.
Elim Hut.
Elim max_n_n; Auto.
Apply supt_node; Auto.
Apply supt_trans with m; Auto.
Save.

Lemma equiv_rotg : (eqm:equil)(equiv_abe (node m t (node l u v dr) eqm) rot_g).
Goal. 
Intros eqm; Unfold equiv_abe rot_g; Split.
Intros x H; Elim (In_node_inv x m t (node l u v dr) eqm); Auto.
Intro H0; Elim (In_node_inv x l u v dr); Auto.
Intros x H; Elim (In_node_inv x l (node m t u mi) v mi); Auto.
Intro H0; Elim (In_node_inv x m t u mi); Auto.
Save.

Lemma haut_rotg : <nat>(S (haut v))=(haut rot_g).
Goal. 
Unfold rot_g; Elim haut_node.
Elim haut_node.
Elim Hut.
Elim max_n_n.
Elim Huv; Auto.
Save.

End left_rotation.

End simple_rotations.

Section double_rotations.

Variable n:a.
Variables u1,u2:abe.
Variable eqn : equil.

Local u =  (node n u1 u2 eqn).
Hypothesis avlu : (avl u).

Hypothesis infmu : (inft m u).
Hypothesis suplu : (supt l u).
Hypothesis infml : (inf m l).

Hint avlu infmu suplu infml.

Lemma infmu1 : (inft m u1).
Goal. 
Elim (inft_node_inv m n u1 u2 eqn); Auto.
Save.

Lemma suplu2 : (supt l u2).
Goal. 
Elim (supt_node_inv l n u1 u2 eqn); Auto.
Save.

Lemma infnl : (inf n l).
Goal. 
Elim (supt_node_inv l n u1 u2 eqn); Auto.
Save.

Lemma infmn : (inf m n).
Goal. 
Elim (inft_node_inv m n u1 u2 eqn); Auto.
Save.

Hint infmu1 suplu2 infnl infmn.

Lemma supnt : (supt n t).
Goal. 
Apply supt_trans with m; Auto.
Save.

Lemma infnv : (inft n v).
Goal. 
Apply inft_trans with l; Auto.
Save.

Hint supnt infnv.

Hypothesis Htu : <nat>(S (haut t))=(haut u).
Hypothesis Htv : <nat>(haut t)=(haut v).

Hint Htu Htv.

Local eqm = (<equil>Match eqn with (* ga *) mi (* mi *) mi (* dr *) ga).
Local eql = (<equil>Match eqn with (* ga *) dr (* mi *) mi (* dr *) mi).

Definition rot_gd = (node n (node m t u1 eqm) (node l u2 v eql) mi).

Lemma equiv_rotgd : (eql':equil)(equiv_abe (node l (node m t u dr) v eql') rot_gd).
Goal. 
Intros eql'; Unfold equiv_abe rot_gd; Split.
Intros x H; Elim (In_node_inv x l (node m t u dr) v eql'); Auto.
Intros H0; Elim (In_node_inv x m t u dr); Auto.
Intros H1; Elim (In_node_inv x n u1 u2 eqn); Auto.
Unfold u; Intros x H; 
       Elim (In_node_inv x n (node m t u1 eqm) (node l u2 v eql) mi);Trivial.
Intros H0; Elim (In_node_inv x  m t u1 eqm); Auto.
Intros H0; Elim (In_node_inv x l u2 v eql); Auto.
Auto.
Save.

Lemma equiv_rotdg : (eql':equil)(equiv_abe (node m t (node l u v ga) eql') rot_gd).
Goal. 
Intros eql'; Unfold equiv_abe rot_gd; Split.
Intros x H; Elim (In_node_inv x m t (node l u v ga) eql'); Auto.
Intros H0; Elim (In_node_inv x l u v ga); Auto.
Intros H1; Elim (In_node_inv x n u1 u2 eqn); Auto.
Unfold u; Intros x H; 
       Elim (In_node_inv x n (node m t u1 eqm) (node l u2 v eql) mi);Trivial.
Intros H0; Elim (In_node_inv x  m t u1 eqm); Auto.
Intros H0; Elim (In_node_inv x l u2 v eql); Auto.
Auto.
Save.

Lemma avl_rotgd : (avl rot_gd).
Goal. 
Unfold rot_gd.
Elim (avl_inv n u1 u2 eqn); Trivial.
Intros avlu1 avlu2 supnu1 infnu2 balu1u2.
Unfold eqm eql; Elim balu1u2.
Intro Hu1u2; Cut <nat>(haut t)=(haut u1).
Intro Htu1; Cut <nat>(S (haut u2))=(haut v).
Intro Hu2v; Apply avl_node; Auto.
Apply bal_mi; Simpl.
Elim Htu1; Elim max_n_n; Elim Hu2v; Elim max_n_Sn; Elim Hu1u2; Auto.
Elim Htv; Elim Hu1u2; Auto.
Apply eq_add_S; Replace (S (haut u1)) with (haut u); Auto.
Simpl; Rewrite -> Hu1u2; Auto.
Intro Hu1u2; Cut <nat>(haut t)=(haut u1).
Intro Htu1; Cut <nat>(haut u2)=(haut v).
Intro Hu2v; Apply avl_node; Auto.
Apply bal_mi; Simpl.
Elim Htu1; Elim max_n_n; Elim Hu2v; Elim max_n_n; Elim Hu1u2; Auto.
Elim Htv; Elim Hu1u2; Auto.
Apply eq_add_S; Replace (S (haut u1)) with (haut u); Auto. 
Simpl; Elim Hu1u2; Auto.
Intro Hu1u2; Cut <nat>(haut t)=(S (haut u1)).
Intro Htu1; Cut <nat>(haut u2)=(haut v).
Intro Hu2v; Apply avl_node; Auto.
Apply bal_mi; Simpl.
Rewrite -> Htu1.
Elim max_Sn_n; Elim Hu2v; Elim max_n_n; Auto.
Elim Htv; Rewrite -> Htu1; Auto.
Apply eq_add_S; Rewrite -> Htu; Simpl.
Elim Hu1u2; Auto.
Save.

Lemma haut_rotgd : <nat>(S (S (haut v)))=(haut rot_gd).
Goal. 
Unfold rot_gd.
Elim haut_node.
Elim haut_node.
Elim haut_node.
Elim Htv.
Replace (haut t) with (max (haut u1) (haut u2)).
Elim (max_sym (haut u2)).
Elim (max_case (haut u1) (haut u2)); Intro H.
Elim H.
Elim H.
Elim max_n_n; Auto.
Elim H.
Elim max_n_n.
Elim (max_sym (haut u2)); Elim H; Auto.
Apply eq_add_S; Auto.
Save.

End double_rotations.

End rotations.
Hint equiv_rotd equiv_rotg equiv_rotgd equiv_rotdg haut_rotd haut_rotg haut_rotgd.

Theorem insert : (x:a)(t:abe)(avl t)->(avl_spec x t).
Goal.
Realizer [x:a][t:abe]
            (avl_rec t avl_spec 
		(h_plus x nil (node x nil nil mi))
                [l:a][g:abe][d:abe][des:equil][avlsg:avl_spec][avlsd:avl_spec]
                  (<avl_spec>Match (inf_dec x l) with
                         (<avl_spec>Match avlsg with
                            [g':abe]
                             (h_eq x (node l g d des) (node l g' d des))
                            (bal_rec g d abe->avl_spec
                               [g':abe][{H:(avl_ins g')}]
                                (avl_ins_rec avl_spec
                                   [m:a][g'g:abe][g'd:abe]
                                      (h_eq x (node l g d ga)
                                            (rot_d l m g'g d g'd))
                                   [l0:a](False_rec avl_spec)
                                   [m:a][g'g:abe][g'd:abe]
                                      (abe_match avl_spec
                                         (False_rec avl_spec)
                                         [n:a][g'd1:abe][g'd2:abe][eqn:equil]
                                             (h_eq x (node l g d ga)
                                                (rot_gd l m g'g d n
                                                   g'd1 g'd2 eqn))
                                         g'd)
                                   g')
                               [g':abe](h_plus x (node l g d mi)
					      (node l g' d ga))
                               [g':abe](h_eq x (node l g d dr)
                                   	     (node l g' d mi))
                               des))
                         (<avl_spec>Match avlsd with
                            [d':abe](h_eq x (node l g d des) (node l g d' des))
                            (bal_rec g d abe->avl_spec
                               [d':abe](h_eq x (node l g d ga)
					     (node l g d' mi))
                               [d':abe](h_plus x (node l g d mi)
                                   	       (node l g d' dr))
                               [d':abe][{H:(avl_ins d')}]
                                (avl_ins_rec avl_spec
                                   [m:a][d'g:abe][d'd:abe]
                                      (abe_match avl_spec
                                         (False_rec avl_spec)
                                         [n:a][d'g1:abe][d'g2:abe][eqn:equil]
                                             (eq_rec nat
                                                (S (max (haut (node n d'g1
                                                                    d'g2 eqn))
                                                        (haut d'd)))
                                                avl_spec
                                                (eq_rec nat
                                                   (S (max (haut d'g1)
                                                           (haut d'g2)))
                                                   avl_spec
                                                   (h_eq x (node l g d dr)
                                                        (rot_gd m l g d'd
                                                                n d'g1 d'g2
                                                                eqn))
                                                   (haut (node n d'g1 d'g2
                                                               eqn)))
                                                (haut (node m (node n d'g1 d'g2
                                                                    eqn)
                                                            d'd ga)))
                                         d'g)
                                   [m:a](False_rec avl_spec)
                                   [m:a][d'g:abe][d'd:abe]
                                      (h_eq x (node l g d dr)
                                            (rot_g m l g d'd d'g))
                                   d')
                               des)))).
Program_all.

(* First lemma *)
Apply equiv_intro ; Intros ; Auto.
Elim  (In_node_inv x0 x nil nil mi) ; Auto.
(* Second lemma *)
Apply avl_node ; Auto.
Apply bal_haut with g d ; Trivial.
Apply equiv_sup_g with g x ; Auto.
(* 3d lemma *)
Apply avl_rotd ; Auto.
Apply equiv_sup_g with g x; Auto.
Apply eq_add_S ; Elim H10 ; Apply eq_add_S ; Elim H7 . 
Elim e0 ; Elim haut_node.
Rewrite -> H10.
Auto.
(* 4th lemma *)
Apply equiv_equiv_abe with (node l (node l0 g0 d0 ga) d ga) ; Auto.
(* 5th lemma *)
Elim haut_node.
Rewrite -> H7.
Elim max_Sn_n.
Elim haut_rotd ; Auto.
Elim H7 ; Elim e0.
Elim haut_node.
Rewrite -> H10.
Elim max_Sn_n ; Auto.
Apply eq_add_S ; Elim H10 ; Apply eq_add_S ; Elim H7 . 
Elim e0 ; Elim haut_node.
Rewrite -> H10.
Auto.
(* 6th lemma *)
Absurd <nat>O=(haut g); Auto.
Rewrite -> H7 ; Auto.
(* 7th lemma *)
Absurd <nat>(S (haut g0))=O ; Auto.
(* 8th lemma *)
Apply avl_rotgd; Auto.
Elim (supt_node_inv l l0 g0  (node l1 g1 d1 des0) dr); Auto.
Apply equiv_sup_g with g x ; Auto.
Apply eq_add_S ; Elim H10 ; Apply eq_add_S ; Elim H7 .
Elim e0 ; Elim haut_node.
Elim H10.
Auto.
(* 9th lemma *)
Apply equiv_equiv_abe with (node l (node l0 g0 (node l1 g1 d1 des0) dr) d ga) ; Auto.
(* 10th lemma *)
Elim haut_rotgd ; Auto.
Elim haut_node.
Rewrite -> H7 ; Auto.
Apply eq_add_S ; Elim H10 ; Apply eq_add_S ; Elim H7 .
Elim e0 ; Elim haut_node.
Elim H10.
Auto.
(* 11th lemma *)
Apply ins_ga ; Auto.
Elim H7 ; Auto.
Apply equiv_sup_g with g x ; Auto.
(* 12th lemma *)
Elim haut_node; Elim haut_node; Elim H7; Elim max_n_n.
Rewrite -> e0; Auto.
(* 13th lemma *)
Apply avl_node ; Auto.
Apply bal_mi ; Auto.
Elim H7; Auto.
Apply equiv_sup_g with g x ; Auto.
(* 14th lemma *)
Elim haut_node; Elim haut_node; Elim H7; Elim max_n_Sn.
Elim e0 ; Auto.
(* 15th lemma *)
Apply avl_node ; Auto.
Apply bal_haut with g d ; Trivial.
Apply equiv_inf_g with d x ; Auto.
(* 16th lemma *)
Simpl; Elim e0; Auto.
(* 17th lemma *)
Apply avl_node ; Auto.
Apply bal_mi ; Auto.
Rewrite -> H7; Auto.
Apply equiv_inf_g with d x ; Auto.
(* 18th lemma *)
Simpl; Rewrite -> e0.
Rewrite -> H7.
Elim max_Sn_n; Auto.
(* 19th lemma *)
Apply ins_dr ; Auto.
Apply trans_equal with (S (haut d)); Auto.
Apply equiv_inf_g with d x ; Auto.
(* 20st lemma *)
Elim haut_node; Elim haut_node; Rewrite -> H7.
Elim max_n_n; Rewrite e0; Auto.
(* 21nd lemma *)
Absurd <nat>O=(S (haut d0)); Auto.
(* 22d lemma *)
Apply avl_rotgd ; Auto.
Elim (inft_node_inv l l0 (node l1 g1 d1 des0) d0 ga); Auto.
Apply equiv_inf_g with d x ; Auto.
Simpl.
Simpl in H10.
Rewrite -> H7.
Apply eq_add_S; Elim e0.
Rewrite -> H10.
Auto.
Apply eq_add_S; Elim H10.
Rewrite -> H7.
Simpl; Apply eq_add_S; Elim e0.
Simpl in H10.
Rewrite -> H10.
Auto.
(* 23th lemma *)
Apply equiv_equiv_abe with (node l g (node l0 (node l1 g1 d1 des0) d0 ga) dr) ; Auto.
(* 24th lemma *)
Elim haut_node; Elim haut_rotgd; Auto.
Elim H7; Elim max_n_Sn.
Rewrite -> H7.
Elim e0.
Simpl in H10; Elim H10.
Rewrite -> H10.
Auto.
Rewrite -> H7.
Simpl.
Apply eq_add_S; Elim e0.
Simpl in H10; Rewrite -> H10; Auto.
Apply eq_add_S; Rewrite -> H7.
Elim H10.
Simpl.
Apply eq_add_S; Elim e0.
Simpl in H10; Rewrite -> H10; Auto.
(* 25th lemma *)
Absurd <nat>O=(haut d); Auto.
Elim H7; Auto.
(* 26th lemma *)
Apply avl_rotg ; Auto.
Apply equiv_inf_g with d x ; Auto.
Apply eq_add_S; Rewrite -> H7.
Apply eq_add_S; Elim e0; Simpl; Elim H10; Auto.
(* 27th lemma *)
Apply equiv_equiv_abe with (node l g (node l0 g0 d0 dr) dr) ; Auto.
(* 28th lemma *)
Elim haut_rotg.
Elim haut_node.
Elim H7; Elim max_n_Sn.
Rewrite -> H7.
Elim e0; Simpl.
Elim H10; Auto.
Apply eq_add_S; Rewrite -> H7.
Apply eq_add_S; Elim e0; Simpl; Elim H10; Auto.
Rewrite -> H10; Auto.
Save.

End trees.

Provide Avl_prog.
