(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                    Variations on Ackermann's function                     *)
(*                                                                           *)
(*****************************************************************************)

(*****************************************************************************)
(*                                                                           *)
(*                    		Definitions             	             *)
(*                                                                           *)
(*****************************************************************************)


Inductive Definition Ack : nat->nat->nat->Prop =
     AckO : (n:nat)(Ack O n (S n))
   | AcknO : (n,p:nat)(Ack n (S O) p)->(Ack (S n) O p)
   | AckSS : (n,m,p,q:nat)
             (Ack (S n) m q)->(Ack n q p)->(Ack (S n) (S m) p).

Hint AckO AcknO.


(*****************************************************************************)
(*                                                                           *)
(*                    Automatic proof from the program                       *)
(*                                                                           *)
(*****************************************************************************)

(* Functional definition of Ackermann :
 (ack 0 n) = (S n)
 (ack (S n) 0) = (ack n (S 0))
 (ack (S n) (S m)) = (ack n (ack (S n) m)) *)
 
Definition ack = 
   [n:nat](<nat->nat> Match n with 
           (* 0 *) S
       (* (S n) *) [n:nat][f:nat->nat][m:nat]
                   (<nat> Match m with 
                   (* 0 *) (f (S O))
                 (* S m *) [m:nat][r:nat](f r))).


Theorem Ackermann : (n,m:nat){p:nat|(Ack n m p)}.
Goal.
Realizer [n:nat]
          (<nat->nat>Match n with
	    [m:nat](S m)
            [y:nat][H:nat->nat][m:nat]
                  (<nat>Match m with
                    (H (S O))
                    [m':nat][H':nat](H H'))).
Program_all.
Apply AckSS with x; Auto.
Save.

Provide Ack_prog.
