(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.6         *)
(*****************************************************************************)
(*                                                                           *)
(*                    Lambo function                                         *)
(*                                                                           *)
(*                                                                           *)
(*****************************************************************************)
    (*******************************************************************)
    (* f : nat->nat is an increasing and unbounded function            *)
    (* lambo(f)(n) = inf {m:nat| f(m)>n}                               *)
    (* is computed using the following algorithm :                     *)
    (* lambo f n = if f(0) > n the 0 else limbo(1)                     *)
    (*        where limbo(i) = if f(i) > n then 0                      *)
    (*                         else let j = limbo(2i) in               *)
    (*                  if f(j+i) > n then j else j+i                  *)
    (*******************************************************************)

(* use Prelude, Prel_Lem, Nat *)

Definition one    : nat    = (S O).

(* Addition and multiplication by 2 *)
Definition add : nat->nat->nat    = [n:nat][m:nat]
                               (<nat>Match n with m [n0:nat]S).

Definition twice : nat->nat = [n:nat](add n n).

Definition peano = [n:nat][P:nat->Prop]<P>Match n with
         :(n:nat)(P:nat->Prop)(P O)->((u:nat)(P u)->(P (S u)))->(P n).


(* Operator for pattern-matching *)
 Definition     nat_match 
     :    (n:nat)(P:nat->Prop)(P O)->((m:nat)(P (S m)))->(P n)
     =    [n:nat][P:nat->Prop][h1:(P O)][h2:(m:nat)(P (S m))]
        (peano n P h1 [m:nat][ind:(P m)](h2 m)).

(* Properties of addition                         *)
Theorem add_nO     (n:nat)<nat>(add n O)=n
Proof    [n:nat](peano n [u:nat](<nat>(add u O)=u)
           (refl_equal nat O)
           ([u:nat](f_equal nat nat S (add u O) u))).

Theorem add_ass    (u,v,w:nat)<nat>(add (add u v) w)=(add u (add v w))
Proof    [u,v,w:nat]
    (peano u [m:nat]<nat>(add (add m v) w)=(add m (add v w))
        (refl_equal nat (add v w))
        [m:nat](f_equal nat nat S (add (add m v) w) (add m (add v w)))).

(* Induction de contenu positif                        *)
Definition peano_set = [n:nat][P:nat->Set]<P>Match n with
         :(n:nat)(P:nat->Set)(P O)->((u:nat)(P u)->(P (S u)))->(P n).

(* Absurdity *)

 Theorem abs     (A:Prop)(False -> A)
 Proof [A:Prop][h:False]<A>Match h with.

(* An axiomatized order relation on natural numbers *)

 Parameter     inf : nat->nat->Prop.

 Axiom tran_inf    :     (trans nat inf).
 Axiom infOO    :     (inf O O).
 Axiom infS_inf    :    (n,m:nat)(inf (S n) (S m))->(inf n m).
 Axiom inf_infS    :    (n,m:nat)(inf n m)->(inf (S n) (S m)).
 Axiom infS    :    (n:nat)(inf n (S n)).
 Axiom absO    :    (inf one O)->False.

 Definition sup    : nat->nat->Prop    = [n,m:nat](inf (S m) n).

(* Properties of this order *)

 Lemma re_inf     (n:nat)(inf n n)
 Proof    [n:nat](peano n [u:nat](inf u u) infOO
           [u:nat][h:(inf u u)](inf_infS u u h)).
      
 Lemma infO      (n:nat)(inf O n)
 Proof    [n:nat](peano n (inf O) (infOO) 
           [u:nat][h:(inf O u)](tran_inf O u (S u) h (infS u))).


 Lemma infS_O    (n:nat)(inf (S n) O)->False
 Proof    [n:nat](peano n [u:nat](inf (S u) O)->False absO
           ([u:nat][h:(inf (S u) O)->False][t:(inf (S (S u)) O)]
            (h (tran_inf (S u) (S (S u)) O (infS (S u)) t)))).


 Lemma infSn_n     (n:nat)(inf (S n) n)->False
 Proof     [n:nat](peano n [u:nat](inf (S u) u)->False absO
           ([u:nat][h:(inf (S u) u)->False]
            [t:(inf (S (S u)) (S u))](h (infS_inf (S u) u t)))).

 Lemma inf_sup_abs    (n,m:nat)(inf n m)->(sup n m)->False
 Proof     [n,m:nat][h1:(inf n m)][h2:(sup n m)]
        (infSn_n n (tran_inf (S n) (S m) n (inf_infS n m h1) h2)).

(* A lemma : (sup n m)->(sup (twice n) (S m)) *)

 Lemma inf_add  (n,m:nat)(inf m (add n m))
 Proof [n,m:nat]
       (peano n [u:nat](inf m (add u m))
       (re_inf m)
       ([u:nat][h:(inf m (add u m))]
        (tran_inf m (add u m) (add (S u) m)  h (infS (add u m))))).

 Lemma sup_twice  (n,m:nat)(sup n m)->(sup (twice n) (S m))
 Proof [n,m:nat]
       (nat_match n [u:nat](sup u m)->(sup (twice u) (S m))
       [h:(sup O m)](abs (sup (twice O) (S m)) (infS_O m h))
       [u:nat][h:(sup (S u) m)]
       (inf_infS (S m) (add u (S u))
           (tran_inf (S m) (S u) (add u (S u)) 
           h (inf_add u (S u))))).


(* Program Lambo *)

(* Hypotheses *)
Variable f    : nat->nat.

(* f is unbounded *)
Hypothesis Unbound    
    :    (n:nat){y:nat|(sup (f y) n)}.

(* f is increasing *)
Hypothesis Increas    : (n:nat)(m:nat)(inf n m)->(inf (f n) (f m)).

(* There is a procedure to decide if inf or sup hold *)

Axiom inf_sup    : (x:nat)(y:nat) {(inf x y)}+{(sup x y)}.
Axiom inf_sup0    : (x:nat)(y:nat)(inf x y)\/(sup x y).

(* We give n : nat and try to compute lambo(n) *)
Variable n : nat.

 Definition Inf : nat->Prop   = [m:nat](inf (f m) n).
 Definition Sup : nat->Prop   = [m:nat](sup (f m) n).

(* We only use the following properties of Inf and Sup *)

 Definition bound : {y:nat|(sup (f y) n)}
           = (Unbound n).

 Definition Inf_Sup : (u:nat){(Inf u)}+{(Sup u)}
             = [u:nat](inf_sup (f u) n).

 Definition Inf_Sup_abs : (u:nat)(Inf u)->(Sup u)->False
             = [u:nat](inf_sup_abs (f u) n).

(* F is increasing is used this way *)

 Lemma infInf     (u,v:nat)(inf u v)->(Inf v)->(Inf u)
 Proof    [u,v:nat][h1:(inf u v)][h2:(Inf v)]
    (tran_inf (f u) (f v) n (Increas u v h1) h2).

(* Setifications *)
 Definition Small : nat->Prop = [m:nat](i:nat)(inf (S i) m)->(Inf i).

 Lemma SmallO  (Small O) 
 Proof [i:nat][h:(inf (S i) O)](abs (Inf i) (infS_O i h)).

(* The initial specification *)
 Definition Lambo : Set = {m:nat|(Sup m)&(Small m)}.

 Fact Lem1  (m:nat)(Inf m)->(Small (S m))
 Proof          [m:nat][h:(Inf m)][i:nat][q:(inf (S i) (S m))]
         (infInf i m (infS_inf i m q) h).

(* Transformation of the specification *)
 Definition Lambo1 : Set 
              = ({m:nat|(Inf m)&(Sup (S m))})+{(Sup O)}.

 Lemma Reduct1  Lambo1->Lambo
 Proof [h:Lambo1]
 (sumor_rec {m:nat|(Inf m)&(Sup (S m))} (Sup O)
    [s:({m:nat|(Inf m)&(Sup (S m))})+{(Sup O)}]Lambo
    [h1:{m:nat|(Inf m)&(Sup (S m))}]
     (sig2_rec nat Inf [m:nat](Sup (S m))
        [s:{m:nat|(Inf m)&(Sup (S m))}]Lambo
        [m:nat]
         [f1:(Inf m)]
          [f2:(Sup (S m))](exist2 nat Sup Small (S m) f2 (Lem1 m f1))
        h1)
    [h2:(Sup O)](exist2 nat Sup Small O h2 SmallO) h).

(* Intermediate function *)
 Definition Limbo : nat -> Set 
     = [i:nat]
     (sup i O)-> ({m:nat|(Inf m)&(Sup (add i m))})+{(Sup O)}.

(* (add one m)=(S m) by Beta reduction *)

 Lemma Reduct2  (Limbo one)->Lambo1 
 Proof [h:(Limbo one)](h (re_inf one)).

(* Termination *)

(* A parametrized order *)
 Definition bd : nat->nat->nat->Prop 
          = [y:nat][u:nat][v:nat]((sup u v)/\(inf v y)).

(* Property to be well-formed *)
 Definition wf_bd 
     : nat->nat->Set
     = [y:nat][i:nat]
     (P:nat->Set)((v:nat)((u:nat)(bd y u v)->(P u))->(P v))->(P i).

(* Some property of bd *)

 Fact Lem2  (y1,y2,u,v:nat)(bd y1 u v)->(inf v y2)->(bd y2 u v)
 Proof [y1,y2,u,v:nat][h1:(bd y1 u v)][h2:(inf v y2)]
        <(sup u v),(inf v y2)>{<(sup u v),(inf v y1)>Fst{h1},h2}.

 Fact Lem3  (y,u,v,w:nat)(bd y u v)->(bd y v w)->(sup y w)
 Proof [y,u,v,w:nat][h1:(bd y u v)][h2:(bd y v w)]
       (tran_inf (S w) v y <(sup v w),(inf w y)>Fst{h2}
       <(sup u v),(inf v y)>Snd{h1}).

 Lemma Term  (i,y:nat)(sup i y)->(wf_bd y i)
 Proof [i,y:nat][h:(sup i y)]
       [P:nat->Set][q:(v:nat)((u:nat)(bd y u v)->(P u))->(P v)]
       (q i [u:nat][g:(bd y u i)]
      (except (P u) (inf_sup_abs i y <(sup u i),(inf i y)>Snd{g} h))).

(* Proof of (wf_bd y) by induction on y *)

 Lemma cas_base (i:nat)(sup i O)->(wf_bd O i)
 Proof [i:nat][h:(sup i O)][P:nat->Set]
       [q:(v:nat)((u:nat)(bd O u v)->(P u))->(P v)]
    (q i [u:nat][g:(bd O u i)]
       (except (P u) (inf_sup_abs i O <(sup u i),(inf i O)>Snd{g} h))).

 Lemma cas_ind  (i,y:nat)(wf_bd y i)->(wf_bd (S y) i)
 Proof [i,y:nat][ind:(wf_bd y i)][P:nat->Set]
       [q:(v:nat)((u:nat)(bd (S y) u v)->(P u))->(P v)]
       (ind P [v:nat][g:(u:nat)(bd y u v)->(P u)]
          (q v [u:nat][h:(bd (S y) u v)]
               (sumbool_rec (inf v y) (sup v y)
                  [s:{(inf v y)}+{(sup v y)}](P u)
                  [t1:(inf v y)](g u (Lem2 (S y) y u v h t1))
                  [t2:(sup v y)]
                   (q u [w:nat][l:(bd (S y) w u)]
                        (except (P w)
                           (infSn_n v
                            (tran_inf (S v) (S y) v
                               (Lem3 (S y) w u v l h) t2))))
                               (inf_sup v y)))).

Theorem Wf  (y,i:nat)(sup i O)->(wf_bd y i)
 Proof     [y,i:nat][h:(sup i O)]
     (peano_set y [u:nat](wf_bd u i) (cas_base i h) (cas_ind i)).

(* Actually we will use a simpler induction scheme *)

 Definition Induct : nat->nat->(nat->Set)->Set
             = [y:nat][i:nat][P:nat->Set]
          ((k:nat)((inf k y)->(P (twice k)))->(P k))->(P i).

(* Proof of the induction scheme *)
Theorem wf_Ind (y:nat)(i:nat)(sup i O)->(P:nat->Set)(Induct y i P)
 Proof [y:nat][i:nat][h:(sup i O)][P:nat->Set]
       (nat_rec [n:nat](Induct n i P)
        ([q:(k:nat)((inf k O)->(P (twice k)))->(P k)]
         (q i [r:(inf i O)](except (P (twice i)) (inf_sup_abs i O r h))))
        ([u:nat][ind:(Induct u i P)]
         [q:(k:nat)((inf k (S u))->(P (twice k)))->(P k)]
          (ind [k:nat][r:(inf k u)->(P (twice k))]
               (q k [t:(inf k (S u))]
                  (sumbool_rec (inf k u) (sup k u)
                   [s:{(inf k u)}+{(sup k u)}]
                    (P (twice k)) r
                     [v:(sup k u)]
                     (q (twice k) [s:(inf (twice k) (S u))]
                                  (except (P (twice (twice k)))
                                    (inf_sup_abs (twice k) (S u) s
                                        (sup_twice k u v))))
                     (inf_sup k u))))) y).

(* Proof of the Limbo's program  *)

 Fact Lem4  (u,v:nat)(Sup u)->(Inf v)->(inf v u)
  Proof [u,v:nat][h1:(Sup u)][h2:(Inf v)]
        (or_ind (inf v u) (sup v u) (inf v u)
          [t1:(inf v u)]t1
          [t2:(sup v u)]
           (abs (inf v u)
            (Inf_Sup_abs u
              (infInf u v (tran_inf u (S u) v (infS u) t2) h2) h1))
          (inf_sup0 v u)).

 Definition LimboSig : nat->Set 
            = [i:nat]{m:nat|(Inf m)&(Sup (add i m))}.

 Lemma LimboLem  (i:nat)(sup i O)->(Inf O)->(LimboSig i)
 Proof [i:nat][h1:(sup i O)][h2:(Inf O)]
       (sig_rec nat [y:nat](sup (f y) n)
        [s:{y:nat|(sup (f y) n)}](LimboSig i)
        [y:nat][hy:(sup (f y) n)]
        (wf_Ind y i h1 LimboSig
             [k:nat][hk:(inf k y)->(LimboSig (twice k))]
               (sumbool_rec (Inf (add k O)) (Sup (add k O))
                [s:{(Inf (add k O))}+{(Sup (add k O))}](LimboSig k)
                [t1:(Inf (add k O))]
                  (sig2_rec nat Inf [m:nat](Sup (add (twice k) m))
                    [s:{m:nat|(Inf m)&(Sup (add (twice k) m))}]
                      (LimboSig k)
                    [m:nat][u1:(Inf m)][u2:(Sup (add (twice k) m))]
                      (sumbool_rec (Inf (add k m)) (Sup (add k m))
                       [s:{(Inf (add k m))}+{(Sup (add k m))}]
                         (LimboSig k)
                       [s1:(Inf (add k m))]
                       (exist2 nat Inf [p:nat](Sup (add k p))
                               (add k m) s1
                               (eq_ind nat (add (add k k) m)
                                 [n:nat](Sup n) u2
                                 (add k (add k m)) (add_ass k k m)))
                       [s2:(Sup (add k m))]
                       (exist2 nat Inf [p:nat](Sup (add k p))
                               m u1 s2)
                       (Inf_Sup (add k m)))
                    (hk (Lem4 y k hy
                        (eq_ind nat (add k O) [n:nat](Inf n) t1 k
                                 (add_nO k)))))
                  [t2:(Sup (add k O))]
                   (exist2 nat Inf [m:nat](Sup (add k m)) O h2 t2)
                  (Inf_Sup (add k O))))
        bound).

 Lemma Prog  (i:nat)(Limbo i)
 Proof [i:nat][h:(sup i O)]
       (<({m:nat|(Inf m)&(Sup (add i m))})+{(Sup O)}>
         Match (Inf_Sup O) with 
      (* left t1 *) [t1:(Inf O)](inleft (LimboSig i) (Sup O) (LimboLem i h t1))
     (* right t2 *) [t2:(Sup O)](inright (LimboSig i) (Sup O) t2)).

(* Final proof *)
Theorem LamboProg  Lambo 
Proof  (Reduct1 (Reduct2 (Prog one))).

Provide Manna.
