(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.6         *)
(*****************************************************************************)
(*                                                                           *)
(*                    Formatting program                                     *)
(*                                                                           *)
(*                    Christine Paulin-Mohring                               *)
(*                                                                           *)
(*****************************************************************************)

    
    (**********************************************************************)
    (* A list of words separated by white characters (space or line feed) *)
    (* is given. The program produces a formated list, that is the same   *)
    (* list of words separated by just one line-feed or space in order to *)
    (* put the maximum number of words on the same line.                  *)
    (**********************************************************************)

Chapter Format.

(* Environment *)

(****************************************************************************)
(* The non-white characters (letters) are indexed by a type Ind.            *)
(* The white spaces (separators) are                                        *)
(* indexed by the type bool (space = true and linefeed = false)             *)
(* The data structure is a type of lists with two constructors for cons of  *)
(* letters and cons of separators                                           *)
(****************************************************************************)


 Parameter      Induct :   Set.                                           
 Inductive Set l_ch = nil : l_ch 
                     | consbl : bool->l_ch->l_ch 
                     | consltr : Induct->l_ch->l_ch.

 Definition l_ch_it.
 Body [l:l_ch][C:Set][x:C][f1:bool->C->C][f2:Induct->C->C]
      (<C>Match l with x [b:bool][l0:l_ch](f1 b)
                     [i:Induct][l0:l_ch](f2 i)) :
      l_ch -> (C:Set)C -> (bool->C->C) -> (Induct->C->C)->C.

 Definition nat_it.
 Body [n:nat][C:Set][x:C][f:C->C](<C>Match n with x [m:nat]f) :
      nat -> (C:Set)C -> (C -> C) ->C.

 Local conssp (consbl true). 
 Local conslf (consbl false). 

(* Induction on the type l_ch *)

 Definition LCH_Ind =
    [x:l_ch][P:l_ch->Prop]<P>Match x with :   
    (x:l_ch)(P:l_ch->Prop)
            (P nil)->((b:bool)(l:l_ch)(P l)->(P (consbl b l)))
            ->((i:Induct)(l:l_ch)(P l)->(P (consltr i l)))
            ->(P x).                                                    

 Definition LCH_rec = [x:l_ch][P:l_ch->Set]<P>Match x with :
    (x:l_ch)(P:l_ch->Set)
            (P nil)->((b:bool)(l:l_ch)(P l)->(P (consbl b l)))
            ->((i:Induct)(l:l_ch)(P l)->(P (consltr i l)))
            ->(P x).                                                    

(* case definition *)

Section Casebl.

 Variable  A : Set.                                                    
 Variable c  : l_ch.
 Variable xnil : A.
 Variables xbl,xltr:A->A.
 Definition  Casebl.
 Body     (l_ch_it c A xnil [b:bool]xbl [i:Induct]xltr) : A.

End Casebl.

(* Length function *)

 Definition lgth.
 Body [l:l_ch](Casebl nat l O S S) : l_ch->nat.              

(* Append function *)

 Definition app.
 Body [l,m:l_ch](l_ch_it l l_ch m consbl consltr) : 
      l_ch->l_ch->l_ch.   

 Local  appsp [l,m:l_ch](app l (conssp m)).                        

 Local  applf [l:l_ch][m:l_ch](app l (conslf m)).          

(* Maximal allowed length of a line *)

 Parameter  max : nat.                                                   

(* Predicate that recognize a word : sequenz (eventually empty) of letters *) 

Inductive Definition word : l_ch -> Prop
    = wordnil : (word nil)
    | wordltr : (j:Induct)(l:l_ch)(word l)->(word (consltr j l)).

(* Predicate that recognize a non-empty sequenz of separators *)

Inductive Definition space  :  l_ch->Prop
     =  space_bl    : (b:bool)(space (consbl b nil))
       |space_co_bl : (b:bool)(l:l_ch)(space l)->(space (consbl b l)).

(* We give an axiomatisation of predicates inf and sup on integers.     *)
(* We will cut  a line according these predicates.                      *)
(* inf n means  n < max and sup n means n >= max                        *)

 Parameter inf, sup : nat->Prop.                                    
 Axiom ax1     :   (n:nat)({(inf n)}+{(sup n)}).                       

 Local  inflg   [m:l_ch](inf (lgth m)).                            

 Local  suplg   [m:l_ch](sup (lgth m)).                            

 Local plus.
 Body [m:l_ch][n:nat](nat_it (lgth m) nat n S) : l_ch->nat->nat.

(* The words must be of length less than max. We define a predicate valide. *)
(* A proof of (valide l) gives a decomposition of the list of characters    *)
(* in words of length less than max, separated by spaces                    *)

Inductive Definition valide  :l_ch->Set
    = vword : (m:l_ch)(word m)->(inflg m)->(valide m)
     |vapp  : (m1,m2,p:l_ch)(word m1)->(inflg m1)->(space m2)->(valide p)
            ->(valide (app m1 (app m2 p))).

(* The empty list is valide if 0<max *)

 Hypothesis infmax : (inf O).                                         

(* A list will be non-valid if it contains a too long word *)

Inductive Definition NV : l_ch->Prop
    = NVword :  (l:l_ch)(word l)->(suplg l)->(NV l)
    |NVapp1 :  (l,m:l_ch)(NV l)->(NV (app l m))
    |NVapp2 :  (l,m:l_ch)(NV l)->(NV (app m l)).

(* We show that every list satisfies valide or NV, this is an informative *)
(* proof (a preprocessing of the text).                                    *)

Inductive Definition val_or_no [l:l_ch] : Set
    = inval : (valide l)->(val_or_no l)
     |inNV : (NV l) -> (val_or_no l).

(* To add a space to a valid list is easy *)

Remark valbl.
Statement  (b:bool)(l:l_ch)(valide l)->(valide (consbl b l)).
Proof [b:bool][l:l_ch][h:(valide l)]
        (vapp nil (consbl b nil) l wordnil infmax (space_bl b) h).      

(* For adding a letter to a valid list, we need to test whether max *)
(* is overheaded.                                                   *) 

Remark valltr.
Statement (i:Induct)(l:l_ch)(valide l)->(val_or_no (consltr i l)).
 Proof
     [i:Induct][l:l_ch][h:(valide l)]
     (valide_rec [l0:l_ch][v:(valide l0)](val_or_no (consltr i l0))
        [m:l_ch][t1:(word m)][t2:(inflg m)]
         (sumbool_rec (inf (S (lgth m))) (sup (S (lgth m)))
            [s:{(inf (S (lgth m)))}+{(sup (S (lgth m)))}]
             (val_or_no (consltr i m))
            [h1:(inf (S (lgth m)))]
            (inval (consltr i m)
                   (vword (consltr i m) (wordltr i m t1) h1))
            [h2:(sup (S (lgth m)))]
            (inNV (consltr i m)
                  (NVword (consltr i m) (wordltr i m t1) h2))
            (ax1 (S (lgth m))))
        [m1:l_ch][m2:l_ch][p:l_ch][t1:(word m1)][t2:(inflg m1)]
        [t3:(space m2)][f1:(valide p)][f2:(val_or_no (consltr i p))]
              (sumbool_rec (inf (S (lgth m1))) (sup (S (lgth m1)))
                 [s:{(inf (S (lgth m1)))}+{(sup (S (lgth m1)))}]
                  (val_or_no (consltr i (app m1 (app m2 p))))
                 [h11:(inf (S (lgth m1)))]
                   (inval (consltr i (app m1 (app m2 p)))
                          (vapp (consltr i m1) m2 p (wordltr i m1 t1)
                                  h11 t3 f1))
                 [h12:(sup (S (lgth m1)))]
                   (inNV (consltr i (app m1 (app m2 p)))
                         (NVapp1 (consltr i m1) (app m2 p)
                                 (NVword (consltr i m1)
                                         (wordltr i m1 t1) h12)))
                 (ax1 (S (lgth m1)))) l h).

(* The complete proof is by induction on the structure of the list *)

Lemma preproc.
Statement (l:l_ch)(val_or_no l).
Proof [l:l_ch]
      (LCH_rec l val_or_no (inval nil (vword nil wordnil infmax))
               [b:bool][m:l_ch][h:(val_or_no m)]
                (val_or_no_rec m
                  [v:(val_or_no m)](val_or_no (consbl b m))
                  [h1:(valide m)](inval (consbl b m) (valbl b m h1))
                  [h2:(NV m)]
                   (inNV (consbl b m) (NVapp2 m (consbl b nil) h2)) h)
               [i:Induct][m:l_ch][h:(val_or_no m)]
                (val_or_no_rec m
                  [v:(val_or_no m)](val_or_no (consltr i m))
                  (valltr i m)
                  [t:(NV m)]
                   (inNV (consltr i m) (NVapp2 m (consltr i nil) t)) h)).

(* We define the relation "two lists are equivalent", the intended meaning *)
(* is that they represent the same list of words.                          *)

Section Equivalence.

 Inductive Definition Eq  : l_ch->l_ch->Prop
    = Eq_nil : (Eq nil nil)
    | Eq_bl_nil : (b:bool)(l:l_ch)(Eq l nil)->(Eq (consbl b l) nil)
    | Eq_co_bl  : (b,c:bool)(l,m:l_ch)(Eq l m)->(Eq (consbl b l) (consbl c m))
    | Eq_co_ltr : (i:Induct)(l,m:l_ch)
            (Eq l m)->(Eq (consltr i l) (consltr i m))
    | Eq_bl_bl  : (b,c:bool)(l,m:l_ch)
            (Eq l (consbl b m))->(Eq (consbl c l)(consbl b m))
    | Eq_tran : (l,m,n:l_ch)(Eq l m)->(Eq m n)->(Eq l n).

(* Properties of equivalence *)

(* Reflexivity *)

 Theorem Eq_re.
 Statement   (l:l_ch)(Eq l l).
 Proof    [l:l_ch](LCH_Ind l [u:l_ch](Eq u u) Eq_nil 
                    [b:bool][m:l_ch](Eq_co_bl b b m m) 
                    [i:Induct][m:l_ch](Eq_co_ltr i m m)).                  

(* Eq stability with respect to append *)

 Theorem Eq_app.
 Statement  (l,m,n:l_ch)(Eq m n)->(Eq (app l m) (app l n)).
 Proof [l,m,n:l_ch][h:(Eq m n)]
       (LCH_Ind l [u:l_ch](Eq (app u m) (app u n)) h 
            [b:bool][u:l_ch](Eq_co_bl b b (app u m) (app u n)) 
            [i:Induct][u:l_ch](Eq_co_ltr i (app u m) (app u n))).          

(* particular case n=nil, directly proved *)

 Theorem Eq_app_nil.
 Statement (l,m:l_ch)(Eq m nil)->(Eq (app l m) l).
 Proof  [l,m:l_ch][h:(Eq m nil)]
       (LCH_Ind l [u:l_ch](Eq (app u m) u) h 
            [b:bool][u:l_ch](Eq_co_bl b b (app u m) u) 
            [i:Induct][u:l_ch](Eq_co_ltr i (app u m) u)).                  

(* Adding more than one separator does not change anything *)
 Theorem Eq_space_bl.
 Variable b : bool.
 Variables l,m,n:l_ch.
 Statement (space l)->(Eq m (consbl b n))->(Eq (app l m) (consbl b n)).
 Proof  [h1:(space l)][h2:(Eq m (consbl b n))]
         (space_ind [l:l_ch](Eq (app l m) (consbl b n))
                    [c:bool](Eq_bl_bl b c m n h2)
                    [c:bool][u:l_ch][x:(space u)]
                     [t:(Eq (app u m) (consbl b n))]
                     (Eq_bl_bl b c (app u m) n t) l h1).

(* Adding separators at the beginning of the list is equivalent to nil *)
 Theorem Eq_space_nil.
 Statement (m:l_ch)(space m)->(Eq (app m nil) nil).
 Proof  [m:l_ch][h:(space m)]
         (space_ind [l:l_ch](Eq (app l nil) nil)
                    [b:bool](Eq_bl_nil b nil Eq_nil)
                    [b:bool][u:l_ch][x:(space u)]
                     [t:(Eq (app u nil) nil)]
                     (Eq_bl_nil b (app u nil) t) m h).

(* Adding separators is equivalent to add a space *)
 Theorem Eq_space.
 Statement (l,m,n:l_ch)(space l)->(Eq m n)->(Eq (app l m) (conssp n)).
 Proof [l,m,n:l_ch][h1:(space l)][h2:(Eq m n)]
        (space_ind [l0:l_ch](Eq (app l0 m) (conssp n))
                   [c:bool](Eq_co_bl c true m n h2)
                   [c:bool][u:l_ch][x:(space u)]
                    [t:(Eq (app u m) (conssp n))]
                     (Eq_bl_bl true c (app u m) n t) l h1).

End Equivalence.

(* Definition of the predicate formn : nat->l_ch->Prop. (formn n l) means that
 l is a formated list with n characters on its last line *)

Inductive Definition formn :nat->l_ch->Prop
    = fword : (m:l_ch)(word m)->(inflg m)->(formn (lgth m) m)
    | fwordinf : (p:nat)(m1:l_ch)(b:bool)(m2:l_ch)
             (inf (plus m1 p))->(word m1)->(formn p (consbl b m2))
              ->(formn (plus m1 p) (appsp m1 m2))
    | fwordsup : (p:nat)(m1:l_ch)(b:bool)(m2:l_ch)
         (sup (plus m1 p))->(word m1)->(inflg m1)->
         (formn p (consbl b m2)) ->(formn (lgth m1) (applf m1 m2))
    | fsp : (p:nat)(i:Induct)(m:l_ch)
            (formn p (consltr i m))->(formn (S p) (conssp (consltr i m))).

(* Program's specification for a list l : there exists n : nat and m : list *)
(* such that (formn n m) and (Eq l m)                                       *)

 Inductive Definition SigFormat [l:l_ch] : Set
    = ExFormat : (n:nat)(m:l_ch)(formn n m)->(Eq l m)->(SigFormat l).

(* Two lemmas *)

Lemma Lem1.
 Variable  b    :   bool.                                       
 Variables p,m1,m2      :   l_ch.                                       
 Variable  n    :   nat.                                        

 Hypothesis h1 :   (word m1).                                           
 Hypothesis h2 :   (inflg m1).                                  
 Hypothesis t1 :   (formn n (consbl b m2)).                             
 Hypothesis t2 :   (Eq p (consbl b m2)).                                 

 Statement   (SigFormat (app m1 p)).
 Proof (sumbool_rec (inf (plus m1 n)) (sup (plus m1 n))
         [s:{(inf (plus m1 n))}+{(sup (plus m1 n))}](SigFormat (app m1 p))
         [f1:(inf (plus m1 n))]
          (ExFormat (app m1 p) (plus m1 n) (appsp m1 m2)
              (fwordinf n m1 b m2 f1 h1 t1)
              (Eq_app m1 p (conssp m2)
                  (Eq_tran p (consbl b m2) (conssp m2) t2
                      (Eq_co_bl b true m2 m2 (Eq_re m2)))))
         [f2:(sup (plus m1 n))]
          (ExFormat (app m1 p) (lgth m1) (applf m1 m2)
              (fwordsup n m1 b m2 f2 h1 h2 t1)
              (Eq_app m1 p (conslf m2)
                  (Eq_tran p (consbl b m2) (conslf m2) t2
                      (Eq_co_bl b false m2 m2 (Eq_re m2)))))
         (ax1 (plus m1 n))).


Lemma Lem2.

Local prop2  [m1,m2,p:l_ch][n:nat][u:l_ch]
    (formn n u)->(Eq p u)->(SigFormat (app m1 (app m2 p))).             

 Variables     m1,m2,p :   l_ch.
 Hypothesis    h1  :   (word m1).
 Hypothesis    h2  :   (inflg m1).
 Hypothesis    h3  :   (space m2).

 Variable  n   :   nat.
 Variable  p0  :   l_ch.
 
 Statement (prop2 m1 m2 p n p0).
 Proof (LCH_rec p0 (prop2 m1 m2 p n)
            ([t1:(formn n nil)][t2:(Eq p nil)]
             (ExFormat (app m1 (app m2 p)) (lgth m1) m1 
                 (fword m1 h1 h2)
                 (Eq_app_nil m1 (app m2 p) 
                     (Eq_tran (app m2 p) (app m2 nil) nil
                         (Eq_app m2 p nil t2)
                         (Eq_space_nil m2 h3)))))
            ([b:bool][l:l_ch][h:(prop2 m1 m2 p n l)]
             [t1:(formn n (consbl b l))][t2:(Eq p (consbl b l))]
             (Lem1 b (app m2 p) m1 l n h1 h2 t1
                   (Eq_space_bl b m2 p l h3 t2)))
            ([i:Induct][l:l_ch][h:(prop2 m1 m2 p n l)]
             [t1:(formn n (consltr i l))][t2:(Eq p (consltr i l))]
             (Lem1 true (app m2 p) m1 (consltr i l) (S n) h1 h2
                   (fsp n i l t1)
                   (Eq_space  m2 p (consltr i l)  h3 t2)))).            

(* Formatting of a valid list *)

 Theorem format.
 Statement  (l:l_ch)(valide l)->(SigFormat l).
 Proof [l:l_ch][h:(valide l)]
        (valide_rec [l0:l_ch][v:(valide l0)](SigFormat l0)
         [m:l_ch][h1:(word m)][h2:(inflg m)]
          (ExFormat m (lgth m) m (fword m h1 h2) (Eq_re m))
         [m1,m2,p:l_ch][h1:(word m1)][h2:(inflg m1)]
          [h3:(space m2)][x:(valide p)][h4:(SigFormat p)]
           (SigFormat_rec p
             [s:(SigFormat p)](SigFormat (app m1 (app m2 p)))
              (Lem2 m1 m2 p h1 h2 h3) h4) l h).

(* Formatting of a list : this function will detect if the list is not valid *)

 Theorem format_all.
 Statement (l:l_ch)(SigFormat l)+{(NV l)}.
 Proof [l:l_ch](val_or_no_rec l
                [s:(val_or_no l)]((SigFormat l)+{(NV l)})
                [h:(valide l)](inleft (SigFormat l) (NV l) (format l h))
                (inright (SigFormat l) (NV l)) (preproc l)).

End Format.

Provide Format.
