(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.6         *)
(*****************************************************************************)
(*                                                                           *)
(*                              Lists                                        *)
(*  A presentation of basic programs on lists, following the CAML manual     *)
(*     Catherine Parent and Christine Paulin-Mohring                         *)
(*          ENS LYON                                                         *)
(*                                                                           *)
(*****************************************************************************)


(* Some programs and results about lists following CAML Manual *)

Chapter Lists.

Variable  A:Set.

Inductive Set list = nil : list | cons : A -> list -> list.

(*********************)
(* The null function *)
(*********************)

Definition Isnil : list -> Prop = [l:list]<list>nil=l.

Lemma Isnil_nil : (Isnil nil).
Goal. 
Red; Auto.
Save.

Lemma not_Isnil_cons : (a:A)(l:list)~(Isnil (cons a l)).
Goal. 
Local absprop [l:list](<Prop>Match l with 
                      (* nil *) True
                 (* cons a m *) [a:A][m:list][H:Prop]False).
Red; Intros; Change (absprop (cons a l)).
Elim H; Simpl; Trivial.
Save.

Hint Isnil_nil not_Isnil_cons.

Lemma Null : (l:list){(Isnil l)}+{~(Isnil l)}.
Goal. 
Realizer [l:list](<sumbool>Match l with 
                      (* nil *) left
                 (* cons a m *) [a:A][m:list][H:sumbool]right).
Program_all.
Save.

(***********************)
(* The Uncons function *)
(***********************)

Lemma Uncons : (l:list){a : A & { m: list | <list>(cons a m)=l}}+{Isnil l}.
Goal. 
Realizer [l:list](<(sumor A*list)> Match l with 
                      (* nil *) (inright A*list)
                 (* cons a m *) [a:A][m:list][H:(sumor A*list)]
                                (inleft A*list <A,list>(a,m))).
Program_all.
Save.

(********************************)
(* The head function            *)
(********************************)

Lemma Hd : (l:list){a : A | <list>Ex([m: list]<list>(cons a m)=l)}+{Isnil l}.
Goal. 
Realizer [l:list](<(sumor A)>Match l with 
                      (* nil *) (inright A)
                 (* cons a m *) [a:A][m:list][H:(sumor A)](inleft A a)).
Program_all.
Exists y; Auto.
Save.

Lemma Tl : (l:list){m:list|<A>Ex([a: A]<list>(cons a m)=l)
                         \/ ((Isnil l) /\ (Isnil m)) }.
Goal. 
Realizer [l:list](<list>Match l with 
                      (* nil *) nil
                 (* cons a m *) [a:A][m:list][H:list]m).
Program_all.
Left; Exists a; Auto.
Save.

(****************************************)
(* Length of lists                      *)
(****************************************)

Definition length.
Body [l:list](<nat>Match l with (* nil *) O
                           (* cons a m *) [a:A][m:list]S) 
   : list->nat.

(* A tail recursive version *)
Lemma Length_l : (l:list)(n:nat){m:nat|<nat>(plus n (length l))=m}.
Goal. 
Realizer [l:list](<nat->nat>Match l with 
                      (* nil *) [n:nat]n
                 (* cons a m *) [a:A][m:list][H:nat->nat][n:nat](H (S n))).
Program_all.
Elim p; Simpl; Auto.
Save.

Lemma Length : (l:list){m:nat|<nat>(length l)=m}.
Goal. 
Realizer [l:list](Length_l l O).
Program_all.
Save.


(*****************************)
(* The append function       *)
(*****************************)

Definition app.
Body [l,m:list](<list>Match l with (* nil *) m 
                              (* cons a m *) [a:A][m:list](cons a)) 
   : list->list->list.


Lemma app_nil_end : (l:list)<list>l=(app l nil).
Goal. 
	Intro l ; Elim l ; Simpl ; Auto.
	(*  (a:A)(y:list)
	     (<list>y=(app y nil))->(<list>(cons a y)=(cons a (app y nil)))
	    ============================
	      l : list *)
Intros a y h ; Elim h ; Auto.
Save.
Hint app_nil_end.

Lemma app_assoc_l : (l,m,n : list)<list>(app (app l m) n)=(app l (app m n)).
Goal. 
	Intros l m n ; Elim l ; Simpl ; Auto.
	(*  (a:A)(y:list)(<list>(app (app y m) n)=(app y (app m n)))->
	     (<list>(cons a (app (app y m) n))=(cons a (app y (app m n))))
	    ============================
	      n : list
	      m : list
	      l : list *)
	Intros a y h ; Elim h ; Auto.
Save.
Hint app_assoc_l.

(*******************************)
(* Members of lists            *)
(*******************************)

Inductive Definition In [a:A] : list -> Prop 
   = in_hd : (l:list)(In a (cons a l))
   | in_tl : (b:A)(l:list)(In a l)->(In a (cons b l)).
Hint in_hd in_tl.

Lemma In_hd_eq : (a,b:A)(l:list)(<A>a=b)->(In a (cons b l)).
Goal. 
Induction 1; Auto.
Save.
Immediate In_hd_eq.

Inductive Definition AllS [S:A->Prop] : list -> Prop 
   = allS_nil : (AllS S nil)
   | allS_cons : (a:A)(l:list)(S a)->(AllS S l)->(AllS S (cons a l)).
Hint allS_nil allS_cons.

Axiom eqA_dec : (a,b:A){<A>a=b}+{~<A>a=b}.

Lemma mem : (a:A)(l:list){(In a l)}+{(AllS [b:A]~<A>b=a l)}.
Goal. 
Realizer [a:A][l:list]
          (<sumbool>Match l with 
         (* nil *) right
    (* cons b m *) [b:A][m:list][H:sumbool]
                   <sumbool>if (eqA_dec a b) then left
                         else H).
Program_all.
Save.

(**********************************)
(* Index of elements              *)
(**********************************)

Require Lt.

Inductive Definition nth_spec : list->nat->A->Prop =
  nth_O : (a:A)(l:list)(nth_spec (cons a l) (S O) a)
| nth_S : (n:nat)(a,b:A)(l:list)
           (nth_spec l n a)->(nth_spec (cons b l) (S n) a).
Hint nth_O nth_S.

Inductive Definition fst_nth_spec : list->nat->A->Prop =
  fst_nth_O : (a:A)(l:list)(fst_nth_spec (cons a l) (S O) a)
| fst_nth_S : (n:nat)(a,b:A)(l:list)(~<A>a=b)->
           (fst_nth_spec l n a)->(fst_nth_spec (cons b l) (S n) a).
Hint fst_nth_O fst_nth_S.

Lemma fst_nth_nth : (l:list)(n:nat)(a:A)(fst_nth_spec l n a)->(nth_spec l n a).
Goal. 
Induction 1; Auto.
Save.
Immediate fst_nth_nth.

Lemma nth_lt_O : (l:list)(n:nat)(a:A)(nth_spec l n a)->(lt O n).
Goal. 
Induction 1; Auto.
Save.

Lemma nth_le_length : (l:list)(n:nat)(a:A)(nth_spec l n a)->(le n (length l)).
Goal. 
Induction 1; Simpl; Auto.
Save.

Lemma Nth : (l:list)(n:nat)
            {a:A|(nth_spec l n a)}+{(<nat>n=O)\/(lt (length l) n)}.
Goal. 
Realizer [l:list]
         (<nat->(sumor A)>Match l with 
               (* nil *) [n:nat](inright A)
          (* cons a m *) [a:A][l':list][F:nat->(sumor A)]
                         [n:nat]      
                         (<(sumor A)>Match n with 
                           (* O *) (inright A)
                         (* S m *) [m:nat][H':(sumor A)]
                             (<(sumor A)>Match m with 
                                (* O *) (inleft A a)
                              (* S p *) [p:nat][H'':(sumor A)](F (S p))))).
Repeat Program.
Simpl; Elim n; Auto.
Auto.
Auto.
Auto.
(Elim b; Intro); [Absurd <nat>(S y1)=O; Auto | Auto].
Save.

Lemma Item : (l:list)(n:nat){a:A|(nth_spec l (S n) a)}+{(le (length l) n)}.
Goal. 
Realizer [l:list][n:nat](Nth l (S n)).
Repeat Program.
(Elim b; Intro); [Absurd <nat>(S n)=O; Auto | Auto].
Save.

Require Minus.

Lemma Index_p : (a:A)(l:list)(p:nat)
     {n:nat|(fst_nth_spec l (minus (S n) p) a)}+{(AllS [b:A]~<A>a=b l)}.
Goal. 
Realizer
 [a:A][l:list]
 (<nat->(sumor nat)>Match l with 
      (* nil *) [p:nat](inright nat)
 (* cons b m *) [b:A][m:list][H:nat->(sumor nat)][p:nat]
                (<(sumor nat)>if (eqA_dec a b) then (inleft nat p)
                              else (H (S p)))).
Repeat Program.
Auto.
Elim a1; Elim minus_Sn_m; Trivial; Elim minus_n_n; Auto.
Elim minus_Sn_m; Auto.
Apply lt_le_weak; Apply lt_O_minus_lt; Apply nth_lt_O with y a; Auto.
Auto.
Save.

Lemma Index : (a:A)(l:list)
     {n:nat|(fst_nth_spec l n a)}+{(AllS [b:A]~<A>a=b l)}.
Goal. 
Realizer [a:A][l:list](Index_p a l (S O)).
Repeat Program.
Rewrite (minus_n_O x); Auto.
Trivial.
Save.

Section Find.
Variable R,S : A -> Prop.

Inductive Definition InR : list -> Prop 
   = inR_hd : (a:A)(l:list)(R a)->(InR (cons a l))
   | inR_tl : (a:A)(l:list)(InR l)->(InR (cons a l)).
Hint inR_hd inR_tl.

Local InR_inv = 
      [l:list]
      (<Prop>Match l with (* nil *) False 
                     (* cons a m *) [b:A][m:list][H:Prop]
                                    (R b)\/(InR m)).

Lemma InR_INV : (l:list)(InR l)->(InR_inv l).
Goal. 
Induction 1; Simpl; Auto.
Save.

Lemma InR_cons_inv : (a:A)(l:list)(InR (cons a l))->((R a)\/(InR l)).
Goal. 
Intros a  l; Exact (InR_INV (cons a l)).
Save.

Lemma InR_or_app : (l,m:list)((InR l)\/(InR m))->(InR (app l m)).
Goal. 
Induction 1.
Induction 1; Simpl; Auto.
Intro; Elim l; Simpl; Auto.
Save.

Lemma InR_app_or : (l,m:list)(InR (app l m))->((InR l)\/(InR m)).
Goal. 
Intros l m; Elim l; Simpl; Auto.
Intros b l' Hrec IAc; Elim (InR_cons_inv b (app l' m)); Auto.
Intros; Elim Hrec; Auto.
Save.

Hypothesis RS_dec : (a:A){(R a)}+{(S a)}.

Lemma Find : (l:list){a:A | (In a l) & (R a)}+{(AllS S l)}.
Goal. 
Realizer [l:list]
          (<(sumor A)>Match l with 
               (* nil *) (inright A)
          (* cons a m *) [a:A][m:list][H:(sumor A)]
                         <(sumor A)>if (RS_dec a) then (inleft A a)
                                    else H).
Program_all.
Save.

Variable B:Set.
Variable T : A -> B -> Prop.

Variable TS_dec : (a:A){c:B| (T a c)}+{(S a)}.

Lemma Try_find : (l:list){c:B|<A>Ex2([a:A](In a l),[a:A](T a c))}+{(AllS S l)}.
Goal. 
Realizer [l:list]
          (<(sumor B)>Match l with 
               (* nil *) (inright B)
          (* cons a m *) [a:A][m:list][H:(sumor B)]
                         (<(sumor B)>Match (TS_dec a) with 
                           (* inleft c *) [c:B](inleft B c)
                            (* inright *) H)).
Program_all.
Exists a; Auto.
Elim p; Intros a1 H1 H2.
Exists a1; Auto.
Save.

End Find.

Provide TheoryList.
