(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                              Lists                                        *)
(*                                                                           *)
(*****************************************************************************)

Require Le.

(* Some programs and results about lists *)

Chapter Lists.

Variable  A:Set.

Inductive Set list = nil : list | cons : A -> list -> list.


Definition app.
Body [l,m:list](<list>Match l with (* nil *) m 
                              (* cons a m *) [a:A][m:list](cons a)) 
   : list->list->list.


Lemma app_nil_end : (l:list)<list>l=(app l nil).
Goal. 
	Intro l ; Elim l ; Simpl ; Auto.
	(*  (a:A)(y:list)
	     (<list>y=(app y nil))->(<list>(cons a y)=(cons a (app y nil)))
	    ============================
	      l : list *)
Intros a y h ; Elim h ; Auto.
Save.
Hint app_nil_end.

Lemma app_ass : (l,m,n : list)<list>(app (app l m) n)=(app l (app m n)).
Goal. 
	Intros l m n ; Elim l ; Simpl ; Auto.
	(*  (a:A)(y:list)(<list>(app (app y m) n)=(app y (app m n)))->
	     (<list>(cons a (app (app y m) n))=(cons a (app y (app m n))))
	    ============================
	      n : list
	      m : list
	      l : list *)
	Intros a y h ; Elim h ; Auto.
Save.
Hint app_ass.

Lemma ass_app : (l,m,n : list)<list>(app l (app m n))=(app (app l m) n).
Goal. 
	Auto.
Save.
Hint ass_app.

Definition tail.
Body [l:list](<list>Match l with 
                 (* nil *) nil 
            (* cons a m *) [a:A][m,t:list]m) : list->list.

Local abs_prop = 
    [l:list](<Prop>Match l with (* nil *) True 
                           (* cons a m *) [a:A][m:list][P:Prop]False).

Lemma nil_cons : (a:A)(m:list)~<list>nil=(cons a m).
Goal. 
	Unfold not ; Intros a m h.
	(*  False
	    ============================
	      h : <list>nil=(cons a m)
	      m : list
	      a : A *)
	Change (abs_prop (cons a m)).
        Elim h ; Simpl ; Auto.
Save.

(****************************************)
(* Length of lists                      *)
(****************************************)

Definition length.
Body [l:list](<nat>Match l with (* nil *) O
                           (* cons a m *) [a:A][m:list]S) 
   : list->nat.

(******************************)
(* Length order of lists      *)
(******************************)

Section length_order.
Definition lel [l,m:list](le (length l) (length m)).

Variables a,b:A.
Variables l,m,n:list.

Lemma lel_refl : (lel l l).
Goal. 
	Unfold lel ; Auto.
Save.

Lemma lel_trans : (lel l m)->(lel m n)->(lel l n).
Goal. 
	Unfold lel ; Intros.
	(*  (le (length l) (length n))
	    ============================
	      H0 : (le (length m) (length n))
	      H : (le (length l) (length m)) *)
        Apply le_trans with (length m) ; Auto.
Save.

Lemma lel_cons_cons : (lel l m)->(lel (cons a l) (cons b m)).
Goal. 
	Unfold lel ; Simpl ; Auto.
Save.

Lemma lel_cons : (lel l m)->(lel l (cons b m)).
Goal. 
	Unfold lel ; Simpl ; Auto.
Save.

Lemma lel_tail : (lel (cons a l) (cons b m)) -> (lel l m).
Goal. 
	Unfold lel ; Simpl ; Auto.
Save.

Lemma lel_nil : (l:list)(lel l nil)-><list>nil=l.
Goal. 
	Intro l ; Elim l ; Auto.
	Intros a y H H0.
	(*  <list>nil=(cons a y)
	    ============================
	      H0 : (lel (cons a y) nil)
	      H : (lel y nil)->(<list>nil=y)
	      y : list
	      a : A
	      l : list *)
	Absurd (le (S (length y)) O); Auto.
Save.
End length_order.

Hint lel_refl lel_cons_cons lel_cons lel_nil lel_nil nil_cons.

Provide List.
