(*****************************************************************************)
(*      Coq V5.8                                                             *)
(*****************************************************************************)
(*                                                                           *)
(*      Alternating Bit Protocol                                             *)
(*                                                                           *)
(*      Jan Friso Groote                                                     *)
(*      Utrecht University                                                   *)
(*                                                                           *)
(*      November 1992                                                        *)
(*                                                                           *)
(*****************************************************************************)
(******************************* ABP.v ***************************************)
(*****************************************************************************)

(* From bezem@phil.ruu.nl Fri Apr  2 13:14:31 1993 *)


(*********************************ABP.v**********************************)

Inductive Set act = r1:act | r2:act | r3:act 
| r5:act | r6:act | s2:act | s3:act 
| s4:act | s5:act | s6:act | c2:act 
| c3:act | c5:act | c6:act | int:act | delta:act | tau:act.

Parameter proc :Set.
Parameter ia : (E:Set)act -> E -> proc.

Inductive Set one = i:one.

Definition Delta = (ia one delta i).

Inductive Set list [A:Set] = nil:(list A)| cons:A->(list A)->(list A).

(* ehlist are the lists used in the hiding and the encapsulation operator *)

Inductive Set ehlist = ehnil:ehlist | ehcons:act->ehlist->ehlist.

Definition In_list:(N:Set)N->(list N)->Prop = [N:Set][n:N][Y:(list N)]
            (<Prop>Match Y with False [m:N][y:(list N)][P:Prop]((<N>n=m) \/ P)).

Definition In_ehlist:act->ehlist->Prop = 
             [a:act][H:ehlist]
            (<Prop>Match H with False 
                     [b:act][H:ehlist][P:Prop](<act>a=b) \/ P).

(* Parameter lab  :act->name *)
Parameter alt  :proc->proc->proc.
Parameter seq  :proc->proc->proc.
Parameter mer  :proc->proc->proc.
Parameter Lmer :proc->proc->proc.
Parameter comm :proc->proc->proc.
Parameter cond :proc->bool->proc->proc.
Parameter sum  :(A:Set)(A->proc)->proc.
Parameter enc  :ehlist ->proc->proc.
Parameter hide :ehlist->proc->proc.
Parameter GRD  :proc->Prop.

Definition gamma = [a,b:act] (<act>Match a with 
    delta
     (<act>Match b with 
             delta delta delta delta delta c2 delta delta delta 
             delta delta delta delta delta delta delta delta)
     (<act>Match b with 
             delta delta delta delta delta delta c3
             delta delta delta delta delta delta delta delta delta delta)
     (<act>Match b with 
             delta delta delta delta delta delta delta delta 
             c5 delta delta delta delta delta delta delta delta)
     (<act>Match b with
             delta delta delta delta delta delta delta delta 
             c6 delta delta delta delta delta delta delta delta)   
     (<act>Match b with 
             delta c2 delta delta delta delta delta 
             delta delta delta delta delta delta delta delta delta delta) 
     (<act>Match b with  
             delta delta c3 delta delta delta delta  
             delta delta delta delta  delta delta delta delta delta delta)
     delta
     (<act>Match b with   
             delta  delta delta c5 delta delta delta  
             delta delta  delta delta delta delta delta delta delta delta) 
     (<act>Match b with   
             delta  delta delta delta c6 delta delta  
             delta delta  delta delta delta delta delta delta delta delta) 
     delta
     delta
     delta
     delta
     delta 
     delta 
     delta).


Parameter EQ : Set->Set->Prop.
Axiom EQ_refl : (S1:Set)(EQ S1 S1).
Axiom EQ_sym  : (S1,S2:Set)(EQ S1 S2)->(EQ S2 S1).

Section COMMUNICATION_F.
Variable a,b:act.
Variable E,F:Set.
Variable e,e1,e2:E.
Variable f:F.
Axiom CF1. Assumes <proc>(ia E (gamma a b) e)=(comm (ia E a e) (ia E b e)).
Axiom CF2. Assumes 
      (<act>(gamma a b)=delta)-><proc>Delta=(comm (ia E a e1) (ia E b e2)).
Axiom CF2'. Assumes
      (~(<E>e1=e2))-><proc>Delta=(comm (ia E a e1) (ia E b e2)).
Axiom CF2''. Assumes 
      (~(EQ E F))-><proc>Delta=(comm (ia E a e) (ia F b f)).
End COMMUNICATION_F.


(* The following lemma also lives under the name KSI in other versions 
   of this proof *)

Axiom EXT. Assumes (D:Set)(x,y:D->proc)((d:D)<proc>(x d)=(y d))-><D->proc>x=y.

Section BPA.
Variable x,y,z:proc.
Axiom A1. Assumes <proc>(alt x y)=(alt y x).
Axiom A2. Assumes <proc>(alt x (alt y z))=(alt (alt x y) z).
Axiom A3. Assumes <proc>x=(alt x x).
Axiom A4. Assumes <proc>(alt (seq x z) (seq y z))=(seq (alt x y) z).
Axiom A5. Assumes <proc>(seq x (seq y z))=(seq (seq x y) z).
Axiom A6. Assumes <proc>x=(alt x Delta).
Axiom A7. Assumes <proc>Delta=(seq Delta x).
End BPA.

Goal (x:proc)<proc>x=(alt Delta x).
Intro.
Elim A1.
Apply A6.
Save A6'.

Section GUARDED.
Variable D  :Set.
Variable d  :D.
Variable x,y:proc.
Variable z  :D->proc.
Variable a  :act.
Variable B  :bool.
Variable L  :ehlist.
Axiom G2.  Assumes (GRD (ia D a d)).
Axiom G5.  Assumes ((d:D)(GRD (z d)))->(GRD (sum D z)).
Axiom G6.  Assumes (GRD x)->(GRD (seq x y)).
Axiom G7.  Assumes (GRD x)->(GRD (Lmer x y)).
Axiom G8.  Assumes (GRD x)->(GRD y)->(GRD (alt x y)).
Axiom G9.  Assumes (GRD x)->(GRD y)->(GRD (mer x y)).
Axiom G10. Assumes (GRD x)->(GRD y)->(GRD (comm x y)).
Axiom G11. Assumes (GRD x)->(GRD y)->(GRD (cond x B y)).
Axiom G12. Assumes (GRD x)->(GRD (hide L x)).
Axiom G13. Assumes (GRD x)->(GRD (enc L x)).
End GUARDED.

Section PARALLEL_OPERATORS.
Variable x,y,z:proc.
Variable E,F:Set.
Variable e:E.
Variable f:F.
Variable a,b  :act.
Axiom CM1. Assumes <proc>(alt (alt (Lmer x y) (Lmer y x)) (comm x y))=(mer x y).
Axiom CM2. Assumes <proc>(seq (ia E a e) x)=(Lmer (ia E a e) x).
Axiom CM3. Assumes <proc>(seq (ia E a e) (mer x y))=(Lmer (seq (ia E a e) x) y).
Axiom CM4. Assumes <proc>(alt (Lmer x z) (Lmer y z))=(Lmer (alt x y) z).
Axiom CM5. Assumes <proc>(seq (comm (ia E a e) (ia F b f)) x)=
                         (comm (seq (ia E a e) x) (ia F b f)).
Axiom CM6. Assumes <proc>(seq (comm (ia E a e) (ia F b f)) x)=
                         (comm (ia E a e) (seq (ia F b f) x)).
Axiom CM7. Assumes <proc>(seq (comm (ia E a e) (ia F b f)) (mer x y))=
                         (comm (seq (ia E a e) x) (seq (ia F b f) y)).
Axiom CM8. Assumes <proc>(alt (comm x z) (comm y z))=(comm (alt x y) z).
Axiom CM9. Assumes <proc>(alt (comm x y) (comm x z))=(comm x (alt y z)).
End PARALLEL_OPERATORS.

Section STANDARD_CONCURRENCY. 
Variable x,y,z:proc.
Axiom SC1. Assumes <proc>(Lmer x (mer y z))=(Lmer (Lmer x y) z).
Axiom SC3. Assumes <proc>(comm y x)=(comm x y).
Axiom SC4. Assumes <proc>(comm x (comm y z))=(comm (comm x y) z).
Axiom SC5. Assumes <proc>(Lmer (comm x y) z)=(comm x (Lmer y z)).
End  STANDARD_CONCURRENCY.

Goal (x,y:proc)<proc>(mer x y)=(mer y x).
Intros.
Elim CM1.
Elim CM1.
Elim SC3.
Elim (A1 (Lmer x y) (Lmer y x)).
Apply refl_equal.
Save SC6.

(* The next axiom should be proven correct *)

Goal (x,y,z:proc)<proc>(mer x (mer y z))=(mer (mer x y) z).
Intros.
Repeat Elim CM1.
Repeat Elim SC1.
Repeat Elim CM8.
Repeat Elim CM9.
Repeat Elim CM4.
Repeat Elim SC5.
Repeat Elim SC4.
Repeat Elim CM1.
Repeat Elim A2.
Repeat Elim SC1.
Repeat Elim CM1.
Elim (A1  (Lmer z x) (Lmer x z)).
Repeat Elim A2.
Elim (SC3 x z).
ElimType <proc> (alt (Lmer z (alt (Lmer y x) (alt (Lmer x y) (comm y x))))
            (alt (Lmer (comm y z) x)
               (alt (Lmer (comm x y) z)
                  (alt (Lmer (comm z x) y) (comm x (comm y z))))))=  
            (alt (Lmer (comm x y) z)
              (alt (Lmer z (alt (Lmer x y) (alt (Lmer y x) (comm x y))))
               (alt (comm (Lmer x y) z)
                  (alt (comm (Lmer y x) z) (comm x (comm y z)))))).
Apply refl_equal.
Elim (A1 
      (alt (Lmer z (alt (Lmer x y) (alt (Lmer y x) (comm x y))))
         (alt (comm (Lmer x y) z)
            (alt (comm (Lmer y x) z) (comm x (comm y z)))))
                   (Lmer (comm x y) z)).
Repeat Elim A2.
ElimType <proc> (alt (Lmer (comm y z) x)
         (alt (Lmer (comm x y) z)
            (alt (Lmer (comm z x) y) (comm x (comm y z)))))=
                (alt (comm (Lmer x y) z)
         (alt (comm (Lmer y x) z)
            (alt (comm x (comm y z)) (Lmer (comm x y) z)))).
ElimType <proc> (alt (Lmer y x) (alt (Lmer x y) (comm y x)))=
              (alt (Lmer x y) (alt (Lmer y x) (comm x y))).
Apply refl_equal.
Elim SC3.
Elim A1.
Elim A2.
Elim A1.
Elim A2.
Elim (A1 (Lmer y x) (Lmer x y)).
Elim A1.
Elim A2.
Apply refl_equal.
Elim (SC3 (Lmer y x) z).
Elim SC5.
Elim (A1  (alt (Lmer (comm z y) x)
         (alt (comm x (comm y z)) (Lmer (comm x y) z))) (comm (Lmer x y) z)).
Repeat Elim A2.
ElimType <proc> (alt (Lmer (comm x y) z)
         (alt (Lmer (comm z x) y) (comm x (comm y z))))=
            (alt (comm x (comm y z))
         (alt (Lmer (comm x y) z) (comm (Lmer x y) z))).
Elim (SC3 y z).
Apply refl_equal.
Elim (A1  (alt (Lmer (comm x y) z) (comm (Lmer x y) z)) (comm x (comm y z))).
Elim A2.
Elim (SC3 (Lmer x y) z).
Elim SC5.
Apply refl_equal.
Save SC7.

Section CONDITION.
Variable x,y:proc.
Axiom COND1. Assumes <proc>x=(cond x true y).
Axiom COND2. Assumes <proc>y=(cond x false y).
End CONDITION.

Section SUM.
Variable D    :Set.
Variable d    :D.
Variable x,y  :D->proc.
Variable p    :proc.
Variable L    :ehlist.
Axiom SUM1.  Assumes <proc>p=(sum D ([d:D]p)).
Axiom SUM3.  Assumes <proc>(alt (sum D x) (x d))=(sum D x).
Axiom SUM4.  Assumes <proc>(alt (sum D x) (sum D y))=
                           (sum D ([d:D](alt (x d) (y d)))).
Axiom SUM5.  Assumes <proc>(sum D ([d:D](seq (x d) p)))=
                            (seq (sum D x ) p).
Axiom SUM6.  Assumes <proc>(sum D ([d:D](Lmer (x d) p)))=
                           (Lmer (sum D x) p).
Axiom SUM7.  Assumes <proc>(sum D ([d:D](comm (x d) p)))=
                           (comm (sum D x) p).
Axiom SUM8.  Assumes <proc> (sum D ([d:D](hide L (x d))))=(hide L (sum D x)).
Axiom SUM9.  Assumes <proc>(sum D ([d:D](enc L (x d))))=(enc L (sum D x)).
End SUM.

Section HIDE.
Variable x,y:proc.
Variable E  :Set.
Variable e  :E.
Variable a  :act.
Variable L  :ehlist.
Axiom TI1. Assumes (~(In_ehlist a L))->
                    (<proc>(ia E a e)=(hide L (ia E a e))).
Axiom TI2. Assumes (In_ehlist a L)->
                    (<proc>(ia one tau i)=(hide L (ia E a e))).
Axiom TI3. Assumes <proc>Delta=(hide L Delta).
Axiom TI4. Assumes <proc>(alt (hide L x) (hide L y))=(hide L (alt x y)). 
Axiom TI5. Assumes <proc>(seq (hide L x) (hide L y))=(hide L (seq x y)). 
End HIDE.

Section ENCAPSULATION. 
Variable x,y:proc. 
Variable E  :Set.
Variable e  :E.
Variable a  :act. 
Variable L  :ehlist.
Axiom D1. Assumes (~(In_ehlist a L))->
            (<proc>(ia E a e)=(enc L (ia E a e))).
Axiom D2. Assumes (In_ehlist a L)->
            (<proc>Delta=(enc L (ia E a e))). 
Axiom D3. Assumes <proc>Delta=(enc L Delta).
Axiom D4. Assumes <proc>(alt (enc L x) (enc L y))=(enc L (alt x y)).
Axiom D5. Assumes <proc>(seq (enc L x) (enc L y))=(enc L (seq x y)).
End ENCAPSULATION. 

Axiom Handshaking:(x,y,z:proc)(<proc>Delta=(comm x (comm y z))).

Axiom T1:(D:Set)(d:D)(a:act)
            <proc>(ia D a d)=(seq (ia D a d) (ia one tau i)).

Goal (D:Set)(d:D)(a:act)(x:proc)
            <proc>(seq (ia D a d) x)=(seq (ia D a d) (seq (ia one tau i) x)).
Intros.
ElimType <proc>(seq (seq (ia D a d) (ia one tau i)) x)
           =(seq (ia D a d) (seq (ia one tau i) x)).
Elim T1.
Apply refl_equal.
Apply sym_equal.
Apply A5.
Save T1'.
 

Axiom KFAR2:
(D:Set)(d:D)(int:act)
 (x,y:proc)(I:ehlist)(In_ehlist int I)->
    (<proc>x=(alt (seq (ia D int d) (seq (ia D int d) x)) y))->
            (<proc>(seq (ia one tau i) (hide I x))=
                      (seq (ia one tau i) (hide I y))).


Axiom RSP. Assumes (D:Set)(x,y:D->proc)(G:(D->proc)->D->proc)
                   ((p:D->proc)(d:D)(GRD (G p d)))->
                   ((d:D)<proc>(x d)=(G x d))->((d:D)<proc>(y d)=(G y d))->
                   (d:D)<proc>(x d)=(y d).

Hint G2 G5 G6 G7 G8 G9 G10 G11 G12 G13.

Goal (B:bool)(<bool>true=B)\/(<bool>false=B).
Intro.
Elim B.
Auto.
Auto.
Save Lemma4.

Section EXP2.
Variable x,y:proc.
Goal <proc>(alt (Lmer x y) (alt (Lmer y x) (comm x y)))=(mer x y).
Elim CM1.
Elim A2.
Apply refl_equal.
Save EXP2.
End EXP2.

 
Section EXP3.
Variable x,y,z:proc. 
Goal <proc>
     (alt (Lmer x (mer y z)) 
      (alt (Lmer y (mer x z))
       (alt (Lmer z (mer x y))
        (alt (Lmer (comm y z) x)
         (alt (Lmer (comm x y) z)
              (Lmer (comm x z) y))))))
      =(mer x (mer y z)).
Elim EXP2.
Elim EXP2.
Elim CM4.
Elim SC1.
Elim (SC6 x z).
Elim CM4.
Elim SC1.
Elim (SC6 x y).
Elim CM9.
Elim CM9.
Elim Handshaking.
Elim A6.

Elim SC5.
Elim SC5.
Repeat Elim A2.
Apply refl_equal.
Save EXP3.
End EXP3. 

Goal (x,y,z,u:proc)<proc>
   (alt (Lmer x (mer y (mer z u)))
      (alt (Lmer y (mer x (mer z u)))
         (alt (Lmer z (mer x (mer y u)))
            (alt (Lmer u (mer x (mer y z)))
               (alt (Lmer (comm z u) (mer x y))
                  (alt (Lmer (comm y z) (mer x u))
                     (alt (Lmer (comm y u) (mer x z))
                        (alt (Lmer (comm x y) (mer z u))
                           (alt (Lmer (comm x z) (mer y u))
                              (Lmer (comm x u) (mer y z)))))))))))
   =(mer x (mer y (mer z u))).


Intros.
Elim EXP2.
Elim EXP3.
Repeat Elim CM4.
Repeat Elim SC1.
Repeat Elim CM9.
Repeat Elim SC5.
Repeat Elim Handshaking.
Unfold Delta.
Repeat Elim CM2.
Repeat Elim A7.
Repeat Elim A6.
Repeat Elim A2.
Elim (SC6 x (mer z u)).
Elim (SC6 x (mer y u)).
Elim (SC6 x (mer y z)).
Elim (SC6 x u).
Elim (SC6 x y).
Elim (SC6 x z).
Elim (SC6 y z).
Apply refl_equal.
Save EXP4.

Section EXPH4.
Variable x,y,z,u:proc.
Variable H:ehlist.

Goal <proc>
   (alt (enc H (Lmer x (mer y (mer z u))))
      (alt (enc H (Lmer y (mer x (mer z u))))
         (alt (enc H (Lmer z (mer x (mer y u))))
            (alt (enc H (Lmer u (mer x (mer y z))))
               (alt (enc H (Lmer (comm z u) (mer x y)))
                  (alt (enc H (Lmer (comm y z) (mer x u)))
                     (alt (enc H (Lmer (comm y u) (mer x z)))
                        (alt (enc H (Lmer (comm x y) (mer z u)))
                           (alt (enc H (Lmer (comm x z) (mer y u)))
                              (enc H (Lmer (comm x u) (mer y z))))))))))))
   =(enc H (mer x (mer y (mer z u)))).

Elim EXP4.
Repeat Elim D4.
Apply refl_equal.
Save EXPH4.
End EXPH4.

(* HERE STARTS THE APPLICATION SECTION *) 

(* First we define the datatypes with a number of
   elementary axioms about them *)

Section BOOL.
Variable b:bool.
Parameter andb,orb:bool->bool->bool.
Parameter notb:bool->bool.
Axiom andb1:<bool>b=(andb true b).
Axiom andb2:<bool>false=(andb false b).
Axiom orb1:<bool>true=(orb true b).
Axiom orb2:<bool>b=(orb false b).
Axiom notb1:<bool>false=(notb true).
Axiom notb2:<bool>true=(notb false).
End BOOL.

Section BIT.
Parameter bit : Set.
Parameter e0,e1:bit. 
Parameter eqb:bit->bit->bool.
Parameter toggle:bit->bit.
Variable b:bit.
Axiom Toggle1:<bit>e1=(toggle e0).
Axiom Toggle2:<bit>e0=(toggle e1).
Axiom bit1:<bool>true=(eqb b b).
Axiom bit2:<bool>false=(eqb b (toggle b)). 
Axiom bit3:<bool>false=(eqb (toggle b) b).
End BIT.

Section DATA.
Parameter D : Set.
Parameter eqD : D->D->bool.
Parameter ifD : bool->D->D->D.
Variable d,e:D.
Axiom eqD5 : <D>d=(ifD true d e).
Axiom eqD6 : <D>e=(ifD false d e).
Axiom eqD7 : <bool>true=(eqD d d).
Axiom eqD8 : <D>(ifD(eqD d e) d e)=e.

Axiom EQDi : (~(EQ D one)).
End DATA.

Goal (d,e:D)((<D>d=e)->(<bool>true=(eqD d e))).
Intros.
Elim H.
Apply eqD7.

Save eqD_elim.

Goal (d,e:D)((<bool>true=(eqD d e)) -> (<D>d=e)).

Intros.
Elim (eqD8 d e).
Elim H.
Elim eqD5.
Apply refl_equal.
Save eqD_intro.

Goal (d,e:D)((<bool>false=(eqD d e)) -> ~(<D>d=e)).

Intros.
Red ; Intro.
Cut (P:bool->Prop)(P true)->(P false) ; Intro L.
Apply (L ([P:bool](<Prop>Match P with True False))).
Exact I.
Intros.
ElimType <bool>(eqD d e)=false.
Elim H0.
Elim eqD7.
Assumption.
Apply sym_equal.
Assumption.
Save eqD_intro'.

Section FRAME1.
Parameter frame : Set.
Variable b,b1,b2:bit.
Variable d,e:frame.
Parameter tuple : bit -> frame. 
Parameter sce:frame.
Parameter eqf : frame->frame->bool.
Parameter iff : bool->frame->frame->frame.
Axiom eqf1:<bool>true=(eqf sce sce).
Axiom eqf2:<bool>false=(eqf sce (tuple b)).
Axiom eqf3:<bool>false=(eqf (tuple b) sce).
Axiom eqf4:<bool>(eqb b1 b2)=(eqf (tuple b1) (tuple b2)).

Axiom eqf5 : <frame>d=(iff true d e).
Axiom eqf6 : <frame>e=(iff false d e).
Axiom eqf7 : <bool>true=(eqf d d).
Axiom eqf8 : <frame>(iff(eqf d e) d e)=e.

Axiom EQfi:(~(EQ frame one)).
Axiom EQfD:(~(EQ frame D)).
End FRAME1.

 
Goal (d,e:frame)((<frame>d=e)->(<bool>true=(eqf d e))).
Intros.
Elim H.
Apply eqf7.
 
Save eqf_elim.
 
Goal (d,e:frame)((<bool>true=(eqf d e)) -> (<frame>d=e)).
 
Intros.
Elim (eqf8 d e).
Elim H.
Elim eqf5.
Apply refl_equal.
Save eqf_intro.
 
Goal (d,e:frame)((<bool>false=(eqf d e)) -> ~(<frame>d=e)).
 
Intros.
Red ; Intro.
Cut (P:bool->Prop)(P true)->(P false) ; Intro L.
Apply (L ([P:bool](<Prop>Match P with True False))).
Exact I.
Intros.
ElimType <bool>(eqf d e)=false.
Elim H0.
Elim eqf7.
Assumption.
Apply sym_equal.
Assumption.
Save eqf_intro'.
 

Section FRAME2.
Parameter Frame : Set.
Variable b,b1,b2:bit.
Variable d,d1,d2:D.

Variable e,e':Frame.
Parameter Tuple : bit->D->Frame. 
Parameter lce:Frame.
Parameter eqF : Frame->Frame->bool.
Parameter ifF : bool->Frame->Frame->Frame. 
Axiom eqF1:<bool>true=(eqF lce lce).
Axiom eqF2:<bool>false=(eqF lce (Tuple b d)).
Axiom eqF3:<bool>false=(eqF (Tuple b d) lce).
Axiom eqF4:<bool>(andb (eqb b1 b2) (eqD d1 d2))=
              (eqF (Tuple b1 d1) (Tuple b2 d2)).
 
Axiom eqF5 : <Frame>e'=(ifF true e' e).
Axiom eqF6 : <Frame>e=(ifF false e' e). 
Axiom eqF7 : <bool>true=(eqF e e). 
Axiom eqF8 : <Frame>(ifF(eqF e e') e e')=e'. 
 
Axiom EQFi:(~(EQ Frame one)).
Axiom EQFD:(~(EQ Frame D)).
Axiom EQFf:(~(EQ Frame frame)).
End FRAME2.


Hint EQFf (*EQfF*).


Goal (d,e:Frame)((<Frame>d=e)->(<bool>true=(eqF d e))).
Intros.
Elim H.
Apply eqF7.

Save eqF_elim.

Goal (d,e:Frame)((<bool>true=(eqF d e)) -> (<Frame>d=e)).

Intros.
Elim (eqF8 d e).
Elim H.
Elim eqF5.
Apply refl_equal.
Save eqF_intro.

Goal (d,e:Frame)((<bool>false=(eqF d e)) -> ~(<Frame>d=e)).

Intros.
Red ; Intro.
Cut (P:bool->Prop)(P true)->(P false) ; Intro L.
Apply (L ([P:bool](<Prop>Match P with True False))).
Exact I.
Intros.
ElimType <bool>(eqF d e)=false.
Elim H0.
Elim eqF7.
Assumption.
Apply sym_equal.
Assumption.
Save eqF_intro'.
 
(* Below the processes used in the alternating bit protocol
   are defined *)

Parameter K:one->proc.
Parameter L:one->proc.
Parameter S:one->proc.
Parameter Sn:bit -> proc.
Parameter Sn_d:D->bit->proc.
Parameter Tn_d:D->bit->proc.
Parameter R:one->proc.
Parameter Rn:bit->proc.

Section PROC.
Variable b:bit.
Variable j:one.
Variable d:D.

Axiom ChanK. Assumes
   <proc>
    (sum Frame ([x:Frame] 
     (seq (ia Frame r2 x)
      (seq 
       (alt 
        (seq (ia one int i) (ia Frame s3 x)) 
        (seq (ia one int i) (ia Frame s3 lce)))  
       (K i)))))=(K j).

Axiom ChanL. Assumes
   <proc>
    (sum frame ([n:frame] 
     (seq (ia frame r5 n)
      (seq 
       (alt 
        (seq (ia one int i) (ia frame s6 n)) 
        (seq (ia one int i) (ia frame s6 sce)))  
       (L i)))))=(L j).

Axiom ProcS. Assumes
    <proc>(seq ( Sn e0) (seq (Sn e1) (S i)))=(S j).

Axiom ProcSn. Assumes
    <proc>(sum D ([d:D] (seq (ia D r1 d) (Sn_d d b))))=(Sn b).

Axiom ProcSn_d. Assumes
    <proc>(seq (ia Frame s2 (Tuple b d)) (Tn_d d b))=(Sn_d d b).

Axiom ProcTn_d. Assumes
    <proc>
       (alt 
        (seq 
          (alt 
            (ia frame r6 (tuple(toggle b)))
            (ia frame r6 sce)) 
          (Sn_d d b)) 
        (ia frame r6 (tuple b)))=(Tn_d d b).

Axiom ProcR. Assumes
    <proc>(seq (Rn e1) (seq (Rn e0) (R i)))=(R j).

Axiom ProcRn. Assumes
    <proc>
       (alt 
        (seq 
         (alt 
          (sum D ([d:D] (ia Frame r3 (Tuple b d)))) 
          (ia Frame r3 lce)) 
         (seq (ia frame s5 (tuple b)) (Rn b)))
        (sum D ([d:D]
         (seq 
          (ia Frame r3 (Tuple (toggle b) d)) 
          (seq 
           (ia D s4 d) 
           (ia frame s5 (tuple (toggle b))))))))=(Rn b).
End PROC.

Definition H=(ehcons r2 
               (ehcons r3
                (ehcons r5
                 (ehcons r6
                  (ehcons s2
                   (ehcons s3
                    (ehcons s5
                     (ehcons s6 ehnil)))))))).

Definition ABP = (enc H (mer (S i) (mer (K i) (mer (L i) (R i))))).
Definition X = (enc H (mer (S i) (mer (K i) (mer (L i) (R i))))).

Definition X1 = ([d:D](enc H (mer 
                        (seq (Sn_d d e0) (seq (Sn e1) (S i)))
                        (mer (K i) (mer (L i) (R i)))))).

Definition X2 = ([d:D](enc H (mer 
                        (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                        (mer (K i) 
                         (mer 
                          (L i) 
                           (seq 
                            (ia frame s5 (tuple e0)) 
                            (seq (Rn e0) (R i)))))))).

Definition Y = (enc H (mer  
                        (seq (Sn e1) (S i))
                        (mer (K i) 
                         (mer 
                          (L i) 
                           (seq (Rn e0) (R i)))))).

Definition Y1 = ([d:D](
                    (enc H (mer  
                        (seq (Sn_d d e1) (S i))
                        (mer (K i) 
                         (mer 
                          (L i) 
                           (seq (Rn e0) (R i)))))))).

Definition Y2 = ([d:D](
                    (enc H (mer      
                        (seq (Tn_d d e1) (S i)) 
                        (mer (K i)    
                         (mer     
                          (L i)  
                           (seq (ia frame s5 (tuple e1)) (R i)))))))).


(* Here the section on equality of actions starts *)

Definition r1f = [a:act](<Prop>Match a with True  False False False False
                                     False False False False False
                                     False False False False
                                     False False False).

Goal ~(<act>r1=r2).
Red ; Intro H.
Change (r1f r2).
Elim H ; Exact I.
Save neqr1r2.

Goal ~(<act>r1=r3).
Red ; Intro H.
Change (r1f r3). 
Elim H ; Exact I.
Save neqr1r3. 

Goal ~(<act>r1=r5).
Red ; Intro H.
Change (r1f r5). 
Elim H ; Exact I.
Save neqr1r5. 

Goal ~(<act>r1=r6).
Red ; Intro H.
Change (r1f r6). 
Elim H ; Exact I.
Save neqr1r6. 

Goal ~(<act>r1=s2).
Red ; Intro H.
Change (r1f s2).
Elim H ; Exact I.
Save neqr1s2.

Goal ~(<act>r1=s3).
Red ; Intro H.
Change (r1f s3).
Elim H ; Exact I.
Save neqr1s3.

Goal ~(<act>r1=s4).
Red ; Intro H.
Change (r1f s4).
Elim H ; Exact I.
Save neqr1s4.

Goal ~(<act>r1=s5).
Red ; Intro H.
Change (r1f s5).
Elim H ; Exact I.
Save neqr1s5.

Goal ~(<act>r1=s6).
Red ; Intro H.
Change (r1f s6).
Elim H ; Exact I.
Save neqr1s6.

Goal ~(<act>r1=c2).
Red ; Intro H.
Change (r1f c2).
Elim H ; Exact I.
Save neqr1c2.

Goal ~(<act>r1=c3).
Red ; Intro H.
Change (r1f c3).
Elim H ; Exact I.
Save neqr1c3.

Goal ~(<act>r1=c5).
Red ; Intro H.
Change (r1f c5).
Elim H ; Exact I.
Save neqr1c5.

Goal ~(<act>r1=c6).
Red ; Intro H.
Change (r1f c6).
Elim H ; Exact I.
Save neqr1c6.

Goal ~(<act>r1=int).
Red ; Intro H.
Change (r1f int).
Elim H ; Exact I.
Save neqr1int.

Goal ~(<act>r1=tau).
Red ; Intro H.
Change (r1f tau).
Elim H ; Exact I.
Save neqr1tau.

Hint neqr1r2 neqr1r3 neqr1r5 neqr1r6 neqr1s2 neqr1s3 neqr1s4 neqr1s5
neqr1s6 neqr1c2 neqr1c3 neqr1c5 neqr1c6 neqr1int neqr1tau.

Definition r2f = [a:act](<Prop>Match a with False True False False False
                                     False False False False False
                                     False False False False False
                                     False False).

Goal ~(<act>r2=r1).
Red ; Intro H.
Change (r2f r1).
Elim H ; Exact I.
Save neqr2r1.

Goal ~(<act>r2=r3).
Red ; Intro H.
Change (r2f r3). 
Elim H ; Exact I.
Save neqr2r3. 

Goal ~(<act>r2=r5).
Red ; Intro H.
Change (r2f r5). 
Elim H ; Exact I.
Save neqr2r5. 

Goal ~(<act>r2=r6).
Red ; Intro H.
Change (r2f r6). 
Elim H ; Exact I.
Save neqr2r6. 

Goal ~(<act>r2=s2).
Red ; Intro H.
Change (r2f s2).
Elim H ; Exact I.
Save neqr2s2.

Goal ~(<act>r2=s3).
Red ; Intro H.
Change (r2f s3).
Elim H ; Exact I.
Save neqr2s3.

Goal ~(<act>r2=s4).
Red ; Intro H.
Change (r2f s4).
Elim H ; Exact I.
Save neqr2s4.

Goal ~(<act>r2=s5).
Red ; Intro H.
Change (r2f s5).
Elim H ; Exact I.
Save neqr2s5.

Goal ~(<act>r2=s6).
Red ; Intro H.
Change (r2f s6).
Elim H ; Exact I.
Save neqr2s6.

Goal ~(<act>r2=c2).
Red ; Intro H.
Change (r2f c2).
Elim H ; Exact I.
Save neqr2c2.

Goal ~(<act>r2=c3).
Red ; Intro H.
Change (r2f c3).
Elim H ; Exact I.
Save neqr2c3.

Goal ~(<act>r2=c5).
Red ; Intro H.
Change (r2f c5).
Elim H ; Exact I.
Save neqr2c5.

Goal ~(<act>r2=c6).
Red ; Intro H.
Change (r2f c6).
Elim H ; Exact I.
Save neqr2c6.

Goal ~(<act>r2=int).
Red ; Intro H.
Change (r2f int).
Elim H ; Exact I.
Save neqr2int.

Goal ~(<act>r2=tau).
Red ; Intro H.
Change (r2f tau).
Elim H ; Exact I.
Save neqr2tau.

Hint neqr2r1 neqr2r3 neqr2r5 neqr2r6 neqr2s2 neqr2s3 neqr2s4 neqr2s5
neqr2s6 neqr2c2 neqr2c3 neqr2c5 neqr2c6 neqr2int neqr2tau.


Definition r3f = [a:act](<Prop>Match a with False False True False False
                                     False False False False False
                                     False False False False False
                                     False False).

Goal ~(<act>r3=r1).
Red ; Intro H.
Change (r3f r1).
Elim H ; Exact I.
Save neqr3r1.

Goal ~(<act>r3=r2).
Red ; Intro H.
Change (r3f r2).
Elim H ; Exact I.
Save neqr3r2.

Goal ~(<act>r3=r5).
Red ; Intro H.
Change (r3f r5). 
Elim H ; Exact I.
Save neqr3r5. 

Goal ~(<act>r3=r6).
Red ; Intro H.
Change (r3f r6). 
Elim H ; Exact I.
Save neqr3r6. 

Goal ~(<act>r3=s2).
Red ; Intro H.
Change (r3f s2).
Elim H ; Exact I.
Save neqr3s2.

Goal ~(<act>r3=s3).
Red ; Intro H.
Change (r3f s3).
Elim H ; Exact I.
Save neqr3s3.

Goal ~(<act>r3=s4).
Red ; Intro H.
Change (r3f s4).
Elim H ; Exact I.
Save neqr3s4.

Goal ~(<act>r3=s5).
Red ; Intro H.
Change (r3f s5).
Elim H ; Exact I.
Save neqr3s5.

Goal ~(<act>r3=s6).
Red ; Intro H.
Change (r3f s6).
Elim H ; Exact I.
Save neqr3s6.

Goal ~(<act>r3=c2).
Red ; Intro H.
Change (r3f c2).
Elim H ; Exact I.
Save neqr3c2.

Goal ~(<act>r3=c3).
Red ; Intro H.
Change (r3f c3).
Elim H ; Exact I.
Save neqr3c3.

Goal ~(<act>r3=c5).
Red ; Intro H.
Change (r3f c5).
Elim H ; Exact I.
Save neqr3c5.

Goal ~(<act>r3=c6).
Red ; Intro H.
Change (r3f c6).
Elim H ; Exact I.
Save neqr3c6.

Goal ~(<act>r3=int).
Red ; Intro H.
Change (r3f int).
Elim H ; Exact I.
Save neqr3int.

Goal ~(<act>r3=tau).
Red ; Intro H.
Change (r3f tau).
Elim H ; Exact I.
Save neqr3tau.

Hint neqr3r2 neqr3r1 neqr3r5 neqr3r6 neqr3s2 neqr3s3 neqr3s4 neqr3s5
neqr3s6 neqr3c2 neqr3c3 neqr3c5 neqr3c6 neqr3int neqr3tau.


Definition r5f = [a:act](<Prop>Match a with False False False True False
                                     False False False False False
                                     False False False False False
                                     False False).

Goal ~(<act>r5=r1).
Red ; Intro H.
Change (r5f r1).
Elim H ; Exact I.
Save neqr5r1.

Goal ~(<act>r5=r2).
Red ; Intro H.
Change (r5f r2).
Elim H ; Exact I.
Save neqr5r2.

Goal ~(<act>r5=r3).
Red ; Intro H.
Change (r5f r3). 
Elim H ; Exact I.
Save neqr5r3. 

Goal ~(<act>r5=r6).
Red ; Intro H.
Change (r5f r6). 
Elim H ; Exact I.
Save neqr5r6. 

Goal ~(<act>r5=s2).
Red ; Intro H.
Change (r5f s2).
Elim H ; Exact I.
Save neqr5s2.

Goal ~(<act>r5=s3).
Red ; Intro H.
Change (r5f s3).
Elim H ; Exact I.
Save neqr5s3.

Goal ~(<act>r5=s4).
Red ; Intro H.
Change (r5f s4).
Elim H ; Exact I.
Save neqr5s4.

Goal ~(<act>r5=s5).
Red ; Intro H.
Change (r5f s5).
Elim H ; Exact I.
Save neqr5s5.

Goal ~(<act>r5=s6).
Red ; Intro H.
Change (r5f s6).
Elim H ; Exact I.
Save neqr5s6.

Goal ~(<act>r5=c2).
Red ; Intro H.
Change (r5f c2).
Elim H ; Exact I.
Save neqr5c2.

Goal ~(<act>r5=c3).
Red ; Intro H.
Change (r5f c3).
Elim H ; Exact I.
Save neqr5c3.

Goal ~(<act>r5=c5).
Red ; Intro H.
Change (r5f c5).
Elim H ; Exact I.
Save neqr5c5.

Goal ~(<act>r5=c6).
Red ; Intro H.
Change (r5f c6).
Elim H ; Exact I.
Save neqr5c6.

Goal ~(<act>r5=int).
Red ; Intro H.
Change (r5f int).
Elim H ; Exact I.
Save neqr5int.

Goal ~(<act>r5=tau).
Red ; Intro H.
Change (r5f tau).
Elim H ; Exact I.
Save neqr5tau.

Hint neqr5r2 neqr5r3 neqr5r1 neqr5r6 neqr5s2 neqr5s3 neqr5s4 neqr5s5
neqr5s6 neqr5c2 neqr5c3 neqr5c5 neqr5c6 neqr5int neqr5tau.


Definition r6f = [a:act](<Prop>Match a with False False False False True
                                     False False False False False
                                     False False False False False
                                     False False).

Goal ~(<act>r6=r1).
Red ; Intro H.
Change (r6f r1).
Elim H ; Exact I.
Save neqr6r1.

Goal ~(<act>r6=r2).
Red ; Intro H.
Change (r6f r2).
Elim H ; Exact I.
Save neqr6r2.

Goal ~(<act>r6=r3).
Red ; Intro H.
Change (r6f r3). 
Elim H ; Exact I.
Save neqr6r3. 

Goal ~(<act>r6=r5).
Red ; Intro H.
Change (r6f r5). 
Elim H ; Exact I.
Save neqr6r5. 

Goal ~(<act>r6=s2).
Red ; Intro H.
Change (r6f s2).
Elim H ; Exact I.
Save neqr6s2.

Goal ~(<act>r6=s3).
Red ; Intro H.
Change (r6f s3).
Elim H ; Exact I.
Save neqr6s3.

Goal ~(<act>r6=s4).
Red ; Intro H.
Change (r6f s4).
Elim H ; Exact I.
Save neqr6s4.

Goal ~(<act>r6=s5).
Red ; Intro H.
Change (r6f s5).
Elim H ; Exact I.
Save neqr6s5.

Goal ~(<act>r6=s6).
Red ; Intro H.
Change (r6f s6).
Elim H ; Exact I.
Save neqr6s6.

Goal ~(<act>r6=c2).
Red ; Intro H.
Change (r6f c2).
Elim H ; Exact I.
Save neqr6c2.

Goal ~(<act>r6=c3).
Red ; Intro H.
Change (r6f c3).
Elim H ; Exact I.
Save neqr6c3.

Goal ~(<act>r6=c5).
Red ; Intro H.
Change (r6f c5).
Elim H ; Exact I.
Save neqr6c5.

Goal ~(<act>r6=c6).
Red ; Intro H.
Change (r6f c6).
Elim H ; Exact I.
Save neqr6c6.

Goal ~(<act>r6=int).
Red ; Intro H.
Change (r6f int).
Elim H ; Exact I.
Save neqr6int.

Goal ~(<act>r6=tau).
Red ; Intro H.
Change (r6f tau).
Elim H ; Exact I.
Save neqr6tau.

Hint neqr6r2 neqr6r3 neqr1r5 neqr6r1 neqr6s2 neqr6s3 neqr6s4 neqr6s5
neqr6s6 neqr6c2 neqr6c3 neqr6c5 neqr6c6 neqr6int neqr6tau.


Definition s2f = [a:act](<Prop>Match a with False False False False False
                                     True  False False False False
                                     False False False False False
                                     False False).

Goal ~(<act>s2=r1).
Red ; Intro H.
Change (s2f r1).
Elim H ; Exact I.
Save neqs2r1.

Goal ~(<act>s2=r2).
Red ; Intro H.
Change (s2f r2).
Elim H ; Exact I.
Save neqs2r2.

Goal ~(<act>s2=r3).
Red ; Intro H.
Change (s2f r3). 
Elim H ; Exact I.
Save neqs2r3. 

Goal ~(<act>s2=r5).
Red ; Intro H.
Change (s2f r5). 
Elim H ; Exact I.
Save neqs2r5. 

Goal ~(<act>s2=r6).
Red ; Intro H.
Change (s2f r6). 
Elim H ; Exact I.
Save neqs2r6. 

Goal ~(<act>s2=s3).
Red ; Intro H.
Change (s2f s3).
Elim H ; Exact I.
Save neqs2s3.

Goal ~(<act>s2=s4).
Red ; Intro H.
Change (s2f s4).
Elim H ; Exact I.
Save neqs2s4.

Goal ~(<act>s2=s5).
Red ; Intro H.
Change (s2f s5).
Elim H ; Exact I.
Save neqs2s5.

Goal ~(<act>s2=s6).
Red ; Intro H.
Change (s2f s6).
Elim H ; Exact I.
Save neqs2s6.

Goal ~(<act>s2=c2).
Red ; Intro H.
Change (s2f c2).
Elim H ; Exact I.
Save neqs2c2.

Goal ~(<act>s2=c3).
Red ; Intro H.
Change (s2f c3).
Elim H ; Exact I.
Save neqs2c3.

Goal ~(<act>s2=c5).
Red ; Intro H.
Change (s2f c5).
Elim H ; Exact I.
Save neqs2c5.

Goal ~(<act>s2=c6).
Red ; Intro H.
Change (s2f c6).
Elim H ; Exact I.
Save neqs2c6.

Goal ~(<act>s2=int).
Red ; Intro H.
Change (s2f int).
Elim H ; Exact I.
Save neqs2int.

Goal ~(<act>s2=tau).
Red ; Intro H.
Change (s2f tau).
Elim H ; Exact I.
Save neqs2tau.

Hint neqs2r2 neqs2r3 neqs2r5 neqs2r6 neqs2r1 neqs2s3 neqs2s4 neqs2s5
neqs2s6 neqs2c2 neqs2c3 neqs2c5 neqs2c6 neqs2int neqs2tau.


Definition s3f = [a:act](<Prop>Match a with False False False False False
                                     False True  False False False
                                     False False False False False
                                     False False).

Goal ~(<act>s3=r1).
Red ; Intro H.
Change (s3f r1).
Elim H ; Exact I.
Save neqs3r1.

Goal ~(<act>s3=r2).
Red ; Intro H.
Change (s3f r2).
Elim H ; Exact I.
Save neqs3r2.

Goal ~(<act>s3=r3).
Red ; Intro H.
Change (s3f r3). 
Elim H ; Exact I.
Save neqs3r3. 

Goal ~(<act>s3=r5).
Red ; Intro H.
Change (s3f r5). 
Elim H ; Exact I.
Save neqs3r5. 

Goal ~(<act>s3=r6).
Red ; Intro H.
Change (s3f r6). 
Elim H ; Exact I.
Save neqs3r6. 

Goal ~(<act>s3=s2).
Red ; Intro H.
Change (s3f s2).
Elim H ; Exact I.
Save neqs3s2.

Goal ~(<act>s3=s4).
Red ; Intro H.
Change (s3f s4).
Elim H ; Exact I.
Save neqs3s4.

Goal ~(<act>s3=s5).
Red ; Intro H.
Change (s3f s5).
Elim H ; Exact I.
Save neqs3s5.

Goal ~(<act>s3=s6).
Red ; Intro H.
Change (s3f s6).
Elim H ; Exact I.
Save neqs3s6.

Goal ~(<act>s3=c2).
Red ; Intro H.
Change (s3f c2).
Elim H ; Exact I.
Save neqs3c2.

Goal ~(<act>s3=c3).
Red ; Intro H.
Change (s3f c3).
Elim H ; Exact I.
Save neqs3c3.

Goal ~(<act>s3=c5).
Red ; Intro H.
Change (s3f c5).
Elim H ; Exact I.
Save neqs3c5.

Goal ~(<act>s3=c6).
Red ; Intro H.
Change (s3f c6).
Elim H ; Exact I.
Save neqs3c6.

Goal ~(<act>s3=int).
Red ; Intro H.
Change (s3f int).
Elim H ; Exact I.
Save neqs3int.

Goal ~(<act>s3=tau).
Red ; Intro H.
Change (s3f tau).
Elim H ; Exact I.
Save neqs3tau.

Hint neqs3r2 neqs3r3 neqs3r5 neqs3r6 neqs3s2 (*neqs3s1*) neqs3s4 neqs3s5
neqs3s6 neqs3c2 neqs3c3 neqs3c5 neqs3c6 neqs3int neqs3tau.


Definition s4f = [a:act](<Prop>Match a with False False False False False
                                     False False True  False False
                                     False False False False False
                                     False False).

Goal ~(<act>s4=r1).
Red ; Intro H.
Change (s4f r1).
Elim H ; Exact I.
Save neqs4r1.

Goal ~(<act>s4=r2).
Red ; Intro H.
Change (s4f r2).
Elim H ; Exact I.
Save neqs4r2.

Goal ~(<act>s4=r3).
Red ; Intro H.
Change (s4f r3). 
Elim H ; Exact I.
Save neqs4r3. 

Goal ~(<act>s4=r5).
Red ; Intro H.
Change (s4f r5). 
Elim H ; Exact I.
Save neqs4r5. 

Goal ~(<act>s4=r6).
Red ; Intro H.
Change (s4f r6). 
Elim H ; Exact I.
Save neqs4r6. 

Goal ~(<act>s4=s2).
Red ; Intro H.
Change (s4f s2).
Elim H ; Exact I.
Save neqs4s2.

Goal ~(<act>s4=s3).
Red ; Intro H.
Change (s4f s3).
Elim H ; Exact I.
Save neqs4s3.

Goal ~(<act>s4=s5).
Red ; Intro H.
Change (s4f s5).
Elim H ; Exact I.
Save neqs4s5.

Goal ~(<act>s4=s6).
Red ; Intro H.
Change (s4f s6).
Elim H ; Exact I.
Save neqs4s6.

Goal ~(<act>s4=c2).
Red ; Intro H.
Change (s4f c2).
Elim H ; Exact I.
Save neqs4c2.

Goal ~(<act>s4=c3).
Red ; Intro H.
Change (s4f c3).
Elim H ; Exact I.
Save neqs4c3.

Goal ~(<act>s4=c5).
Red ; Intro H.
Change (s4f c5).
Elim H ; Exact I.
Save neqs4c5.

Goal ~(<act>s4=c6).
Red ; Intro H.
Change (s4f c6).
Elim H ; Exact I.
Save neqs4c6.

Goal ~(<act>s4=int).
Red ; Intro H.
Change (s4f int).
Elim H ; Exact I.
Save neqs4int.

Goal ~(<act>s4=tau).
Red ; Intro H.
Change (s4f tau).
Elim H ; Exact I.
Save neqs4tau.

Hint neqs4r2 neqs4r3 neqs4r5 neqs4r6 neqs4s2 neqs4s3 (*neqs4s1*) neqs4s5
neqs4s6 neqs4c2 neqs4c3 neqs4c5 neqs4c6 neqs4int neqs4tau.


Definition s5f = [a:act](<Prop>Match a with False False False False False
                                     False False False True  False
                                     False False False False False
                                     False False).

Goal ~(<act>s5=r1).
Red ; Intro H.
Change (s5f r1).
Elim H ; Exact I.
Save neqs5r1.

Goal ~(<act>s5=r2).
Red ; Intro H.
Change (s5f r2).
Elim H ; Exact I.
Save neqs5r2.

Goal ~(<act>s5=r3).
Red ; Intro H.
Change (s5f r3). 
Elim H ; Exact I.
Save neqs5r3. 

Goal ~(<act>s5=r5).
Red ; Intro H.
Change (s5f r5). 
Elim H ; Exact I.
Save neqs5r5. 

Goal ~(<act>s5=r6).
Red ; Intro H.
Change (s5f r6). 
Elim H ; Exact I.
Save neqs5r6. 

Goal ~(<act>s5=s2).
Red ; Intro H.
Change (s5f s2).
Elim H ; Exact I.
Save neqs5s2.

Goal ~(<act>s5=s3).
Red ; Intro H.
Change (s5f s3).
Elim H ; Exact I.
Save neqs5s3.

Goal ~(<act>s5=s4).
Red ; Intro H.
Change (s5f s4).
Elim H ; Exact I.
Save neqs5s4.

Goal ~(<act>s5=s6).
Red ; Intro H.
Change (s5f s6).
Elim H ; Exact I.
Save neqs5s6.

Goal ~(<act>s5=c2).
Red ; Intro H.
Change (s5f c2).
Elim H ; Exact I.
Save neqs5c2.

Goal ~(<act>s5=c3).
Red ; Intro H.
Change (s5f c3).
Elim H ; Exact I.
Save neqs5c3.

Goal ~(<act>s5=c5).
Red ; Intro H.
Change (s5f c5).
Elim H ; Exact I.
Save neqs5c5.

Goal ~(<act>s5=c6).
Red ; Intro H.
Change (s5f c6).
Elim H ; Exact I.
Save neqs5c6.

Goal ~(<act>s5=int).
Red ; Intro H.
Change (s5f int).
Elim H ; Exact I.
Save neqs5int.

Goal ~(<act>s5=tau).
Red ; Intro H.
Change (s5f tau).
Elim H ; Exact I.
Save neqs5tau.

Hint neqs5r2 neqs5r3 neqs5r5 neqs5r6 neqs5s2 neqs5s3 neqs5s4 neqs5r1
neqs5s6 neqr1c2 neqs5c3 neqs5c5 neqs5c6 neqs5int neqs5tau.

Definition s6f = [a:act](<Prop>Match a with False False False False False
                                     False False False False True
                                     False False False False False
                                     False False).

Goal ~(<act>s6=r1).
Red ; Intro H.
Change (s6f r1).
Elim H ; Exact I.
Save neqs6r1.

Goal ~(<act>s6=r2).
Red ; Intro H.
Change (s6f r2).
Elim H ; Exact I.
Save neqs6r2.

Goal ~(<act>s6=r3).
Red ; Intro H.
Change (s6f r3). 
Elim H ; Exact I.
Save neqs6r3. 

Goal ~(<act>s6=r5).
Red ; Intro H.
Change (s6f r5). 
Elim H ; Exact I.
Save neqs6r5. 

Goal ~(<act>s6=r6).
Red ; Intro H.
Change (s6f r6). 
Elim H ; Exact I.
Save neqs6r6. 

Goal ~(<act>s6=s2).
Red ; Intro H.
Change (s6f s2).
Elim H ; Exact I.
Save neqs6s2.

Goal ~(<act>s6=s3).
Red ; Intro H.
Change (s6f s3).
Elim H ; Exact I.
Save neqs6s3.

Goal ~(<act>s6=s4).
Red ; Intro H.
Change (s6f s4).
Elim H ; Exact I.
Save neqs6s4.

Goal ~(<act>s6=s5).
Red ; Intro H.
Change (s6f s5).
Elim H ; Exact I.
Save neqs6s5.

Goal ~(<act>s6=c2).
Red ; Intro H.
Change (s6f c2).
Elim H ; Exact I.
Save neqs6c2.

Goal ~(<act>s6=c3).
Red ; Intro H.
Change (s6f c3).
Elim H ; Exact I.
Save neqs6c3.

Goal ~(<act>s6=c5).
Red ; Intro H.
Change (s6f c5).
Elim H ; Exact I.
Save neqs6c5.

Goal ~(<act>s6=c6).
Red ; Intro H.
Change (s6f c6).
Elim H ; Exact I.
Save neqs6c6.

Goal ~(<act>s6=int).
Red ; Intro H.
Change (s6f int).
Elim H ; Exact I.
Save neqs6int.

Goal ~(<act>s6=tau).
Red ; Intro H.
Change (s6f tau).
Elim H ; Exact I.
Save neqs6tau.

Hint neqs6r2 neqs6r3 neqs6r5 neqs6r6 neqs6s2 neqs6s3 neqs6s4 neqs6s5
neqs6r1 neqs6c2 neqs6c3 neqs6c5 neqs6c6 neqs6int neqs6tau.


Definition c2f = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     True  False False False False
                                     False False).

Goal ~(<act>c2=r1).
Red ; Intro H.
Change (c2f r1).
Elim H ; Exact I.
Save neqc2r1.

Goal ~(<act>c2=r2).
Red ; Intro H.
Change (c2f r2).
Elim H ; Exact I.
Save neqc2r2.

Goal ~(<act>c2=r3).
Red ; Intro H.
Change (c2f r3). 
Elim H ; Exact I.
Save neqc2r3. 

Goal ~(<act>c2=r5).
Red ; Intro H.
Change (c2f r5). 
Elim H ; Exact I.
Save neqc2r5. 

Goal ~(<act>c2=r6).
Red ; Intro H.
Change (c2f r6). 
Elim H ; Exact I.
Save neqc2r6. 

Goal ~(<act>c2=s2).
Red ; Intro H.
Change (c2f s2).
Elim H ; Exact I.
Save neqc2s2.

Goal ~(<act>c2=s3).
Red ; Intro H.
Change (c2f s3).
Elim H ; Exact I.
Save neqc2s3.

Goal ~(<act>c2=s4).
Red ; Intro H.
Change (c2f s4).
Elim H ; Exact I.
Save neqc2s4.

Goal ~(<act>c2=s5).
Red ; Intro H.
Change (c2f s5).
Elim H ; Exact I.
Save neqc2s5.

Goal ~(<act>c2=s6).
Red ; Intro H.
Change (c2f s6).
Elim H ; Exact I.
Save neqc2s6.

Goal ~(<act>c2=c3).
Red ; Intro H.
Change (c2f c3).
Elim H ; Exact I.
Save neqc2c3.

Goal ~(<act>c2=c5).
Red ; Intro H.
Change (c2f c5).
Elim H ; Exact I.
Save neqc2c5.

Goal ~(<act>c2=c6).
Red ; Intro H.
Change (c2f c6).
Elim H ; Exact I.
Save neqc1c6.

Goal ~(<act>c2=int).
Red ; Intro H.
Change (c2f int).
Elim H ; Exact I.
Save neqc2int.

Goal ~(<act>c2=tau).
Red ; Intro H.
Change (c2f tau).
Elim H ; Exact I.
Save neqc2tau.

Hint neqc2r2 neqc2r3 neqc2r5 neqc2r6 neqc2s2 neqc2s3 neqc2s4 neqc2s5
neqc2s6 (*neqc2s1*) neqc2c3 neqc2c5 (*neqc2c6*) neqc2int neqc2tau.


Definition c3f = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     False True  False False False
                                     False False).

Goal ~(<act>c3=r1).
Red ; Intro H.
Change (c3f r1).
Elim H ; Exact I.
Save neqc3r1.

Goal ~(<act>c3=r2).
Red ; Intro H.
Change (c3f r2).
Elim H ; Exact I.
Save neqc3r2.

Goal ~(<act>c3=r3).
Red ; Intro H.
Change (c3f r3). 
Elim H ; Exact I.
Save neqc3r3. 

Goal ~(<act>c3=r5).
Red ; Intro H.
Change (c3f r5). 
Elim H ; Exact I.
Save neqc3r5. 

Goal ~(<act>c3=r6).
Red ; Intro H.
Change (c3f r6). 
Elim H ; Exact I.
Save neqc3r6. 

Goal ~(<act>c3=s2).
Red ; Intro H.
Change (c3f s2).
Elim H ; Exact I.
Save neqc3s2.

Goal ~(<act>c3=s3).
Red ; Intro H.
Change (c3f s3).
Elim H ; Exact I.
Save neqc3s3.

Goal ~(<act>c3=s4).
Red ; Intro H.
Change (c3f s4).
Elim H ; Exact I.
Save neqc3s4.

Goal ~(<act>c3=s5).
Red ; Intro H.
Change (c3f s5).
Elim H ; Exact I.
Save neqc3s5.

Goal ~(<act>c3=s6).
Red ; Intro H.
Change (c3f s6).
Elim H ; Exact I.
Save neqc3s6.

Goal ~(<act>c3=c2).
Red ; Intro H.
Change (c3f c2).
Elim H ; Exact I.
Save neqc3c2.

Goal ~(<act>c3=c5).
Red ; Intro H.
Change (c3f c5).
Elim H ; Exact I.
Save neqc3c5.

Goal ~(<act>c3=c6).
Red ; Intro H.
Change (c3f c6).
Elim H ; Exact I.
Save neqc3c6.

Goal ~(<act>c3=int).
Red ; Intro H.
Change (c3f int).
Elim H ; Exact I.
Save neqc3int.

Goal ~(<act>c3=tau).
Red ; Intro H.
Change (c3f tau).
Elim H ; Exact I.
Save neqc3tau.

Hint neqc3r2 neqc3r3 neqc3r5 neqc3r6 neqc3s2 neqc3s3 neqc3s4 neqc3s5
neqc3s6 neqc3c2 neqc3r1 neqc3c5 neqc3c6 neqc3int neqc3tau.


Definition c5f = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     False False True  False False
                                     False False).

Goal ~(<act>c5=r1).
Red ; Intro H.
Change (c5f r1).
Elim H ; Exact I.
Save neqc5r1.

Goal ~(<act>c5=r2).
Red ; Intro H.
Change (c5f r2).
Elim H ; Exact I.
Save neqc5r2.

Goal ~(<act>c5=r3).
Red ; Intro H.
Change (c5f r3). 
Elim H ; Exact I.
Save neqc5r3. 

Goal ~(<act>c5=r5).
Red ; Intro H.
Change (c5f r5). 
Elim H ; Exact I.
Save neqc5r5. 

Goal ~(<act>c5=r6).
Red ; Intro H.
Change (c5f r6). 
Elim H ; Exact I.
Save neqc5r6. 

Goal ~(<act>c5=s2).
Red ; Intro H.
Change (c5f s2).
Elim H ; Exact I.
Save neqc5s2.

Goal ~(<act>c5=s3).
Red ; Intro H.
Change (c5f s3).
Elim H ; Exact I.
Save neqc5s3.

Goal ~(<act>c5=s4).
Red ; Intro H.
Change (c5f s4).
Elim H ; Exact I.
Save neqc5s4.

Goal ~(<act>c5=s5).
Red ; Intro H.
Change (c5f s5).
Elim H ; Exact I.
Save neqc5s5.

Goal ~(<act>c5=s6).
Red ; Intro H.
Change (c5f s6).
Elim H ; Exact I.
Save neqc5s6.

Goal ~(<act>c5=c2).
Red ; Intro H.
Change (c5f c2).
Elim H ; Exact I.
Save neqc5c2.

Goal ~(<act>c5=c3).
Red ; Intro H.
Change (c5f c3).
Elim H ; Exact I.
Save neqc5c3.

Goal ~(<act>c5=c6).
Red ; Intro H.
Change (c5f c6).
Elim H ; Exact I.
Save neqc5c6.

Goal ~(<act>c5=int).
Red ; Intro H.
Change (c5f int).
Elim H ; Exact I.
Save neqc5int.

Goal ~(<act>c5=tau).
Red ; Intro H.
Change (c5f tau).
Elim H ; Exact I.
Save neqc5tau.

Hint neqc5r2 neqc5r3 neqc5r5 neqc5r6 neqc5s2 neqc5s3 neqc5s4 neqc5s5
neqc5s6 neqc5c2 neqc5c3 neqc5r1 neqc5c6 neqc5int neqc5tau.


Definition c6f = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     False False False True False
                                     False False).

Goal ~(<act>c6=r1).
Red ; Intro H.
Change (c6f r1).
Elim H ; Exact I.
Save neqc6r1.

Goal ~(<act>c6=r2).
Red ; Intro H.
Change (c6f r2).
Elim H ; Exact I.
Save neqc6r2.

Goal ~(<act>c6=r3).
Red ; Intro H.
Change (c6f r3). 
Elim H ; Exact I.
Save neqc6r3. 

Goal ~(<act>c6=r5).
Red ; Intro H.
Change (c6f r5). 
Elim H ; Exact I.
Save neqc6r5. 

Goal ~(<act>c6=r6).
Red ; Intro H.
Change (c6f r6). 
Elim H ; Exact I.
Save neqc6r6. 

Goal ~(<act>c6=s2).
Red ; Intro H.
Change (c6f s2).
Elim H ; Exact I.
Save neqc6s2.

Goal ~(<act>c6=s3).
Red ; Intro H.
Change (c6f s3).
Elim H ; Exact I.
Save neqc6s3.

Goal ~(<act>c6=s4).
Red ; Intro H.
Change (c6f s4).
Elim H ; Exact I.
Save neqc6s4.

Goal ~(<act>c6=s5).
Red ; Intro H.
Change (c6f s5).
Elim H ; Exact I.
Save neqc6s5.

Goal ~(<act>c6=s6).
Red ; Intro H.
Change (c6f s6).
Elim H ; Exact I.
Save neqc6s6.

Goal ~(<act>c6=c2).
Red ; Intro H.
Change (c6f c2).
Elim H ; Exact I.
Save neqc6c2.

Goal ~(<act>c6=c3).
Red ; Intro H.
Change (c6f c3).
Elim H ; Exact I.
Save neqc6c3.

Goal ~(<act>c6=c5).
Red ; Intro H.
Change (c6f c5).
Elim H ; Exact I.
Save neqc6c5.

Goal ~(<act>c6=int).
Red ; Intro H.
Change (c6f int).
Elim H ; Exact I.
Save neqc6int.

Goal ~(<act>c6=tau).
Red ; Intro H.
Change (c6f tau).
Elim H ; Exact I.
Save neqc6tau.

Hint neqc6r2 neqc6r3 neqc6r5 neqc6r6 neqc6s2 neqc6s3 neqc6s4 neqc6s5
neqc6s6 neqc6c2 neqc6c3 neqc6c5 neqc6r1 neqc6int neqc6tau.


Definition intf = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     False False False False True
                                     False False).

Goal ~(<act>int=r1).
Red ; Intro H.
Change (intf r1).
Elim H ; Exact I.
Save neqintr1.

Goal ~(<act>int=r2).
Red ; Intro H.
Change (intf r2).
Elim H ; Exact I.
Save neqintr2.

Goal ~(<act>int=r3).
Red ; Intro H.
Change (intf r3). 
Elim H ; Exact I.
Save neqintr3. 

Goal ~(<act>int=r5).
Red ; Intro H.
Change (intf r5). 
Elim H ; Exact I.
Save neqintr5. 

Goal ~(<act>int=r6).
Red ; Intro H.
Change (intf r6). 
Elim H ; Exact I.
Save neqintr6. 

Goal ~(<act>int=s2).
Red ; Intro H.
Change (intf s2).
Elim H ; Exact I.
Save neqints2.

Goal ~(<act>int=s3).
Red ; Intro H.
Change (intf s3).
Elim H ; Exact I.
Save neqints3.

Goal ~(<act>int=s4).
Red ; Intro H.
Change (intf s4).
Elim H ; Exact I.
Save neqints4.

Goal ~(<act>int=s5).
Red ; Intro H.
Change (intf s5).
Elim H ; Exact I.
Save neqints5.

Goal ~(<act>int=s6).
Red ; Intro H.
Change (intf s6).
Elim H ; Exact I.
Save neqints6.

Goal ~(<act>int=c2).
Red ; Intro H.
Change (intf c2).
Elim H ; Exact I.
Save neqintc2.

Goal ~(<act>int=c3).
Red ; Intro H.
Change (intf c3).
Elim H ; Exact I.
Save neqintc3.

Goal ~(<act>int=c5).
Red ; Intro H.
Change (intf c5).
Elim H ; Exact I.
Save neqintc5.

Goal ~(<act>int=c6).
Red ; Intro H.
Change (intf c6).
Elim H ; Exact I.
Save neqintc6.

Goal ~(<act>int=tau).
Red ; Intro H.
Change (intf tau).
Elim H ; Exact I.
Save neqinttau.

Hint neqintr2 neqintr3 neqintr5 neqintr6 neqints2 neqints3 neqints4 neqints5
neqints6 neqintc2 neqintc3 neqintc5 neqintc6 neqintr1 neqinttau.


Definition tauf = [a:act](<Prop>Match a with False False False False False
                                     False False False False False
                                     False False False False  False
                                     False True).

Goal ~(<act>tau=r1).
Red ; Intro H.
Change (tauf r1).
Elim H ; Exact I.
Save neqtaur1.

Goal ~(<act>tau=r2).
Red ; Intro H.
Change (tauf r2).
Elim H ; Exact I.
Save neqtaur2.

Goal ~(<act>tau=r3).
Red ; Intro H.
Change (tauf r3). 
Elim H ; Exact I.
Save neqtaur3. 

Goal ~(<act>tau=r5).
Red ; Intro H.
Change (tauf r5). 
Elim H ; Exact I.
Save neqtaur5. 

Goal ~(<act>tau=r6).
Red ; Intro H.
Change (tauf r6). 
Elim H ; Exact I.
Save neqtaur6. 

Goal ~(<act>tau=s2).
Red ; Intro H.
Change (tauf s2).
Elim H ; Exact I.
Save neqtaus2.

Goal ~(<act>tau=s3).
Red ; Intro H.
Change (tauf s3).
Elim H ; Exact I.
Save neqtaus3.

Goal ~(<act>tau=s4).
Red ; Intro H.
Change (tauf s4).
Elim H ; Exact I.
Save neqtaus4.

Goal ~(<act>tau=s5).
Red ; Intro H.
Change (tauf s5).
Elim H ; Exact I.
Save neqtaus5.

Goal ~(<act>tau=s6).
Red ; Intro H.
Change (tauf s6).
Elim H ; Exact I.
Save neqtaus6.

Goal ~(<act>tau=c2).
Red ; Intro H.
Change (tauf c2).
Elim H ; Exact I.
Save neqtauc2.

Goal ~(<act>tau=c3).
Red ; Intro H.
Change (tauf c3).
Elim H ; Exact I.
Save neqtauc3.

Goal ~(<act>tau=c5).
Red ; Intro H.
Change (tauf c5).
Elim H ; Exact I.
Save neqtauc5.

Goal ~(<act>tau=c6).
Red ; Intro H.
Change (tauf c6).
Elim H ; Exact I.
Save neqtauc6.

Goal ~(<act>tau=int).
Red ; Intro H.
Change (tauf int).
Elim H ; Exact I.
Save neqtauint.

Hint neqtaur2 neqtaur3 neqtaur5 neqtaur6 neqtaus2 neqtaus3 neqtaus4 neqtaus5
neqtaus6 neqtauc2 neqtauc3 neqtauc5 neqtauc6 neqtauint neqtaur1.

(*Here the section on equality of actions ends *)

(*Here the section on actions in the set H starts *)

Goal (a:act)(<act>a=r2) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto.
Save HLemmar2.

Goal (a:act)(<act>a=r3) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto.
Save HLemmar3.

Goal (a:act)(<act>a=r5) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto.
Save HLemmar5.

Goal (a:act)(<act>a=r6) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto.
Save HLemmar6.

Goal (a:act)(<act>a=s2) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto 10.
Save HLemmas2.

Goal (a:act)(<act>a=s3) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto 10.
Save HLemmas3.

Goal (a:act)(<act>a=s5) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto 10.
Save HLemmas5.

Goal (a:act)(<act>a=s6) ->(In_ehlist a H).
Intros.
Unfold In_ehlist.
Auto 10.
Save HLemmas6.


Goal (a:act)(~<act>a=r2)->(~<act>a=r3)->(~<act>a=r5)->(~<act>a=r6)->
  (~<act>a=s2)-> (~<act>a=s3)->(~<act>a=s5)->(~<act>a=s6)->~(In_ehlist a H).
Intros.
Red . Unfold In_ehlist . 
Intro I1. Elim I1. Assumption.
Intro I2. Elim I2. Assumption.
Intro I3. Elim I3. Assumption.
Intro I4. Elim I4. Assumption.
Intro I5. Elim I5. Assumption.
Intro I6. Elim I6. Assumption.
Intro I7. Elim I7. Assumption.
Intro I8. Elim I8. Assumption.
Intro . Assumption.
Save HLemma.

Hint HLemmar2 HLemmar3 HLemmar5 HLemmar6 HLemmas2 HLemmas3 HLemmas5
HLemmas6 HLemma.

Goal ~(In_ehlist r1 H).
Auto.
Save Inr1H.

Goal (In_ehlist r2 H).
Auto.
Save Inr2H.

Goal (In_ehlist r3 H).
Auto.
Save Inr3H.

Goal (In_ehlist r5 H).
Auto.
Save Inr5H.

Goal (In_ehlist r6 H).
Auto.
Save Inr6H.

Goal (In_ehlist s2 H).
Auto.
Save Ins2H.

Goal (In_ehlist s3 H).
Auto.
Save Ins3H.

Goal ~(In_ehlist s4 H).
Auto.
Save Ins4H.

Goal (In_ehlist s5 H).
Auto.
Save Ins5H.

Goal (In_ehlist s6 H).
Auto.
Save Ins6H.

Goal ~(In_ehlist int H).
Auto.
Save InintH.

Goal ~(In_ehlist c2 H).
Auto.
Save Inc2H.

Goal ~(In_ehlist c3 H). 
Auto.
Save Inc3H. 

Goal ~(In_ehlist c5 H). 
Auto.
Save Inc5H. 

Goal ~(In_ehlist c6 H). 
Auto.
Save Inc6H. 

Definition I'=(ehcons c2 (ehcons c3 (ehcons c5 (ehcons c6 ehnil)))).
Definition I''=(ehcons int ehnil).

Goal (In_ehlist c2 I').
Unfold In_ehlist. 
Left. Apply refl_equal. 
Save Inc2I. 

Goal (In_ehlist c3 I').
Unfold In_ehlist. 
Right.Left. Apply refl_equal. 
Save Inc3I. 

Goal (In_ehlist c5 I').
Unfold In_ehlist. 
Right.Right.Left. Apply refl_equal. 
Save Inc5I. 

Goal (In_ehlist c6 I').
Unfold In_ehlist.
Right.Right.Right.Left. Apply refl_equal.
Save Inc6I.

Goal ~(In_ehlist int I').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqintc2 . Assumption.
Intro . Elim H0 . Intro . Apply neqintc3 . Assumption.
Intro . Elim H1 . Intro . Apply neqintc5 . Assumption.
Intro . Elim H2 . Intro . Apply neqintc6 . Assumption.
Intro . Assumption.
Save InintI.

Goal ~(In_ehlist s4 I').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqs4c2 . Assumption.
Intro . Elim H0 . Intro . Apply neqs4c3 . Assumption.
Intro . Elim H1 . Intro . Apply neqs4c5 . Assumption.
Intro . Elim H2 . Intro . Apply neqs4c6 . Assumption.
Intro . Assumption.
Save Ins4I.

Goal ~(In_ehlist r1 I').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqr1c2 . Assumption.
Intro . Elim H0 . Intro . Apply neqr1c3 . Assumption.
Intro . Elim H1 . Intro . Apply neqr1c5 . Assumption.
Intro . Elim H2 . Intro . Apply neqr1c6 . Assumption.
Intro . Assumption.
Save Inr1I.

Goal (In_ehlist int I'').
Unfold In_ehlist.
Left. Apply refl_equal.
Save InintI''.


Goal ~(In_ehlist s4 I'').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqints4 . 
Apply sym_equal. Assumption.
Intro . Assumption.
Save Ins4I''.

Goal ~(In_ehlist r1 I'').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqintr1 . 
Apply sym_equal. Assumption.
Intro . Assumption.
Save Inr1I''.

Goal ~(In_ehlist tau I'').
Red . Unfold In_ehlist .
Intro . Elim H . Intro . Apply neqinttau . 
Apply sym_equal. Assumption.
Intro . Assumption.
Save IntauI''.


(*  End of basic axioms about the sets H and I   *)


Goal (b:bit)(x,y:proc)
     <proc>(sum D ([d:D](seq (ia D r1 d) 
        (enc H (mer (seq (Sn_d d b) y) x)))))
           =(enc H (Lmer (seq (Sn b) y) x)).

Intros.
Elim ProcSn.
Elim (SUM5 D ([d:D](seq (ia D r1 d) (Sn_d d b))) y).
ElimType <D->proc>[d:D](seq (ia D r1 d) 
                       (seq (Sn_d d b) y))
                =[d:D](seq (seq (ia D r1 d) (Sn_d d b)) y).
2:Apply EXT; Intro; Elim A5; Apply refl_equal.
Elim (SUM6 D 
          ([d:D](seq (ia D r1 d) (seq (Sn_d d b) y))) x).
Elim SUM9.
ElimType <D->proc>([d:D](seq (ia D r1 d) (enc H (mer (seq (Sn_d d b) y) x))))=
                  [d:D] (enc H
        (Lmer (seq (ia D r1 d) (seq (Sn_d d b) y)) x)).
           
Apply refl_equal.
Apply EXT ; Intro . 
Elim CM3.
Elim D5.
Elim D1.
Apply refl_equal.
Exact Inr1H.
Save LmerSn.

Goal (x:proc)<proc>Delta=(enc H (Lmer (K i) x)).
Intro.
Elim ChanK.
Elim (SUM6 Frame ([x:Frame]
           (seq (ia Frame r2 x)
              (seq
                 (alt (seq (ia one int i) (ia Frame s3 x))
                    (seq (ia one int i) (ia Frame s3 lce)))
                 (K i)))) x).
Elim SUM9.
ElimType <Frame->proc>([d:Frame]Delta)=
         [d:Frame]
     (enc H
        (Lmer
           (seq (ia Frame r2 d)
              (seq
                 (alt (seq (ia one int i) (ia Frame s3 d))
                    (seq (ia one int i) (ia Frame s3 lce)))
                 (K i)))
           x)).
Elim SUM1.
Apply refl_equal.
Apply EXT. Intro.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Inr2H.
Save LmerK.

Goal (x:proc)<proc>Delta=(enc H (Lmer (L i)  x)).
Intro.
Elim ChanL.
Elim (SUM6 frame ([n:frame]
           (seq (ia frame r5 n)
              (seq
                 (alt (seq (ia one int i) (ia frame s6 n))
                    (seq (ia one int i) (ia frame s6 sce)))
                 (L i)))) x).
Elim SUM9.
ElimType <frame->proc>([d:frame]Delta)=
            [d:frame]
     (enc H
        (Lmer
           (seq (ia frame r5 d)
              (seq
                 (alt (seq (ia one int i) (ia frame s6 d))
                    (seq (ia one int i) (ia frame s6 sce)))
                 (L i))) x)).
           
Elim SUM1.
Apply refl_equal.
Apply EXT. Intro.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Inr5H.
Save LmerL.

Goal (b:bit)(x,y:proc)<proc>Delta=(enc H (Lmer (seq (Rn b) y) x)).
Intros.
Elim ProcRn.
Elim (A4 (seq
                    (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                       (ia Frame r3 lce))
                    (seq (ia frame s5 (tuple b)) (Rn b)))
                (D+[d:D]
                   (seq (ia Frame r3 (Tuple (toggle b) d))
                      (seq (ia D s4 d)
                         (ia frame s5 (tuple (toggle b))))))
               y).
Elim (CM4 (seq
                 (seq
                    (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                       (ia Frame r3 lce))
                    (seq (ia frame s5 (tuple b)) (Rn b)))
                 y)
               (seq
                 (D
                 +[d:D]
                   (seq (ia Frame r3 (Tuple (toggle b) d))
                      (seq (ia D s4 d)
                         (ia frame s5 (tuple (toggle b)))))) y) x).
Elim D4.
Cut <proc>Delta=(enc H
         (Lmer
            (seq
               (D
               +[d:D]
                 (seq (ia Frame r3 (Tuple (toggle b) d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
                y) x)).
Intro.
Elim H0.
Elim A6.
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce)
        (seq (ia frame s5 (tuple b)) (Rn b))).
Elim (A4 (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (ia frame s5 (tuple b)) (Rn b)))
           (seq (ia Frame r3 lce)
                  (seq (ia frame s5 (tuple b)) (Rn b))) y).
Elim (CM4 (seq
               (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (ia frame s5 (tuple b)) (Rn b))) y)
         (seq
               (seq (ia Frame r3 lce)
                  (seq (ia frame s5 (tuple b)) (Rn b))) y) x).
Elim A5.
Elim A5.
(* added *)
Elim A5.
(* end added *)
Elim CM3.
Elim D4.
Elim D5.
Elim D2.
Elim A7.
Elim A6.
(* removed
Elim (A5 (D+[d:D](ia Frame r3 (Tuple b d)))
        (seq (ia frame s5 (tuple b)) (Rn b))
             y).
Elim (SUM5 D ([d:D](ia Frame r3 (Tuple b d))) 
     (seq (seq (ia frame s5 (tuple b)) (Rn b)) y)).
Elim (SUM6 D [d:D]
           (seq (ia Frame r3 (Tuple b d))
             (seq (seq (ia frame s5 (tuple b)) (Rn b))
                 y)) x). *)
(* added *)
Elim SUM5.
Elim SUM6.
(* end added *)
Elim SUM9.
(* pattern changed*)
ElimType <D->proc>[d:D]Delta=[d:D](enc H
        (Lmer
           (seq (ia Frame r3 (Tuple b d))
              (seq (ia frame s5 (tuple b)) (seq (Rn b) y)))
           x)).
(* end pattern changed*)
Elim SUM1.
Apply refl_equal.
Apply EXT.
Intro.
Elim CM3.
Elim D5.
Elim D2. 
Elim A7.
Apply refl_equal.
Exact Inr3H.
Exact Inr3H. 
Elim (SUM5 D ([d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
           y).
Elim (SUM6 D ([d:D]
           (seq
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
              y)) x).
Elim SUM9.
ElimType <D->proc>[d:D]Delta=
   [d:D]
     (enc H
        (Lmer
           (seq
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
              y)
           x)).
Elim SUM1.
Apply refl_equal.
Apply EXT ; Intro.
Elim A5.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Inr3H.

Save LmerRn.

Goal (b:bit)(x,y:proc)
       <proc>Delta=(enc H (Lmer (comm (L i) (seq (Rn b) y)) x)).
Intros.
Cut <proc>Delta=(comm (L i) (seq (Rn b) y)).
Intro.
Elim H0.
Unfold 2 Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.

Elim ChanL.
Elim SUM7.
ElimType <frame->proc>[d:frame]Delta=
    [d:frame]
     (comm
        (seq (ia frame r5 d)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (Rn b) y)).
Elim SUM1.
Apply refl_equal.
Apply EXT.
Intro.
Elim ProcRn.
Elim (A4 (seq
               (alt D+[d:D](ia Frame r3 (Tuple b d)) (ia Frame r3 lce))
               (seq (ia frame s5 (tuple b)) (Rn b)))
          ( D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
          y).

Elim CM9.

Cut <proc>Delta=
        (comm
         (seq (ia frame r5 d)
            (seq
               (alt (seq (ia one int i) (ia frame s6 d))
                  (seq (ia one int i) (ia frame s6 sce)))
               (L i)))
         (seq
            D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
             y)).
Intro.
Elim H.
Elim A6.
Elim (A5 (alt D+[d:D](ia Frame r3 (Tuple b d)) (ia Frame r3 lce))
       (seq (ia frame s5 (tuple b)) (Rn b))
       y).
Elim A4.
Elim (A4 D+[d:D](ia Frame r3 (Tuple b d)) (ia Frame r3 lce) 
         (seq (seq (ia frame s5 (tuple b)) (Rn b)) y)).
Elim CM9.
Cut <proc>Delta=
      (comm
         (seq (ia frame r5 d)
            (alt (seq (seq (ia one int i) (ia frame s6 d)) (L i))
               (seq (seq (ia one int i) (ia frame s6 sce)) (L i))))
         (seq (ia Frame r3 lce)
            (seq (seq (ia frame s5 (tuple b)) (Rn b))
               y))).

Intro.
Elim H0.
Elim A6.
Elim (SUM5 D ([d:D](ia Frame r3 (Tuple b d)))
      (seq (seq (ia frame s5 (tuple b)) (Rn b)) y)).
Elim SC3.
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
    [d0:D]
     (comm
        (seq (ia Frame r3 (Tuple b d0))
           (seq (seq (ia frame s5 (tuple b)) (Rn b))
              y))
        (seq (ia frame r5 d)
           (alt (seq (seq (ia one int i) (ia frame s6 d)) (L i))
              (seq (seq (ia one int i) (ia frame s6 sce)) (L i))))).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Red.
Intro.
Apply EQFf.
Apply EQ_sym.
Assumption.
Elim (SUM5 D ([d:D]
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
     y).
Elim SC3. 
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
          [d0:D]
     (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle b) d0))
              (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
           y)
        (seq (ia frame r5 d)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))).
Elim SUM1.   
Apply refl_equal.
Apply EXT ; Intro.
Elim A5.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.
Save CommLRn.

Goal (x:proc)<proc>Delta=(enc H (Lmer (comm (K i) (L i)) x)).
Cut <proc>Delta=(comm (K i) (L i)).
Intro.
Elim H0.
Unfold 2 Delta.
Intro.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal.
Elim ChanK.
Elim SUM7.
ElimType <Frame->proc>[d:Frame]Delta=
       [d:Frame]
     (comm
        (seq (ia Frame r2 d)
           (seq
              (alt (seq (ia one int i) (ia Frame s3 d))
                 (seq (ia one int i) (ia Frame s3 lce)))
              (K i)))
        (L i)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro .
Elim ChanL.
Elim SC3.
Elim SUM7.
ElimType <frame->proc>[d:frame]Delta=
         [d0:frame]
     (comm
        (seq (ia frame r5 d0)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d0))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (ia Frame r2 d)
           (seq
              (alt (seq (ia one int i) (ia Frame s3 d))
                 (seq (ia one int i) (ia Frame s3 lce)))
              (K i)))).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.   
Elim A7.
Apply refl_equal.
Red ; Intro.
Apply EQFf.
Apply EQ_sym.
Assumption.

Save CommKL.

Goal (b:bit)(x,y:proc)
       <proc>Delta=(enc H (Lmer (comm (K i) (seq (Rn b) y)) x)).
Intros.
Cut <proc>Delta=(comm (K i) (seq (Rn b) y)).
Intro.
Elim H0.
Unfold 2 Delta.
Elim CM2.
Elim A7. 
Elim D3.
Apply refl_equal. 

Elim ChanK.
Elim SUM7.
ElimType <Frame->proc>[d:Frame]Delta=
      [d:Frame]
     (comm
        (seq (ia Frame r2 d)
           (seq
              (alt (seq (ia one int i) (ia Frame s3 d))
                 (seq (ia one int i) (ia Frame s3 lce)))
              (K i)))
        (seq (Rn b) y)).
Elim SUM1 ; Apply refl_equal.  
Apply EXT ; Intro.
Elim ProcRn.
Elim A4.
Elim (A4 
       (seq
               (alt D+[d:D](ia Frame r3 (Tuple b d)) (ia Frame r3 lce))
               (seq (ia frame s5 (tuple b)) (Rn b)))
       (        D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
            )
  y).
Elim CM9.
Cut <proc>Delta=
       (comm
         (seq (ia Frame r2 d)
            (alt (seq (seq (ia one int i) (ia Frame s3 d)) (K i))
               (seq (seq (ia one int i) (ia Frame s3 lce)) (K i))))
         (seq
            D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
             y)).
Intro .
Elim H.
Elim A6.
Elim A5.
Elim A5.
Elim (A5 (alt D+[d:D](ia Frame r3 (Tuple b d)) (ia Frame r3 lce))
     (seq (ia frame s5 (tuple b)) (Rn b))
      y).
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce)
         (seq (seq (ia frame s5 (tuple b)) (Rn b))
            y)).
Elim CM9.
Elim CM7.
Elim CF2.
Elim A7 ; Elim  A6.
Elim (SUM5 D ([d:D](ia Frame r3 (Tuple b d)))
          (seq (seq (ia frame s5 (tuple b)) (Rn b))
            y)).
Elim SC3.
Elim SUM7.
ElimType <D->proc>[d:D]Delta= 
     [d0:D]
     (comm
        (seq (ia Frame r3 (Tuple b d0))
           (seq (seq (ia frame s5 (tuple b)) (Rn b))
              y))
        (seq (ia Frame r2 d)
           (alt (seq (ia one int i) (seq (ia Frame s3 d) (K i)))
              (seq (ia one int i) (seq (ia Frame s3 lce) (K i)))))).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2.
Elim A7 ; Apply refl_equal.  
Apply refl_equal.
Apply refl_equal.
Elim SC3.

Elim (SUM5 D ([d:D]
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
       y).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
     [d0:D]
     (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle b) d0))
              (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
           y)
        (seq (ia Frame r2 d)
           (alt (seq (seq (ia one int i) (ia Frame s3 d)) (K i))
              (seq (seq (ia one int i) (ia Frame s3 lce)) (K i))))).
Elim SUM1 ; Apply refl_equal.  
Apply EXT ; Intro.
Elim A5.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.  
Save CommKRn.



Goal (b:bit)(x,y:proc)
      <proc>Delta=(enc H (Lmer (comm (seq (Sn b) y) (K i)) x)).
Intros.
Cut <proc>Delta=(comm (seq (Sn b) y) (K i)).
Intro . 
Elim H0.
Unfold 2 Delta.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal.

Elim ProcSn.
Elim (SUM5 D ([d:D](seq (ia D r1 d) (Sn_d d b))) y).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
        [d:D](comm (seq (seq (ia D r1 d) (Sn_d d b)) y) (K i)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim A5.
Elim ChanK.
Elim SC3.
Elim SUM7.
ElimType <Frame->proc>[d:Frame]Delta=
    [d0:Frame]
     (comm
        (seq (ia Frame r2 d0)
           (seq
              (alt (seq (ia one int i) (ia Frame s3 d0))
                 (seq (ia one int i) (ia Frame s3 lce)))
              (K i)))
        (seq (ia D r1 d) (seq (Sn_d d b) y))).
Elim SUM1 ; Apply refl_equal.   
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFD.

Save  CommSnK.

Goal (b:bit)(x,y:proc)
          <proc>Delta=(enc H (Lmer (comm (seq (Sn b) y) (L i)) x)).

Intros.    
Cut <proc>Delta=(comm (seq (Sn b) y) (L i)).
Intro .   
Elim H0.
Unfold 2 Delta.
Elim CM2. 
Elim A7.
Elim D3.
Apply refl_equal.

Elim ProcSn.
Elim (SUM5 D ([d:D](seq (ia D r1 d) (Sn_d d b))) y).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
        [d:D](comm (seq (seq (ia D r1 d) (Sn_d d b)) y) (L i)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro. 
Elim A5.
Elim ChanL.
Elim SC3.
Elim SUM7.
ElimType <frame->proc>[d:frame]Delta=
     [d0:frame]
     (comm
        (seq (ia frame r5 d0)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d0))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (ia D r1 d) (seq (Sn_d d b) y))).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQfD.
Save CommSnL.


Goal (b,b':bit)(x,y,y':proc)
         <proc>Delta=(enc H (Lmer (comm (seq (Sn b) y) (seq (Rn b') y')) x)).
Intros.
Cut <proc>Delta=(comm (seq (Sn b) y) (seq (Rn b') y')). 
Intro .   
Elim H0.
Unfold 2 Delta. 
Elim CM2. 
Elim A7. 
Elim D3.
Apply refl_equal. 
 
Elim ProcSn.
Elim (SUM5 D ([d:D](seq (ia D r1 d) (Sn_d d b))) y). 
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
       [d:D](comm (seq (seq (ia D r1 d) (Sn_d d b)) y) (seq (Rn b') y')).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro. 
Elim A5.

Elim ProcRn.
Elim (A4 (seq
               (alt D+[d:D](ia Frame r3 (Tuple b' d)) (ia Frame r3 lce))
               (seq (ia frame s5 (tuple b')) (Rn b')))
         (D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b') d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b')))))
            )
         y').

Elim CM9.
Cut <proc>Delta=
        (comm (seq (ia D r1 d) (seq (Sn_d d b) y))
         (seq
            D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b') d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b')))))
             y')).
Intro.
Elim H.
Elim A6.
Elim (A5 (alt D+[d:D](ia Frame r3 (Tuple b' d)) (ia Frame r3 lce))
                 (seq (ia frame s5 (tuple b')) (Rn b'))
                  y').
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b' d)))
          (ia Frame r3 lce)
              (seq (seq (ia frame s5 (tuple b')) (Rn b'))
            y')).  
Elim CM9.
Elim CM7.
Elim CF2''.
Elim A7 ; Elim A6.
Elim SC3.
Elim (SUM5 D ([d:D](ia Frame r3 (Tuple b' d)))
              (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                   y')).
Elim SUM7.
ElimType  <D->proc>[d:D]Delta=
      [d0:D] (comm
        (seq (ia Frame r3 (Tuple b' d0))
           (seq (seq (ia frame s5 (tuple b')) (Rn b')) y'))
        (seq (ia D r1 d) (seq (Sn_d d b) y))).
Elim SUM1 ; Apply refl_equal. 
Apply EXT ; Intro. 
Elim CM7 . 
Elim CF2'' . 
Elim A7 ; Apply refl_equal. 
Exact EQFD.
Red.
Intro.
Apply EQFD.
Apply EQ_sym.
Assumption.

Elim (SUM5 D ([d:D]
           (seq (ia Frame r3 (Tuple (toggle b') d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b'))))))
           y').
Elim SC3.
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
     [d0:D]
      (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle b') d0))
              (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b')))))
           y')
        (seq (ia D r1 d) (seq (Sn_d d b) y))).

Elim SUM1 ; Apply refl_equal.  
Apply EXT ; Intro. 
Elim A5.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFD.

Save CommSnRn.

Goal (b:bit)(d:D)(x,y:proc)<proc>Delta=(enc H (Lmer (seq (Sn_d d b) y) x)).

Intros.
Elim ProcSn_d.
Elim A5.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Ins2H.
Save LmerSnd.

Goal (b:bit)(d:D)(x,y:proc)<proc>Delta=(enc H (Lmer (seq (Tn_d d b) y) x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Elim CM4.
Elim CM4.
Elim A5.
Elim A5.
Elim CM3.
Elim CM3.
Elim CM3.
Elim D4.
Elim D4.
Elim D5.
Elim D5.
Elim D5.
Elim D2.
Elim D2.
Elim D2.
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Apply refl_equal.
Exact Inr6H.
Exact Inr6H.
Exact Inr6H.
Save LmerTnd.

Goal (f:frame)(x,y:proc)
        <proc>Delta=(enc H (Lmer (seq (ia frame s5 f) y) x)).

Intros.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Ins5H.
Save Lmers5.

Goal (d:D)(x,y:proc)
        <proc>(seq (ia D s4 d) (enc H (mer y x)))=
             (enc H (Lmer (seq (ia D s4 d) y) x)).

Intros.
Elim CM3.
Elim D5.
Elim D1.
Apply refl_equal.
Exact Ins4H.
Save Lmers4.

 
Goal (x,y,y':proc)
        <proc>(alt (seq (ia one int i) (enc H (mer y x)))
                    (seq (ia one int i) (enc H (mer y' x))))=
             (enc H (Lmer (alt (seq (ia one int i) y)
                               (seq (ia one int i) y')) x)).
 
Intros.
Elim CM4.
Elim CM3.
Elim CM3.
Elim D4.
Elim D5.
Elim D5.
Elim D1.
Apply refl_equal.
Exact InintH.
Save Lmeri.

Goal (f:Frame)(x,y:proc)
       <proc>Delta=(enc H (Lmer (seq (ia Frame s3 f) y) x)).

Intros.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Ins3H.
Save Lmers3.

Goal (f:frame)(x,y:proc)
       <proc>Delta=(enc H (Lmer (seq (ia frame s6 f) y) x)).

Intros.
Elim CM3.
Elim D5.
Elim D2.
Elim A7.
Apply refl_equal.
Exact Ins6H.
Save Lmers6.

Goal (c: bool)(p:proc)<proc>(cond p c p)=p.
Intros.
Elim c.
Elim COND1.
Apply refl_equal.
Elim COND2.
Apply refl_equal.
Save Bak4_2_1.

Goal (c:bool)(x,y,z:proc)
      ((<bool>true=c)->(<proc>x=y))->(<proc>(cond x c z)=(cond y c z)).
Intro.
Intro.
Intro.
Intro.
Elim c.
Intro.
Elim COND1.
Elim COND1.
Elim H.
Apply refl_equal.
Apply refl_equal.

Intro.
Elim COND2.
Elim COND2.
Apply refl_equal.
Save Def4_3_1_2.

Goal (c:bool)(x,y,z:proc)
      ((<bool>false=c)->(<proc>x=y))->(<proc>(cond z c x)=(cond z c y)).

Intro.
Intro.
Intro.
Intro.
Elim c.
Intro.
Elim COND1.
Elim COND1.
Apply refl_equal.

Intro.
Elim COND2.
Elim COND2.
Elim H.
Apply refl_equal.
Apply refl_equal.
Save Def4_3_1_2'.

Goal(x:Frame->proc)(d:Frame)<proc>(x d) =
    (sum Frame ([e:Frame](cond (x d) (eqF e d) Delta))).

Intros.
Pattern 1 (x d).
ElimType (<proc>(Frame+[e:Frame](x d))=(x d)).
Cut (e:Frame)<proc>(x d)=(alt (cond (x d) (eqF e d) Delta) (x d)).
Intros.
Elim (SUM3 Frame d [e:Frame](cond (x d) (eqF e d) Delta)).

Elim eqF7.
Elim COND1.
Pattern 3 (x d).
ElimType (<proc>(Frame+[e:Frame](x d))=(x d)).
Cut (x,y:Frame->proc)
      (<proc>(Frame+[d:Frame](alt (x d) (y d)))=(alt (Frame+x) (Frame+y))).
Intro SUM4r.

Elim SUM4r.
Cut <Frame->proc>[e:Frame](alt (cond (x d) (eqF e d) Delta) (x d))=
                          [e:Frame](x d).
Intros.
Elim H0.
Apply refl_equal.

Apply EXT.
Intro ; Apply sym_equal ; Trivial.
Intros.
Apply sym_equal.
Apply SUM4.


Elim SUM1; Auto.
Intro.
Elim (eqF e d).
Elim COND1.
Elim A3;Auto.
Elim COND2.
Elim A1;Elim A6;Auto.
Elim SUM1;Auto.
Save Sum_EliminationF.

Goal(x:frame->proc)(d:frame)<proc>(x d) =
    (sum frame ([e:frame](cond (x d) (eqf e d) Delta))).

Intros.
Pattern 1 (x d).
ElimType (<proc>(frame+[e:frame](x d))=(x d)).
Cut (e:frame)<proc>(x d)=(alt (cond (x d) (eqf e d) Delta) (x d)).
Intros.
Elim (SUM3 frame d [e:frame](cond (x d) (eqf e d) Delta)).

Elim eqf7.
Elim COND1.
Pattern 3 (x d).
ElimType (<proc>(frame+[e:frame](x d))=(x d)).
Cut (x,y:frame->proc)
      (<proc>(frame+[d:frame](alt (x d) (y d)))=(alt (frame+x) (frame+y))).
Intro SUM4r.

Elim SUM4r.
Cut <frame->proc>[e:frame](alt (cond (x d) (eqf e d) Delta) (x d))=
                          [e:frame](x d).
Intros.
Elim H0.
Apply refl_equal.

Apply EXT.
Intro ; Apply sym_equal ; Trivial.
Intros.
Apply sym_equal.
Apply SUM4.
 
 
Elim SUM1; Auto.
Intro.
Elim (eqf e d).
Elim COND1.
Elim A3;Auto.
Elim COND2.
Elim A1;Elim A6;Auto.
Elim SUM1;Auto.
Save Sum_Eliminationf.
 

Goal(x:D->proc)(d:D)<proc>(x d) =
    (sum D ([e:D](cond (x d) (eqD e d) Delta))).
 
Intros.
Pattern 1 (x d).
ElimType (<proc>(D+[e:D](x d))=(x d)).
Cut (e:D)<proc>(x d)=(alt (cond (x d) (eqD e d) Delta) (x d)).
Intros.  
Elim (SUM3 D d [e:D](cond (x d) (eqD e d) Delta)).
 
Elim eqD7.
Elim COND1.
Pattern 3 (x d).
ElimType (<proc>(D+[e:D](x d))=(x d)).
Cut (x,y:D->proc)
      (<proc>(D+[d:D](alt (x d) (y d)))=(alt (D+x) (D+y))).
Intro SUM4r.
 
Elim SUM4r.
Cut <D->proc>[e:D](alt (cond (x d) (eqD e d) Delta) (x d))=
                          [e:D](x d).
Intros.  
Elim H0.
Apply refl_equal.
 
Apply EXT.
Intro ; Apply sym_equal ; Trivial.
Intros.  
Apply sym_equal.
Apply SUM4.
 
 
Elim SUM1; Auto.
Intro.   
Elim (eqD e d).
Elim COND1.
Elim A3;Auto.
Elim COND2.
Elim A1;Elim A6;Auto.
Elim SUM1;Auto.
Save Sum_EliminationD.
 

Goal (d:D)(n:bit)(y:proc)
     <proc>
     (seq
         (ia Frame c2 (Tuple n d))
         (mer
             y
             (seq
                 (alt
                     (seq
                         (ia one int i)
                         (ia Frame s3 (Tuple n d)))   
                     (seq
                         (ia one int i)
                         (ia Frame s3 lce)))   
                 (K i))))=
     (comm (seq (ia Frame s2 (Tuple n d)) y) (K i)).

Intros.
Pattern 2 (K i).
Elim ChanK.
Elim SC3.
Elim SUM7.

ElimType <Frame->proc>
    [d0:Frame]
    (cond
      (seq (ia Frame c2 (Tuple n d))
      (mer y
         (seq
            (alt (seq (ia one int i) (ia Frame s3 (Tuple n d)))
               (seq (ia one int i) (ia Frame s3 lce)))
            (K i))))
       (eqF d0 (Tuple n d))
       Delta)
     =
     [d0:Frame]
     (comm
        (seq (ia Frame r2 d0)
           (seq
              (alt (seq (ia one int i) (ia Frame s3 d0))
                 (seq (ia one int i) (ia Frame s3 lce)))
              (K i)))
        (seq (ia Frame s2 (Tuple n d)) y)).


2:Apply EXT ; Intro.
2:Elim CM7.
2:Elim (Bak4_2_1
       (eqF d0 (Tuple n d))  
       (seq (comm (ia Frame r2 d0) (ia Frame s2 (Tuple n d)))
        (mer
         (seq
            (alt (seq (ia one int i) (ia Frame s3 d0))
               (seq (ia one int i) (ia Frame s3 lce)))
            (K i))
         y))
       ).
2:Elim (Def4_3_1_2' 
         (eqF d0 (Tuple n d))
         Delta
         (seq (comm (ia Frame r2 d0) (ia Frame s2 (Tuple n d)))
         (mer
            (seq
               (alt (seq (ia one int i) (ia Frame s3 d0))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i))
            y))
         (seq (comm (ia Frame r2 d0) (ia Frame s2 (Tuple n d)))
         (mer
            (seq
               (alt (seq (ia one int i) (ia Frame s3 d0))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i))
            y))).
2:Elim (Def4_3_1_2
          (eqF d0 (Tuple n d))
          (seq (ia Frame c2 (Tuple n d))
         (mer y
            (seq
               (alt (seq (ia one int i) (ia Frame s3 (Tuple n d)))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i))))
           (seq (comm (ia Frame r2 d0) (ia Frame s2 (Tuple n d)))
         (mer
            (seq
               (alt (seq (ia one int i) (ia Frame s3 d0))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i))
            y))
         Delta).
2:Apply refl_equal.
2:Intros.
2:Elim (eqF_intro d0 (Tuple n d)).
3:Assumption.
2:Elim CF1.
2:Unfold gamma.
2:Elim SC6.
2:Apply refl_equal.

2:Intro.
2:Elim CF2'.
2:Elim A7.
2:Apply refl_equal.

2:Apply eqF_intro'.
2:Assumption.
Elim (Sum_EliminationF
          [d':Frame]
          (seq (ia Frame c2 d')
           (mer y
              (seq
                 (alt (seq (ia one int i) (ia Frame s3 d'))
                    (seq (ia one int i) (ia Frame s3 lce)))
                 (K i))))
          (Tuple n d)).
Apply refl_equal.
Save comms2K.


Goal (d:D)(n:bit)(y,x:proc)
     <proc>
     (seq
         (ia Frame c2 (Tuple n d))
         (enc H
          (mer
           (mer
             y
             (seq
                 (alt
                     (seq
                         (ia one int i)
                         (ia Frame s3 (Tuple n d)))
                     (seq
                         (ia one int i)
                         (ia Frame s3 lce)))
                 (K i)))
          x)))=
     (enc H (Lmer (comm (seq (ia Frame s2 (Tuple n d)) y) (K i)) x)).

Intros.
Elim comms2K.
Elim CM3.
Elim D5.
Elim D1.
Apply refl_equal.
Exact Inc2H.
Save Comms2K.

Goal (d:D)(n,n':bit)(y,y':proc)
     <proc> Delta=
     (comm (seq (ia Frame s2 (Tuple n d)) y) (seq (Rn n') y')).
Intros.
Elim ProcRn.
Elim (A4 
        (seq
               (alt (D+[d:D](ia Frame r3 (Tuple n' d))) (ia Frame r3 lce))
               (seq (ia frame s5 (tuple n')) (Rn n')))
        (D+[d:D]
              (seq (ia Frame r3 (Tuple (toggle n') d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle n'))))))
       y').
Elim CM9.
Elim (A4 (D+[d:D](ia Frame r3 (Tuple n' d)))
                  (ia Frame r3 lce) (seq (ia frame s5 (tuple n')) (Rn n'))).
Elim (A4 (seq (D+[d:D](ia Frame r3 (Tuple n' d)))
                  (seq (ia frame s5 (tuple n')) (Rn n')))
               (seq (ia Frame r3 lce)
                  (seq (ia frame s5 (tuple n')) (Rn n')))
               y').           
Elim (CM9 
       (seq (ia Frame s2 (Tuple n d)) y)
             (seq
               (seq (D+[d:D](ia Frame r3 (Tuple n' d)))
                  (seq (ia frame s5 (tuple n')) (Rn n')))
               y')
       (seq
               (seq (ia Frame r3 lce)
                  (seq (ia frame s5 (tuple n')) (Rn n')))
               y')).

ElimType <proc>Delta=
       (comm (seq (ia Frame s2 (Tuple n d)) y)
         (seq
            (D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle n') d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle n'))))))
             y')).


ElimType <proc>Delta=
 (comm (seq (ia Frame s2 (Tuple n d)) y)
            (seq
               (seq (ia Frame r3 lce)
                  (seq (ia frame s5 (tuple n')) (Rn n')))
               y')).

Repeat Elim A6.
Elim (A5 (D+[d:D](ia Frame r3 (Tuple n' d)))
             (seq (ia frame s5 (tuple n')) (Rn n'))
                y').
Elim SC3.

Elim (SUM5 D 
        [d:D](ia Frame r3 (Tuple n' d))
        (seq (seq (ia frame s5 (tuple n')) (Rn n')) y')).
Elim SUM7.
ElimType <D->proc>[d0:D]Delta=
     [d0:D]
     (comm
        (seq (ia Frame r3 (Tuple n' d0))
           (seq (seq (ia frame s5 (tuple n')) (Rn n')) y'))
        (seq (ia Frame s2 (Tuple n d)) y)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.
Elim A5.
Elim CM7.
Elim CF2.
Elim A7. 
Apply refl_equal. 
Apply refl_equal. 
Elim SC3.
Elim (SUM5 D [d:D]
           (seq (ia Frame r3 (Tuple (toggle n') d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle n')))))
       y').
Elim SUM7.
ElimType  <D->proc>[d0:D]Delta= 
     [d0:D]
     (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle n') d0))
              (seq (ia D s4 d0) (ia frame s5 (tuple (toggle n')))))
           y')
        (seq (ia Frame s2 (Tuple n d)) y)).

Elim SUM1 ; Apply refl_equal. 
Apply EXT ; Intro. 
Elim A5.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.

Save comms2Rn.

Goal (n,n':bit)(d:D)(x,y,y':proc)<proc>Delta=
   (enc H (Lmer  (comm (seq (ia Frame s2 (Tuple n d)) y) (seq (Rn n') y')) x)).
Intros.
Elim comms2Rn.
Unfold Delta.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal.

Save Comms2Rn.

Goal (d:D)(n:bit)(y:proc)
     <proc> Delta=
     (comm (seq (ia Frame s2 (Tuple n d)) y) (L i)).
Intros.
Elim ChanL.
Elim SC3.
Elim SUM7.
ElimType <frame->proc> [d0:frame]Delta=
     [d0:frame]
     (comm
        (seq (ia frame r5 d0)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d0))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (ia Frame s2 (Tuple n d)) y)).
Elim SUM1.
Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Red.
Intro.
Apply EQFf.
Apply EQ_sym.
Assumption.
Save comms2L.

Goal (d:D)(n:bit)(x,y:proc)
     <proc> Delta=
     (enc H (Lmer (comm (seq (ia Frame s2 (Tuple n d)) y) (L i)) x)).
Intros.
Elim comms2L.
Unfold Delta.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal.
Save Comms2L.

Goal (x,y,y':proc)<proc>Delta=
     (enc H 
        (Lmer 
           (comm 
              (alt (seq (ia one int i) y) (seq (ia one int i) y'))
              (L i))
           x)).
Intros.
Elim SC3.
Elim CM9.
Elim ChanL.
ElimType <proc>Delta=
      (comm
               (frame
               +[n:frame]
                 (seq (ia frame r5 n)
                    (seq
                       (alt (seq (ia one int i) (ia frame s6 n))
                          (seq (ia one int i) (ia frame s6 sce)))
                       (L i))))
                (seq (ia one int i) y')).

ElimType <proc>Delta= 
            (comm
               (frame
               +[n:frame]
                 (seq (ia frame r5 n)
                    (seq
                       (alt (seq (ia one int i) (ia frame s6 n))
                          (seq (ia one int i) (ia frame s6 sce)))
                       (L i))))
                (seq (ia one int i) y)) .
Elim A6.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Elim SUM7.
ElimType <frame->proc>[d:frame]Delta=
   [d:frame]
     (comm
        (seq (ia frame r5 d)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (ia one int i) y)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQfi.
Elim SUM7.
ElimType <frame->proc>[d:frame]Delta= 
     [d:frame]
     (comm
        (seq (ia frame r5 d)
           (seq
              (alt (seq (ia one int i) (ia frame s6 d))
                 (seq (ia one int i) (ia frame s6 sce)))
              (L i)))
        (seq (ia one int i) y')).

Elim SUM1 ; Apply refl_equal. 
Apply EXT ; Intro.
Elim CM7.
Elim CF2''. 
Elim A7.
Apply refl_equal. 
Exact EQfi.

Save CommiL.

Goal
    (x,y,y':proc)<proc>Delta=
     (enc H
        (Lmer
           (comm
              (alt (seq (ia one int i) y) (seq (ia one int i) y'))
              (K i))
           x)).
Intros.
Elim SC3.
Elim ChanK.
Elim (SUM7 Frame
             [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
             (alt (seq (ia one int i) y) (seq (ia one int i) y'))).
ElimType <Frame->proc>[d:Frame]Delta=
      [d:Frame]
           (comm
              (seq (ia Frame r2 d)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (alt (seq (ia one int i) y) (seq (ia one int i) y'))).
Elim SUM1.
Unfold 2 Delta.
Elim CM2.
Elim D5. Elim D3.
Elim A7. Apply refl_equal.
Apply EXT. Intro.
Elim A4.
Elim CM9.
Elim CM7.
Elim CM7.
Elim CF2''.
Elim A7.
Elim A7.
Elim A6.
Apply refl_equal.
Exact EQFi.

Save CommiK.



Goal (x,y,y':proc)(b:bit)
     <proc>Delta= 
     (enc H 
        (Lmer 
           (comm 
              (seq (ia one int i) y)
              (seq (Rn b) y'))
           x)).   
Intros.
Elim SC3.
Elim ProcRn.
ElimType <proc>Delta=
      (comm
               (seq
                  (alt
                     (seq
                        (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                           (ia Frame r3 lce))
                        (seq (ia frame s5 (tuple b)) (Rn b)))
                     (D
                     +[d:D]
                       (seq (ia Frame r3 (Tuple (toggle b) d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b))))))
                     )
                  y')
               (seq (ia one int i) y)).

Unfold Delta.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal. 

Elim (A4 (seq
               (alt (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce))
               (seq (ia frame s5 (tuple b)) (Rn b)))
         (D +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
         y').
Elim CM8.
ElimType <proc>Delta=
       (comm
         (seq
            (D
            +[d:D]
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))))
             y')
         (seq (ia one int i) y)).
Elim A6.
Elim (A5 (alt (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce))
         (seq (ia frame s5 (tuple b)) (Rn b))
         y').
Elim (A4  (D+[d:D](ia Frame r3 (Tuple b d)))
          (ia Frame r3 lce)
          (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim CM8.
ElimType <proc>Delta=
         (comm
         (seq (ia Frame r3 lce)
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia one int i) y)).
Elim A6.
Elim (SUM5 D [d:D](ia Frame r3 (Tuple b d))
          (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
        [d:D]
     (comm
        (seq (ia Frame r3 (Tuple b d))
           (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
        (seq (ia one int i) y)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFi.
Elim CM7.
Elim CF2''.
Elim A7. 
Apply refl_equal.
Exact EQFi. 
Elim (SUM5 D [d:D]
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))) y').
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
            [d:D]
     (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
           y')
        (seq (ia one int i) y)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim A5.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFi.
Save commiRn.

Goal (x,y,y',y'':proc)(b:bit)
     <proc>Delta= 
     (enc H 
        (Lmer 
           (comm 
              (alt (seq (ia one int i) y) (seq (ia one int i) y'))
              (seq (Rn b) y''))
           x)).   
Intros.
Elim CM8.
Elim CM4.
Elim D4.
Elim commiRn.
Elim commiRn.
Elim A6.
Apply refl_equal.
Save CommiRn.

Goal (x,y:proc)(b:bit)(d:D)
     <proc>Delta=
     (enc H  
        (Lmer  
           (comm  
              (seq (Tn_d d b) y)
              (L i))
           x)).
Intros.
Elim ProcTn_d.
Elim ChanL.
Elim A4.
Elim (SC3 (alt
               (seq
                  (seq
                     (alt (ia frame r6 (tuple (toggle b)))
                        (ia frame r6 sce))
                     (Sn_d d b))
                  y)
               (seq (ia frame r6 (tuple b)) y))
           (frame
            +[n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i))))).
Elim (SUM7 frame 
          [n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              
            (alt
               (seq
                  (seq
                     (alt (ia frame r6 (tuple (toggle b)))
                        (ia frame r6 sce))
                     (Sn_d d b))
                  y)
               (seq (ia frame r6 (tuple b)) y))).
Elim (SUM6 frame 
           [d0:frame]
           (comm
              (seq (ia frame r5 d0)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d0))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (alt
                 (seq
                    (seq
                       (alt (ia frame r6 (tuple (toggle b)))
                          (ia frame r6 sce))
                       (Sn_d d b))
                    y)
                 (seq (ia frame r6 (tuple b)) y)))
              x).
Elim SUM9.
ElimType <frame->proc>[d:frame]Delta=
     [d0:frame]
     (enc H
        (Lmer
           (comm
              (seq (ia frame r5 d0)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d0))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (alt
                 (seq
                    (seq
                       (alt (ia frame r6 (tuple (toggle b)))
                          (ia frame r6 sce))
                       (Sn_d d b))
                    y)
                 (seq (ia frame r6 (tuple b)) y)))
           x)).
Elim SUM1 ; Apply refl_equal.
Apply EXT ; Intro.
Elim CM9.
Elim A5.
Elim A4.
Elim A4.
Elim CM9.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF2.
Elim CF2.
Elim CF2.
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply refl_equal.
Apply refl_equal.
Apply refl_equal.
Save CommTn_dL.


Goal (x,y,y':proc)(b:bit)(d:D)
     <proc>Delta=
     (enc H   
        (Lmer 
           (comm
              (seq (Tn_d d b) y)
              (seq (ia one int i) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim CM8.
Elim A5.
Elim A4.
Elim CM8.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF2''.
Elim CF2''.
Elim CF2''.
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Exact EQfi.
Exact EQfi.
Exact EQfi.
Save commTn_di1.

Goal (x,y,y',y'':proc)(b:bit)(d:D)
     <proc>Delta= 
     (enc H     
        (Lmer   
           (comm  
              (seq (Tn_d d b) y)
              (alt (seq (ia one int i) y') (seq (ia one int i) y'')))
           x)). 
Intros.
Elim CM9.
Elim CM4.
Elim D4.
Elim commTn_di1.
Elim commTn_di1.
Elim A6.
Apply refl_equal.
Save CommTn_di. 

Goal
    (x,y:proc)(b:bit)(d:D)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (Sn_d d b) y)
              (L i))
           x)).
Intros.
Elim ProcSn_d.
Elim A5.
Elim SC3.
Elim ChanL.
Elim (SUM7 frame [n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
             (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))).
ElimType <frame->proc>[d:frame]Delta=
   [d0:frame]
           (comm
              (seq (ia frame r5 d0)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d0))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))).
Elim SUM1.
Unfold 2 Delta.
Elim CM2.
Elim D5. Elim D3.
Elim A7. Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Red. Intro.
Apply EQFf.
Apply EQ_sym.
Assumption.
Save CommSn_dL.

Goal
 (x,y:proc)(b:bit)(d:D) <proc>
   (seq (ia Frame c2 (Tuple b d))
      (enc H (mer (seq (Tn_d d b) y)  
               (mer 
                 (alt (seq (ia one int i) (seq (ia Frame s3 (Tuple b d))(K i)))
                     (seq (ia one int i) (seq (ia Frame s3 lce)(K i))))
                 x))))=
   (enc H (Lmer (comm (seq (Sn_d d b) y) (K i)) x)).
Intros.
Elim ProcSn_d.
Elim A5.
Pattern 3 (K i).
Elim ChanK.
Elim (SC3 (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))
            (Frame
            +[x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i))))).
Elim (SUM7 Frame [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
             (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))).
ElimType <proc>(Frame+[d0:Frame]
       (cond
          (comm
              (seq (ia Frame r2 (Tuple b d))
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 (Tuple b d)))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))
         (eqF d0 (Tuple b d)) Delta)) =
        (Frame+[d0:Frame]
          (comm
              (seq (ia Frame r2 d0)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d0))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))).
Elim (Sum_EliminationF [d0:Frame]
              (comm
                 (seq (ia Frame r2 d0)
                    (seq
                       (alt (seq (ia one int i) (ia Frame s3 d0))
                          (seq (ia one int i) (ia Frame s3 lce)))
                       (K i)))
                 (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))
          (Tuple b d)).
Elim CM7;Elim CF1.
Elim CM3;Elim D5.
Elim A4.
Elim A5.
Elim A5.
Elim (SC6 (seq (Tn_d d b) y)
(alt
                  (seq (ia one int i)
                     (seq (ia Frame s3 (Tuple b d)) (K i)))
                  (seq (ia one int i) (seq (ia Frame s3 lce) (K i))))).
Elim SC7.
Unfold gamma; Trivial.
Elim D1.
Trivial.
Exact Inc2H.
ElimType <Frame->proc>
[d0:Frame]
      (cond
         (comm
            (seq (ia Frame r2 (Tuple b d))
               (seq
                  (alt (seq (ia one int i) (ia Frame s3 (Tuple b d)))
                     (seq (ia one int i) (ia Frame s3 lce)))
                  (K i)))
            (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))
         (eqF d0 (Tuple b d)) Delta)
=
[d0:Frame]
      (comm
         (seq (ia Frame r2 d0)
            (seq
               (alt (seq (ia one int i) (ia Frame s3 d0))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i)))
         (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))).
Trivial.
Apply EXT;Intros.
Cut ((<bool>true=(eqF d0 (Tuple b d))) \/ (<bool>false=(eqF d0 (Tuple b d)))).
Cut (<bool>true=(eqF d0 (Tuple b d)))->
 <proc
  >(cond
      (comm
         (seq (ia Frame r2 (Tuple b d))
            (seq
               (alt (seq (ia one int i) (ia Frame s3 (Tuple b d)))
                  (seq (ia one int i) (ia Frame s3 lce)))
               (K i)))
         (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))
      (eqF d0 (Tuple b d)) Delta)
  =(comm
      (seq (ia Frame r2 d0)
         (seq
            (alt (seq (ia one int i) (ia Frame s3 d0))
               (seq (ia one int i) (ia Frame s3 lce)))
            (K i)))
      (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))).
Cut (<bool>false=(eqF d0 (Tuple b d)))->
 <proc
  >(cond 
      (comm 
         (seq (ia Frame r2 (Tuple b d)) 
            (seq 
               (alt (seq (ia one int i) (ia Frame s3 (Tuple b d))) 
                  (seq (ia one int i) (ia Frame s3 lce))) 
               (K i))) 
         (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))) 
      (eqF d0 (Tuple b d)) Delta) 
  =(comm 
      (seq (ia Frame r2 d0) 
         (seq 
            (alt (seq (ia one int i) (ia Frame s3 d0)) 
               (seq (ia one int i) (ia Frame s3 lce))) 
            (K i))) 
      (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))). 
Intros.
Exact (or_ind
(<bool>true=(eqF d0 (Tuple b d)))
(<bool>false=(eqF d0 (Tuple b d)))
 <proc
  >(cond 
      (comm 
         (seq (ia Frame r2 (Tuple b d)) 
            (seq 
               (alt (seq (ia one int i) (ia Frame s3 (Tuple b d))) 
                  (seq (ia one int i) (ia Frame s3 lce))) 
               (K i))) 
         (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y))) 
      (eqF d0 (Tuple b d)) Delta) 
  =(comm 
      (seq (ia Frame r2 d0) 
         (seq 
            (alt (seq (ia one int i) (ia Frame s3 d0)) 
               (seq (ia one int i) (ia Frame s3 lce))) 
            (K i))) 
      (seq (ia Frame s2 (Tuple b d)) (seq (Tn_d d b) y)))
H0 H H1).
Intro.
Elim H.
Elim COND2.
Elim CM7.
Elim CF2'.
Elim A7.
Trivial.
Exact (eqF_intro' d0 (Tuple b d) H).
Intro.
Elim  (eqF_intro d0 (Tuple b d) H).
Elim eqF7;Elim COND1.
Trivial.
Apply Lemma4.
Save CommSn_dK.

Goal
    (x,y,y':proc)(b,b':bit)(d:D)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (Sn_d d b) y)
              (seq (Rn b') y'))
           x)).
Intros.
Elim SC3.
Elim ProcRn.
Elim (A4 (seq (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b')) (Rn b')))
                  (D+[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b') d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b')))))) y').
Elim (CM8 (seq (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b')) (Rn b')))
                  y')
               (seq
                  (D+[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b') d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b'))))))
                   y') (seq (Sn_d d b) y)).
ElimType <proc>Delta=
      (comm (seq (seq (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b')) (Rn b')))
                  y')
               (seq (Sn_d d b) y)).
Elim (A6'  (comm
               (seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b') d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b'))))))
                   y')
               (seq (Sn_d d b) y))).
Elim (SUM5 D [d:D]
                 (seq (ia Frame r3 (Tuple (toggle b') d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b'))))) y').
Elim (SUM7 D [d:D]
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b') d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b')))))
                 y') (seq (Sn_d d b) y)).

ElimType <D->proc>[d:D]Delta=
      [d0:D]
           (comm
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b') d0))
                    (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b')))))
                 y') (seq (Sn_d d b) y)).
Elim SUM1.
Unfold 2 Delta.
Elim CM2. Elim D5. Elim D3. Elim A7. Apply refl_equal.
Apply EXT. Intro.
Elim A5.
Elim ProcSn_d.
Elim A5.
Elim A5.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b' d))) (ia Frame r3 lce)
            (seq (ia frame s5 (tuple b')) (Rn b'))). 
Elim (A4 (seq (D+[d:D](ia Frame r3 (Tuple b' d)))
               (seq (ia frame s5 (tuple b')) (Rn b')))
            (seq (ia Frame r3 lce)
               (seq (ia frame s5 (tuple b')) (Rn b'))) y').
Elim CM8.
ElimType <proc>Delta=
     (comm
         (seq
            (seq (D+[d:D](ia Frame r3 (Tuple b' d)))
               (seq (ia frame s5 (tuple b')) (Rn b')))
            y') (seq (Sn_d d b) y)).
Elim A6'.
Elim A5.
Elim ProcSn_d.
Elim A5.
Elim A5.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.
Elim (A5 (D+[d:D](ia Frame r3 (Tuple b' d)))
            (seq (ia frame s5 (tuple b')) (Rn b')) y').
Elim (SUM5 D [d:D](ia Frame r3 (Tuple b' d)) (seq (seq (ia frame s5
(tuple b')) (Rn b')) y')).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
      [d0:D]
      (comm
         (seq (ia Frame r3 (Tuple b' d0))
            (seq (seq (ia frame s5 (tuple b')) (Rn b')) y'))
         (seq (Sn_d d b) y)).
Elim SUM1. Apply refl_equal.
Apply EXT. Intro.
Elim ProcSn_d.
Elim A5.
Elim A5.
Elim CM7.
Elim CF2.
Elim A7.
Apply refl_equal.
Apply refl_equal.
Save CommSn_dRn.

Goal
   (x,y,y':proc)(b:bit)(d:D)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (ia D s4 d) y)
              (seq (Tn_d d b) y'))
           x)).
Intros.
Elim SC3.
Elim ProcTn_d.
Elim A4.
Elim A4. 
Elim A4. 
Elim CM8. 
Elim CM8. 
Elim A5. 
Elim A5. 
Elim CM7. 
Elim CM7. 
Elim CM7. 
Elim CF2''. 
Elim CF2''. 
Elim CF2''. 
  
Elim A7. 
Elim A7. 
Elim A6. 
Elim A6. 
Unfold 2 Delta. 
Elim CM2. 
Elim D5. 
Elim D3. 
Elim A7. 
Apply refl_equal.
Exact EQfD.
Exact EQfD.
Exact EQfD.


Save CommTn_ds4.

Goal
   (x,y,y':proc)(b:bit)(d:D)(f:frame)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (ia frame s5 f) y)
              (seq (Tn_d d b) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Elim CM9.
Elim CM9.
Elim A5.
Elim A5.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF2.
Elim CF2.
Elim CF2.
 
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Unfold 2 Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.

Apply refl_equal.
Apply refl_equal.
Apply refl_equal.
Apply refl_equal.

Save CommTn_ds5.

Goal (x,y:proc)(b:bit)(d:D)
     <proc>Delta=
     (enc H (Lmer (comm (K i) (seq (Tn_d d b) y)) x)).

Intros.
Elim ChanK.
Elim (SUM7 Frame
             [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
             (seq (Tn_d d b) y)).
ElimType <Frame->proc>[f:Frame]Delta=
       [d0:Frame]
           (comm
              (seq (ia Frame r2 d0)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d0))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (Tn_d d b) y)).
Elim SUM1.
Unfold Delta.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Apply EXT.
Intro.
Elim CM9.
Elim CM9.
Elim A5.
Elim A5.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF2''.
Elim CF2''.
Elim CF2''.

Elim A7.
Elim A7.
Elim A6.
Elim A6.
Apply refl_equal.
Exact EQFf.
Exact EQFf.
Exact EQFf.
Save CommTn_dK.

Goal 
   (x,y:proc)(d:D)
     <proc>Delta= 
     (enc H 
        (Lmer 
           (comm (seq (ia D s4 d) y) (L i)) 
           x)). 
Intros.
Elim SC3.
Elim ChanL.
Elim (SUM7 frame
             [n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
             (seq (ia D s4 d) y)).
ElimType <frame->proc>[d:frame]Delta=
    [d0:frame]
           (comm
              (seq (ia frame r5 d0)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d0))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia D s4 d) y)).
Elim SUM1.
Unfold Delta.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQfD.
Save CommLs4.

Goal
   (x,y:proc)(f:frame) <proc>
     (seq (ia frame c5 f)
        (enc H
           (mer y
              (mer
                 (alt
                    (seq (ia one int i) (seq (ia frame s6 f) (L i)))
                    (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
                 x))))=
     (enc H (Lmer (comm (seq (ia frame s5 f) y) (L i)) x)).
Intros.
Pattern 3 (L i).
Elim ChanL.
Elim (SC3
(seq (ia frame s5 f) y)
(frame
                +[n:frame]
                  (seq (ia frame r5 n)
                     (seq
                        (alt (seq (ia one int i) (ia frame s6 n))
                           (seq (ia one int i) (ia frame s6 sce)))
                        (L i))))
                ).
Elim (SUM7
frame
             [n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
             (seq (ia frame s5 f) y)).
ElimType <frame->proc>
[d:frame]
(cond      (comm
              (seq (ia frame r5 f)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 f))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia frame s5 f) y))
(eqf d f)
          Delta)
=
[d:frame]
           (comm
              (seq (ia frame r5 d)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia frame s5 f) y)).
Elim (Sum_Eliminationf
[e:frame](comm
              (seq (ia frame r5 e)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 e))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia frame s5 e) y))
f).
Elim CM7.
Elim CF1.
Unfold gamma.
Elim CM3.
Elim A4.
Elim (SC6 y
(alt (seq (seq (ia one int i) (ia frame s6 f)) (L i))
                  (seq (seq (ia one int i) (ia frame s6 sce)) (L i)))).
Elim SC7.
Elim D5.
Elim D1.
Elim A5;Elim A5.
Trivial.
Exact Inc5H.
Apply EXT;Intro.
Cut ((<bool>true=(eqf d f))\/(<bool>false=(eqf d f))).
Cut (<bool>true=(eqf d f))->
<proc>(cond
      (comm
         (seq (ia frame r5 f)
            (seq
               (alt (seq (ia one int i) (ia frame s6 f))
                  (seq (ia one int i) (ia frame s6 sce)))
               (L i)))
         (seq (ia frame s5 f) y))
      (eqf d f) Delta)
  =(comm
      (seq (ia frame r5 d)
         (seq
            (alt (seq (ia one int i) (ia frame s6 d))
               (seq (ia one int i) (ia frame s6 sce)))
            (L i)))
      (seq (ia frame s5 f) y)).
Cut (<bool>false=(eqf d f))->
<proc>(cond
      (comm
         (seq (ia frame r5 f)
            (seq
               (alt (seq (ia one int i) (ia frame s6 f))
                  (seq (ia one int i) (ia frame s6 sce)))
               (L i)))
         (seq (ia frame s5 f) y))
      (eqf d f) Delta)
  =(comm
      (seq (ia frame r5 d)
         (seq
            (alt (seq (ia one int i) (ia frame s6 d))
               (seq (ia one int i) (ia frame s6 sce)))
            (L i)))
      (seq (ia frame s5 f) y)).
Intros.
Exact (or_ind
(<bool>true=(eqf d f))
(<bool>false=(eqf d f))
<proc>(cond
      (comm
         (seq (ia frame r5 f)
            (seq
               (alt (seq (ia one int i) (ia frame s6 f))
                  (seq (ia one int i) (ia frame s6 sce)))
               (L i)))
         (seq (ia frame s5 f) y))
      (eqf d f) Delta)
  =(comm
      (seq (ia frame r5 d)
         (seq
            (alt (seq (ia one int i) (ia frame s6 d))
               (seq (ia one int i) (ia frame s6 sce)))
            (L i)))
      (seq (ia frame s5 f) y))
H0 H H1).
Intro.
Elim H;Elim COND2.
Elim CM7;Elim CF2'.
Elim A7;Trivial.
Exact (eqf_intro' d f H).
2:Apply Lemma4.
Intros.
Elim H.
Elim COND1.
Elim (eqf_intro d f H).
Trivial.
Save CommLs5.


Goal
   (x,y:proc)(f:frame)
     <proc>Delta=
     (enc H
        (Lmer
           (comm (seq (ia frame s6 f) y) (K i))
           x)).
Intros.
Elim SC3.
Elim ChanK.
Elim (SUM7 Frame 
            [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
             (seq (ia frame s6 f) y)).
ElimType <Frame->proc>[d:Frame]Delta=
     [d:Frame]
           (comm
              (seq (ia Frame r2 d)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (ia frame s6 f) y)).
Elim SUM1.
Unfold Delta.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.


Save CommKs6.


Goal
   (x,y,y':proc)(b:bit)(f:frame)
     <proc>Delta=
     (enc H
        (Lmer
           (comm (seq (ia frame s6 f) y) (seq (Rn b) y'))
           x)).
Intros.
Elim SC3.
Elim ProcRn.
Elim (A4 (seq (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  (D +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                  y').
Elim (CM8 (seq (seq (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')
            (seq (D +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y')(seq (ia frame s6 f) y)).

ElimType <proc>Delta=
            (comm
               (seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y')
               (seq (ia frame s6 f) y)).

Elim (A6 (comm
               (seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')
               (seq (ia frame s6 f) y))).
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b d)))
                     (ia Frame r3 lce) (seq (ia frame s5 (tuple b)) (Rn b))).

Elim (A4 (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  (seq (ia Frame r3 lce)
                     (seq (ia frame s5 (tuple b)) (Rn b))) y').
Elim (CM8 (seq (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')
               (seq
                  (seq (ia Frame r3 lce)
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y') (seq (ia frame s6 f) y)).

ElimType <proc>Delta=
       (comm (seq (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')
               (seq (ia frame s6 f) y)).
Elim A6'.
Elim A5.
Elim CM7.
Elim CF2''.
Elim A7.
Unfold 2 Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Exact EQFf.
Elim (A5 (D+[d:D](ia Frame r3 (Tuple b d)))
            (seq (ia frame s5 (tuple b)) (Rn b)) y').
Elim (SUM5 D [d:D](ia Frame r3 (Tuple b d))
         (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
     [d:D]
      (comm
         (seq (ia Frame r3 (Tuple b d))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia frame s6 f) y)).
Elim SUM1.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.
Elim (SUM5 D [d:D]
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))) y').
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
      [d:D]
      (comm
         (seq
            (seq (ia Frame r3 (Tuple (toggle b) d))
               (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
            y')
         (seq (ia frame s6 f) y)).
Elim SUM1.
Apply refl_equal. 
Apply EXT. Intro. 
Elim A5.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.
Save CommRns6.

Goal
   (x,y,y':proc)(b:bit)(d:D)
     <proc>
     (seq (ia frame c6 sce) (enc H (mer y (mer (seq (Sn_d d b) y') x))))=
     (enc H
        (Lmer
           (comm (seq (ia frame s6 sce) y) (seq (Tn_d d b) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Elim CM9.
Elim CM9.
Elim A5.
Elim A5.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF1.
Elim CF2'.
Elim CF2'.
Elim A7.
Elim A7.
Elim A6.
Elim A6'.
Elim CM3.
Elim D5.
Elim D1.
Elim SC7.
Apply refl_equal.
Exact Inc6H.
Apply eqf_intro'.
Apply eqf2.
Apply eqf_intro'.
Apply eqf2.
Save CommTn_ds6_sce.

Goal
   (x,y,y':proc)(b:bit)(d:D)
     <proc>
     (seq (ia frame c6 (tuple (toggle b))) 
        (enc H (mer y (mer (seq (Sn_d d b) y') x))))=
     (enc H
        (Lmer
           (comm (seq (ia frame s6 (tuple (toggle b))) y) (seq (Tn_d d b) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Elim CM9.
Elim CM9.
Elim A5.
Elim A5.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF1.
Elim CF2'.
Elim CF2'.
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Elim CM3.
Elim D5.
Elim D1.
Elim SC7.
Apply refl_equal.
Exact Inc6H.
Apply eqf_intro'.
Elim eqf4.
Apply bit3.
Apply eqf_intro'.
Apply eqf3.

Save CommTn_ds6_b.

Goal
   (x,y,y':proc)(b:bit)(d:D)
     <proc>
     (seq (ia frame c6 (tuple b))
        (enc H (mer y (mer y' x))))=
     (enc H
        (Lmer
           (comm (seq (ia frame s6 (tuple b)) y) (seq (Tn_d d b) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim A4.
Elim A4.
Elim CM9.
Elim CM9.
Elim A5.
Elim A5.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF1.
Elim CF2'.
Elim CF2'.
Elim A7.
Elim A6'.
Elim A6'.
Elim CM3.
Elim D5.
Elim D1.
Elim SC7.
Apply refl_equal.
Exact Inc6H.
Apply eqf_intro'.
Apply eqf3.
Apply eqf_intro'.
Elim eqf4.
Apply bit2.
Save CommTn_ds6_b'.

Goal (x,y:proc)(d:D) 
     <proc>Delta=  
     (enc H     
        (Lmer  
           (comm (K i) (seq (ia D s4 d) y)) 
           x)).   
Intros.
Elim ChanK.
Elim (SUM7 Frame [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))  (seq (ia D s4 d) y)).
ElimType <Frame->proc>[d:Frame]Delta=
     [d0:Frame]
           (comm
              (seq (ia Frame r2 d0)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d0))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (ia D s4 d) y)).
Elim SUM1. 
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFD.
Save CommKs4.

Goal (x,y:proc)(f:frame) <proc>Delta=
     (enc H (Lmer (comm (K i) (seq (ia frame s5 f) y)) x)).
Intros.
Elim ChanK.
Elim (SUM7 Frame [x:Frame]
              (seq (ia Frame r2 x)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 x))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
             (seq (ia frame s5 f) y)).
ElimType <Frame->proc>[f:Frame]Delta=
    [d:Frame]
           (comm
              (seq (ia Frame r2 d)
                 (seq
                    (alt (seq (ia one int i) (ia Frame s3 d))
                       (seq (ia one int i) (ia Frame s3 lce)))
                    (K i)))
              (seq (ia frame s5 f) y)).
Elim SUM1.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Exact EQFf.
Save CommKs5.

Goal (x,y,y':proc)(b,b':bit)(d:D)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (Tn_d d b) y)
              (seq (Rn b') y'))
           x)).
Intros.
Elim ProcTn_d; Elim ProcRn.
Elim A4.
Elim (CM8 (seq
                  (seq
                     (alt (ia frame r6 (tuple (toggle b)))
                        (ia frame r6 sce))
                     (Sn_d d b))
                  y)
               (seq (ia frame r6 (tuple b)) y)
(seq
               (alt
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b')) (Rn b')))
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b') d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b'))))))
                  )
               y')).
Elim A5.
Elim A4.
Elim (CM8 
(seq (ia frame r6 (tuple (toggle b)))(seq (Sn_d d b) y))
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
(seq
                  (alt
                     (seq
                        (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                           (ia Frame r3 lce))
                        (seq (ia frame s5 (tuple b')) (Rn b')))
                     (D
                     +[d:D]
                       (seq (ia Frame r3 (Tuple (toggle b') d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b'))))))
                     )
                  y')).
Elim (A4 
(seq
                           (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                              (ia Frame r3 lce))
                           (seq (ia frame s5 (tuple b')) (Rn b')))
(D +[d:D]

                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b')))))
                        )
                     y').
Elim (CM9
(seq (ia frame r6 (tuple (toggle b)))
                     (seq (Sn_d d b) y))
(seq
                        (seq
                           (alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                              (ia Frame r3 lce))
                           (seq (ia frame s5 (tuple b')) (Rn b')))
                        y')
(seq
                        (D
                        +[d:D]
                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b'))))))
                         y')).
Elim (A5
(alt (D+[d:D](ia Frame r3 (Tuple b' d)))
                              (ia Frame r3 lce))
(seq (ia frame s5 (tuple b')) (Rn b'))
y').
Elim (A4
(D+[d:D](ia Frame r3 (Tuple b' d)))
(ia Frame r3 lce)
(seq (seq (ia frame s5 (tuple b')) (Rn b')) y')).
Elim (CM9
(seq (ia frame r6 (tuple (toggle b)))
                        (seq (Sn_d d b) y))
(seq (D+[d:D](ia Frame r3 (Tuple b' d)))
                           (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y'))
(seq (ia Frame r3 lce)
                           (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y'))).
Elim (SUM5
D
[d:D](ia Frame r3 (Tuple b' d))
(seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y')).
Elim (SC3
(seq (ia frame r6 (tuple (toggle b)))
                           (seq (Sn_d d b) y))
(D
                        +[d:D]
                          (seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y')))).
Elim (SUM7 D
[d:D](seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y'))
(seq (ia frame r6 (tuple (toggle b)))
                           (seq (Sn_d d b) y))).
Elim CM7.
Cut (d0:D)<proc>Delta=
                       (comm
                          (seq (ia Frame r3 (Tuple b' d0))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y'))
                          (seq (ia frame r6 (tuple (toggle b)))
                             (seq (Sn_d d b) y))).
2:Intro.
2:Elim (CM7 
(seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y')
(seq (Sn_d d b) y)
Frame
frame
(Tuple b' d0)
(tuple (toggle b))
r3
r6).
2:Elim (CF2'' r3 r6 Frame frame (Tuple b' d0) (tuple (toggle b)) EQFf).
2:Elim A7;Auto.
Intros.
Elim (EXT D [d0:D]Delta [d0:D]
                       (comm
                          (seq (ia Frame r3 (Tuple b' d0))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y'))
                          (seq (ia frame r6 (tuple (toggle b)))
                             (seq (Sn_d d b) y))) H0).
Elim SUM1.
Elim (CF2'' r6 r3 frame Frame (tuple (toggle b)) lce).
2:Red.
2:Intro.
2:Apply EQFf.
2:Exact (EQ_sym frame Frame H).
Elim A7.
Elim (A3 Delta).
Elim (A1 
(comm
                     (seq (ia frame r6 (tuple (toggle b)))
                        (seq (Sn_d d b) y))
                     (seq
                        (D
                        +[d:D]
                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b'))))))
                         y'))
Delta).
Elim (A6 (comm
                      (seq (ia frame r6 (tuple (toggle b)))
                         (seq (Sn_d d b) y))
                      (seq
                         (D
                         +[d:D]
                           (seq (ia Frame r3 (Tuple (toggle b') d))
                              (seq (ia D s4 d)
                                 (ia frame s5 (tuple (toggle b'))))))
                          y'))).
Elim (SUM5
D
[d:D]
                       (seq (ia Frame r3 (Tuple (toggle b') d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b')))))
y'
                            ). 
Elim (SC3
(seq (ia frame r6 (tuple (toggle b)))
                     (seq (Sn_d d b) y))
(D+[d:D]
                    (seq
                       (seq (ia Frame r3 (Tuple (toggle b') d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b')))))
                       y'))
).
Elim (SUM7 D
[d:D]
                    (seq
                       (seq (ia Frame r3 (Tuple (toggle b') d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b')))))
                       y')
(seq (ia frame r6 (tuple (toggle b)))
                     (seq (Sn_d d b) y))
).
ElimType <D->proc>[d:D]Delta=
[d0:D]
                 (comm
                    (seq
                       (seq (ia Frame r3 (Tuple (toggle b') d0))
                          (seq (ia D s4 d0)
                             (ia frame s5 (tuple (toggle b')))))
                       y')
                    (seq (ia frame r6 (tuple (toggle b)))
                       (seq (Sn_d d b) y))).
2:Apply EXT;Intro.

2:Elim (A5
(ia Frame r3 (Tuple (toggle b') d0))
(seq (ia D s4 d0)
                             (ia frame s5 (tuple (toggle b'))))
y').
2:Elim CM7.
2:Elim (CF2'' r3 r6 Frame frame (Tuple (toggle b') d0) (tuple (toggle b)) EQFf).2:Elim A7.
Auto.
Elim SUM1.
Elim (CM9
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
                     (alt
                        (D
                        +[d:D]
                          (seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y')))

                        (seq (ia Frame r3 lce)
                           (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y')))
(D +[d:D]
                       (seq
                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b')))))
                          y'))
                     ).
Elim (CM9
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
(D +[d:D]
                          (seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y')))
(seq (ia Frame r3 lce)
                           (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y'))).
Elim (SC3
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
(D
                        +[d:D]
                          (seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y')))).
Elim (SUM7 D
[d:D]
                          (seq (ia Frame r3 (Tuple b' d))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y'))
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
).
ElimType <D->proc>[d:D]Delta=
[d0:D]
                       (comm
                          (seq (ia Frame r3 (Tuple b' d0))
                             (seq
                                (seq (ia frame s5 (tuple b')) (Rn b'))
                                y'))
                          (seq (ia frame r6 sce) (seq (Sn_d d b) y))).
2:Apply EXT;Intro.
2:Elim CM7.
2:Elim (CF2'' r3 r6 Frame frame (Tuple b' d0) sce EQFf).
2:Elim A7.
2:Auto.
Elim (CM7
(seq (Sn_d d b) y)
(seq (seq (ia frame s5 (tuple b')) (Rn b'))
                              y')).
Elim (CF2'' r6 r3).
Elim A7.
Elim (SC3
(seq (ia frame r6 sce) (seq (Sn_d d b) y))
(D+[d:D]
                       (seq
                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b')))))
                          y'))
                     ).
Elim (SUM7 D
[d:D]
                       (seq
                          (seq (ia Frame r3 (Tuple (toggle b') d))
                             (seq (ia D s4 d)
                                (ia frame s5 (tuple (toggle b')))))
                          y')
(seq (ia frame r6 sce) (seq (Sn_d d b) y))).
ElimType <D->proc>[d:D]Delta=
[d0:D]
                    (comm
                       (seq
                          (seq (ia Frame r3 (Tuple (toggle b') d0))
                             (seq (ia D s4 d0)
                                (ia frame s5 (tuple (toggle b')))))
                          y')
                       (seq (ia frame r6 sce) (seq (Sn_d d b) y))).
2:Apply EXT;Intro.
2:Elim A5.
2:Elim CM7.
2:Elim (CF2'' r3 r6 Frame frame (Tuple (toggle b') d0) sce EQFf).
2:Elim A7; Auto.
ElimType <proc>Delta=
(comm (seq (ia frame r6 (tuple b)) y)
               (alt
                  (alt
                     (D
                     +[d:D]
                       (seq (ia Frame r3 (Tuple b' d))
                          (seq (seq (ia frame s5 (tuple b')) (Rn b'))
                             y')))

                     (seq (ia Frame r3 lce)
                        (seq (seq (ia frame s5 (tuple b')) (Rn b')) y')))
                  (D
                  +[d:D]
                    (seq
                       (seq (ia Frame r3 (Tuple (toggle b') d))
                          (seq (ia D s4 d)
                             (ia frame s5 (tuple (toggle b')))))
                       y'))
                  )).
Elim SUM1.
Elim A6.
Elim A6.
Elim A6.
Elim A6.
Unfold Delta.
Elim CM2.
Elim A7.
Elim D3.
Auto.
2:Red.
2:Intro.
2:Apply EQFf.
2:Exact (EQ_sym frame Frame H).
Elim CM9.
ElimType <proc>Delta=
(comm (seq (ia frame r6 (tuple b)) y)
         (alt
            (D
            +[d:D]
              (seq (ia Frame r3 (Tuple b' d))
                 (seq (seq (ia frame s5 (tuple b')) (Rn b')) y')))

            (seq (ia Frame r3 lce)
               (seq (seq (ia frame s5 (tuple b')) (Rn b')) y')))).
ElimType <proc>Delta=
(comm (seq (ia frame r6 (tuple b)) y)
         (D
         +[d:D]
           (seq
              (seq (ia Frame r3 (Tuple (toggle b') d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b')))))
              y'))
         ).
Elim A6;Auto.
Elim SC3.
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
[d:D]
     (comm
        (seq
           (seq (ia Frame r3 (Tuple (toggle b') d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b')))))
           y')
        (seq (ia frame r6 (tuple b)) y)).
Elim SUM1.
Auto.
Apply EXT;Intro.
Elim (A5
(ia Frame r3 (Tuple (toggle b') d0))
(seq (ia D s4 d0) (ia frame s5 (tuple (toggle b'))))
y').
Elim CM7.
Elim CF2''.
Elim A7.
Auto.
Red.
Intro.
Apply EQFf.
Assumption.
Elim (CM9
(seq (ia frame r6 (tuple b)) y)
(D+[d:D]
           (seq (ia Frame r3 (Tuple b' d))
              (seq (seq (ia frame s5 (tuple b')) (Rn b')) y')))

         (seq (ia Frame r3 lce)
            (seq (seq (ia frame s5 (tuple b')) (Rn b')) y'))).
Elim (SC3 (seq (ia frame r6 (tuple b)) y)
(D
         +[d:D]
           (seq (ia Frame r3 (Tuple b' d))
              (seq (seq (ia frame s5 (tuple b')) (Rn b')) y')))).
Elim (SUM7 D
[d:D]
           (seq (ia Frame r3 (Tuple b' d))
              (seq (seq (ia frame s5 (tuple b')) (Rn b')) y'))
          (seq (ia frame r6 (tuple b)) y)).
ElimType <D->proc>[d:D]Delta=
[d:D]
        (comm
           (seq (ia Frame r3 (Tuple b' d))
              (seq (seq (ia frame s5 (tuple b')) (Rn b')) y'))
           (seq (ia frame r6 (tuple b)) y) ).
Elim CM7.
Elim CF2''.
Elim A7.
Elim SUM1;Elim A6;Auto.
Red.
Intro.
Apply EQFf.
Exact (EQ_sym frame Frame H).
Apply EXT;Intro.
Elim CM7;Elim CF2''.
Elim A7;Auto.
Red.
Intro.
Apply EQFf.
Assumption.
Trivial.
Save CommTn_dRn.

Goal (x,y,y':proc)(b:bit)(d:D)(f:Frame)
     <proc>Delta=
     (enc H
        (Lmer
           (comm
              (seq (ia Frame s3 f) y)
              (seq (Tn_d d b) y'))
           x)).
Intros.
Elim ProcTn_d.
Elim A4.
Elim CM9.
Elim A5.
Elim A4.
Elim CM9.
Elim CM7.
Elim CM7.
Elim CM7.
Elim CF2''.
Elim CF2''.
Elim CF2''.
Elim A7.
Elim A7.
Elim A6.
Elim A6.
Unfold Delta.
Elim CM2.
Elim A7.
Elim D3.
Apply refl_equal.
Exact EQFf.
Exact EQFf.
Exact EQFf.

Save Comms3Tn_d.


Goal (x,y:proc)(f:Frame) <proc>Delta=
     (enc H (Lmer (comm (seq (ia Frame s3 f) y) (L i)) x)).

Intros.
Elim SC3.
Elim ChanL.
Elim (SUM7 frame [n:frame]
              (seq (ia frame r5 n)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 n))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i))) (seq (ia Frame s3 f) y)).
ElimType <frame->proc>[d:frame]Delta=
    [d:frame]
           (comm
              (seq (ia frame r5 d)
                 (seq
                    (alt (seq (ia one int i) (ia frame s6 d))
                       (seq (ia one int i) (ia frame s6 sce)))
                    (L i)))
              (seq (ia Frame s3 f) y)).
Elim SUM1.
Unfold Delta.
Elim CM2.
Elim D5.
Elim D3.
Elim A7.
Apply refl_equal.
Apply EXT. Intro.
Elim CM7.
Elim CF2''.
Elim A7.
Apply refl_equal.
Red. Intro.
Apply EQFf.
Apply EQ_sym.
Assumption.
Save Comms3L. 


Goal 
   (x,y,y':proc)(b:bit)
     <proc>
     (seq (ia Frame c3 lce) 
       (enc H (mer (mer y (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')) x)))=
     (enc H
        (Lmer
           (comm
              (seq (ia Frame s3 lce) y)
              (seq (Rn b) y'))
           x)).
Intros.
Pattern 2 (Rn b).
Elim ProcRn.
Elim (A4 
        (seq
           (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                  (ia Frame r3 lce))
               (seq (ia frame s5 (tuple b)) (Rn b)))
             (D+[d:D]
                (seq (ia Frame r3 (Tuple (toggle b) d))
                   (seq (ia D s4 d)
                      (ia frame s5 (tuple (toggle b))))))
            y').
Elim (CM9
        (seq (ia Frame s3 lce) y)
          (seq
             (seq
                (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                     (ia Frame r3 lce))
                  (seq (ia frame s5 (tuple b)) (Rn b)))
               y')
        (seq (D+[d:D]
                (seq (ia Frame r3 (Tuple (toggle b) d))
                   (seq (ia D s4 d)
                      (ia frame s5 (tuple (toggle b))))))
                   y')).
Elim (CM4 
        (comm (seq (ia Frame s3 lce) y)
               (seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y'))
        (comm (seq (ia Frame s3 lce) y)
               (seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y'))
        x).
ElimType <proc>Delta=
       (Lmer
            (comm (seq (ia Frame s3 lce) y)
               (seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y'))
            x).
Elim (A6  (Lmer
            (comm (seq (ia Frame s3 lce) y)
               (seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y'))
            x)).
Elim (A5 (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                     (ia Frame r3 lce))
              (seq (ia frame s5 (tuple b)) (Rn b)) y').
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce)
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim (CM9 (seq (ia Frame s3 lce) y)
          (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
          (seq (ia Frame r3 lce)
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))).
ElimType <proc>Delta=
        (comm (seq (ia Frame s3 lce) y)
               (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))).
Elim A6'.
Elim CM7.
Elim CF1.
Elim CM3.
Elim D5.
Elim D1.
Apply refl_equal.

Exact Inc3H.

Elim SC3.
Elim (SUM5 D [d:D](ia Frame r3 (Tuple b d))
              (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
        [d:D]
      (comm
         (seq (ia Frame r3 (Tuple b d))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 lce) y)).
Elim SUM1. 
Apply refl_equal.
Apply EXT. 
Intro.
Elim A5.
Elim CM7.
Elim CF2'.
Elim A7.
Apply refl_equal.
Apply eqF_intro'.
Apply eqF3.
Elim (SUM5 D 
       [d:D] (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
       y').
Elim (SC3 (seq (ia Frame s3 lce) y)
         (D
         +[d:D]
           (seq
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
              y'))).
Elim (SUM7 D
        [d:D]
           (seq
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
              y')
          (seq (ia Frame s3 lce) y)).
ElimType <D->proc>[d:D]Delta=
    [d:D](comm
           (seq
              (seq (ia Frame r3 (Tuple (toggle b) d))
                 (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
              y')
           (seq (ia Frame s3 lce) y)).
Unfold Delta.
Elim SUM6.
Elim CM2.
Elim SUM1.
Elim A7.
Apply refl_equal.
Apply EXT.
Intro.
Elim A5.
Elim CM7.
Elim CF2'.
Elim A7.
Apply refl_equal.
Apply eqF_intro'.
Apply eqF3.
Save Comms3Rn_lce.

Goal (x,y,y':proc)(b:bit)(d:D)
     <proc>
      (seq (ia Frame c3  (Tuple b d))
         (enc H (mer (mer (seq (ia frame s5 (tuple b))
                                (seq (Rn b) y')) y) x)))
     =
     (enc H
        (Lmer
           (comm
              (seq (ia Frame s3 (Tuple b d)) y)
              (seq (Rn b) y'))
           x)).
Intros.
Pattern 2 (Rn b).
Elim ProcRn.
Elim (A4 (seq (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                   (D+[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                  y').
Elim (CM9 (seq (ia Frame s3 (Tuple b d)) y)
          (seq (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')
          (seq (D+[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y')).
ElimType <proc>Delta=
       (comm (seq (ia Frame s3 (Tuple b d)) y)
               (seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y')).
Elim (A6 (comm (seq (ia Frame s3 (Tuple b d)) y)
               (seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y'))).

Elim (A5 (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                     (ia Frame r3 lce))
              (seq (ia frame s5 (tuple b)) (Rn b)) y').
Elim (A4 (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce)
       (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim (CM9 (seq (ia Frame s3 (Tuple b d)) y)
      (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
               (seq (ia Frame r3 lce)
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))).
ElimType <proc>Delta=
          (comm (seq (ia Frame s3 (Tuple b d)) y)
               (seq (ia Frame r3 lce)
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))).
Elim (A6 (comm (seq (ia Frame s3 (Tuple b d)) y)
               (seq (D+[d:D](ia Frame r3 (Tuple b d)))
                  (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')))).
Elim (SUM5 D [d:D](ia Frame r3 (Tuple b d))
      (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim (SC3 (seq (ia Frame s3 (Tuple b d)) y)
            (D+[d:D]
              (seq (ia Frame r3 (Tuple b d))
                 (seq (seq (ia frame s5 (tuple b)) (Rn b)) y')))).
Elim (SUM7 D [d:D]
              (seq (ia Frame r3 (Tuple b d))
                 (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
           (seq (ia Frame s3 (Tuple b d)) y)).
ElimType <D->proc>[d0:D]
        (cond
           (comm
              (seq (ia Frame r3 (Tuple b d))
                 (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
              (seq (ia Frame s3 (Tuple b d)) y))
           (eqD d0 d)
           Delta)=
         [d0:D]
           (comm
              (seq (ia Frame r3 (Tuple b d0))
                 (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
              (seq (ia Frame s3 (Tuple b d)) y)).
Elim (Sum_EliminationD [d:D](comm
                 (seq (ia Frame r3 (Tuple b d))
                    (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
                 (seq (ia Frame s3 (Tuple b d)) y)) d).
Elim CM7.           
Elim CF1.
Elim CM3.
Elim D5.
Elim D1.
Elim A5.
Apply refl_equal.
Exact Inc3H.
Apply EXT ; Intro.
Pattern 1 (comm
      (seq (ia Frame r3 (Tuple b d0))
         (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
      (seq (ia Frame s3 (Tuple b d)) y)).
Elim (Bak4_2_1 (eqD d0 d)
        (comm
        (seq (ia Frame r3 (Tuple b d0))
           (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
        (seq (ia Frame s3 (Tuple b d)) y))).
Elim (Def4_3_1_2
         (eqD d0 d)
              (comm
         (seq (ia Frame r3 (Tuple b d))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 (Tuple b d)) y))
                (comm
         (seq (ia Frame r3 (Tuple b d0))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 (Tuple b d)) y))
           (comm
         (seq (ia Frame r3 (Tuple b d0))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 (Tuple b d)) y))).
Elim (Def4_3_1_2'
         (eqD d0 d)
         Delta
                (comm
         (seq (ia Frame r3 (Tuple b d0))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 (Tuple b d)) y))
           (comm
         (seq (ia Frame r3 (Tuple b d))
            (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
         (seq (ia Frame s3 (Tuple b d)) y))).
Apply refl_equal.
Intro.
Elim CM7.
Elim CF2'.
Elim A7.
Apply refl_equal.
Red.
Intro.
Absurd <bool>true=false.
Red ; Intro.
Cut (P:bool->Prop)(P true)->(P false).
Intro L.
Apply (L ([b:bool](<Prop>Match b with True False))).
Exact I.
Intros.
Elim H1.
Assumption.
ElimType <bool>(eqD d0 d)=false.
ElimType <bool> (eqF (Tuple b d0) (Tuple b d))=(eqD d0 d).
Elim H0.
Elim eqF4.
Elim eqD7.
Elim bit1.
Elim andb1.
Apply refl_equal.
 
Elim eqF4.
Elim bit1.
Elim andb1.
Apply refl_equal.
 
Elim H.
Apply refl_equal.
Intro.
Elim (eqD_intro d0 d).
Apply refl_equal.
Assumption.
Elim CM7.
Elim CF2'.
Elim A7.
Apply refl_equal.
Apply eqF_intro'.
Elim eqF3.
Apply refl_equal.
 
Elim SC3.
Elim (SUM5 D [d:D]
           (seq (ia Frame r3 (Tuple (toggle b) d))
              (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
        y').
Elim SUM7.
ElimType <D->proc>[d:D]Delta=
     [d0:D]
      (comm
         (seq
            (seq (ia Frame r3 (Tuple (toggle b) d0))
               (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
            y')
         (seq (ia Frame s3 (Tuple b d)) y)).
Elim SUM1.
Apply refl_equal.
Apply EXT.
Intro.
Elim A5.
Elim CM7.
Elim CF2'.
Elim A7.
Apply refl_equal.
Red ; Intro.
Absurd <bool>true=false.
Red.
Intro.
Cut (P:bool->Prop)(P true)->(P false).
Intro L.
Apply (L ([b:bool](<Prop>Match b with True False))).
Exact I.
Intros.
Elim H0.
Assumption.
ElimType <bool>(eqF (Tuple b d) (Tuple b d))=true.
Pattern 2 (Tuple b d).
Elim H.
Elim eqF4.
Elim bit2.
Elim andb2.
Apply refl_equal.
Elim eqF4.
Elim bit1.
Elim andb1.
Elim eqD7.
Apply refl_equal.
 
Save Comms3Rn_b'.


Goal (x,y,y':proc)(b:bit)(d:D)
     <proc>
(seq (ia Frame c3  (Tuple (toggle b) d))
       (enc H (mer y (mer
                        (seq (ia D s4 d)
                           (seq (ia frame s5 (tuple (toggle b)))
                                      y')) x))))
     =
     (enc H
        (Lmer
           (comm
              (seq (ia Frame s3 (Tuple (toggle b) d)) y)
              (seq (Rn b) y'))
           x)).
Intros.
Elim ProcRn.
Elim (A4
(seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                (D+[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b)))))) y').
Elim (CM9
(seq (ia Frame s3 (Tuple (toggle b) d)) y)
(seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')(seq
                  (D
                  +[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b))))))
                   y')).
ElimType <proc>Delta=
(comm (seq (ia Frame s3 (Tuple (toggle b) d)) y)
               (seq
                  (seq
                     (alt (D+[d:D](ia Frame r3 (Tuple b d)))
                        (ia Frame r3 lce))
                     (seq (ia frame s5 (tuple b)) (Rn b)))
                  y')).
Elim (SUM5 D
[d:D]
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b)))))
y').
Elim (SC3
(seq (ia Frame s3 (Tuple (toggle b) d)) y)
(D
               +[d:D]
                 (seq
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b)))))
                    y'))).
Cut (p:proc)(<proc>p=(alt Delta p)).
Intro.
Elim (H0 
(comm
               (D
               +[d:D]
                 (seq
                    (seq (ia Frame r3 (Tuple (toggle b) d))
                       (seq (ia D s4 d)
                          (ia frame s5 (tuple (toggle b)))))
                    y'))
                (seq (ia Frame s3 (Tuple (toggle b) d)) y))).
Elim (SUM7 D
[d:D]
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b) d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
                 y')
(seq (ia Frame s3 (Tuple (toggle b) d)) y)).
ElimType <D->proc>[d1:D]
(cond 
           (comm
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b) d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
                 y')
              (seq (ia Frame s3 (Tuple (toggle b) d)) y))
(eqD d1 d)
           Delta)
=
[d0:D]
           (comm
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b) d0))
                    (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
                 y')
              (seq (ia Frame s3 (Tuple (toggle b) d)) y)).
Elim (Sum_EliminationD
([d:D]
           (comm
              (seq
                 (seq (ia Frame r3 (Tuple (toggle b) d))
                    (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
                 y')
              (seq (ia Frame s3 (Tuple (toggle b) d)) y)))
d).
Elim A5.
Elim CM7.
Elim CF1.
Unfold gamma.
Elim CM3.
Elim D5.
Elim D1.
Unfold abbrev.
Elim (SC6 y
(seq (seq (ia D s4 d) (ia frame s5 (tuple (toggle b))))
                  y')).
Elim SC7.
Elim A5;Trivial.
Exact Inc3H.
Apply EXT;Intros.
Cut ((<bool>true=(eqD d0 d))\/(<bool>false=(eqD d0 d))).
Cut (<bool>true=(eqD d0 d))->
<proc
  >(cond
      (comm
         (seq
            (seq (ia Frame r3 (Tuple (toggle b) d))
               (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
            y')
         (seq (ia Frame s3 (Tuple (toggle b) d)) y))
      (eqD d0 d) Delta)
  =(comm
      (seq
         (seq (ia Frame r3 (Tuple (toggle b) d0))
            (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
         y')
      (seq (ia Frame s3 (Tuple (toggle b) d)) y)).
Cut (<bool>false=(eqD d0 d))->
<proc
  >(cond
      (comm
         (seq
            (seq (ia Frame r3 (Tuple (toggle b) d))
               (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
            y')
         (seq (ia Frame s3 (Tuple (toggle b) d)) y))
      (eqD d0 d) Delta)
  =(comm
      (seq
         (seq (ia Frame r3 (Tuple (toggle b) d0))
            (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
         y')
      (seq (ia Frame s3 (Tuple (toggle b) d)) y)).
Intros.
Exact (or_ind
(<bool>true=(eqD d0 d))
(<bool>false=(eqD d0 d))
(<proc>(cond
      (comm
         (seq
            (seq (ia Frame r3 (Tuple (toggle b) d))
               (seq (ia D s4 d) (ia frame s5 (tuple (toggle b)))))
            y')
         (seq (ia Frame s3 (Tuple (toggle b) d)) y))
      (eqD d0 d) Delta)
  =(comm
      (seq
         (seq (ia Frame r3 (Tuple (toggle b) d0))
            (seq (ia D s4 d0) (ia frame s5 (tuple (toggle b)))))
         y')
      (seq (ia Frame s3 (Tuple (toggle b) d)) y)))
H1 H H2).
Intro.
Elim H; Elim COND2.
Elim A5;Elim CM7.
Elim CF2'.
Elim A7.
Trivial.
Apply eqF_intro'.
Elim eqF4.
Elim H.
Elim bit1.
Elim andb1.
Trivial.
Intro.
Elim (eqD_intro d0 d H).
Trivial.
ElimType <bool>true=(eqD d0 d0).
Elim COND1.
Trivial.
Apply eqD7.
Elim (eqD d0 d).
Left.
Apply refl_equal.
Right.
Apply refl_equal.
Intro;Elim A1;Elim A6;Trivial.
Elim (A5
(alt (D+[d:D](ia Frame r3 (Tuple b d))) (ia Frame r3 lce))
(seq (ia frame s5 (tuple b)) (Rn b))
y').
Elim SC3.
Elim (A4
(D+[d:D](ia Frame r3 (Tuple b d)))
(ia Frame r3 lce)
(seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim CM8.
Elim CM7.
Elim CF2'.
2:Apply eqF_intro'.
2:Elim eqF2.
2:Trivial.
Elim (SUM5 D
[d:D](ia Frame r3 (Tuple b d))
(seq (seq (ia frame s5 (tuple b)) (Rn b)) y')).
Elim (SUM7 D
[d:D](seq (ia Frame r3 (Tuple b d))
              (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
(seq (ia Frame s3 (Tuple (toggle b) d)) y)).
ElimType <D->proc>[d:D]Delta=
[d0:D]
        (comm
           (seq (ia Frame r3 (Tuple b d0))
              (seq (seq (ia frame s5 (tuple b)) (Rn b)) y'))
           (seq (ia Frame s3 (Tuple (toggle b) d)) y)).
Elim A7;Elim SUM1;Elim A6; Trivial.
Apply EXT;Intro;Elim CM7;Elim CF2'.
Elim A7;Trivial.
Apply eqF_intro'.
Elim eqF4.
Elim bit2.
Elim andb2;Trivial.
Save Comms3Rn_b.


Goal <proc>(sum D ([d:D] (seq (ia D r1 d) (X1 d))))=X.
Unfold 1 X.
Elim ProcS ; Elim ProcR.
Elim EXPH4.
Elim LmerSn.
Elim LmerK.
Elim LmerL.
Elim LmerRn.
Elim CommLRn.
Elim CommKL.
Elim CommKRn.
Elim CommSnK.
Elim CommSnL.
Elim CommSnRn.
Repeat Elim A6.
Elim (A6 (D+[d:D](seq (ia D r1 d)
           (enc H
              (mer (seq (Sn_d d e0) (seq (Sn e1) (S i)))
                 (mer (K i)
                    (mer (L i) (seq (Rn e1) (seq (Rn e0) (R i)))))))))).
Unfold X1.
Pattern 1 (R i).
Elim ProcR.
Apply refl_equal.
Save Lem1.


Goal <proc>(sum D ([d:D](seq (ia D r1 d) (Y1 d))))=Y.
Unfold Y.
Elim ProcS .
Elim EXPH4.
Elim LmerSn.
Elim LmerK.
Elim LmerL.
Elim LmerRn.
Elim CommLRn.
Elim CommKL.
Elim CommKRn.
Elim CommSnK.
Elim CommSnL.
Elim CommSnRn.
Repeat Elim A6.
Elim (A6 (D
      +[d:D]
        (seq (ia D r1 d)
           (enc H
              (mer (seq (Sn_d d e1) (seq (Sn e0) (seq (Sn e1) (S i))))
                 (mer (K i) (mer (L i) (seq (Rn e0) (R i))))))))).

Unfold Y1.
Pattern 1 (S i).
Elim ProcS.
Apply refl_equal.
Save Lem2.


Goal (d:D)<proc>
    (seq (ia Frame c2 (Tuple e0 d))
      (enc H
         (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
            (mer
               (seq
                  (alt (seq (ia one int i) (ia Frame s3 (Tuple e0 d)))
                     (seq (ia one int i) (ia Frame s3 lce)))
                  (K i))
               (mer (L i) (R i))))))=
     (X1 d).
                 
Intro.
Unfold 1 X1.
Elim EXPH4.
Elim LmerSnd.
Elim LmerK.
Elim LmerL.
Pattern 2 3 5 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommKL.
Elim CommKRn.
Elim ProcSn_d.
Elim A5.
Elim Comms2K.
Elim Comms2Rn.
Elim Comms2L.
Repeat Elim A6.
Repeat Elim A6'.
Elim SC7.
Apply refl_equal.
Save Lem3.

Goal (d:D)<proc>
      (alt
         (seq
            (ia one int i)
            (enc H
               (mer (seq (ia Frame s3 (Tuple e0 d)) (K i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                     (mer (L i) (R i))))))
         (seq 
            (ia one int i) 
            (enc H
               (mer (seq (ia Frame s3 lce) (K i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                     (mer (L i) (R i)))))))
        =
      (enc H
         (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
            (mer
               (seq
                  (alt (seq (ia one int i) (ia Frame s3 (Tuple e0 d)))
                     (seq (ia one int i) (ia Frame s3 lce)))
                  (K i))
               (mer (L i) (R i))))).

Intros. 
Elim EXPH4.
Elim LmerTnd.
Elim LmerL.
Elim A4.
Elim A5.
Elim A5.
Elim Lmeri.
Pattern 5 6 8 11 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommiL.
Elim CommiRn.
Elim CommTn_dL.
Elim CommTn_di.
Elim CommTn_dRn.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem4.

Goal (d:D)<proc>
       (seq (ia Frame c3 lce) 
         (enc H
            (mer (K i)
               (mer (seq (ia frame s5 (tuple e1)) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))))))=
            (enc H
               (mer (seq (ia Frame s3 lce) (K i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                     (mer (L i) (R i))))).

Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Pattern 2 3 5 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Elim Comms3Rn_lce.
Repeat Elim A6'.
Repeat Elim A6.
Elim SC7.
Pattern 1 (R i).
Elim ProcR.
Elim A5.
Apply refl_equal.
Save Lem5.

Goal (d:D)<proc>
(seq (ia Frame c3 (Tuple e0 d))
      (enc H
         (mer (K i)
            (mer
               (seq (ia D s4 d)
                  (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i))))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))))))
          =  (enc H
                (mer (seq (ia Frame s3 (Tuple e0 d)) (K i))
                   (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                      (mer (L i) (R i))))).

Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Pattern 1 2 3 5 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Pattern 6 e0.
ElimType <bit>(toggle e1)=e0.
Elim Comms3Rn_b.
Repeat Elim A6'.
Elim Toggle2.
Pattern 2 (R i).
Elim ProcR.
Apply refl_equal.
Elim Toggle2.
Apply refl_equal.
Save Lem6.

Goal (d:D)<proc>
 (seq (ia D s4 d) (X2 d))
     =
      (enc H
         (mer (K i)
            (mer  
               (seq (ia D s4 d)
                  (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i))))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))))).
Intros.
Elim EXPH4.
Elim LmerK.
Elim Lmers4.
Elim LmerTnd.
Elim LmerL.
Elim CommTn_dL.
Elim CommTn_ds4.
Elim CommLs4.
Elim CommKs4.
Elim CommTn_dK.
Elim CommKL.
Repeat Elim A6.
Repeat Elim A6'.
Unfold X2.
Elim (SC6  (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i))) (L i)).
Elim (SC6 (mer (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))
                  (L i)) (K i)).
Elim (SC6 (mer (mer (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))
             (L i)) (K i))  (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i)))) (L i)).
Elim SC7.
Apply refl_equal.
Save Lem7.

Goal (d:D)<proc>
     (seq (ia frame c5 (tuple e1)) 
        (enc H  (mer (R i)
           (mer
              (alt
                 (seq (ia one int i)
                    (seq (ia frame s6 (tuple e1)) (L i)))
                 (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
              (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i))))))))
        =(enc H
            (mer (K i)
               (mer (seq (ia frame s5 (tuple e1)) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))))).
Intros.
Elim EXPH4.
Elim LmerK.
Elim LmerL.
Elim Lmers5.
Elim LmerTnd.
Elim CommTn_dL.
Elim CommTn_ds5.
Elim CommLs5.
Elim CommKs5.
Elim CommKL.
Elim CommTn_dK.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem8.

Goal (d:D)<proc>
         (alt (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 (tuple e1)) (L i))
               (mer (R i)
                  (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i))))))))
           (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (R i)
                  (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i)))))))))
    =
    (enc H  (mer (R i)
           (mer
              (alt
                 (seq (ia one int i)
                    (seq (ia frame s6 (tuple e1)) (L i)))
                 (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
              (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i))))))).
 
Intros.
Elim EXPH4.
Elim Lmeri.
Elim LmerK.
Elim LmerTnd.
Pattern 3 9 10 11 (R i).
Elim ProcR.
Elim LmerRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) 
              (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i)))
                           (alt
                              (seq (ia one int i)
                                 (seq (ia frame s6 (tuple e1)) (L i)))
                              (seq (ia one int i)
                                 (seq (ia frame s6 sce) (L i))))).

Elim CommiRn.
Elim (SC3 (alt (seq (ia one int i)
                              (seq (ia frame s6 (tuple e1)) (L i)))
                           (seq (ia one int i)
                              (seq (ia frame s6 sce) (L i))))
                        (seq (Tn_d d e0) (seq (Sn e1) (S i)))).

Elim CommTn_di.
Elim CommTn_dK.
Elim CommiK.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem9.

Goal (d:D)<proc>
      (seq (ia frame c6 (tuple e1)) (X1 d))=
         (enc H
            (mer (seq (ia frame s6 (tuple e1)) (L i))
               (mer (R i)
                  (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i))))))).
Intros.
Elim EXPH4.
Elim Lmers6.
Elim LmerK.
Elim LmerTnd.
Pattern 1 3 4 5 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommTn_dK.
Elim (SC3  (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i)))
                     (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim CommKs6.
Elim CommRns6.
Pattern 1 2 e1.
ElimType <bit>(toggle e0)=e1.
Elim CommTn_ds6_b.

Repeat Elim A6.
Repeat Elim A6'.
Unfold X1.
Elim (SC6 (mer (seq (Sn_d d e0) (seq (Sn e1) (S i)))
               (mer (R i) (K i))) (L i)).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (L i)) (R i)).
Elim SC7.
Apply refl_equal.
Elim Toggle1.
Apply refl_equal.

Save Lem10.

Goal (d:D)<proc>
       (seq (ia frame c6 sce) (X1 d))=
         (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (R i)
                  (mer (K i) (seq (Tn_d d e0) (seq (Sn e1) (S i))))))).
Intros.
Elim EXPH4.
Elim Lmers6.
Elim LmerK.
Elim LmerTnd.
Pattern 1 3 4 5 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommTn_dK.
Elim (SC3  (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i)))
                     (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim CommKs6.
Elim CommRns6.
Elim CommTn_ds6_sce.
Repeat Elim A6.
Repeat Elim A6'.
Unfold X1.
Elim (SC6 (mer (seq (Sn_d d e0) (seq (Sn e1) (S i)))
               (mer (R i) (K i))) (L i)).
Elim SC7.
Elim SC7.
ElimType <proc>(mer (K i) (mer (L i) (R i)))=(mer (R i) (mer (K i) (L i))).
Apply refl_equal.
Elim (SC6 (mer (K i) (L i)) (R i)).
Elim SC7.
Apply refl_equal.
Save Lem11.

Goal (d:D)<proc> 
     (seq (ia Frame c2 (Tuple e0 d))
        (alt
           (seq (ia one int i) 
              (seq (ia Frame c3 (Tuple e0 d))
                  (seq (ia D s4 d) (X2 d))))
           (seq (ia one int i) 
              (seq (ia Frame c3 lce)
                 (seq (ia frame c5 (tuple e1)) 
                    (seq
                       (alt (seq (ia one int i) (ia frame c6 (tuple e1))) 
                            (seq (ia one int i) (ia frame c6 sce)))
                       (X1 d)))))))=(X1 d).
Intros.
Pattern 2 (X1 d).
Elim Lem3.
Elim Lem4.
Elim Lem5.
Elim Lem6.
Elim Lem7.
Elim Lem8.
Elim Lem9.
Elim Lem10.
Elim Lem11.
Elim A4.
Elim A5.
Elim A5.
Apply refl_equal.

Save Lem12.

Goal (d:D)<proc>
    (seq (ia Frame c2 (Tuple e1 d))
      (enc H
         (mer (seq (Tn_d d e1) (S i))
            (mer
               (seq
                  (alt (seq (ia one int i) (ia Frame s3 (Tuple e1 d)))
                     (seq (ia one int i) (ia Frame s3 lce)))
                  (K i))
               (mer (L i) (seq (Rn e0) (R i)))))))=
     (Y1 d).

Intro.
Unfold 1 Y1.
Elim EXPH4.
Elim LmerSnd.
Elim LmerK.
Elim LmerL.
Pattern 2 3 5 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommKL.
Elim CommKRn.
Elim ProcSn_d.
Elim A5.
Elim Comms2K.
Elim Comms2Rn.
Elim Comms2L.
Repeat Elim A6.
Repeat Elim A6'.
Elim SC7.
Apply refl_equal.

Save Lem13.

Goal (d:D)<proc>
      (alt
      (seq (ia one int i)
         (enc H
            (mer (seq (ia Frame s3 (Tuple e1 d)) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (seq (Rn e0) (R i)))))))
      (seq (ia one int i)
         (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (seq (Rn e0) (R i))))))))
        =
      (enc H
         (mer (seq (Tn_d d e1) (S i))
            (mer
               (seq
                  (alt (seq (ia one int i) (ia Frame s3 (Tuple e1 d)))
                     (seq (ia one int i) (ia Frame s3 lce)))
                  (K i))
               (mer (L i) (seq (Rn e0) (R i)))))).
Intros.
Elim EXPH4.
Elim LmerTnd.
Elim LmerL.
Elim A4.
Elim A5.
Elim A5.
Elim Lmeri.
Elim LmerRn.
Elim CommLRn.
Elim CommiL.
Elim CommiRn.
Elim CommTn_dL.
Elim CommTn_di.
Elim CommTn_dRn.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem14.



Goal (d:D)<proc>
   (seq (ia Frame c3 lce)
      (enc H
         (mer (K i)
            (mer (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))
               (mer (seq (Tn_d d e1) (S i)) (L i))))))
              =
            (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e1) (S i)) 
                  (mer (L i) (seq (Rn e0) (R i)))))).
 
Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Elim Comms3Rn_lce.
Repeat Elim A6'.
Repeat Elim A6.
Elim SC7.
Elim A5.
Apply refl_equal.
Save Lem15.


Goal (d:D)<proc>
   (seq (ia Frame c3 (Tuple e1 d))
      (enc H
         (mer (K i)
            (mer (seq (ia D s4 d) (seq (ia frame s5 (tuple e1)) (R i)))
               (mer (seq (Tn_d d e1) (S i)) (L i))))))
       = (enc H
            (mer (seq (ia Frame s3 (Tuple e1 d)) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (seq (Rn e0) (R i)))))).
 
Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Pattern 4 e1.
ElimType <bit>(toggle e0)=e1.
Elim Comms3Rn_b.
Repeat Elim A6'.
Elim Toggle1.
Apply refl_equal.
Elim Toggle1.
Apply refl_equal.
Save Lem16.


Goal (d:D)<proc>
 (seq (ia D s4 d) (Y2 d))
     =
      (enc H
         (mer (K i)
            (mer (seq (ia D s4 d) (seq (ia frame s5 (tuple e1)) (R i)))
               (mer (seq (Tn_d d e1) (S i)) (L i))))).
Intros.
Elim EXPH4.
Elim LmerK.
Elim Lmers4.
Elim LmerTnd.
Elim LmerL.
Elim CommTn_dL.
Elim CommTn_ds4.
Elim CommLs4.
Elim CommKs4.
Elim (SC3 (seq (Tn_d d e1) (S i)) (K i)).
Elim CommTn_dK.
Elim CommKL.
Repeat Elim A6.
Repeat Elim A6'.
Unfold Y2.
Elim (SC6  (seq (ia frame s5 (tuple e1)) (R i)) (L i)).
Elim (SC6 (mer (seq (ia frame s5 (tuple e1)) (R i)) (L i)) (K i)).
Elim (SC6 (mer (mer (seq (ia frame s5 (tuple e1)) (R i))
             (L i)) (K i))  (seq (Tn_d d e1) (S i))).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (seq (Tn_d d e1) (S i))) (L i)).
Elim SC7.
Apply refl_equal.
Save Lem17.

Goal (d:D)<proc>
   (seq (ia frame c5 (tuple e0))
      (enc H
         (mer (seq (Rn e0) (R i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia frame s6 (tuple e0)) (L i)))
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
               (mer (K i) (seq (Tn_d d e1) (S i)))))))
        =(enc H
         (mer (K i)
            (mer (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))
               (mer (seq (Tn_d d e1) (S i)) (L i))))).

Intros.
Elim EXPH4.
Elim LmerK.
Elim LmerL.
Elim Lmers5.
Elim LmerTnd.
Elim CommTn_dL.
Elim CommTn_ds5.
Elim CommLs5.
Elim CommKs5.
Elim CommKL.
Elim CommTn_dK.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem18.

Goal (d:D)<proc>
 (alt
      (seq (ia one int i)
         (enc H
            (mer (seq (ia frame s6 (tuple e0)) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (K i) (seq (Tn_d d e1) (S i)))))))
      (seq (ia one int i)
         (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (K i) (seq (Tn_d d e1) (S i))))))))
    =
      (enc H
         (mer (seq (Rn e0) (R i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia frame s6 (tuple e0)) (L i)))
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
               (mer (K i) (seq (Tn_d d e1) (S i)))))).
 
Intros.
Elim EXPH4.
Elim Lmeri.
Elim LmerK.
Elim LmerTnd.
Elim LmerRn.
Elim (SC3 (seq (Rn e0) (R i))
              (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim (SC3 (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e0) (R i))
            (alt (seq (ia one int i)
                    (seq (ia frame s6 (tuple e0)) (L i)))
                 (seq (ia one int i)
                    (seq (ia frame s6 sce) (L i))))).
 
Elim CommiRn.
Elim (SC3 (alt (seq (ia one int i)
                              (seq (ia frame s6 (tuple e0)) (L i)))
                           (seq (ia one int i)
                              (seq (ia frame s6 sce) (L i))))
                        (seq (Tn_d d e1) (S i))).
 
Elim CommTn_di.
Elim CommTn_dK.
Elim CommiK.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem19.

 
Goal (d:D)<proc>
      (seq (ia frame c6 (tuple e0)) (Y1 d))=
         (enc H
            (mer (seq (ia frame s6 (tuple e0)) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (K i) (seq (Tn_d d e1) (S i)))))).
Intros.
Elim EXPH4.
Elim Lmers6.
Elim LmerK.
Elim LmerTnd.
Elim LmerRn.
Elim CommTn_dK.
Elim (SC3  (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e0) (R i))
                     (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim CommKs6.
Elim CommRns6.
Pattern 1 2 e0.
ElimType <bit>(toggle e1)=e0.
Elim CommTn_ds6_b.
 
Repeat Elim A6.
Repeat Elim A6'.
Elim Toggle2.
Unfold Y1.
Elim (SC6 (mer (seq (Sn_d d e1) (S i))
               (mer (seq (Rn e0) (R i)) (K i))) (L i)).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (L i)) (seq (Rn e0) (R i))).
Elim SC7.
Apply refl_equal.
Elim Toggle2.
Apply refl_equal.

Save Lem20.


Goal (d:D)<proc>
       (seq (ia frame c6 sce) (Y1 d))=
         (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (K i) (seq (Tn_d d e1) (S i)))))).
Intros.
Elim EXPH4.
Elim Lmers6.
Elim LmerK.
Elim LmerTnd.
Elim LmerRn.
Elim CommTn_dK.
Elim (SC3  (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim (SC3 (seq (Rn e0) (R i))
                     (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim CommKs6.
Elim CommRns6.
Elim CommTn_ds6_sce.
Repeat Elim A6.
Repeat Elim A6'.
Unfold Y1.
Elim (SC6 (mer (seq (Sn_d d e1) (S i))
               (mer (seq (Rn e0) (R i)) (K i))) (L i)).
Elim SC7.
Elim SC7.
ElimType <proc>(mer (K i) (mer (L i) (seq (Rn e0) (R i))))=
            (mer (seq (Rn e0) (R i)) (mer (K i) (L i))).
Apply refl_equal.
Elim (SC6 (mer (K i) (L i)) (seq (Rn e0) (R i))).
Elim SC7.
Apply refl_equal.
Save Lem21.


Goal (d:D)<proc> 
     (seq (ia Frame c2 (Tuple e1 d))
        (alt
           (seq (ia one int i)
              (seq (ia Frame c3 (Tuple e1 d))
                  (seq (ia D s4 d) (Y2 d))))
           (seq (ia one int i)
              (seq (ia Frame c3 lce)
                 (seq (ia frame c5 (tuple e0))
                    (seq
                       (alt (seq (ia one int i) (ia frame c6 (tuple e0)))
                            (seq (ia one int i) (ia frame c6 sce)))
                       (Y1 d)))))))=(Y1 d).
Intros.
Pattern 2 (Y1 d).
Elim Lem13.
Elim Lem14.
Elim Lem15.
Elim Lem16.
Elim Lem17.
Elim Lem18.
Elim Lem19.
Elim Lem20.
Elim Lem21.
Elim A4.
Elim A5.
Elim A5.
Apply refl_equal.
 
Save Lem22.

Goal (d:D)<proc>
   (seq (ia frame c5 (tuple e0)) 
      (enc H
         (mer (seq (Rn e0) (R i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia frame s6 (tuple e0)) (L i)))
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i))))))= (X2 d).

Intros.
Unfold X2.
Elim EXPH4.
Elim LmerTnd.
Elim LmerK.
Elim LmerL.
Elim Lmers5.
Elim (SC3 (L i) (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))).
Elim CommLs5.
Elim CommKL.
Elim CommKs5.
Elim (SC3 (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i)).
Elim CommTn_dK.
Elim CommTn_dL.
Elim (SC3 (seq (Tn_d d e0) (seq (Sn e1) (S i)))
             (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))).
Elim CommTn_ds5.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.

Save Lem23.

Goal (d:D)<proc>
     (alt (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 (tuple e0)) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i))))))
          (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i)))))))
     =(enc H
         (mer (seq (Rn e0) (R i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia frame s6 (tuple e0)) (L i)))
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i))))).
Intros.
Elim EXPH4. 
Elim LmerRn.
Elim Lmeri.
Elim LmerTnd.
Elim LmerK.
Elim (SC3 (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e0) (R i))
                (alt
                   (seq (ia one int i)
                      (seq (ia frame s6 (tuple e0))
                         (L i)))
                   (seq (ia one int i)
                      (seq (ia frame s6 sce) (L i))))).
Elim CommiRn.
Elim (SC3 (seq (Rn e0) (R i)) (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim (SC3 (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim (SC3 (alt (seq (ia one int i) (seq (ia frame s6 (tuple e0)) (L i)))
                 (seq (ia one int i)
                                    (seq (ia frame s6 sce) (L i))))
                              (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_di.
Elim CommiK. 
Repeat Elim A6. 
Repeat Elim A6'.
Apply refl_equal.
Save Lem24.

Goal (d:D)<proc>
       (seq (ia frame c6 (tuple e0)) Y)=
         (enc H
            (mer (seq (ia frame s6 (tuple e0)) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i))))).
Intros.
Elim EXPH4. 
Elim LmerRn.
Elim Lmers6.
Elim LmerTnd.
Elim LmerK.
Elim (SC3 (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e0) (R i)) (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim CommRns6.
Elim (SC3  (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim CommKs6.
Elim CommTn_ds6_b'.
Repeat Elim A6.
Repeat Elim A6'.
Unfold Y.
Elim (SC6 (mer (seq (Sn e1) (S i)) (mer (seq (Rn e0) (R i)) (K i))) (L i)).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (L i)) (seq (Rn e0) (R i))).
Elim SC7.
Apply refl_equal.
Save Lem25.

Goal (d:D)<proc>
      (seq (ia frame c6 sce) (enc H
         (mer (L i)
            (mer (seq (Sn_d d e0) (seq (Sn e1) (S i)))
               (mer (seq (Rn e0) (R i)) (K i))))))=
         (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (seq (Rn e0) (R i))
                  (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i))))).
     
Intros.
Elim EXPH4.
Elim LmerRn.
Elim Lmers6.
Elim LmerTnd.
Elim LmerK.
Elim (SC3 (seq (Tn_d d e0) (seq (Sn e1) (S i))) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e0) (R i)) (seq (Tn_d d e0) (seq (Sn e1) (S i)))).
Elim CommTn_dRn.
Elim CommRns6. 
Elim (SC3  (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.  
Elim CommKs6.
Elim CommTn_ds6_sce.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.

Save Lem26.


Goal (d:D)<proc>
    (seq (ia Frame c2 (Tuple e0 d)) (enc H
         (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia Frame s3 (Tuple e0 d)) (K i)))
                  (seq (ia one int i) (seq (ia Frame s3 lce) (K i))))
               (mer (L i) (seq (Rn e0) (R i)))))))=
       (enc H
         (mer (L i)
            (mer (seq (Sn_d d e0) (seq (Sn e1) (S i)))
               (mer (seq (Rn e0) (R i)) (K i))))).
Intros.
Elim EXPH4.
Elim LmerL.
Elim LmerSnd.
Elim LmerRn.
Elim LmerK.
Elim CommLRn.
Elim (SC3  (seq (Rn e0) (R i)) (K i)).
Elim CommKRn.
Elim CommSn_dK.
Elim (SC3 (L i) (seq (Sn_d d e0) (seq (Sn e1) (S i)))).
Elim CommSn_dL.
Elim (SC3 (L i) (K i)).
Elim CommKL.
Elim CommSn_dRn.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.

Save Lem27.

Goal (d:D)<proc>
     (alt (seq (ia one int i) 
         (enc H
            (mer (seq (ia Frame s3 (Tuple e0 d)) (K i))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                  (mer (L i) (seq (Rn e0) (R i)))))))
       (seq (ia one int i) (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                  (mer (L i) (seq (Rn e0) (R i))))))))=
      (enc H
         (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia Frame s3 (Tuple e0 d)) (K i)))
                  (seq (ia one int i) (seq (ia Frame s3 lce) (K i))))
               (mer (L i) (seq (Rn e0) (R i)))))).
Intros.
Elim EXPH4.
Elim LmerTnd.
Elim Lmeri.
Elim LmerL.
Elim LmerRn.
Elim CommTn_dRn.
Elim CommTn_dL.
Elim CommTn_di.
Elim CommLRn.
Elim CommiRn.
Elim CommiL.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem28.

Goal (d:D)<proc>
   (seq (ia Frame c3 lce) (X2 d))=
         (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i)))
                  (mer (L i) (seq (Rn e0) (R i)))))).
Intros.   
Elim EXPH4. 
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Elim Comms3Rn_lce.
Repeat Elim A6.
Repeat Elim A6'.

Unfold X2.
Elim (SC6 (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))
            (mer (K i)
               (seq (seq (ia frame s5 (tuple e0)) (Rn e0)) (R i)))).
Elim SC7.
Elim (SC6 (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i))) (L i)).
Elim (SC6 (mer (K i)
               (seq (seq (ia frame s5 (tuple e0)) (Rn e0)) (R i))) (L i)).
Elim SC7.
Elim A5.
Apply refl_equal.
Save Lem29.

Goal  (d:D)<proc> 
   (seq (ia Frame c3 (Tuple e0 d)) (X2 d))=
         (enc H 
            (mer (seq (ia Frame s3 (Tuple e0 d)) (K i)) 
               (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) 
                  (mer (L i) (seq (Rn e0) (R i)))))). 
Intros.   
Elim EXPH4.  
Elim Lmers3. 
Elim LmerTnd.
Elim LmerL. 
Elim LmerRn.
Elim CommLRn. 
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d. 
Elim Comms3L. 
Elim Comms3Rn_b'.
Repeat Elim A6. 
Repeat Elim A6'. 
Unfold X2.
Elim (SC6 (mer (seq (Tn_d d e0) (seq (Sn e1) (S i))) (L i))
    (mer (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i))) (K i))).

Elim SC7.
Elim (SC6 (mer (L i)
          (seq (ia frame s5 (tuple e0)) (seq (Rn e0) (R i)))) (K i)).
Elim SC7.
Apply refl_equal.
Save Lem30.

Goal (d:D)<proc>
     (seq (ia frame c5 (tuple e0))
        (alt 
           (seq (ia one int i)
              (seq (ia frame c6 sce) 
                 (seq (ia Frame c2 (Tuple e0 d))
                    (seq
                       (alt (seq (ia one int i) (ia Frame c3 lce))
                            (seq (ia one int i) (ia Frame c3 (Tuple e0 d))))
                       (X2 d)))))
           (seq (ia one int i)
              (seq (ia frame c6 (tuple e0)) Y))))=(X2 d).
Intros.
Pattern 2 (X2 d).
Elim Lem23.
Elim Lem24.
Elim Lem25.
Elim Lem26.
Elim Lem27.
Elim Lem28.
Elim Lem29.
Elim Lem30.
Elim (A1 (seq (ia one int i)
            (seq (ia frame c6 sce)
               (seq (ia Frame c2 (Tuple e0 d))
                  (alt
                     (seq (ia one int i)
                        (seq (ia Frame c3 (Tuple e0 d)) (X2 d)))
                     (seq (ia one int i)
                        (seq (ia Frame c3 lce) (X2 d)))))))
       (seq (ia one int i) (seq (ia frame c6 (tuple e0)) Y))).
Elim A4.
Elim (A1 
     (seq (ia one int i) (seq (ia Frame c3 lce) (X2 d)))
     (seq (ia one int i) (seq (ia Frame c3 (Tuple e0 d)) (X2 d)))).
Elim A5.
Elim A5.
Apply refl_equal.
Save Lem31.

Goal (d:D)<proc>
   (seq (ia frame c5 (tuple e1))
      (enc H
         (mer (R i)
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia frame s6 (tuple e1)) (L i)))
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i))))
               (mer (seq (Tn_d d e1) (S i)) (K i))))))=(Y2 d).

Intros.
Unfold Y2.
Elim EXPH4.
Elim LmerTnd.
Elim LmerK.
Elim LmerL.
Elim Lmers5.
Elim (SC3 (L i) (seq (ia frame s5 (tuple e1)) (R i))).
Elim CommLs5.
Elim CommKL.
Elim CommKs5.
Elim (SC3 (seq (Tn_d d e1) (S i)) (K i)).
Elim CommTn_dK.
Elim CommTn_dL.
Elim (SC3 (seq (Tn_d d e1) (S i)) (seq (ia frame s5 (tuple e1)) (R i))).
Elim CommTn_ds5.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem33.


Goal (d:D)<proc>
     (alt (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 (tuple e1)) (L i))
               (mer (R i)
                  (mer (seq (Tn_d d e1) (S i)) (K i))))))
          (seq (ia one int i) (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (R i) (mer (seq (Tn_d d e1) (S i)) (K i)))))))
     =
      (enc H 
         (mer (R i)
            (mer  
               (alt 
                  (seq (ia one int i) 
                     (seq (ia frame s6 (tuple e1)) (L i))) 
                  (seq (ia one int i) (seq (ia frame s6 sce) (L i)))) 
               (mer (seq (Tn_d d e1) (S i)) (K i))))).
Intros.
Elim EXPH4.
Elim Lmeri.
Elim LmerTnd.
Elim LmerK.
Pattern 3 9 10 11 (R i).
Elim ProcR.
Elim LmerRn.
Elim (SC3 (seq (Tn_d d e1) (S i)) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.

Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i)))
                (alt
                   (seq (ia one int i)
                      (seq (ia frame s6 (tuple e1))
                         (L i)))
                   (seq (ia one int i)
                      (seq (ia frame s6 sce) (L i))))).
Elim CommiRn.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim (SC3 (alt (seq (ia one int i) (seq (ia frame s6 (tuple e1)) (L i)))
  (seq (ia one int i) (seq (ia frame s6 sce) (L i)))) (seq (Tn_d d e1) (S i))).

Elim CommTn_di.
Elim CommiK.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem34.

Goal (d:D)<proc>
       (seq (ia frame c6 (tuple e1)) X)=
         (enc H
            (mer (seq (ia frame s6 (tuple e1)) (L i))
               (mer (R i)
                  (mer (seq (Tn_d d e1) (S i)) (K i))))).

Intros.
Elim EXPH4.
Pattern 2 6 7 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim Lmers6.
Elim LmerTnd.
Elim LmerK.
Elim (SC3 (seq (Tn_d d e1) (S i)) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim CommRns6.
Elim (SC3  (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim CommKs6.
Elim CommTn_ds6_b'.
Repeat Elim A6.
Repeat Elim A6'.
Unfold X.
Elim (SC6 (mer (S i) (mer (R i) (K i))) (L i)).
Elim SC7.
Elim SC7.
Elim (SC6 (mer (K i) (L i)) (R i)).
Elim SC7.
Apply refl_equal.
Save Lem35.

Goal (d:D)<proc>
      (seq (ia frame c6 sce) (enc H
         (mer (L i)
            (mer (seq (Sn_d d e1) (S i))
               (mer (R i) (K i))))))=
         (enc H
            (mer (seq (ia frame s6 sce) (L i))
               (mer (R i) (mer (seq (Tn_d d e1) (S i)) (K i))))).

     
Intros.
Elim EXPH4.
Pattern 3 7 8 9 (R i).
Elim ProcR.
Elim LmerRn.
Elim Lmers6.
Elim LmerTnd.
Elim LmerK.
Elim (SC3 (seq (Tn_d d e1) (S i)) (K i)).
Elim CommTn_dK.
Elim (SC3 (seq (Rn e1) (seq (Rn e0) (R i))) (seq (Tn_d d e1) (S i))).
Elim CommTn_dRn.
Elim CommRns6.
Elim (SC3  (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim CommKs6.
Elim CommTn_ds6_sce.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem36.

Goal (d:D)<proc>
    (seq (ia Frame c2 (Tuple e1 d)) (enc H
         (mer (seq (Tn_d d e1) (S i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia Frame s3 (Tuple e1 d)) (K i)))
                  (seq (ia one int i) (seq (ia Frame s3 lce) (K i))))
               (mer (L i) (R i))))))=
      (enc H
         (mer (L i)
            (mer (seq (Sn_d d e1) (S i))
               (mer (R i) (K i))))).
Intros.
Elim EXPH4.
Elim LmerL.
Elim LmerSnd.
Pattern 2 4 5 8 (R i).
Elim ProcR.
Elim LmerRn.
Elim LmerK.
Elim CommLRn.
Elim (SC3  (seq (Rn e1) (seq (Rn e0) (R i))) (K i)).
Elim CommKRn.
Elim CommSn_dK.
Elim (SC3 (L i) (seq (Sn_d d e1) (S i))).
Elim CommSn_dL.
Elim (SC3 (L i) (K i)).
Elim CommKL.
Elim CommSn_dRn.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.
Save Lem37.

Goal (d:D)<proc>
     (alt (seq (ia one int i)
         (enc H
            (mer (seq (ia Frame s3 (Tuple e1 d)) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (R i))))))
       (seq (ia one int i) (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (R i)))))))=
      (enc H
         (mer (seq (Tn_d d e1) (S i))
            (mer
               (alt
                  (seq (ia one int i)
                     (seq (ia Frame s3 (Tuple e1 d)) (K i)))
                  (seq (ia one int i) (seq (ia Frame s3 lce) (K i))))
               (mer (L i) (R i))))).
Intros.
Elim EXPH4.
Elim LmerTnd.
Elim Lmeri.
Elim LmerL.
Pattern 5 6 8 11 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommTn_dRn.
Elim CommTn_dL.
Elim CommTn_di.
Elim CommLRn.
Elim CommiRn.
Elim CommiL.
Repeat Elim A6.
Repeat Elim A6'.
Apply refl_equal.

Save Lem38.



Goal (d:D)<proc>
   (seq (ia Frame c3 lce) (Y2 d))=
        (enc H
            (mer (seq (ia Frame s3 lce) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (R i))))).
Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Pattern 1 2 4 7 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Elim Comms3Rn_lce.
Repeat Elim A6.
Repeat Elim A6'.
 
Unfold Y2.
Elim (SC6 (mer (seq (Tn_d d e1) (S i)) (L i))
          (mer (K i)
               (seq (seq (ia frame s5 (tuple e1)) (Rn e1))
                  (seq (Rn e0) (R i))))).
Elim SC7.
Elim (SC6 (seq (ia frame s5 (tuple e1)) (R i)) (L i)).
Elim (SC6 (mer (K i)
                  (seq (seq (ia frame s5 (tuple e1)) (Rn e1))
                     (seq (Rn e0) (R i)))) (L i)).
Elim SC7.
Elim A5.
Pattern 1 (R i).
Elim ProcR.
Apply refl_equal.
Save Lem39.

Goal  (d:D)<proc>
   (seq (ia Frame c3 (Tuple e1 d)) (Y2 d))=
         (enc H
            (mer (seq (ia Frame s3 (Tuple e1 d)) (K i))
               (mer (seq (Tn_d d e1) (S i))
                  (mer (L i) (R i))))).
Intros.
Elim EXPH4.
Elim Lmers3.
Elim LmerTnd.
Elim LmerL.
Pattern 1 2 4 7 (R i).
Elim ProcR.
Elim LmerRn.
Elim CommLRn.
Elim CommTn_dL.
Elim CommTn_dRn.
Elim Comms3Tn_d.
Elim Comms3L.
Elim Comms3Rn_b'.
Repeat Elim A6.
Repeat Elim A6'.
Unfold Y2.
Elim (SC6 (mer (seq (Tn_d d e1) (S i)) (L i))
    (mer (seq (ia frame s5 (tuple e1)) 
          (seq (Rn e1) (seq (Rn e0) (R i)))) (K i))).
 
Elim SC7.
Elim (SC6 (mer (L i)
          (seq (ia frame s5 (tuple e1)) (R i))) (K i)).
Elim SC7.
Pattern 1 (R i).
Elim ProcR.
Apply refl_equal.
Save Lem40.

Goal (d:D)<proc>
     (seq (ia frame c5 (tuple e1))
        (alt
           (seq (ia one int i)
              (seq (ia frame c6 sce)
                 (seq (ia Frame c2 (Tuple e1 d))
                    (seq
                       (alt (seq (ia one int i) (ia Frame c3 lce))
                            (seq (ia one int i) (ia Frame c3 (Tuple e1 d))))
                       (Y2 d)))))
           (seq (ia one int i)
              (seq (ia frame c6 (tuple e1)) X))))=(Y2 d).
Intros.
Pattern 2 (Y2 d).
Elim Lem33.
Elim Lem34.
Elim Lem35.
Elim Lem36.
Elim Lem37.
Elim Lem38.
Elim Lem39.
Elim Lem40.
Elim (A1 (seq (ia one int i)
            (seq (ia frame c6 sce)
               (seq (ia Frame c2 (Tuple e1 d))
                  (alt
                     (seq (ia one int i)
                        (seq (ia Frame c3 (Tuple e1 d)) (Y2 d)))
                     (seq (ia one int i)
                        (seq (ia Frame c3 lce) (Y2 d)))))))
       (seq (ia one int i) (seq (ia frame c6 (tuple e1)) X))).
Elim A4.
Elim (A1
     (seq (ia one int i) (seq (ia Frame c3 lce) (Y2 d)))
     (seq (ia one int i) (seq (ia Frame c3 (Tuple e1 d)) (Y2 d)))).
Elim A5.
Elim A5.
Apply refl_equal.

Save Lem41.


(* Now we define a number of simplified processes *)

Parameter X',Y':proc.
Parameter X1',X2',Y1',Y2':D->proc.


Axiom Lin2':
 (d:D)<proc>
        (alt
           (seq (ia one int i) (seq (ia D s4 d) (hide I' (X2 d))))
           (seq (ia one int i) (seq (ia one int i) (X1' d))))=(X1' d).


Axiom Lin3':
 (d:D)<proc>
        (alt
           (seq (ia one int i) (seq (ia one int i) (X2' d)))
           (seq (ia one int i) (hide I' Y)))=(X2' d).



Axiom Lin5':
(d:D)<proc> 
        (alt
           (seq (ia one int i) (seq (ia D s4 d) (hide I' (Y2 d))))
           (seq (ia one int i) (seq (ia one int i) (Y1' d))))=(Y1' d).

Axiom Lin6':
 (d:D)<proc>
        (alt
           (seq (ia one int i) (seq (ia one int i)  (Y2' d)))
           (seq (ia one int i) (hide I' X)))=(Y2' d).


Goal (d:D)<proc>(seq (ia one tau i) (X1' d))=(hide I' (X1 d)).
Intros.
Apply (RSP 
         D 
         ([d:D](seq (ia one tau i)(X1' d)))
         ([d:D](hide I' (X1 d))) 
          ([X:D->proc][d:D](seq (ia one tau i)(alt
           (seq (ia one int i) (seq (ia D s4 d) (hide I' (X2 d))))
           (seq (ia one int i) (seq (ia one int i) (X d))))))).
Auto.
Intros.
Pattern 1 (X1' d0).
Elim Lin2'.
Elim T1'.
Apply refl_equal.

Intros.
Pattern 1 (X1 d0).
Elim Lem12.
Elim TI5.
Elim TI4.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI4.
Elim TI5.
Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI2.
Elim A3.
Repeat Elim T1'.
Elim T1.
Apply refl_equal.
Exact Inc6I.
Exact InintI.
Exact Inc6I.
Exact InintI.
Exact Inc5I.
Exact Inc3I.
Exact InintI.
Exact Ins4I.
Exact Inc3I.
Exact InintI.
Exact Inc2I.

Save LemLin2.

Goal (d:D)<proc>(seq (ia one tau i) (X2' d))=(hide I' (X2 d)).
Intros.
Apply (RSP   
         D
         ([d:D](seq (ia one tau i)(X2' d)))
         ([d:D](hide I' (X2 d)))
         ([X:D->proc][d:D](seq (ia one tau i) 
          (alt
           (seq (ia one int i) (seq (ia one int i) (X d)))
           (seq (ia one int i) (hide I' Y)))))).
Auto.
Intro.
Pattern 1 (X2' d0).
Elim Lin3'.
Elim T1'.
Apply refl_equal.
Intro.
Pattern 1 (X2 d0).
Elim Lem31.
Elim TI5.
Elim TI2.
Elim TI4.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.

Elim TI5.
Elim TI2.
Elim TI5.
Elim TI4.
Elim TI5.

Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Repeat Elim T1'.
Repeat Elim T1.
Elim A3.
Apply refl_equal.
Exact Inc6I.
Exact InintI.
Exact Inc3I.
Exact InintI.
Exact Inc3I.
Exact InintI.
Exact Inc2I.
Exact Inc6I.
Exact InintI.
Exact Inc5I.
Save LemLin3.

Goal (d:D)<proc>(seq (ia one tau i) (Y1' d))=(hide I' (Y1 d)).
Intros.
Apply (RSP 
         D 
         ([d:D](seq (ia one tau i)(Y1' d)))
         ([d:D](hide I' (Y1 d))) 
          ([Y:D->proc][d:D](seq (ia one tau i)(alt
           (seq (ia one int i) (seq (ia D s4 d) (hide I' (Y2 d))))
           (seq (ia one int i) (seq (ia one int i) (Y d))))))).
Auto.
Intros.
Pattern 1 (Y1' d0).
Elim Lin5'.
Elim T1'.
Apply refl_equal.
Intros.
Pattern 1 (Y1 d0).
Elim Lem22.
Elim TI5.
Elim TI4.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI4.
Elim TI5.
Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI2.
Elim A3.
Repeat Elim T1'.
Elim T1.
Apply refl_equal.
Exact Inc6I.
Exact InintI.
Exact Inc6I.
Exact InintI.
Exact Inc5I.
Exact Inc3I.
Exact InintI.
Exact Ins4I.
Exact Inc3I.
Exact InintI.
Exact Inc2I.
Save LemLin5.

Goal (d:D)<proc>(seq (ia one tau i) (Y2' d))=(hide I' (Y2 d)).
Intros.
Apply (RSP   
         D
         ([d:D](seq (ia one tau i)(Y2' d)))
         ([d:D](hide I' (Y2 d)))
         ([Y:D->proc][d:D](seq (ia one tau i) 
          (alt
           (seq (ia one int i) (seq (ia one int i) (Y d)))
           (seq (ia one int i) (hide I' X)))))).
Auto.
Intro.
Pattern 1 (Y2' d0).
Elim Lin6'.
Elim T1'.
Apply refl_equal.
Intro.
Pattern 1 (Y2 d0).
Elim Lem41.
Elim TI5.
Elim TI2.
Elim TI4.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.

Elim TI5.
Elim TI2.
Elim TI5.
Elim TI4.
Elim TI5.

Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI2.
Elim TI5.
Elim TI1.
Elim TI5.
Elim TI2.
Repeat Elim T1'.
Repeat Elim T1.
Elim A3.
Apply refl_equal.
Exact Inc6I.
Exact InintI.
Exact Inc3I.
Exact InintI.
Exact Inc3I.
Exact InintI.
Exact Inc2I.
Exact Inc6I.
Exact InintI.
Exact Inc5I.
Save LemLin6.


Goal (d:D)<proc>(seq (ia one tau i) (seq (ia D s4 d) 
          (hide I'' (hide I' (X2 d)))))=
              (seq (ia one tau i) (hide I'' (X1' d))).
Intro.
Apply sym_equal.
ElimType <proc> 
      (seq 
         (ia one tau i) 
         (hide I'' 
            (seq 
               (ia one int i) (seq (ia D s4 d) (hide I' (X2 d))))))=
       (seq 
          (ia one tau i) 
          (seq (ia D s4 d) (hide I'' (hide I' (X2 d))))).
Apply (KFAR2 one i int).
Exact InintI''.
Pattern  1 (X1' d).
Elim Lin2'.
Elim A1.
Apply refl_equal.
Elim TI5.
Elim TI2.
Elim TI5.
Elim TI1.
Elim T1'.
Apply refl_equal.
Exact Ins4I''.
Exact InintI''.
Save KFlin2.

Goal (d:D)<proc>(seq (ia one tau i) (hide I'' (hide I' Y)))=
              (seq (ia one tau i) (hide I'' (X2' d))).
Intros.
Apply sym_equal.
ElimType <proc>
       (seq (ia one tau i) (hide I'' (seq (ia one int i) (hide I' Y))))
          =(seq (ia one tau i) (hide I'' (hide I' Y))).
Apply (KFAR2 one i int).
Exact InintI''.
Pattern  1 (X2' d).
Elim Lin3'.
Apply refl_equal.
Elim TI5.
Elim TI2.
Elim T1'.
Apply refl_equal.
Exact InintI''.
Save KFlin3.

Goal (d:D)<proc>(seq (ia one tau i) (seq (ia D s4 d)
          (hide I'' (hide I' (Y2 d)))))=
              (seq (ia one tau i) (hide I'' (Y1' d))).
Intro.
Apply sym_equal.
ElimType <proc>
      (seq
         (ia one tau i)
         (hide I''
            (seq
               (ia one int i) (seq (ia D s4 d) (hide I' (Y2 d))))))=
       (seq
          (ia one tau i)
          (seq (ia D s4 d) (hide I'' (hide I' (Y2 d))))).
Apply (KFAR2 one i int).
Exact InintI''.
Pattern  1 (Y1' d).
Elim Lin5'.
Elim A1.
Apply refl_equal.
Elim TI5.
Elim TI2.
Elim TI5. 
Elim TI1. 
Elim T1'.
Apply refl_equal.
Exact Ins4I''. 
Exact InintI''. 
Save KFlin5. 

Goal (d:D)<proc>(seq (ia one tau i) (hide I'' (hide I' X)))=
              (seq (ia one tau i) (hide I'' (Y2' d))). 
Intros. 
Apply sym_equal. 
ElimType <proc>  
       (seq (ia one tau i) (hide I'' (seq (ia one int i) (hide I' X)))) 
          =(seq (ia one tau i) (hide I'' (hide I' X))). 
Apply (KFAR2 one i int). 
Exact InintI''. 
Pattern  1 (Y2' d). 
Elim Lin6'.  

Apply refl_equal. 
Elim TI5. 
Elim TI2.
Elim T1'. 
Apply refl_equal. 
Exact InintI''.
Save KFlin6.

Parameter B:proc.
Axiom Specificat:
 <proc>(sum D ([d:D](seq (ia D r1 d) (seq (ia D s4 d) B))))=B.

Goal <proc>B=(hide I'' (hide I' ABP)).

Apply (RSP one ([d:one]B) ([d:one](hide I'' (hide I' X)))
        ([Z:one->proc]([d':one]
             (sum D ([d:D](seq (ia D r1 d) (seq (ia D s4 d) 
               (sum D ([d:D](seq (ia D r1 d) (seq (ia D s4 d) (Z d')))))))))))).
Auto.
3:Exact i.
Intro.
Pattern 1 B.
Elim Specificat.
Pattern 1 B.
Elim Specificat.
Apply refl_equal.
Intro.
Pattern 1 X.
Elim Lem1.
Elim (SUM8 D [d:D](seq (ia D r1 d) (X1 d)) I').
Elim (SUM8 D [d:D](hide I' (seq (ia D r1 d) (X1 d))) I'').
ElimType <D->proc>
      [d:D](seq (ia D r1 d)
         (seq (ia D s4 d)
            (D
            +[d0:D]
              (seq (ia D r1 d0)
                 (seq (ia D s4 d0) (hide I'' (hide I' X)))))))=
      [d:D](hide I'' (hide I' (seq (ia D r1 d) (X1 d)))).
Apply refl_equal.
Apply EXT. Intro.
Elim TI5.
Elim TI1.
Elim LemLin2.
Elim T1'.
Elim TI5.
Elim TI1.
ElimType <proc> (seq (ia D r1 d0) (seq (ia one tau i) (hide I'' (X1' d0))))
               =(seq (ia D r1 d0) (hide I'' (X1' d0))).
2:Apply sym_equal.
2:Apply T1'.
Elim KFlin2.
Elim T1'.
Elim LemLin3.

Elim TI5.
Elim TI1.
Elim KFlin3.
Elim T1'.
Elim Lem2.
Elim (SUM8 D [d:D](seq (ia D r1 d) (Y1 d)) I').
Elim (SUM8 D [d:D](hide I' (seq (ia D r1 d) (Y1 d))) I'').

ElimType <D->proc>
      [d0:D](seq (ia D r1 d0) (seq (ia D s4 d0) (hide I'' (hide I' X))))=
      [d:D](hide I'' (hide I' (seq (ia D r1 d) (Y1 d)))).
Apply refl_equal.
Apply EXT. Intro.
Elim TI5.
Elim TI1.
Elim LemLin5.
Elim T1'. 
Elim TI5.
Elim TI1.
ElimType <proc> (seq (ia D r1 d1) (seq (ia one tau i) (hide I'' (Y1' d1))))
               =(seq (ia D r1 d1) (hide I'' (Y1' d1))).
2:Apply sym_equal.
2:Apply T1'.

Elim KFlin5. 
Elim T1'. 
Elim LemLin6.
Elim TI5.
Elim TI1. 
Elim KFlin6.
Elim T1'.
Apply refl_equal.
Exact IntauI''.
Exact Inr1I''.
Exact Inr1I.
Exact IntauI''.
Exact Inr1I''.
Exact Inr1I.
 
Save Hurrah.

