Require Ensembles.
Require Relations.
Require podefs.

Section The_power_set_partial_order.
   Variable U: Type.
   Variable B: (Ensemble U).
   
   Theorem Extension.
    Statement (B: (Ensemble U)) (C: (Ensemble U)) <(Ensemble U)> C == B ->
               (Same_set U C B).
    Goal.
   (Intros B C H'; Rewrite -> H'); Auto.
   Save.
   
   Theorem Empty_set_minimal.
    Statement (X: (Ensemble U)) (Included U (Empty_set U) X).
    Goal.
   Red; Intros X x H'; Elim H'.
   Save.
   Hint Empty_set_minimal.
   
   Theorem Power_set_non_empty.
    Statement (Non_empty (Ensemble U) (Power_set U B)).
    Goal.
   Red; Exists (Empty_set U); Auto.
   Save.
   Hint Power_set_non_empty.
   
   Theorem Inclusion_is_an_order.
    Statement (Order (Ensemble U) (Included U)).
    Goal.
   Auto 8.
   Save.
   Hint Inclusion_is_an_order.
   
   Theorem Inclusion_is_transitive.
    Statement (Transitive (Ensemble U) (Included U)).
    Goal.
   Auto 8.
   Save.
   Hint Inclusion_is_transitive.
   
   Theorem Same_set_equivalence.
    Statement (Equivalence (Ensemble U) (Same_set U)).
    Goal.
   Unfold 1 Same_set; Auto.
   Save.
   
   Theorem Same_set_reflexive.
    Statement (Reflexive (Ensemble U) (Same_set U)).
    Goal.
   Auto.
   Save.
   Hint Same_set_reflexive.
   (* I think Power_set_po would be a better name *)
   
   Theorem Power_po.
    Statement (PO (Ensemble U)).
    Goal.
   Apply Po_intro with (Power_set U B) (Included U); Auto.
   Save.
   
   Theorem Union_minimal.
    Statement (a,b,X: (Ensemble U)) (Included U a X) -> (Included U b X) ->
               (Included U (Union U a b) X).
    Goal.
   Unfold Included.
   (Intros a b X H' H'0 x H'1; Elim H'1); Auto.
   Save.
   Hint Union_minimal.
   (* Here, it is amazing, but 'Hint Unfold Intersection.' does not help *)
   
   Theorem Intersection_maximal.
    Statement (a,b,X: (Ensemble U)) (Included U X a) -> (Included U X b) ->
               (Included U X (Intersection U a b)).
    Goal.
   Unfold Intersection; Auto.
   Save.
   
   Theorem Union_increases_l.
    Statement (a,b: (Ensemble U)) (Included U a (Union U a b)).
    Goal.
   Auto.
   Save.
   
   Theorem Union_increases_r.
    Statement (a,b: (Ensemble U)) (Included U b (Union U a b)).
    Goal.
   Auto.
   Save.
   
   Theorem Intersection_decreases_l.
    Statement (a,b: (Ensemble U)) (Included U (Intersection U a b) a).
    Goal.
   Unfold 1 Intersection.
   Unfold 1 Included.
   (Intros a b x H'; Elim H'); Auto.
   Save.
   
   Theorem Intersection_decreases_r.
    Statement (a,b: (Ensemble U)) (Included U (Intersection U a b) b).
    Goal.
   Unfold 1 Intersection.
   Unfold 1 Included.
   (Intros a b x H'; Elim H'); Auto.
   Save.
   Hint Union_increases_l Union_increases_r Intersection_decreases_l
        Intersection_decreases_r.
   (* Here again, it is amazing, but 'Hint Unfold Bottom Lower_bound.' does 
                         not help either *)
   
   Theorem Empty_set_is_Bottom.
    Statement (Bottom (Ensemble U) Power_po (Empty_set U)).
    Goal.
   Red; Red; Simpl; Auto.
   Save.
   Hint Empty_set_is_Bottom.
   
   Theorem Union_is_Lub.
    Statement (a,b: (Ensemble U)) (Included U a B) -> (Included U b B) ->
               (Lub
                  (Ensemble U) Power_po (Couple (Ensemble U) a b) (Union U a b)).
    Goal.
   (Intros a b H' H'0; Red); Auto.
   (Split; Red); Simpl.
   (Split; [Idtac | Intros y H'1; Elim H'1]); Auto; (Intro H'2; Elim H'2); Auto.
   (Intros y H'1; Red in H'1); Auto.
   (Elim H'1; Intros H'2 H'3; Clear H'1; Simpl in H'3); Auto 20.
   Save.
   
   Theorem Intersection_is_Glb.
    Statement (a,b: (Ensemble U)) (Included U a B) -> (Included U b B) ->
               (Glb
                  (Ensemble U) Power_po (Couple (Ensemble U) a b)
                  (Intersection U a b)).
    Goal.
   (Intros a b H' H'0; Red); Auto.
   (Split; Red); Simpl.
   (Split; [Red | Idtac]); Auto.
   Red; Generalize Inclusion_is_transitive; Intro IT; Red in IT;
    Apply IT with a; Auto.
   (Intros y H'1; Elim H'1); (Intro H'2; Elim H'2); Auto.
   (Intros y H'1; Elim H'1); Simpl; Auto 20.
   Save.
   
   Theorem Empty_set_zero.
    Statement (X: (Ensemble U)) <(Ensemble U)> (Union U (Empty_set U) X) == X.
    Goal.
   Intro X; Apply Extensionality_Ensembles; Auto.
   Save.
   
   Theorem Union_commutative.
    Statement (A: (Ensemble U)) (B: (Ensemble U))
               <(Ensemble U)> (Union U A B) == (Union U B A).
    Goal.
   Auto.
   Save.
   
   Theorem Union_associative.
    Statement (A,B,C: (Ensemble U))
               <(Ensemble U)>
                 (Union U (Union U A B) C) == (Union U A (Union U B C)).
    Goal.
   Auto 20.
   Save.
   
   Theorem Strict_super_set_contains_new_element.
    Statement (X: (Ensemble U))
              (Y: (Ensemble U)) (Included U X Y) -> ~ <(Ensemble U)> X == Y ->
               (Non_empty U (Setminus U Y X)).
    Goal.
   (Intros X Y H' H'0; Try Assumption); Auto.
   Apply not_empty_non_empty; Auto.
   (Red; Intro H'1; Try Exact H'1); Auto.
   (Elim H'0; Try Assumption); Auto.
   Apply Extensionality_Ensembles; Auto.
   Red; Auto.
   (Split; [Try Assumption | Idtac]); Auto.
   Unfold 1 Setminus in H'1.
   Red; Auto.
   (Intros x H'2; Try Assumption); Auto.
   (Generalize (Excluded_Middle_sets U X x); Intro h; Elim h;
     [Intro H'3; Clear h; Try Exact H'3 | Clear h; Intro H'3]); Auto.
   Cut (In U (Empty_set U) x).
   (Intro H'4; Elim H'4); Auto.
   Rewrite -> H'1; Auto.
   Save.
   Hint Strict_super_set_contains_new_element.
   
   Theorem Non_disjoint_union.
    Statement (X: (Ensemble U)) (x: U) (In U X x) ->
               <(Ensemble U)> (Union U (Singleton U x) X) == X.
    Goal.
   (Intros X x H'; Try Assumption); Auto.
   Apply Extensionality_Ensembles; Auto.
   Red; Auto.
   (Split; [Idtac | Try Assumption]); Auto.
   Red; Auto.
   (Intros x0 H'0; Elim H'0); Auto.
   (Intro H'1; Elim H'1); Auto.
   Save.
   
   Theorem Finite_plus_one_is_finite.
    Statement (X: (Ensemble U)) (x: U) (Finite U X) ->
               (Finite U (Union U (Singleton U x) X)).
    Goal.
   (Intros X x H'; Try Assumption); Auto.
   (Generalize (Excluded_Middle_sets U X x); Intro h; Elim h;
     [Intro H'0; Clear h; Try Exact H'0 | Clear h; Intro H'0]); Auto.
   (Generalize (Non_disjoint_union X x); Intro h; Use h;
     [Intro H'1; Rewrite -> H'1; Clear h | Clear h]); Auto.
   Save.
   Hint Finite_plus_one_is_finite.
   
   Theorem Union_of_finite_is_finite.
    Statement (X,Y: (Ensemble U)) (Finite U X) -> (Finite U Y) ->
               (Finite U (Union U X Y)).
    Goal.
   (Intros X Y H'; Elim H'); Auto.
   (Generalize (Empty_set_zero Y); Intro h; Rewrite -> h; Clear h); Auto.
   (Intros A H'0 H'1 x H'2 H'3; Try Assumption); Auto.
   (Generalize (Union_associative (Singleton U x) A Y); Intro h; Rewrite -> h;
     Clear h); Auto.
   Save.
   
End The_power_set_partial_order.
Hint Empty_set_minimal.
Hint Power_set_non_empty.
Hint Inclusion_is_an_order.
Hint Inclusion_is_transitive.
Hint Same_set_reflexive.
Hint Union_minimal.
Hint Same_set_reflexive.
Hint Union_increases_l.
Hint Union_increases_r.
Hint Intersection_decreases_l.
Hint Intersection_decreases_r.
Hint Empty_set_is_Bottom.
Hint Empty_set_zero.
Hint Strict_super_set_contains_new_element.
Provide ps.


