Require Ensembles.
Require Relations.

Section Partial_orders.
   Variable U: Type.
   
   Inductive Definition PO : Type =
         Po_intro:
           (C: (Ensemble U)) (R: (Relation U)) (Non_empty U C) /\ (Order U R) ->
            PO.
   
   Definition Carrier =  (Ensemble U).
   
   Definition Rel =  (Relation U).
   
   Theorem Carrier_of.
    Statement PO -> Carrier.
    Goal.
   Intro H'; Elim H'.
   Intros C R H'0; Try Assumption.
   Save.
   
   Theorem Rel_of.
    Statement PO -> Rel.
    Goal.
   (Intro H'; Elim H'); Auto.
   Save.
   
   Definition SRel_of : PO -> Rel =
      [p: PO] [x,y: U] (Rel_of p x y) /\ ~ <U> x == y.
   
   (***************************)
   Variable D: PO.
   
   Local C =  (Carrier_of D).
   
   Local R =  (Rel_of D).
   
   Definition Totally_ordered : (Ensemble U) -> Prop =
      [B: (Ensemble U)] (Included U B C) ->
       (x: U) (y: U) (Included U (Couple U x y) B) -> (R x y) \/ (R y x).
   
   Definition Upper_Bound : (Ensemble U) -> U -> Prop =
      [B: (Ensemble U)] [x: U] (In U C x) /\ ((y: U) (In U B y) -> (R y x)).
   
   Definition Lower_Bound : (Ensemble U) -> U -> Prop =
      [B: (Ensemble U)] [x: U] (In U C x) /\ ((y: U) (In U B y) -> (R x y)).
   
   Definition Lub : (Ensemble U) -> U -> Prop =
      [B: (Ensemble U)] [x: U]
       (Upper_Bound B x) /\ ((y: U) (Upper_Bound B y) -> (R x y)).
   
   Definition Glb : (Ensemble U) -> U -> Prop =
      [B: (Ensemble U)] [x: U]
       (Lower_Bound B x) /\ ((y: U) (Lower_Bound B y) -> (R y x)).
   
   Definition Bottom : U -> Prop =  [bot: U] (Lower_Bound C bot).
   
   Definition Compatible : U -> U -> Prop =
      [x: U] [y: U]
       <U> ExT([z: U]
       (In U C x) -> (In U C y) -> (In U C z) /\ (Upper_Bound (Couple U x y) z)).
   
   Definition Directed : (Ensemble U) -> Prop =
      [X: (Ensemble U)]
       (Non_empty U X) /\
       ((Included U X C) /\
        ((x1: U) (x2: U) (Included U (Couple U x1 x2) X) ->
          <U> ExT([x3: U] (In U X x3) /\ (Upper_Bound (Couple U x1 x2) x3)))).
   
   Definition Complete : Prop =
      (<U> ExT([bot: U] (Bottom bot))) /\
      ((X: (Ensemble U)) (Directed X) -> <U> ExT([bsup: U] (Lub X bsup))).
   
   Definition Cpo : Prop =  Complete.
   
   Definition Chain : (Ensemble U) -> Prop =
      [X: (Ensemble U)] (Non_empty U X) /\ (Totally_ordered X).
   
   Definition Conditionally_complete : Prop =
      (X: (Ensemble U)) (<U> ExT([maj: U] (Upper_Bound X maj))) ->
       <U> ExT([bsup: U] (Lub X bsup)).
   
End Partial_orders.
Hint Unfold Carrier_of.
Hint Unfold Rel_of.
Hint Unfold Lower_Bound.
Hint Unfold Upper_Bound.
Hint Unfold Lub.
Hint Unfold Glb.
Hint Unfold Bottom.
Hint Unfold Compatible.
Hint Unfold Directed.
Hint Unfold Directed.
Provide podefs.


