
(* Initial Version: Frederic Prost, July 1993 
             Revised Version: Gilles Kahn, September 1993   
             INRIA Sophia-Antipolis, FRANCE   
            *)
Require Ensembles.
Require Relations.
Require podefs.
Require algpodefs.

Section Lemmas_on_partial_orders.
   Variable U: Type.
   Variable B: (Ensemble U).
   Variable D: (PO U).
   
   Theorem Rel_of_reflexive.
    Statement (x: U) (Rel_of U D x x).
    Goal.
   Elim D; Auto.
   (Intros C R a; Try Assumption); Auto.
   (Elim a; Intros H' H'0; Red in H'0); Auto.
   (Elim H'0; Intros h H'1; Elim h; Intros H'2 H'3; Clear H'0 h; Red in H'2);
    Auto.
   Save.
   Hint Rel_of_reflexive.
   
   Theorem Couple_included_in_carrier.
    Statement (x: U)
              (y: U) (In U (Carrier_of U D) x) -> (In U (Carrier_of U D) y) ->
               (Included U (Couple U x y) (Carrier_of U D)).
    Goal.
   Intros x y H' H'0; Red.
   (Intros x0 H'1; Elim H'1); (Intro H'2; Elim H'2); Auto.
   Save.
   Hint Couple_included_in_carrier.
   
   Theorem Lub_is_in_Carrier.
    Statement (bsup: U)
              (X: (Ensemble U))
              (Included U X (Carrier_of U D)) -> (Lub U D X bsup) ->
               (In U (Carrier_of U D) bsup).
    Goal.
   (Intros bsup X H' H'0; Red in H'0); Auto.
   (Elim H'0; Intros H'1 H'2; Clear H'0; Elim H'1); Auto.
   Save.
   
   Theorem Singleton_has_lub.
    Statement (x: U) (In U (Carrier_of U D) x) -> (Lub U D (Singleton U x) x).
    Goal.
   (Intros x H'; Red); Auto.
   (Split; [Idtac | Intros y H'0; Elim H'0]); Auto.
   Red; Auto.
   (Split; [Idtac | Intros y H'0; Elim H'0]); Auto.
   Save.
   Hint Singleton_has_lub.
   
   Theorem Empty_set_has_Upper_Bound.
    Statement <U> ExT([maj: U] (Upper_Bound U D (Empty_set U) maj)).
    Goal.
   Elim D; Auto.
   (Intros C R a; Try Assumption); Auto.
   (Elim a; Intros H' H'0; Red in H'); Auto.
   (Elim H'; Intros x E; Clear H'; Try Exact E); Auto.
   (Exists x; Red; Simpl); Auto.
   (Split; [Idtac | Intros y H'; Elim H']); Auto.
   Save.
   Hint Empty_set_has_Upper_Bound.
   
   Theorem Empty_set_has_lub.
    Statement (Cpo U D) -> <U> ExT([bsup: U] (Lub U D (Empty_set U) bsup)).
    Goal.
   (Intro H'; Red in H'; Red in H'); Auto.
   (Elim H'; Intros h H'0; Elim h; Intros bot E; Clear H' h; Red in E; Red in E);
    Auto.
   (Elim E; Intros H' H'1; Clear E; Try Exact H'); Auto.
   (Exists bot; Red); Auto.
   (Split; [Red | Idtac]); Auto.
   (Split; [Idtac | Intros y H'2; Elim H'2]); Auto.
   (Intros y H'2; Elim H'2); Auto.
   Save.
   Hint Empty_set_has_lub.
   
   Theorem Upper_downward_stable.
    Statement (A: (Ensemble U))
              (B: (Ensemble U))
              (maj: U)
              (Included U A (Carrier_of U D)) ->
              (Included U B (Carrier_of U D)) ->
              (Included U A B) -> (Upper_Bound U D B maj) ->
               (Upper_Bound U D A maj).
    Goal.
   Unfold Upper_Bound.
   (Intros A B maj H' H'0 H'1 h; Elim h; Intros H'2 H'3; Clear h; Try Exact H'2);
    Auto.
(*   Red in H'1; Auto.*)
   Save.
   
   Theorem Conditionally_complete_has_a_bottom.
    Statement (Conditionally_complete U D) -> <U> ExT([bot: U] (Bottom U D bot)).
    Goal.
   Intro H'; Red in H'.
   Generalize (H' (Empty_set U)); Intro H'0; Try Exact H'0.
   (Use H'0; [Intro H'1; Clear H'0 | Try Assumption]); Auto.
   Elim H'1; Intros bsup E; Clear H'1; Exists bsup.
   Red in E; Red; Red.
   Elim E; Intros H'0 H'1; Clear E; Red in H'0.
   (Elim H'0; Intros H'2 H'3; Clear H'0; Try Exact H'2); Auto.
   (Split; [Idtac | Intros y H'0; Apply H'1]); Auto.
   Red; (Split; [Idtac | Intros y0 H'4; Elim H'4]); Auto.
   Save.
   Hint Conditionally_complete_has_a_bottom.
   
   Theorem Coherent_has_a_bottom.
    Statement (Coherent U D) -> <U> ExT([bot: U] (Bottom U D bot)).
    Goal.
   (Intro H'; Red in H'); Auto.
   Generalize (H' (Empty_set U)); Intro H'0; Clear H'.
   (Use H'0; [Intro h; Elim h; Intros bsup E; Clear H'0 h; Red in E | Idtac]);
    Auto.
   (Exists bsup; Red); Auto.
   Red; Auto.
   (Elim E; Intros H' H'0; Clear E; Red in H'); Auto.
   (Elim H'; Intros H'1 H'2; Clear H'; Try Exact H'1); Auto.
   (Split; [Idtac | Intros y H'; Try Assumption]); Auto 20.
   Apply H'0; Auto.
   Red; Auto.
   (Split; [Idtac | Intros y0 H'3; Elim H'3]); Auto.
   Red; Auto.
   (Intros H' x y H'1; Red in H'1); Auto.
   (Generalize (H'1 x); Intro h; Use h;
     [Intro H'2; Clear h | Clear h; Try Assumption]); Auto 20.
   Elim H'2; Auto.
   Save.
   Hint Coherent_has_a_bottom.
   
   Theorem Bottom_is_compact.
    Statement (Conditionally_complete U D) ->
               <U> ExT([bot: U] (Bottom U D bot) /\ (Compact U D bot)).
    Goal.
   Intro H'; Use Conditionally_complete_has_a_bottom;
    [Intro H'0; Clear | Try Assumption].
   (Elim H'0; Intros bot E; Clear H'0; Try Exact E); Auto.
   (Exists bot; Split; [Idtac | Red]); Auto.
   Red in E; Red in E.
   (Elim E; Intros H'0 H'1; Clear E; Try Exact H'0); Auto.
   (Split; [Idtac | Intros X H'2; Red in H'2]); Auto.
   (Elim H'2; Intros H'3 H'4; Clear H'2; Red in H'3); Auto.
   (Elim H'3; Intros x E; Clear H'3; Try Exact E); Auto.
   (Elim H'4; Intros H'2 H'3; Clear H'4; Red in H'2); Auto.
   (Intro H'4; Exists x; Split; [Idtac | Try Assumption]); Auto.
   Save.
   Hint Bottom_is_compact.
   
   Theorem Compact_is_in_Carrier.
    Statement (x: U) (Compact U D x) -> (In U (Carrier_of U D) x).
    Goal.
   (Intros x H'; Elim H'); Auto.
   Save.
   Hint Compact_is_in_Carrier.
   
   Theorem Compatible_is_reflexive.
    Statement (Reflexive U (Compatible U D)).
    Goal.
   Elim D; Intros C R a.
   Elim a; Intros H' H'0; Red in H'0.
   Elim H'0; Intros h H'1; Elim h; Intros H'2 H'3; Clear H'0 h; Red in H'2.
   Red; Red; Auto.
   (Intro x; Exists x; Intros H'0 H'4; Split; [Idtac | Red; Simpl]); Auto.
   (Split; [Idtac | Intros y H'5; Elim H'5; Intro H'6; Elim H'6]); Auto.
   Save.
   
   Theorem Couple_is_symmetric.
    Statement (x: U) (y: U) <(Ensemble U)> (Couple U x y) == (Couple U y x).
    Goal.
   (Intros x y; Apply Extensionality_Ensembles); Red.
   (Split; Red); (Intros x0 H'; Elim H'); Auto.
   Save.
   
   Theorem Compatible_is_symmetric.
    Statement (Symmetric U (Compatible U D)).
    Goal.
   Red; Unfold Compatible.
   (Intros x y h; Elim h; Intros z E; Clear h; Try Exact E); Auto.
   Elim Couple_is_symmetric; (Exists z; Try Assumption); Auto.
   Save.
   
   Theorem Compatible_imp_consistent.
    Statement (x: U) (y: U) (Compatible U D x y) ->
               (Consistent U D (Couple U x y)).
    Goal.
   (Intros x y H'; Red); Auto.
   Red in H'; Auto.
   (Elim H'; Intros z E; Clear H'; Try Exact E); Auto.
   (Intros H' x0 y0 H'0; Red); Auto.
   Red in H'; Auto.
   (Generalize (H' x); Intro h; Use h;
     [Intro H'1; Clear h | Clear h; Try Assumption]); Auto 20.
   (Use E; [Intro H'2; Clear E | Try Assumption]); Auto.
   (Generalize (H' y); Intro h; Use h;
     [Intro H'3; Clear h | Clear h; Try Assumption]); Auto 20.
   (Use H'2; [Intro H'4; Clear H'2 | Try Assumption]); Auto.
   (Elim H'4; Intros H'2 H'5; Clear H'4; Try Exact H'5); Auto.
   (Exists z; Intros H'4 H'6; Split; [Idtac | Try Assumption]); Auto.
   Apply Upper_downward_stable with (Couple U x y); Auto 20.
   Save.
   
   Theorem Consistent_imp_compatible.
    Statement (x: U)
              (y: U)
              (In U (Carrier_of U D) x) ->
              (In U (Carrier_of U D) y) -> (Consistent U D (Couple U x y)) ->
               (Compatible U D x y).
    Goal.
   (Intros x y H' H'0 H'1; Red in H'1); Auto.
   Save.
   
   Theorem Coherent_implies_Conditionally_Complete.
    Statement (Coherent U D) -> (Conditionally_complete U D).
    Goal.
   (Intro H'; Red in H'); Auto.
   Red; Auto.
   (Intros X H'0; Try Assumption); Auto.
   Apply H'; Auto.
   (Elim H'0; Intros maj E; Clear H'0; Try Exact E); Auto.
   Red; Auto.
   (Intros H'0 x y H'1; Red); Auto.
   Generalize E; Intro E0.
   Red in E; Auto.
   (Elim E; Intros H'2 H'3; Clear E; Try Exact H'2); Auto.
   (Exists maj; Intros H'4 H'5; Split; [Idtac | Try Assumption]); Auto.
(*   Apply Upper_downward_stable with X; Auto.*)
   Save.
   
   Theorem Coherent_implies_Complete.
    Statement (Coherent U D) -> (Complete U D).
    Goal.
   (Intro H'; Red); Auto.
   (Use Coherent_has_a_bottom; [Intro H'0; Clear | Try Assumption]); Auto.
   (Split; [Idtac | Intros X H'1; Try Assumption]); Auto.
   Apply H'; Auto.
   Red; Auto.
   Red in H'1; Auto.
   (Intros H'2 x y H'3; Red); Auto.
   (Elim H'1; Intros H'4 h; Elim h; Intros H'5 H'6; Clear H'1 h; Try Exact H'6);
    Auto.
   (Generalize (H'6 x y); Intro h; Use h;
     [Intro H'1; Clear h | Clear h; Try Assumption]); Auto.
   (Elim H'1; Intros x3 h; Elim h; Intros H'7 H'8; Clear H'1 h; Try Exact H'8);
    Auto.
   Red in H'5; Auto.
   (Exists x3; Intros H'1 H'9; Split; [Idtac | Try Assumption]); Auto.
   Save.
   
End Lemmas_on_partial_orders.
Hint Couple_included_in_carrier.
Hint Singleton_has_lub.
Hint Empty_set_has_Upper_Bound.
Hint Empty_set_has_lub.
Hint Conditionally_complete_has_a_bottom.
Hint Coherent_has_a_bottom.
Hint Compact_is_in_Carrier.
Provide lpo.


