
(*       Initial Version: Frederic Prost, July 1993      
                     Revised Version: Gilles Kahn, September 1993    
                     Revised again: G.K., November 1993 for more automatic proofs  
                     INRIA Sophia-Antipolis, FRANCE   
               *)
Require Ensembles.
Require Relations.
Require podefs.
Require algpodefs.
Require ps.
Require lpo.

Section Advanced_lemmas.
   Variable U: Type.
   Variable B: (Ensemble U).
   Variable D: (PO U).
   
   Theorem Rel_of_transitive.
    Statement (Transitive U (Rel_of U D)).
    Goal.
   Elim D; Auto.
   (Intros C R a; Try Assumption); Auto.
   (Elim a; Intros H' H'0; Red in H'0); Auto.
   (Elim H'0; Intros h H'1; Elim h; Intros H'2 H'3; Clear H'0 h; Red in H'3);
    Auto.
   Save.
   Hint Rel_of_transitive.
   
   Theorem Rel_of_antisymmetric.
    Statement (Antisymmetric U (Rel_of U D)).
    Goal.
   Elim D; Auto.
   (Intros C R a; Try Assumption); Auto.
   (Elim a; Intros H' H'0; Red in H'0); Auto.
   (Elim H'0; Intros H'1 H'2; Clear H'0; Red in H'2); Auto.
   Save.
   Hint Rel_of_antisymmetric.
   
   Theorem Non_empty_has_glb.
    Statement (Conditionally_complete U D) ->
               (X: (Ensemble U))
               (Included U X (Carrier_of U D)) /\ (Non_empty U X) ->
                <U> ExT([binf: U] (Glb U D X binf)).
    Goal.
   (Intro H'; Red in H'); Auto.
   (Intros X h; Elim h; Intros H'0 H'1; Clear h; Red in H'1); Auto.
   Red in H'0; Auto.
   (Elim H'1; Intros x E; Clear H'1; Try Exact E); Auto.
   Cut <U> ExT([maj: U] (Upper_Bound U D [z: U] (Lower_Bound U D X z) maj)).
   Intro H'1.
   (Generalize (H' [z: U] (Lower_Bound U D X z)); Intro h; Use h;
     [Intro H'2; Clear h | Clear h; Try Assumption]); Auto.
   (Elim H'2; Intros bsup E0; Clear H'2; Red in E0); Auto.
   Unfold Upper_Bound in E0.
   (Exists bsup; Red); Auto.
   Unfold Lower_Bound.
   Unfold Lower_Bound in E0.
   (Elim E0; Intros h H'2; Elim h; Intros H'3 H'4; Clear E0 h; Try Exact H'3);
    Auto.
   Generalize Rel_of_transitive; Intro RoT; Red in RoT.
   (Split; [Idtac | Intros y H'5; Try Assumption]); Auto 20.
   (Split; [Idtac | Intros y H'5; Try Assumption]); Auto.
   (Generalize (H'2 y); Intro h; Use h;
     [Intro H'6; Clear h; Try Exact H'6 | Clear h]); Auto.
   (Split; [Idtac | Intros y0 H'6; Try Assumption]); Auto.
   Apply RoT with bsup; Auto.
   (Generalize (H'2 y); Intro h; Use h;
     [Intro H'7; Clear h; Try Exact H'7 | Clear h]); Auto 20.
   (Split; [Idtac | Intros y10 H'7; Try Exact H'7]); Auto 20.
   Elim H'7; Auto.
   (Exists x; Red); Auto.
   Unfold 1 Lower_Bound.
   (Split; [Idtac | Intros y H'1; Try Exact H'1]); Auto.
   Elim H'1; Auto.
   Save.
   
   Theorem Lub_of_compacts_is_compact.
    Statement (Conditionally_complete U D) ->
               (x: U)
               (y: U)
               (Compact U D x) -> (Compact U D y) -> (Compatible U D x y) ->
                <U> ExT([bsup: U]
                (Lub U D (Couple U x y) bsup) /\ (Compact U D bsup)).
    Goal.
   (Intros H' x y H'0 H'1 H'2; Red in H'2); Auto.
   Red in H'; Auto.
   (Elim H'2; Intros z E; Use E;
     [Intro H'3; Use H'3;
       [Intro h; Elim h; Intros H'4 H'5; Clear H'2 E H'3 h; Try Exact H'5 |
         Clear H'2 E] | Clear H'2]); Auto.
   (Generalize (H' (Couple U x y)); Intro h; Use h;
     [Intro H'2; Clear h | Exists z; Clear h; Try Assumption]); Auto.
   (Elim H'2; Intros bsup E; Clear H'2; Try Exact E); Auto.
   (Exists bsup; Split; [Idtac | Red]); Auto.
   Red in E; Auto.
   (Elim E; Intros H'2 H'3; Clear E; Red in H'2); Auto.
   (Elim H'2; Intros H'6 H'7; Clear H'2; Try Exact H'6); Auto.
   (Split; [Idtac | Intros X H'2 H'8; Try Assumption]); Auto.
   Red in H'1; Red in H'0; Auto.
   (Elim H'1; Intros H'9 H'10; Clear H'1; Try Exact H'9); Auto.
   (Elim H'0; Intros H'1 H'11; Clear H'0; Try Exact H'1); Auto.
   (Elim H'8; Intros bsup0 h; Elim h; Intros H'0 H'12; Clear H'8 h;
     Try Exact H'12); Auto.
   Generalize Rel_of_transitive; Intro RoT; Red in RoT.
   (Generalize (H'7 x); Intro h; Use h;
     [Intro H'8; Clear h | Clear h; Try Assumption]); Auto 20.
   (Generalize (H'7 y); Intro h; Use h;
     [Intro H'13; Clear h | Clear h; Try Assumption]); Auto 20.
   (Generalize (H'10 X); Intro h; Use h;
     [Intro H'14; Use H'14;
       [Intro H'15; Clear h H'14 |
         Exists bsup0; Split; [Clear h | Clear h; Try Assumption]] | Clear h]);
    Auto.
   2:Apply RoT with bsup; Auto.
   (Generalize (H'11 X); Intro h; Use h;
     [Intro H'14; Use H'14;
       [Intro H'16; Clear h H'14 |
         Exists bsup0; Split; [Clear h | Clear h; Try Assumption]] | Clear h]);
    Auto.
   2:Apply RoT with bsup; Auto.
   (Elim H'16; Intros y0 h; Elim h; Intros H'14 H'17; Clear H'16 h;
     Try Exact H'17); Auto.
   (Elim H'15; Intros y1 h; Elim h; Intros H'16 H'18; Clear H'15 h;
     Try Exact H'18); Auto.
   Generalize H'2; Intro H'20.
   Red in H'2; Auto.
   (Elim H'2; Intros H'15 h; Elim h; Intros H'19 H'21; Generalize (H'21 y1 y0);
     Intro h0; Use h0; [Intro H'22; Clear H'2 h h0 | Clear H'2 h h0; Red]); Auto.
   2:(Intros x0 H'2; Elim H'2); Auto.
   2:(Intro H'22; Elim H'22); Auto.
   2:(Intro H'22; Elim H'22); Auto.
   (Elim H'22; Intros x3 h; Elim h; Intros H'2 H'23; Clear H'22 h;
     Try Exact H'23); Auto.
   (Exists x3; Split; [Idtac | Try Assumption]); Auto.
   Apply H'3; Auto.
   Red; Auto.
   Red in H'19; Auto.
   Red in H'23; Auto.
   (Elim H'23; Intros H'22 H'24; Generalize (H'24 y1); Intro h; Use h;
     [Intro H'25; Clear H'23 h | Clear H'23 h; Try Assumption]); Auto 20.
   (Generalize (H'24 y0); Intro h; Use h;
     [Intro H'23; Clear h | Clear h; Try Assumption]); Auto 20.
   (Split; [Idtac | Intros y2 H'26; Elim H'26]); Auto 20.
   (Intro H'27; Elim H'27); Apply RoT with y0; Auto 20.
   (Intro H'27; Elim H'27); Apply RoT with y1; Auto 20.
   Save.
   
   Theorem Approximants_directed_set.
    Statement (Conditionally_complete U D) ->
               (x: U) (In U (Carrier_of U D) x) ->
                (Directed U D (Approximants U D x)).
    Goal.
   (Intros H' x H'0; Red); Auto.
   (Split; [Red | Idtac]); Auto.
   (Generalize (Bottom_is_compact U D); Intro h; Use h;
     [Intro H'1; Clear h | Clear h; Try Assumption]); Auto.
   (Elim H'1; Intros bot h; Elim h; Intros H'2 H'3; Clear H'1 h; Red in H'2);
    Auto.
   (Exists bot; Try Assumption); Auto.
   Red; Red; Auto.
   Elim H'2; Auto.
   (Split; [Red | Idtac]); Auto.
   (Intros x0 H'1; Elim H'1); Auto.
   (Intros x1 x2 H'1; Red in H'1); Auto.
   (Generalize (H'1 x1); Intro h; Use h;
     [Intro H'2; Clear h | Clear h; Try Assumption]); Auto 20.
   (Generalize (H'1 x2); Intro h; Use h;
     [Intro H'3; Clear h | Clear h; Try Assumption]); Auto 20.
   Red in H'3; Red in H'3.
   Red in H'2; Red in H'2.
   (Elim H'3; Intros H'4 H'5; Clear H'3; Try Exact H'4); Auto.
   (Elim H'2; Intros H'3 H'6; Clear H'2; Try Exact H'3); Auto.
   (Use Lub_of_compacts_is_compact;
     [Intro H'2; Generalize (H'2 x1 x2); Intro h; Use h;
       [Intro H'7; Use H'7;
         [Intro H'8; Use H'8;
           [Intro H'9; Clear h H'7 H'8 | Clear h H'7; Try Assumption] | Clear h] |
         Clear h] | Idtac]); Auto.
   2:Red; Auto.
   2:(Exists x; Intros H'7 H'9; Split; [Idtac | Auto]); Auto 20.
   2:Red; Auto.
   2:(Split; [Idtac | Intros y H'10; Elim H'10]); Auto; (Intro H'11; Elim H'11);
      Auto.
   (Elim H'9; Intros bsup h; Elim h; Intros H'7 H'8; Clear H'9 h; Try Exact H'7);
    Auto.
   (Exists bsup; Split; [Red | Idtac]); Auto.
   Red; Auto.
   (Split; [Idtac | Try Assumption]); Auto.
   Red in H'7; Auto.
   (Elim H'7; Intros H'9 H'10; Clear H'7; Apply H'10); Auto.
   Red; Auto.
   (Split; [Idtac | Intros y H'7; Elim H'7]); Auto; (Intro H'11; Elim H'11);
    Auto 20.
   Elim H'7; Auto.
   Save.
   
   Theorem Inclusion_of_Approximants.
    Statement (Domain U D) ->
               (x,y: U)
               (In U (Carrier_of U D) x) ->
               (In U (Carrier_of U D) y) ->
               (Included U (Approximants U D x) (Approximants U D y)) ->
                (Rel_of U D x y).
    Goal.
   (Intros H' x y H'0 H'1 H'2; Try Assumption); Auto.
   Red in H'; Elim H'; Intros H'3 H'4; Clear H'; Red in H'4.
   (Elim H'4; Intros H' H'5; Clear H'4; Red in H'); Auto.
   (Generalize (H' x); Intro h; Elim h; Intros H'4 H'6; Clear h; Red in H'6);
    Auto.
   (Elim H'6; Intros H'7 H'8; Clear H'6; Apply H'8); Auto.
   (Generalize (H' y); Intro h; Elim h; Intros H'6 H'9; Clear h; Try Exact H'9);
    Auto.
   Apply Upper_downward_stable with (Approximants U D y); Auto.
   3:Elim H'9; Auto.
   Red; (Intros x0 H'10; Elim H'10); Auto.
   Red; (Intros x0 H'10; Elim H'10); Auto.
   Save.
   Hint Inclusion_of_Approximants.
   
   Theorem Less_imp_Inclusion_of_Approximants.
    Statement (Domain U D) ->
               (x,y: U)
               (In U (Carrier_of U D) x) ->
               (In U (Carrier_of U D) y) -> (Rel_of U D x y) ->
                (Included U (Approximants U D x) (Approximants U D y)).
    Goal.
   Intros H' x y H'0 H'1 H'2; Red; Unfold Approximants; Unfold In.
   Generalize Rel_of_transitive; Intro RoT; Red in RoT.
   (Intros x0 h; Elim h; Intros H'3 H'4; Clear h; Try Exact H'4); Auto.
   (Split; [Idtac | Apply RoT with x]); Auto.
   Save.
   
   Theorem Corollary1_1.
    Statement (Domain U D) ->
               (x,y: U)
               (Compact U D x) ->
               (In U (Carrier_of U D) y) -> (SRel_of U D x y) ->
                <U> ExT([z: U]
                (In U (Approximants U D y) z) /\ (SRel_of U D x z)).
    Goal.
   Unfold SRel_of.
   (Intros H' x y H'0 H'1 h; Elim h; Intros H'2 H'3; Clear h; Try Exact H'2);
    Auto.
   (Use Less_imp_Inclusion_of_Approximants;
     [Intro H'4; Generalize (H'4 x y); Intro h; Use h;
       [Intro H'5; Use H'5;
         [Intro H'6; Use H'6;
           [Intro H'7; Clear h H'5 H'6 | Clear h H'5; Try Assumption] | Clear h] |
         Clear h] | Idtac]); Auto.
   (Generalize (Strict_super_set_contains_new_element
                  U (Approximants U D x) (Approximants U D y)); Intro h; Use h;
     [Intro H'5; Use H'5; [Intro H'6; Clear h H'5; Try Exact H'6 | Clear h] |
       Clear h]); Auto.
   Red in H'6; (Elim H'6; Intros x0 E; Clear H'6; Red in E; Red in E); Auto.
   (Elim E; Intros H'5 H'6; Clear E; Try Exact H'5); Auto.
   Red in H'5; Red in H'5; Auto.
   (Elim H'5; Intros H'8 H'9; Clear H'5; Try Exact H'9); Auto.
   (Use Lub_of_compacts_is_compact;
     [Intro H'5; Generalize (H'5 x0 x); Intro h; Use h;
       [Intro H'10; Use H'10;
         [Intro H'11; Use H'11;
           [Intro H'12; Clear h H'10 H'11 | Clear h H'10; Try Assumption] |
           Clear h] | Clear h] | Idtac]); Auto.
   2:Red; Auto.
   2:(Exists y; Intros H'10 H'12; Split; [Idtac | Red]); Auto.
   2:(Split; [Idtac | Intros y0 H'13; Elim H'13]); Auto;
      (Intro H'14; Elim H'14); Auto.
   2:Red in H'; (Elim H'; Intros H'5 H'10; Clear H'; Try Exact H'5);
      Apply Coherent_implies_Conditionally_Complete; Auto.
   (Elim H'12; Intros bsup h; Elim h; Intros H'10 H'11; Clear H'12 h;
     Red in H'10); Auto.
   (Exists bsup; Split; [Red; Red | Split; [Try Assumption | Idtac]]); Auto.
   (Split; [Idtac | Try Assumption]); Auto.
   (Elim H'10; Intros H'12 H'13; Clear H'10; Apply H'13); Auto.
   Red; Auto.
   (Split; [Idtac | Intros y0 H'10; Elim H'10]); Auto; (Intro H'14; Elim H'14);
    Auto.
   (Elim H'10; Intros H'12 H'13; Clear H'10; Red in H'12); Auto.
   (Elim H'12; Intros H'10 H'14; Generalize (H'14 x); Intro h; Use h;
     [Intro H'15; Clear H'12 h | Clear H'12 h; Try Assumption]); Auto 20.
   (Red; Intro H'12; Try Exact H'12); Auto.
   Apply H'6; Auto.
   Red; Red; Auto.
   Rewrite -> H'12; Auto.
   (Elim H'10; Intros H'13 H'14; Clear H'10; Red in H'13); Auto.
   (Elim H'13; Intros H'10 H'15; Generalize (H'15 x0); Intro h; Use h;
     [Intro H'16; Clear H'13 h | Clear H'13 h; Try Assumption]); Auto 20.
   (Red; Intro H'6; Try Exact H'6); Auto.
   Apply H'3; Auto.
   Apply Rel_of_antisymmetric; Auto.
   (Split; [Idtac | Try Assumption]); Auto.
   Specialize 4 Extension with 1:= H'6; Auto.
   (Intro H'8; Red in H'8); Auto.
   (Elim H'8; Intros H'9 H'10; Clear H'8; Try Exact H'10); Auto.
   Save.
   
End Advanced_lemmas.
Hint Inclusion_of_Approximants.
Provide alpo.


