
(* Initial Version: Frederic Prost, July 1993 
       Revised Version: Gilles Kahn, September 1993   
       INRIA Sophia-Antipolis, FRANCE   
      *)
Require Ensembles.
Require Relations.
Require podefs.

Section Algebraic_partial_orders.
   Variable U: Type.
   Variable D: (PO U).
   
   Local D_C =  (Carrier_of U D).
   
   Local D_R =  (Rel_of U D).
   
   Definition Consistent : (Ensemble U) -> Prop =
      [A: (Ensemble U)] (Included U A D_C) ->
       (x: U) (y: U) (Included U (Couple U x y) A) -> (Compatible U D x y).
   
   Definition Coherent : Prop =
      (A: (Ensemble U)) (Consistent A) -> <U> ExT([bsup: U] (Lub U D A bsup)).
   
   Definition Compact : U -> Prop =
      [x: U]
       (In U D_C x) /\
       ((X: (Ensemble U))
        (Directed U D X) ->
        (<U> ExT([bsup: U] (Lub U D X bsup) /\ (D_R x bsup))) ->
         <U> ExT([y: U] (In U X y) /\ (D_R x y))).
   
   Definition Approximants : U -> (Ensemble U) =
      [x: U] [y: U] (Compact y) /\ (D_R y x).
   
   Definition Algebraic : Prop =
      (x: U) (Directed U D (Approximants x)) /\ (Lub U D (Approximants x) x).
   
   Definition Denumerable : (Ensemble U) -> Prop =
      [A: (Ensemble U)]
       <U -> nat> Ex([f: U -> nat]
       (x: U) (y: U) (In U A x) /\ (In U A y) -> <nat> (f x) = (f y) ->
        <U> x == y).
   
   Definition Omega_algebraic : Prop =
      Algebraic /\ (Denumerable [x: U] (Compact x)).
   
   Definition Domain : Prop =  Coherent /\ Omega_algebraic.
   
End Algebraic_partial_orders.
Hint Unfold Compact.
Provide algpodefs.


