
(* Initial Version: Frederic Prost, July 1993 
             Revised Version: Gilles Kahn, September 1993   
             INRIA Sophia-Antipolis, FRANCE   
            *)
Require Logic_Type.
(* this hint is missing in Logic_Type V5.8.2 *)
Hint refl_eqT.

Section Relations.
   Variable U: Type.
   
   Definition Relation =  U -> U -> Prop.
   Variable R: Relation.
   
   Definition Reflexive : Prop =  (x: U) (R x x).
   
   Definition Transitive : Prop =  (x,y,z: U) (R x y) -> (R y z) -> (R x z).
   
   Definition Antisymmetric : Prop =
      (x: U) (y: U) (R x y) /\ (R y x) -> <U> x == y.
   
   Definition Order : Prop =  (Reflexive /\ Transitive) /\ Antisymmetric.
   
   Definition Symmetric : Prop =  (x,y: U) (R x y) -> (R y x).
   
   Definition Equivalence : Prop =  (Reflexive /\ Symmetric) /\ Transitive.
   
   Definition PER : Prop =  Symmetric /\ Transitive.
   
End Relations.
Hint Unfold Reflexive.
Hint Unfold Transitive.
Hint Unfold Antisymmetric.
Hint Unfold Order.
Hint Unfold Symmetric.
Hint Unfold Equivalence.
Hint Unfold PER.

Theorem sym_not_P.
 Statement (U: Type) (P: (Relation U)) (x,y: U) (Symmetric U P) -> ~ (P x y) ->
            ~ (P y x).
 Goal.
Intros U P x y H' H'0; Unfold 1 not; Intro H'1.
Apply H'0; Apply H'; Auto.
Save.

Theorem Equiv_from_order.
 Statement (U: Type) (R: (Relation U)) (Order U R) ->
            (Equivalence U [x,y: U] (R x y) /\ (R y x)).
 Goal.
Intros U R H'; Red.
Elim H'; Intros H'0 H'1; Elim H'0; Intros H'2 H'3; Clear H' H'0.
Split; [Split; Red | Red].
Intro x; Split; Try Exact (H'2 x).
Intros x y H'; Elim H'; Intros H'0 H'4; Clear H'; Auto.
Intros x y z H' H'0; Elim H'0; Intros H'4 H'5; Clear H'0; Elim H';
 Intros H'6 H'7; Clear H'.
Red in H'3.
Split; Apply H'3 with y; Auto.
Save.
Hint Equiv_from_order.
Provide Relations.


