
(* Initial Version: Frederic Prost, July 1993 
               Revised Version: Gilles Kahn, September 1993   
               INRIA Sophia-Antipolis, FRANCE   
              *)
Require Logic_Type.
(* this hint is missing in Logic_Type V5.8.2 *)
Hint refl_eqT.

Section Ensembles.
   Variable U: Type.
   
   Definition Ensemble =  U -> Prop.
   
   Definition Empty_set : Ensemble =  [x: U] False.
   
   Definition In : Ensemble -> U -> Prop =  [B: Ensemble] [x: U] (B x).
   
   Definition Non_empty : Ensemble -> Prop =
      [B: Ensemble] <U> ExT([x: U] (In B x)).
   
   Definition Included : Ensemble -> Ensemble -> Prop =
      [B: Ensemble] [C: Ensemble] (x: U) (In B x) -> (In C x).
   
   Definition Same_set : Ensemble -> Ensemble -> Prop =
      [B: Ensemble] [C: Ensemble] (Included B C) /\ (Included C B).
   
   Definition Union : Ensemble -> Ensemble -> Ensemble =
      [B: Ensemble] [C: Ensemble] [x: U] (In B x) \/ (In C x).
   
   Definition Intersection : Ensemble -> Ensemble -> Ensemble =
      [B: Ensemble] [C: Ensemble] [x: U] (In B x) /\ (In C x).
   
   Definition Singleton : U -> Ensemble =  [x: U] [y: U] <U> x == y.
   
   Definition Couple : U -> U -> Ensemble =
      [x: U] [y: U] (Union (Singleton x) (Singleton y)).
   
   Definition Setminus : Ensemble -> Ensemble -> Ensemble =
      [Y: Ensemble] [X: Ensemble] [x: U] (In Y x) /\ ~ (In X x).
   
   Definition Disjoint : Ensemble -> Ensemble -> Prop =
      [X: Ensemble] [Y: Ensemble] <Ensemble> (Intersection X Y) == Empty_set.
   
   Axiom Extensionality_Ensembles:
      (A: Ensemble) (B: Ensemble) (Same_set A B) -> <Ensemble> A == B.
   
   Inductive Definition Finite : Ensemble -> Prop =
         Empty_is_finite: (Finite Empty_set)
      | Union_is_finite:
          (A: Ensemble) (Finite A) ->
           (x: U) ~ (In A x) -> (Finite (Union (Singleton x) A)).
   Hint Empty_is_finite Union_is_finite.
   
   Axiom Excluded_Middle_sets: (X: Ensemble) (x: U) (In X x) \/ ~ (In X x).
   
   Axiom not_empty_non_empty:
      (A: Ensemble) ~ <Ensemble> Empty_set == A -> (Non_empty A).
   
   Definition Power_set : Ensemble -> Ensemble -> Prop =
      [A: Ensemble] [X: Ensemble] (Included X A).
   
End Ensembles.
Hint Unfold In.
Hint Unfold Included.
Hint Unfold Same_set.
Hint Unfold Union.
Hint Unfold Same_set.
Hint Unfold Intersection.
Hint Unfold Couple.
Hint Unfold Singleton.
Hint Unfold Power_set.
Hint Empty_is_finite Union_is_finite.
Hint Extensionality_Ensembles.
Hint not_empty_non_empty.
Provide Ensembles.


