
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


              (* Preuve de terminaison *)  

Require Pol1.
Require Pol2.

Section ordre.

Variable A : Set.
Variable f,g: A->nat.

Definition lexfg  [a,b:A] (gt (f a) (f b)) \/
                  (<nat>(f a)=(f b) /\ (gt (g a) (g b))).

Lemma lexfg_notherian: (noetherian A lexfg). 
Goal.
Unfold noetherian;Unfold universal;Unfold hereditary;
  Unfold adjoint;Unfold sub;Unfold set.
Intros P H.
Cut (n,m:nat)(a:A)(gt n (f a)) \/
    (<nat>n=(f a) /\ (gt m (g a)))->(P a).
Intros;Apply (H0 (S (f x)) O).
(* Auto *)Apply or_introl;Unfold gt;Unfold lt;Apply le_n.
Induction n;Induction m.
(* m=n=0 *)
Induction 1;Intro H1.
Absurd (gt O (f a));(* Auto *)[Apply le_not_gt;Apply le_O_n|Assumption].
Elim H1;Intros.
Absurd (gt O (g a));(* Auto *)[Apply le_not_gt;Apply le_O_n|Assumption].
(* n=0, m=(S y) *)
Intros y H' a H0.
Apply H;Intros b lexfgab. 
Apply H';Right.
Elim  H0;Intro H1.
Absurd (gt O (f a));(* Auto *)[Apply le_not_gt;Apply le_O_n|Assumption].
Elim H1;Intros H2 H3;Elim lexfgab;Intro H4.
Absurd (gt O (f b));(* Auto *)[Apply le_not_gt;Apply le_O_n|Rewrite H2;Assumption].
Elim H4;Intros.
Split.
Rewrite H2;Assumption.
Apply le_gt_trans with (g a);(* Auto *)[Apply gt_S_le;Assumption|Assumption].
(* n=(S y), m=0 *)
Intros a H0';Apply H;Intros b lexfgab.
Apply (H0 (g a) b);Elim H0';Intro H1.
Elim lexfgab;Intro H2.
Left;Apply le_gt_trans with (f a);(* Auto *)[Apply gt_S_le;Assumption|Assumption].
Elim H2;Intros H3 H4;Elim (gt_S y (f a) H1);Intro H5.
Left;Elim H3;Assumption.
Right;Split.
Elim H3;(* Auto *)Apply sym_equal;Assumption.
Assumption.
Elim H1;Intros H2 H3.
Absurd (gt O (g a));(* Auto *)[Apply le_not_gt;Apply le_O_n|Assumption].
(* n=(S y), m=(S y0) *)
Intros y0 H0' a H1;Apply H;Intros b lexfgab.
Apply H0';Elim H1;Elim lexfgab;Intros H2 H3.
Left;Apply le_gt_trans with (f a);(* Auto *)[Apply lt_le_weak;Assumption|Assumption].
Elim H2;Intros H4 H5;Left;Elim H4;Assumption.
Elim H3;Intros H4 H5;Left;Rewrite H4;Assumption.
Elim H2;Intros H4 H5;Elim H3;Intros H6 H7.
Right;Split.
Apply trans_equal with (f a);Assumption.
Apply le_gt_trans with (g a);(* Auto *)[Apply gt_S_le;Assumption|Assumption].
Save.

End ordre.

Goal (b:bool)(M,N:(TS b))(systemSL b M N)->(lexfg (TS b) (P1 b) (P2 b) M N).
Red;Induction 1;Intros.
Right;Split;[Apply P1_app;Assumption|Apply P2_app;Assumption].
Left;Apply P1_lambda;Assumption. 
Right;Split;[Apply P1_clos;Assumption|Apply P2_clos;Assumption].
Right;Split;[Apply P1_varshift1;Assumption|Apply P2_varshift1;Assumption].
Right;Split;[Apply P1_varshift2;Assumption|Apply P2_varshift2;Assumption].
Left;Apply P1_fvarcons;Assumption. 
Left;Apply P1_fvarlift1;Assumption. 
Left;Apply P1_fvarlift2;Assumption. 
Left;Apply P1_rvarcons;Assumption. 
Right;Split;[Apply P1_rvarlift1;Assumption|Apply P2_rvarlift1;Assumption]. 
Right;Split;[Apply P1_rvarlift2;Assumption|Apply P2_rvarlift2;Assumption]. 
Right;Split;[Apply P1_assenv;Assumption|Apply P2_assenv;Assumption]. 
Right;Split;[Apply P1_mapenv;Assumption|Apply P2_mapenv;Assumption]. 
Left;Apply P1_shiftcons;Assumption.
Right;Split;[Apply P1_shiftlift1;Assumption|Apply P2_shiftlift1;Assumption]. 
Right;Split;[Apply P1_shiftlift2;Assumption|Apply P2_shiftlift2;Assumption]. 
Right;Split;[Apply P1_lift1;Assumption|Apply P2_lift1;Assumption]. 
Right;Split;[Apply P1_lift2;Assumption|Apply P2_lift2;Assumption]. 
Left;Apply P1_liftenv;Assumption.
Left;Apply P1_idl;Assumption.
Left;Apply P1_idr;Assumption.
Right;Split;[Apply P1_liftid;Assumption|Apply P2_liftid;Assumption]. 
Left;Apply P1_id;Assumption.
Save lexfg_systemSL.

Goal (a,a',b:terms)(lexfg (TS false) (P1 false) (P2 false) a a')->
       (lexfg (TS false) (P1 false) (P2 false) (app a b) (app a' b)).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_reg_r;Assumption.
Elim H0;Intros;Right;Split.
Apply eq_plus_reg_l;Assumption.
Apply gt_n_S;Apply gt_reg_r;Assumption.
Save lexfg_app_l.

Goal (a,b,b':terms)(lexfg (TS false) (P1 false) (P2 false) b b')->
       (lexfg (TS false) (P1 false) (P2 false) (app a b) (app a b')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_reg_l;Assumption.
Elim H0;Intros;Right;Split.
Apply eq_plus_reg_r;Assumption.
Apply gt_n_S;Apply gt_reg_l;Assumption.
Save lexfg_app_r.

Goal (a,a':terms)(lexfg (TS false) (P1 false) (P2 false) a a')->
       (lexfg (TS false) (P1 false) (P2 false) (lambda a) (lambda a')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_reg_r;Assumption.
Elim H0;Intros;Right;Split.
Apply eq_plus_reg_l;Assumption.
Do 2 (Elim plus_n_O);Apply gt_plus_plus;Assumption.
Save lexfg_lambda.

Goal (a,a':terms)(s:substitutions)(lexfg (TS false) (P1 false) (P2 false) a a')->
       (lexfg (TS false) (P1 false) (P2 false) (env a s) (env a' s)).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_mult_reg_r;[Apply gt_S_r;Apply gt_P1_1|Assumption].
Elim H0;Intros;Right;Split.
Apply eq_mult_reg_l;Assumption.
Apply gt_mult_reg_r;[Apply gt_Sn_O|Assumption].
Save lexfg_env_t.

Goal (a:terms)(s,s':substitutions)(lexfg (TS true) (P1 true) (P2 true) s s')->
       (lexfg (TS false) (P1 false) (P2 false) (env a s) (env a s')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_mult_reg_l;[Apply gt_S_r;Apply gt_P1_1|Assumption].
Elim H0;Intros;Right;Split.
Apply eq_mult_reg_r;Assumption.
Apply gt_mult_reg_l;[Apply P2_pos|Apply gt_n_S;Assumption].
Save lexfg_env_s.

Goal (a,a':terms)(s:substitutions)(lexfg (TS false) (P1 false) (P2 false) a a')->
       (lexfg (TS true) (P1 true) (P2 true) (cons a s) (cons a' s)).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_reg_r;Assumption.
Elim H0;Intros;Right;Split.
Apply eq_plus_reg_l;Assumption.
Apply gt_n_S;Apply gt_reg_r;Assumption.
Save lexfg_cons_t.

Goal (a:terms)(s,s':substitutions)(lexfg (TS true) (P1 true) (P2 true) s s')->
       (lexfg (TS true) (P1 true) (P2 true) (cons a s) (cons a s')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_reg_l;Assumption.
Elim H0;Intros;Right;Split.
Apply eq_plus_reg_r;Assumption.
Apply gt_n_S;Apply gt_reg_l;Assumption.
Save lexfg_cons_s.

Goal (s,s',t:substitutions)(lexfg (TS true) (P1 true) (P2 true) s s')->
       (lexfg (TS true) (P1 true) (P2 true) (comp s t) (comp s' t)).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_mult_reg_r;[Apply gt_S_r;Apply gt_P1_1|Assumption].
Elim H0;Intros;Right;Split.
Apply eq_mult_reg_l;Assumption.
Apply gt_mult_reg_r;[Apply gt_Sn_O|Assumption].
Save lexfg_comp_l.

Goal (s,t,t':substitutions)(lexfg (TS true) (P1 true) (P2 true) t t')->
       (lexfg (TS true) (P1 true) (P2 true) (comp s t) (comp s t')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Apply gt_mult_reg_l;[Apply gt_S_r;Apply gt_P1_1|Assumption].
Elim H0;Intros;Right;Split.
Apply eq_mult_reg_r;Assumption.
Apply gt_mult_reg_l;[Apply P2_pos|Apply gt_n_S;Assumption].
Save lexfg_comp_r.

Goal (s,s':substitutions)(lexfg (TS true) (P1 true) (P2 true) s s')->
       (lexfg (TS true) (P1 true) (P2 true) (lift s) (lift s')).
Unfold lexfg;Induction 1;Simpl;Intros.
Left;Assumption.
Elim H0;Intros;Right;Split.
Assumption.
Change (gt (mult (S(S(S(S O)))) (P2 true s))
           (mult (S(S(S(S O)))) (P2 true s'))).
Apply gt_mult_reg_l;[Apply gt_Sn_O|Assumption].
Save lexfg_lift.

Goal (b:bool)(M,N:(TS b))(relSL b M N)->(lexfg (TS b) (P1 b) (P2 b) M N).
Induction 1;Intros.
Apply lexfg_systemSL;Assumption.
Apply lexfg_app_l;Assumption.
Apply lexfg_app_r;Assumption.
Apply lexfg_lambda;Assumption.
Apply lexfg_env_t;Assumption.
Apply lexfg_env_s;Assumption.
Apply lexfg_cons_t;Assumption.
Apply lexfg_cons_s;Assumption.
Apply lexfg_comp_l;Assumption.
Apply lexfg_comp_r;Assumption.
Apply lexfg_lift;Assumption.
Save lexfg_relSL.


(***************************************************)
(*   la relation sigma-lift (SL) est noetherienne  *)
(***************************************************)

Theorem relSL_noetherian: (b:bool)(noetherian (TS b) (relSL b)).
Goal.
Intro b;Apply noether_inclus with (lexfg (TS b) (P1 b) (P2 b)).
Apply lexfg_notherian.
Exact (lexfg_relSL b).
Save.

Provide terminaison_SL.

