
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                  (*  Generalites sur les relations  *)


(**************)
(* Relations  *)
(**************)

Section Rels.

Variable A: Set.

(* R* fermeture reflexive-transitive d une relation binaire R *)

Inductive Definition star [R:A->A->Prop]: A->A->Prop
=  star_refl: (x:A)(star R x x)
 | star_trans1 : (x,y,z:A)(R x y)->(star R y z)->(star R x z).

(* composition de deux relations *)

Inductive Definition comp_rel [R1,R2:A->A->Prop]: A->A->Prop
= comp_2rel: (x,y,z:A)(R1 x y)->(R2 y z)->(comp_rel R1 R2 x z).

(* R+ frmeture transitive de R *)

Inductive Definition rel_plus [R:A->A->Prop]:A->A->Prop
=  relplus_1step: (x,y:A)(R x y)->(rel_plus R x y)
 | relplus_trans1: (x,y,z:A)(R x y)->(rel_plus R y z)->(rel_plus R x z). 

End Rels.

Hint star_refl.
Hint relplus_1step.

(**************)
(* proprietes *)


Section rels_prop.

Variable A: Set.
Variable R: A->A->Prop.

(* R confluente *)

Definition confluence' [x:A](y,z:A)(star A R x y)->(star A R x z)->
                         <A>Ex([u:A](star A R y u)/\(star A R z u)).

Definition confluence (x:A)(confluence' x).

(* R localement confluente *)

Definition local_confluence' [x:A](y,z:A)(R x y)->(R x z)->
                         <A>Ex([u:A](star A R y u)/\(star A R z u)).

Definition local_confluence (x:A)(local_confluence' x).

(* R fortement confluente *)

Definition strong_confluence' [x:A](y,z:A)(R x y)->(R x z)->
                            <A>Ex([u:A](R y u)/\(R z u)).

Definition strong_confluence (x:A)(strong_confluence' x).

End rels_prop.

(* inclusion de relations binaires, R1 inclus dans R2: R1 incl R2*)

Definition inclus [A:Set][R1,R2:A->A->Prop]
      (x,y:A)(R1 x y)->(R2 x y).


Section relations_noetherian.

Variable U:Set.

Variable R:U->U->Prop.

(* Sets as characteristic predicates over universe U *)
Definition set = U->Prop.

(* A is a subset of B *)
Definition sub = [A,B:set](x:U)(A x)->(B x).

(* The full universe *)
Definition universal = [A:set](x:U)(A x).

(* Adjoint map *)
Definition adjoint : set->set = [A:set][x:U](sub (R x) A).

Definition hereditary = [A:set](sub (adjoint A) A).
(*  i.e  (hereditary A) <-> (x:A)(sub (R x) A)->(A x) *)

Definition noetherian = (A:set)(hereditary A)->(universal A).

End relations_noetherian.

(**********************)
(* quelques resultats *)

(* sur le Ex *)

Goal (A:Set)(P,Q:A->Prop)<A>Ex([u:A](P u)/\(Q u))-><A>Ex([u:A](Q u)/\(P u)).
Induction 1;Intros u1 H1.
Elim H1;Intros H2 H3.
Exists u1;Split;Assumption.
Save Ex_PQ.

(* sur les constructions de relations *)

Lemma star_trans:(A:Set)(R:A->A->Prop)(x,y,z:A)
                 (star A R x y)->(star A R y z)->(star A R x z).
Goal.
Intros A R x y z H;Elim H.
Intros x0 H1;Assumption.
Intros x0 y0 z0 H1 H2 H3 H4;Apply star_trans1 with y0.
Assumption.
Exact (H3 H4).
Save.

Goal (A:Set)(R:A->A->Prop)(x,y:A)(R x y)->(star A R x y).
Intros;Apply star_trans1 with y.
Assumption.
Apply star_refl.
Save star_step1.

Hint star_step1.

Goal (A:Set)(R1,R2:A->A->Prop)(M,N:A)(comp_rel A R1 R2 M N)->
                                  <A>Ex([u:A] (R1 M u)/\(R2 u N)).  
Intros A R1 R2 M N H;Elim H.
Intros x y z H1 H2;Exists y;Split;Assumption.
Save comp_case.

Goal (A:Set)(R:A->A->Prop)(x,y:A)(comp_rel A R (star A R) x y)->
                                 (rel_plus A R x y).
Intros A R x y H;Elim H.
Intros a b c H1 H2;Generalize H1;Generalize a.
Elim H2.
Intros;Apply relplus_1step;Assumption.
Intros x0 y0 z H3 H4 H5 a0 H6;Apply relplus_trans1 with x0.
Assumption.
Apply H5;Assumption.
Save comp_relplus.

Goal (A:Set)(R:A->A->Prop)(M,N:A)(star A R M N)->((<A> M=N) \/
                                  <A>Ex([u:A] (R M u)/\(star A R u N))).
Intros A R M N H;Elim H.
Intros x;Left;Trivial.
Intros x y z H1 H2 H3;Right;Exists y;Split;Trivial.
Save star_case.

Goal (A:Set)(R:A->A->Prop)(x,y,z:A)(rel_plus A R x y)-> 
     (rel_plus A R y z)->(rel_plus A R x z).
Induction 1.
Intros;Apply relplus_trans1 with y0;Trivial.
Intros;Apply relplus_trans1 with y0;Auto.
Save Rplus_transitive.

Goal (A:Set)(R:A->A->Prop)(x,y:A)(rel_plus A R x y)->(star A R x y).
Induction 1;Intros.
Auto.
Apply star_trans1 with y0;Auto.
Save Rplus_Rstar.

Hint Rplus_Rstar.

Goal (A:Set)(R:A->A->Prop)
      (x,y,z:A)(star A R x y)->(rel_plus A R y z)-> 
           <A>Ex([u:A](R x u) /\ (star A R u z)).
Induction 1;Intros.
Elim H0;Intros.
Exists y0;Auto.
Exists y0;Auto.
Exists y0; Split;Trivial.
Apply star_trans with z0;Auto.
Save Rstar_Rplus_R.

(* sur les relations noetheriennes *)

Goal (A:Set)(R:A->A->Prop)(noetherian A R)-> 
     (A1:(set A))(hereditary A (rel_plus A R) A1) -> 
     (universal A (adjoint A (star A R) A1)).
Unfold noetherian;Unfold hereditary;Unfold universal; 
 Unfold sub;Intros A R N A1 H x.
Apply (N (adjoint A (star A R) A1)).
Unfold adjoint;Unfold sub;Intros.
Apply H;Unfold adjoint;Unfold sub;Intros.
Elim Rstar_Rplus_R with A R x0 x1 x2;Trivial.
Intro z;Induction 1;Intros C1 C2;Apply H0 with z;Trivial.
Save noetherian_course_of_values.

Lemma plus_preserves_noetherian :
  (A:Set)(R:A->A->Prop)(noetherian A R)->(noetherian A (rel_plus A R)).
Goal.
Generalize noetherian_course_of_values.
Unfold adjoint;Unfold universal;Unfold sub;Intros.
Unfold noetherian;Unfold universal;Unfold sub;Intros.
Apply (H A R H0 A0 H1 x x).
Auto.
Save.

Lemma noetherian_induction1: (A:Set)(R:A->A->Prop)(noetherian A R)->
    (x:A)(P:A->Prop)((y:A)((z:A)(R y z)->(P z))->(P y))->(P x).
Goal.
Unfold noetherian;Unfold universal;Unfold hereditary;
  Unfold adjoint;Unfold sub;Unfold set;Intros.
Apply H;Exact H0.
Save.

Lemma noetherian_induction: (A:Set)(R:A->A->Prop)(noetherian A R)->
    (x:A)(P:A->Prop)((y:A)((z:A)(rel_plus A R y z)->(P z))->(P y))->(P x).
Goal.
Intros;Apply noetherian_induction1 with A (rel_plus A R).
Apply plus_preserves_noetherian;Assumption.
Exact H0.
Save.

Lemma noether_inclus: (A:Set)(R,R':A->A->Prop)
                      (noetherian A R)->
                      ((x,y:A)(R' x y)->(R x y))->
                      (noetherian A R').
Goal.
Intros;Unfold noetherian;Unfold universal;Unfold hereditary;
  Unfold adjoint;Unfold sub;Unfold set;Intros.
Apply (noetherian_induction1 A R H);Intros.
Apply H1;Intros.
Apply H2;Apply H0;Trivial.
Save.

(* sur l'inclusion *)

Goal (A:Set)(R,S:A->A->Prop)(inclus A R (star A S))->(inclus A (star A R) (star A S)).
Intros A R S H;Red;Induction 1.
Intros;Apply star_refl.
Intros x0 y0 z H1 H2 H3;Apply star_trans with y0.
Apply H;Assumption.
Assumption.
Save inclus_star.

Goal (A:Set)(R,S:A->A->Prop)(inclus A R S)->(inclus A (star A R) (star A S)).
Unfold inclus;Induction 2.
Intros;Apply star_refl.
Intros x0 y0 z H1 H2 H3;Apply star_trans1 with y0.
Apply (H x0 y0 H1).
Assumption.
Save inclus_reg_star.

Goal (A:Set)(R1,R2,S:A->A->Prop)(inclus A R1 S)->(inclus A R2 S)->
     (* S transitive *)((x,y,z:A)(S x y)->(S y z)->(S x z))->
     (inclus A (comp_rel A R1 R2) S).   
Intros A R1 R2 S H H0 H1;Red;Induction 1.
Intros x0 y0 z H3 H4;Apply H1 with y0.
Apply H;Assumption.
Apply H0;Assumption.
Save inclus_comp.

(* sur la confluence *)

Goal (A:Set)(R:A->A->Prop)(strong_confluence A R)->(confluence A R).
Intros A R H;Red;Red.
Intros x y z H1;Generalize z;Elim H1.
Intros x0 z0 H2;Exists z0;Split.
Assumption.
Apply star_refl.
Intros x0 y0 y1 H2 H3 H4 z0 H5.
Cut <A>Ex([u:A](star A R y0 u)/\(R z0 u)).
Intro H6;Elim H6;Intros z1 H7;Elim H7;Intros H8 H9.
Elim (H4 z1 H8);Intros u H10;Elim H10;Intros H11 H12.
Exists u;Split.
Assumption.
Apply star_trans1 with z1;Assumption.
Generalize H2;Generalize y0;Elim H5.
Intros x1 y2 H6;Exists y2;Split.
Apply star_refl.
Assumption.
Intros x1 y2 z1 H6 H7 H8 y3 H9;Elim (H x1 y3 y2).
Intros x2 H10;Elim H10;Intros H11 H12.
Elim (H8 x2 H12);Intros u H13;Elim H13;Intros H14 H15.
Exists u;Split;[Apply star_trans1 with x2;Assumption|Assumption].
Assumption.
Assumption.
Save strong_conf_conf.

Goal (A:Set)(R,S:A->A->Prop)(inclus A R S)->(inclus A S (star A R))->
     (confluence A S)->(confluence A R).
Red;Red;Intros A R S H H0 H1 x y z H2 H3.
Cut (inclus A (star A R) (star A S)).
2:Apply inclus_reg_star;Assumption.
Intro H4;Elim (H1 x y z (H4 x y H2) (H4 x z H3)).
Intros x' H5;Elim H5;Intros H6 H7.
Exists x';Split.
Exact (inclus_star A S R H0 y x' H6).
Exact (inclus_star A S R H0 z x' H7).
Save inclus_conf.

Provide sur_les_relations.



