
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                    (* Systeme sigma-lift *)

Require TS.
Require sur_les_relations.

(* regles de reecriture *)

Inductive Definition reg_app: (b:bool)(TS b)->(TS b)->Prop
=  reg1_app: (a,b:terms)(s:substitutions)
             (reg_app false (env (app a b) s) (app (env a s) (env b s))).

Inductive Definition reg_lambda: (b:bool)(TS b)->(TS b)->Prop
=  reg1_lambda: (a:terms)(s:substitutions)
                (reg_lambda false (env (lambda a) s) (lambda (env a (lift s)))).

Inductive Definition reg_clos: (b:bool)(TS b)->(TS b)->Prop
=  reg1_clos: (a:terms)(s,t:substitutions)
              (reg_clos false (env (env a s) t) (env a (comp s t))).

Inductive Definition reg_varshift1: (b:bool)(TS b)->(TS b)->Prop
=  reg1_varshift1: (n:nat)(reg_varshift1 false (env (var n) shift) (var (S n))).

Inductive Definition reg_varshift2: (b:bool)(TS b)->(TS b)->Prop
=  reg1_varshift2: (n:nat)(s:substitutions)
        (reg_varshift2  false (env (var n) (comp shift s)) (env (var (S n)) s)).

Inductive Definition reg_fvarcons: (b:bool)(TS b)->(TS b)->Prop 
=  reg1_fvarcons: (a:terms)(s:substitutions)
              (reg_fvarcons false (env (var O) (cons a s)) a).

Inductive Definition reg_fvarlift1: (b:bool)(TS b)->(TS b)->Prop 
=  reg1_fvarlift1: (s:substitutions)
           (reg_fvarlift1 false (env (var O) (lift s)) (var O)).

Inductive Definition reg_fvarlift2: (b:bool)(TS b)->(TS b)->Prop 
=  reg1_fvarlift2: (s,t:substitutions)
                   (reg_fvarlift2 false (env (var O) (comp (lift s) t)) 
                                           (env (var O) t)).

Inductive Definition reg_rvarcons: (b:bool)(TS b)->(TS b)->Prop 
=  reg1_rvarcons: (n:nat)(a:terms)(s:substitutions)
           (reg_rvarcons false (env (var (S n)) (cons a s)) (env (var n) s)).

Inductive Definition reg_rvarlift1: (b:bool)(TS b)->(TS b)->Prop
=  reg1_rvarlift1: (n:nat)(s:substitutions)
 (reg_rvarlift1 false (env (var (S n)) (lift s)) (env (var n) (comp s shift))).

Inductive Definition reg_rvarlift2: (b:bool)(TS b)->(TS b)->Prop
=  reg1_rvarlift2: (n:nat)(s,t:substitutions)
                   (reg_rvarlift2 false (env (var (S n)) (comp (lift s) t)) 
                                  (env (var n) (comp s (comp shift t)))).
Inductive Definition reg_assenv: (b:bool)(TS b)->(TS b)->Prop
=  reg1_assenv: (s,t,u:substitutions)(reg_assenv true 
              (comp (comp s t) u) (comp s (comp t u))).

Inductive Definition reg_mapenv: (b:bool)(TS b)->(TS b)->Prop
=  reg1_mapenv: (a:terms)(s,t:substitutions)
         (reg_mapenv true (comp (cons a s) t) (cons (env a t) (comp s t))).

Inductive Definition reg_shiftcons: (b:bool)(TS b)->(TS b)->Prop
=  reg1_shiftcons: (a:terms)(s:substitutions)
         (reg_shiftcons true (comp shift (cons a s)) s).

Inductive Definition reg_shiftlift1: (b:bool)(TS b)->(TS b)->Prop
=  reg1_shiftlift1: (s:substitutions)
     (reg_shiftlift1 true (comp shift (lift s)) (comp s shift)).

Inductive Definition reg_shiftlift2: (b:bool)(TS b)->(TS b)->Prop
=  reg1_shiftlift2: (s,t:substitutions)
 (reg_shiftlift2 true (comp shift (comp (lift s) t)) (comp s (comp shift t))). 

Inductive Definition reg_lift1: (b:bool)(TS b)->(TS b)->Prop
=  reg1_lift1: (s,t:substitutions)
       (reg_lift1 true (comp (lift s) (lift t)) (lift (comp s t))). 

Inductive Definition reg_lift2: (b:bool)(TS b)->(TS b)->Prop
=  reg1_lift2: (s,t,u:substitutions)
(reg_lift2 true (comp (lift s) (comp (lift t) u)) (comp (lift (comp s t)) u)). 

Inductive Definition reg_liftenv: (b:bool)(TS b)->(TS b)->Prop
=  reg1_liftenv: (a:terms)(s,t:substitutions)
         (reg_liftenv true (comp (lift s) (cons a t)) (cons a (comp s t))).

Inductive Definition reg_idl: (b:bool)(TS b)->(TS b)->Prop
=  reg1_idl: (s:substitutions)(reg_idl true (comp id s) s).

Inductive Definition reg_idr: (b:bool)(TS b)->(TS b)->Prop
=  reg1_idr: (s:substitutions)(reg_idr true (comp s id) s).

Inductive Definition reg_liftid: (b:bool)(TS b)->(TS b)->Prop
=  reg1_liftid: (reg_liftid true (lift id) id).

Inductive Definition reg_id: (b:bool)(TS b)->(TS b)->Prop
=  reg1_id: (a:terms)(reg_id false (env a id) a).

(* systeme sigma-lift *)

Inductive Definition systemSL: (b:bool)(TS b)->(TS b)->Prop
=  regle_app: (a,b:terms)(reg_app false a b)->(systemSL false a b) 
 | regle_lambda: (a,b:terms)(reg_lambda false a b)->(systemSL false a b) 
 | regle_clos: (a,b:terms)(reg_clos false a b)->(systemSL false a b) 
 | regle_varshift1: (a,b:terms)(reg_varshift1 false a b)->(systemSL false a b)  
 | regle_varshift2: (a,b:terms)(reg_varshift2 false a b)->(systemSL false a b) 
 | regle_fvarcons: (a,b:terms)(reg_fvarcons false a b)->(systemSL false a b) 
 | regle_fvarlift1: (a,b:terms)(reg_fvarlift1 false a b)->(systemSL false a b) 
 | regle_fvarlift2: (a,b:terms)(reg_fvarlift2 false a b)->(systemSL false a b) 
 | regle_rvarcons: (a,b:terms)(reg_rvarcons false a b)->(systemSL false a b) 
 | regle_rvarlift1: (a,b:terms)(reg_rvarlift1 false a b)->(systemSL false a b) 
 | regle_rvarlift2: (a,b:terms)(reg_rvarlift2 false a b)->(systemSL false a b) 
 | regle_assenv: (s,t:substitutions)(reg_assenv true s t)->(systemSL true s t) 
 | regle_mapenv: (s,t:substitutions)(reg_mapenv true s t)->(systemSL true s t)
 | regle_shiftcons: (s,t:substitutions)
      (reg_shiftcons true s t)->(systemSL true s t)
 | regle_shiftlift1: (s,t:substitutions)
          (reg_shiftlift1 true s t)->(systemSL true s t) 
 | regle_shiftlift2: (s,t:substitutions)
           (reg_shiftlift2 true s t)->(systemSL true s t)
 | regle_lift1: (s,t:substitutions)(reg_lift1 true s t)->(systemSL true s t)
 | regle_lift2: (s,t:substitutions)(reg_lift2 true s t)->(systemSL true s t) 
 | regle_liftenv: (s,t:substitutions)(reg_liftenv true s t)->(systemSL true s t)
 | regle_idl: (s,t:substitutions)(reg_idl true s t)->(systemSL true s t)
 | regle_idr: (s,t:substitutions)(reg_idr true s t)->(systemSL true s t)
 | regle_liftid: (s,t:substitutions)(reg_liftid  true s t)->(systemSL true s t) 
 | regle_id: (a,b:terms)(reg_id false a b)->(systemSL false a b).

(* relation engendree par le systeme sigma-lift *)

Inductive Definition relSL: (b:bool)(TS b)->(TS b)->Prop
=  SL_one_regle: (b:bool)(M,N:(TS b))(systemSL b M N)->(relSL b M N)
 | SL_context_app_l: (a,a',b:terms)
         (relSL false a a')->(relSL false (app a b) (app a' b))
 | SL_context_app_r: (a,b,b':terms)(relSL false b b')->
                                      (relSL false (app a b) (app a b'))  
 | SL_context_lambda: (a,a':terms)(relSL false a a')->
                                      (relSL false (lambda a) (lambda a'))
 | SL_context_env_t: (a,a':terms)(s:substitutions)(relSL false a a')->
                                               (relSL false (env a s) (env a' s))
 | SL_context_env_s: (a:terms)(s,s':substitutions)(relSL true s s')->
					       (relSL false (env a s) (env a s'))
 | SL_context_cons_t: (a,a':terms)(s:substitutions)(relSL false a a')->
	     (relSL true (cons a s) (cons a' s)) 
 | SL_context_cons_s: (a:terms)(s,s':substitutions)(relSL true s s')->
						(relSL true (cons a s) (cons a s'))
 | SL_context_comp_l: (s,s',t:substitutions)(relSL true s s')->
				         (relSL true (comp s t) (comp s' t))
 | SL_context_comp_r: (s,t,t':substitutions)(relSL true t t')->
                                         (relSL true (comp s t) (comp s t'))
 | SL_context_lift: (s,s':substitutions)(relSL true s s')->
                                         (relSL true (lift s) (lift s')).

(* fermeture reflexive-transitive de la relation sigma-lift *)

Definition relSLstar [b:bool] (star (TS b) (relSL b)).

(* *)

Goal (a,a',b:terms)(relSLstar false a a')->(relSLstar false (app a b) (app a' b)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (app y b).
Apply SL_context_app_l;Assumption.
Assumption.
Save SLstar_context_app_l.

Goal (a,b,b':terms)(relSLstar false b b')->(relSLstar false (app a b) (app a b')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (app a y).
Apply SL_context_app_r;Assumption.
Assumption.
Save SLstar_context_app_r.

Goal (a,a':terms)(relSLstar false a a')->(relSLstar false (lambda a) (lambda a')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (lambda y).
Apply SL_context_lambda;Assumption.
Assumption.
Save SLstar_context_lambda.

Goal (a,a':terms)(s:substitutions)(relSLstar false a a')->
                                        (relSLstar false (env a s) (env a' s)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (env y s).
Apply SL_context_env_t;Assumption.
Assumption.
Save  SLstar_context_env_t.

Goal (a:terms)(s,s':substitutions)(relSLstar true s s')->
                                        (relSLstar false (env a s) (env a s')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (env a y).
Apply SL_context_env_s;Assumption.
Assumption.
Save  SLstar_context_env_s.

Goal (a,a':terms)(s:substitutions)(relSLstar false a a')->
                (relSLstar true (cons a s) (cons a' s)). 
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (cons y s).
Apply SL_context_cons_t;Assumption.
Assumption.
Save SLstar_context_cons_t.

Goal (a:terms)(s,s':substitutions)(relSLstar true s s')->
                (relSLstar true (cons a s) (cons a s')). 
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (cons a y).
Apply SL_context_cons_s;Assumption.
Assumption.
Save SLstar_context_cons_s.

Goal (s,s',t:substitutions)(relSLstar true s s')->
			  (relSLstar true (comp s t) (comp s' t)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (comp y t).
Apply SL_context_comp_l;Assumption.
Assumption.
Save SLstar_context_comp_l.

Goal (s,t,t':substitutions)(relSLstar true t t')->
			  (relSLstar true (comp s t) (comp s t')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (comp s y).
Apply SL_context_comp_r;Assumption.
Assumption.
Save SLstar_context_comp_r.

Goal  (s,s':substitutions)(relSLstar true s s')->
                                  (relSLstar true (lift s) (lift s')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (lift y).
Apply SL_context_lift;Assumption.
Assumption.
Save SLstar_context_lift.


Provide sigma_lift.

