
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


      (* confluence locale de sigma_lift: resolution des paires critiques *)

Require determinePC_SL.


(*** app ***)

Goal (a,b:terms)
     <terms>Ex([u:terms](relSLstar false (app (env a id) (env b id)) u)/\
                        (relSLstar false (app  a b) u)).
Exists (app a b);Split;Red.
Apply star_trans1 with (app a (env b id)).
Apply SL_context_app_l;Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Apply star_step1;Apply SL_context_app_r;
Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Apply star_refl.
Save PC_app_id.

Goal (a,a',b:terms)(s:substitutions)(relSL false a a')->
     <terms>Ex([u:terms](relSLstar false (app (env a s) (env b s)) u)/\
                        (relSLstar false (env (app a' b) s) u)).
Exists (app (env a' s) (env b s));Split;Red;Apply star_step1.
Apply SL_context_app_l;Apply SL_context_env_t;Assumption.
Apply SL_one_regle;Apply regle_app;Apply reg1_app.
Save PC1_app_ctxt_l.

Goal (a,b,b':terms)(s:substitutions)(relSL false b b')->
     <terms>Ex([u:terms](relSLstar false (app (env a s) (env b s)) u)/\
                        (relSLstar false (env (app a b') s) u)).
Exists (app (env a s) (env b' s));Split;Red;Apply star_step1.
Apply SL_context_app_r;Apply SL_context_env_t;Assumption.
Apply SL_one_regle;Apply regle_app;Apply reg1_app.
Save PC2_app_ctxt_l.

Goal (a,b:terms)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (app (env a s) (env b s)) u)/\
                        (relSLstar false (env (app a b) s') u)).
Exists (app (env a s') (env b s'));Split;Red.
Apply star_trans1 with (app (env a s') (env b s)).
Apply SL_context_app_l;Apply SL_context_env_s;Assumption.
Apply star_step1;Apply SL_context_app_r;Apply SL_context_env_s;Assumption.
Apply star_step1;Apply SL_one_regle;Apply regle_app;Apply reg1_app.
Save PC_app_ctxt_r.

Goal (a,b,x':terms)(s:substitutions)(relSL false (app a b) x')->
     <terms>Ex([u:terms](relSLstar false (app (env a s) (env b s)) u)/\
                        (relSLstar false (env x' s) u)).
Intros a b x' s H;Pattern x';Apply case_SLapp with a b;Intros.
3:Assumption.
Apply PC1_app_ctxt_l;Assumption.
Apply PC2_app_ctxt_l;Assumption.
Save PC_app_ctxt_l.

(*** lambda ***)

Goal (a:terms)
     <terms>Ex([u:terms](relSLstar false (lambda (env a (lift id))) u)/\
                        (relSLstar false (lambda a) u)).
Exists (lambda a);Split;Red.
Apply star_trans1 with (lambda (env a id)).
Apply SL_context_lambda;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_liftid;Apply reg1_liftid.
Apply star_step1;Apply SL_context_lambda;
Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Apply star_refl.
Save PC_lambda_id.

Goal (a,x':terms)(s:substitutions)(relSL false (lambda a) x')->
     <terms>Ex([u:terms](relSLstar false (lambda (env a (lift s))) u)/\
                        (relSLstar false (env x' s) u)).
Intros a x' s H;Pattern x';Apply case_SLlambda  with a;Intros.
2:Assumption.
Exists (lambda (env a' (lift s)));Split;Red;Apply star_step1.
Apply SL_context_lambda;Apply SL_context_env_t;Assumption.
Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
Save PC_lambda_ctxt_l.

Goal (a:terms)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (lambda (env a (lift s))) u)/\
                        (relSLstar false (env (lambda a) s') u)).
Exists (lambda (env a (lift s')));Split;Red;Apply star_step1.
Apply SL_context_lambda;Apply SL_context_env_s;Apply SL_context_lift;Assumption.
Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
Save PC_lambda_ctxt_r.

(*** Clos ***)

Goal (a:terms)(s:substitutions)
     <terms>Ex([u:terms](relSLstar false (env a (comp s id)) u)/\
                        (relSLstar false (env a s) u)).
Exists (env a s);Split;Red.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply star_refl.
Save PC1_clos_id.

Goal (a,b:terms)(s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (app a b) (comp s t)) u)/\
                        (relSLstar false (env (app (env a s) (env b s)) t) u)).
Exists (app (env a (comp s t)) (env b (comp s t)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_app;Apply reg1_app.
Apply star_trans1 with (app (env (env a s) t) (env (env b s) t)).
Apply SL_one_regle;Apply regle_app;Apply reg1_app.
Apply star_trans1 with (app (env a (comp s t)) (env (env b s) t)).
Apply SL_context_app_l;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_step1;Apply SL_context_app_r;
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Save PC_clos_app.

Goal (a:terms)(s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (lambda a) (comp s t)) u)/\
                        (relSLstar false (env (lambda (env a (lift s))) t) u)).
Exists (lambda (env a (lift (comp s t))));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
Apply star_trans1 with (lambda (env (env a (lift s)) (lift t))).
Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
Apply star_trans1 with (lambda (env a (comp (lift s) (lift t)))).
Apply SL_context_lambda;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_step1;Apply SL_context_lambda;Apply SL_context_env_s.
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save PC_clos_lambda.

Goal (a:terms)(s,s1,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (env a s1) (comp s t)) u)/\
                        (relSLstar false (env (env a (comp s1 s)) t) u)).
Exists (env a (comp s1 (comp s t)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_trans1 with (env a (comp (comp s1 s) t)).
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_clos_clos.

Goal (n:nat)(t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var n) (comp shift t)) u)/\
                        (relSLstar false (env (var (S n)) t) u)).
Exists (env (var (S n)) t);Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_varshift2;Apply reg1_varshift2.
Apply star_refl.
Save PC_clos_varshift1.

Goal (n:nat)(s,t:substitutions)<terms>Ex([u:terms]
        (relSLstar false (env (var n) (comp (comp shift s) t)) u)/\
        (relSLstar false (env (env (var (S n)) s) t) u)).
Exists (env (var (S n)) (comp s t));Split;Red.
Apply star_trans1 with (env (var n) (comp shift (comp s t))). 
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_varshift2;Apply reg1_varshift2.
Apply star_step1;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Save PC_clos_varshift2.

Goal (a:terms)(s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) (comp (cons a s) t)) u)/\
                        (relSLstar false (env a t) u)).
Exists (env a t);Split;Red.
Apply star_trans1 with (env (var O) (cons (env a t) (comp s t))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarcons;Apply reg1_fvarcons.
Apply star_refl.
Save PC_clos_fvarcons.

Goal (s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) (comp (lift s) t)) u)/\
                        (relSLstar false (env (var O) t) u)).
Exists (env (var O) t);Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Apply star_refl.
Save PC_clos_fvarlift1.

Goal (s1,s2,t:substitutions)<terms>Ex([u:terms]
       (relSLstar false (env (var O) (comp (comp (lift s1) s2) t)) u)/\
                        (relSLstar false (env (env (var O) s2) t) u)).
Exists (env (var O) (comp s2 t));Split;Red.
Apply star_trans1 with (env (var O) (comp (lift s1) (comp s2 t))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Apply star_step1;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Save PC_clos_fvarlift2.

Goal (n:nat)(a:terms)(s,t:substitutions)<terms>Ex([u:terms]
        (relSLstar false (env (var (S n)) (comp (cons a s) t)) u)/\
        (relSLstar false (env (env (var n) s) t) u)).
Exists (env (var n) (comp s t));Split;Red.
Apply star_trans1 with (env (var (S n)) (cons (env a t) (comp s t))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Apply star_step1;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Save PC_clos_rvarcons.

Goal (n:nat)(s,t:substitutions)<terms>Ex([u:terms]
          (relSLstar false (env (var (S n)) (comp (lift s) t)) u)/\
          (relSLstar false (env (env (var n) (comp s shift)) t) u)).
Exists (env (var n) (comp s (comp shift t)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Apply star_trans1 with (env (var n) (comp (comp s shift) t)).
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_clos_rvarlift1.

Goal (n:nat)(s1,s2,t:substitutions)<terms>Ex([u:terms]
           (relSLstar false (env (var (S n)) (comp (comp (lift s1) s2) t)) u)/\
           (relSLstar false (env (env (var n) (comp s1 (comp shift s2))) t) u)).
Exists (env (var n) (comp s1 (comp shift (comp s2 t))));Split;Red.
Apply star_trans1 with (env (var (S n)) (comp (lift s1) (comp s2 t))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Apply star_trans1 with (env (var n) (comp (comp s1 (comp shift s2)) t)).
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_trans1 with (env (var n) (comp s1 (comp (comp shift s2) t))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_clos_rvarlift2.

Goal (a:terms)(t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env a (comp id t)) u)/\
                        (relSLstar false (env a t) u)).
Exists (env a t);Split;Red.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply star_refl.
Save PC2_clos_id.

Goal (a,a':terms)(s,t:substitutions)(relSL false a a')->
     <terms>Ex([u:terms](relSLstar false (env a (comp s t)) u)/\
                        (relSLstar false (env (env a' s) t) u)).
Exists (env a' (comp s t));Split;Red;Apply star_step1.
Apply SL_context_env_t;Assumption.
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos. 
Save PC1_clos_ctxt_l.

Goal (a:terms)(s,s',t:substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (env a (comp s t)) u)/\
                        (relSLstar false (env (env a s') t) u)).
Exists (env a (comp s' t));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos. 
Save PC2_clos_ctxt_l.

Goal (a:terms)(s,t,t':substitutions)(relSL true t t')->
     <terms>Ex([u:terms](relSLstar false (env a (comp s t)) u)/\
                        (relSLstar false (env (env a s) t') u)).
Exists (env a (comp s t'));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos. 
Save PC_clos_ctxt_r.

Goal (a,x':terms)(s,t:substitutions)(relSL false (env a s) x')->
     <terms>Ex([u:terms](relSLstar false (env a (comp s t)) u)/\
                        (relSLstar false (env x' t) u)).
Intros a x' s t H;Pattern a s x';Apply case_SLenv;Intros.
15:Assumption.
Apply PC_clos_app.
Apply PC_clos_lambda.
Apply PC_clos_clos.
Apply PC_clos_varshift1.
Apply PC_clos_varshift2.
Apply PC_clos_fvarcons.
Apply PC_clos_fvarlift1.
Apply PC_clos_fvarlift2.
Apply PC_clos_rvarcons.
Apply PC_clos_rvarlift1.
Apply PC_clos_rvarlift2.
Apply PC2_clos_id.
Apply PC1_clos_ctxt_l;Assumption.
Apply PC2_clos_ctxt_l;Assumption.
Save PC_clos_ctxt_l.

(*** varshift1 ***)

 (* aucune PC *)

(*** varshift2 ***)

Goal (n:nat)(a:terms)(s:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var (S n)) (cons a s)) u)/\
                        (relSLstar false (env (var n) s) u)).
Exists (env (var n) s);Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Apply star_refl.
Save PC_varshift2_shiftcons.

Goal (n:nat)(s:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var (S n)) (lift s)) u)/\
                        (relSLstar false (env (var n) (comp s shift)) u)).
Exists (env (var n) (comp s shift));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarlift1;Apply reg1_rvarlift1.
Apply star_refl.
Save PC_varshift2_shiftlift1.

Goal (n:nat)(s,t:substitutions)<terms>Ex([u:terms]
     (relSLstar false (env (var (S n)) (comp (lift s) t)) u)/\
     (relSLstar false (env (var n) (comp s (comp shift t))) u)).
Exists (env (var n) (comp s (comp shift t)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Apply star_refl.
Save PC_varshift2_shiftlift2.

Goal (n:nat)
     <terms>Ex([u:terms](relSLstar false (env (var (S n)) id) u)/\
                        (relSLstar false (env (var n) shift) u)).
Exists (var (S n));Split;Red;Apply star_step1;Apply SL_one_regle.
Apply regle_id;Apply reg1_id.
Apply regle_varshift1;Apply reg1_varshift1.
Save PC_varshift2_idr.

Goal (n:nat)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (env (var (S n)) s) u)/\
                        (relSLstar false (env (var n) (comp shift s')) u)).
Exists (env (var (S n)) s');Split;Red;Apply star_step1.
Apply SL_context_env_s;Assumption.
Apply SL_one_regle;Apply regle_varshift2;Apply reg1_varshift2.
Save PC_varshift2_ctxt_r.

Goal (n:nat)(s,x':substitutions)(relSL true (comp shift s) x')->
     <terms>Ex([u:terms](relSLstar false (env (var (S n)) s) u)/\
                        (relSLstar false (env (var n) x') u)).
Intros n s x' H;Pattern s x';Apply case_SLcomp1;Intros.
6:Assumption.
Apply PC_varshift2_shiftcons;Assumption.
Apply PC_varshift2_shiftlift1;Assumption.
Apply PC_varshift2_shiftlift2;Assumption.
Apply PC_varshift2_idr;Assumption.
Apply PC_varshift2_ctxt_r;Assumption.
Save PC_varshift2_ctxt_r'.

(*** fvarcons ***)

Goal (a,a':terms)(s:substitutions)(relSL false a a')->
     <terms>Ex([u:terms](relSLstar false a u)/\
                        (relSLstar false (env (var O) (cons a' s)) u)).
Exists a';Split;Red;Apply star_step1.
Assumption.
Apply SL_one_regle;Apply regle_fvarcons;Apply reg1_fvarcons.
Save PC1_fvarcons_ctxt_r.

Goal (a:terms)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false a u)/\
                        (relSLstar false (env (var O) (cons a s')) u)).
Exists a;Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarcons;Apply reg1_fvarcons.
Save PC2_fvarcons_ctxt_r.

Goal (a:terms)(s,x':substitutions)(relSL true (cons a s) x')->
     <terms>Ex([u:terms](relSLstar false a u)/\
                        (relSLstar false (env (var O) x') u)).
Intros a s x' H;Pattern x';Apply case_SLcons with a s;Intros.
3:Assumption.
Apply PC1_fvarcons_ctxt_r;Assumption.
Apply PC2_fvarcons_ctxt_r with s;Assumption.
Save PC_fvarcons_ctxt_r. 

(*** fvarlift1 ***)

Goal <terms>Ex([u:terms](relSLstar false (var O) u)/\
                        (relSLstar false (env (var O) id) u)).
Exists (var O);Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Save PC_fvarlift1_liftid.

Goal (s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (var O) u)/\
                        (relSLstar false (env (var O) (lift s')) u)).
Exists (var O);Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarlift1;Apply reg1_fvarlift1.
Save PC_fvarlift1_ctxt_r.

Goal (s,x':substitutions)(relSL true (lift s) x')->
     <terms>Ex([u:terms](relSLstar false (var O) u)/\
                        (relSLstar false (env (var O) x') u)).
Intros s x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC_fvarlift1_liftid;Assumption.
Apply PC_fvarlift1_ctxt_r with s;Assumption.
Save PC_fvarlift1_ctxt_r'.

(*** fvarlift2 ***)

Goal (s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) (lift t)) u)/\
                        (relSLstar false (env (var O) (lift (comp s t))) u)).
Exists (var O);Split;Red;Apply star_step1;
Apply SL_one_regle;Apply regle_fvarlift1;Apply reg1_fvarlift1.
Save PC_fvarlift2_lift1.

Goal (s,t,v:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) (comp (lift t) v)) u)/\
      (relSLstar false (env (var O) (comp (lift (comp s t)) v)) u)).
Exists (env (var O) v);Split;Red;Apply star_step1;
Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Save PC_fvarlift2_lift2.

Goal (a:terms)(s,t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) (cons a t)) u)/\
                        (relSLstar false (env (var O) (cons a (comp s t))) u)).
Exists a;Split;Red;Apply star_step1;
Apply SL_one_regle;Apply regle_fvarcons;Apply reg1_fvarcons.
Save PC_fvarlift2_liftenv.

Goal (s:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) id) u)/\
                        (relSLstar false (env (var O) (lift s)) u)).
Exists (var O);Split;Red;Apply star_step1.
Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Apply SL_one_regle;Apply regle_fvarlift1;Apply reg1_fvarlift1.
Save PC_fvarlift2_idr.

Goal (t:substitutions)
     <terms>Ex([u:terms](relSLstar false (env (var O) t) u)/\
                        (relSLstar false (env (var O) (comp id t)) u)).
Exists (env (var O) t);Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC_fvarlift2_liftid.

Goal (s,s',t:substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (env (var O) t) u)/\
                        (relSLstar false (env (var O) (comp (lift s') t)) u)).
Exists (env (var O) t);Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Save PC1_fvarlift2_ctxt_r.

Goal (s,t,t':substitutions)(relSL true t t')->
     <terms>Ex([u:terms](relSLstar false (env (var O) t) u)/\
                        (relSLstar false (env (var O) (comp (lift s) t')) u)).
Exists (env (var O) t');Split;Red;Apply star_step1.
Apply SL_context_env_s;Assumption.
Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Save PC2_fvarlift2_ctxt_r.

Goal (s,t,x':substitutions)(relSL true (comp (lift s) t) x')->
     <terms>Ex([u:terms](relSLstar false (env (var O) t) u)/\
                        (relSLstar false (env (var O) x') u)).
Intros s t x' H;Pattern t x';Apply case_SLcomp2 with s;Intros.
7:Assumption.
Apply PC_fvarlift2_lift1;Assumption.
Apply PC_fvarlift2_lift2;Assumption.
Apply PC_fvarlift2_liftenv;Assumption.
Apply PC_fvarlift2_idr;Assumption.
Pattern s x'0;Apply case_SLlift;Intros.
3:Assumption.
Apply PC_fvarlift2_liftid.
Apply PC1_fvarlift2_ctxt_r with s;Assumption.
Apply PC2_fvarlift2_ctxt_r;Assumption.
Save PC_fvarlift2_ctxt_r.

(*** rvarcons ***)

Goal (n:nat)(a,a':terms)(s:substitutions)(relSL false a a')->
     <terms>Ex([u:terms](relSLstar false (env (var n) s) u)/\
                        (relSLstar false (env (var (S n)) (cons a' s)) u)).
Exists (env (var n) s);Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Save PC1_rvarcons_ctxt_r.

Goal (n:nat)(a:terms)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (env (var n) s) u)/\
                        (relSLstar false (env (var (S n)) (cons a s')) u)).
Exists (env (var n) s');Split;Red;Apply star_step1.
Apply SL_context_env_s;Assumption.
Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Save PC2_rvarcons_ctxt_r.

Goal (n:nat)(a:terms)(s,x':substitutions)(relSL true (cons a s) x')->
     <terms>Ex([u:terms](relSLstar false (env (var n) s) u)/\
                        (relSLstar false (env (var (S n)) x') u)).
Intros n a s x' H;Pattern x';Apply case_SLcons with a s;Intros.
3:Assumption.
Apply PC1_rvarcons_ctxt_r with a;Assumption.
Apply PC2_rvarcons_ctxt_r;Assumption.
Save PC_rvarcons_ctxt_r.

(*** rvarlift1 ***)

Goal (n:nat)
     <terms>Ex([u:terms](relSLstar false (env (var n) (comp id shift)) u)/\
                        (relSLstar false (env (var (S n)) id) u)).
Exists (var (S n));Split;Red.
Apply star_trans1 with (env (var n) shift).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply star_step1;Apply SL_one_regle;Apply regle_varshift1;Apply reg1_varshift1.
Apply star_step1;Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Save PC_rvarlift1_id.

Goal (n:nat)(s,s':substitutions)(relSL true s s')->
     <terms>Ex([u:terms](relSLstar false (env (var n) (comp s shift)) u)/\
                        (relSLstar false (env (var (S n)) (lift s')) u)).
Exists (env (var n) (comp s' shift));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_rvarlift1;Apply reg1_rvarlift1.
Save PC_rvarlift1_ctxt_r.

Goal (n:nat)(s,x':substitutions)(relSL true (lift s) x')->
     <terms>Ex([u:terms](relSLstar false (env (var n) (comp s shift)) u)/\
                        (relSLstar false (env (var (S n)) x') u)).
Intros n s x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC_rvarlift1_id.
Apply PC_rvarlift1_ctxt_r;Assumption.
Save PC_rvarlift1_ctxt_r'.

(*** rvarlift2 ***)

Goal (n:nat)(s,t:substitutions)<terms>Ex([u:terms]
      (relSLstar false (env (var n) (comp s (comp shift (lift t)))) u)/\
      (relSLstar false (env (var (S n)) (lift (comp s t))) u)).
Exists (env (var n) (comp s (comp t shift)));Split;Red.
Apply star_step1;Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_shiftlift1;Apply reg1_shiftlift1.
Apply star_trans1 with (env (var n) (comp (comp s t) shift)).
Apply SL_one_regle;Apply regle_rvarlift1;Apply reg1_rvarlift1.
Apply star_step1;Apply SL_context_env_s;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_rvarlift2_lift1.

Goal (n:nat)(s,t,v:substitutions)<terms>Ex([u:terms]
  (relSLstar false (env (var n) (comp s (comp shift (comp (lift t) v)))) u)/\
  (relSLstar false (env (var (S n)) (comp (lift (comp s t)) v)) u)).
Exists (env (var n) (comp s (comp t (comp shift v))));Split;Red.
Apply star_step1;Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Apply star_trans1 with (env (var n) (comp (comp s t) (comp shift v))).
Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Apply star_step1;Apply SL_context_env_s;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_rvarlift2_lift2.

Goal (n:nat)(a:terms)(s,t:substitutions)<terms>Ex([u:terms]
      (relSLstar false (env (var n) (comp s (comp shift (cons a t)))) u)/\
      (relSLstar false (env (var (S n)) (cons a (comp s t))) u)).
Exists (env (var n) (comp s t));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Save PC_rvarlift2_liftenv.

Goal (n:nat)(s:substitutions)<terms>Ex([u:terms]
      (relSLstar false (env (var n) (comp s (comp shift id))) u)/\
      (relSLstar false (env (var (S n)) (lift s)) u)).
Exists (env (var n) (comp s shift));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply SL_one_regle;Apply regle_rvarlift1;Apply reg1_rvarlift1.
Save PC_rvarlift2_idr.

Goal (n:nat)(t:substitutions)<terms>Ex([u:terms]
      (relSLstar false (env (var n) (comp id (comp shift t))) u)/\
      (relSLstar false (env (var (S n)) (comp id t)) u)).
Exists (env (var (S n)) t);Split;Red.
Apply star_trans1 with (env (var n) (comp shift t)).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply star_step1;Apply SL_one_regle;Apply regle_varshift2;Apply reg1_varshift2.
Apply star_step1;Apply SL_context_env_s;
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC_rvarlift2_liftid.

Goal (n:nat)(s,s',t:substitutions)(relSL true s s')->
 <terms>Ex([u:terms](relSLstar false (env (var n) (comp s (comp shift t))) u)/\
                    (relSLstar false (env (var (S n)) (comp (lift s') t)) u)).
Exists (env (var n) (comp s' (comp shift t)));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Save PC1_rvarlift2_ctxt_r.

Goal (n:nat)(s,t,t':substitutions)(relSL true t t')->
 <terms>Ex([u:terms](relSLstar false (env (var n) (comp s (comp shift t))) u)/\
                    (relSLstar false (env (var (S n)) (comp (lift s) t')) u)).
Exists (env (var n) (comp s (comp shift t')));Split;Red;Apply star_step1.
Apply SL_context_env_s;Apply SL_context_comp_r;
Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Save PC2_rvarlift2_ctxt_r.

Goal (n:nat)(s,t,x':substitutions)(relSL true (comp (lift s) t) x')->
 <terms>Ex([u:terms](relSLstar false (env (var n) (comp s (comp shift t))) u)/\
                    (relSLstar false (env (var (S n)) x') u)).
Intros n s t x' H;Pattern t x';Apply case_SLcomp2 with s;Intros.
7:Assumption.
Apply PC_rvarlift2_lift1;Assumption.
Apply PC_rvarlift2_lift2;Assumption.
Apply PC_rvarlift2_liftenv;Assumption.
Apply PC_rvarlift2_idr;Assumption.
Pattern s x'0;Apply case_SLlift;Intros.
3:Assumption.
Apply PC_rvarlift2_liftid.
Apply PC1_rvarlift2_ctxt_r;Assumption.
Apply PC2_rvarlift2_ctxt_r;Assumption.
Save PC_rvarlift2_ctxt_r.

(*** assenv ***) 

Goal (s1,s2,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (comp s1 s2) (comp t v)) u)/\
     (relSLstar true (comp (comp s1 (comp s2 t)) v) u)).
Exists (comp s1 (comp s2 (comp t v)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_trans1 with (comp s1 (comp (comp s2 t) v)).
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_context_comp_r;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_assenv.

Goal (a:terms)(s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (cons a s) (comp t v)) u)/\
     (relSLstar true (comp (cons (env a t) (comp s t)) v) u)).
Exists (cons (env a (comp t v)) (comp s (comp t v)));Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_trans1 with (cons (env (env a t) v) (comp (comp s t) v)).
Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_trans1 with (cons (env a (comp t v)) (comp (comp s t) v)).
Apply SL_context_cons_t;Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_step1;Apply SL_context_cons_s;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_mapenv.

Goal (a:terms)(s,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp shift (comp (cons a s) v)) u)/\
     (relSLstar true (comp s v) u)).
Exists (comp s v);Split;Red.
Apply star_trans1 with (comp shift (cons (env a v) (comp s v))).
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Apply star_refl.
Save PC_assenv_shiftcons.

Goal (s,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp shift (comp (lift s) v)) u)/\
     (relSLstar true (comp (comp s shift) v) u)).
Exists (comp s (comp shift v));Split;Red;Apply star_step1.
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_shiftlift1.

Goal (s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp shift (comp (comp (lift s) t) v)) u)/\
     (relSLstar true (comp (comp s (comp shift t)) v) u)).
Exists (comp s (comp shift (comp t v)));Split;Red.
Apply star_trans1 with (comp shift (comp (lift s) (comp t v))).
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Apply star_trans1 with (comp s (comp (comp shift t) v)).
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_context_comp_r;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_shiftlift2.

Goal (s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift s) (comp (lift t) v)) u)/\
     (relSLstar true (comp (lift (comp s t)) v) u)).
Exists (comp (lift (comp s t)) v);Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Apply star_refl.
Save PC_assenv_lift1.

Goal (s,t1,t2,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift s) (comp (comp (lift t1) t2) v)) u)/\
     (relSLstar true (comp (comp (lift (comp s t1)) t2) v) u)).
Exists (comp (lift (comp s t1)) (comp t2 v));Split;Red.
Apply star_trans1 with (comp (lift s) (comp (lift t1) (comp t2 v))).
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Apply star_step1;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_lift2.

Goal (a:terms)(s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift s) (comp (cons a t) v)) u)/\
     (relSLstar true (comp (cons a (comp s t)) v) u)).
Exists (cons (env a v) (comp s (comp t v)));Split;Red.
Apply star_trans1 with (comp (lift s) (cons (env a v) (comp t v))).
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Apply star_trans1 with (cons (env a v) (comp (comp s t) v)).
Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_context_cons_s;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_liftenv.

Goal (t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp id (comp t v)) u)/\
     (relSLstar true (comp t v) u)).
Exists (comp t v);Split;Red.
Apply star_step1;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply star_refl.
Save PC_assenv_idl.

Goal (s,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp s (comp id v)) u)/\
     (relSLstar true (comp s v) u)).
Exists (comp s v);Split;Red.
Apply star_step1;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply star_refl.
Save PC1_assenv_idr.

Goal (s,t:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp s (comp t id)) u)/\
     (relSLstar true (comp s t) u)).
Exists (comp s t);Split;Red.
Apply star_step1;Apply SL_context_comp_r;
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply star_refl.
Save PC2_assenv_idr.

Goal (s,s',t,v:substitutions)(relSL true s s')->
 <substitutions>Ex([u:substitutions](relSLstar true (comp s (comp t v)) u)/\
                                    (relSLstar true (comp (comp s' t) v) u)).
Exists (comp s' (comp t v));Split;Red;Apply star_step1.
Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_assenv_ctxt_l.

Goal (s,t,t',v:substitutions)(relSL true t t')->
 <substitutions>Ex([u:substitutions](relSLstar true (comp s (comp t v)) u)/\
                                    (relSLstar true (comp (comp s t') v) u)). 
Exists (comp s (comp t' v));Split;Red;Apply star_step1.
Apply SL_context_comp_r;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC1_assenv_ctxt_r.

Goal (s,t,v,v':substitutions)(relSL true v v')->
  <substitutions>Ex([u:substitutions](relSLstar true (comp s (comp t v)) u)/\
                                   (relSLstar true (comp (comp s t) v') u)). 
Exists (comp s (comp t v'));Split;Red;Apply star_step1.
Do 2 (Apply SL_context_comp_r);Assumption.
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC2_assenv_ctxt_r.

Goal (s,t,v,x':substitutions)(relSL true (comp s t) x')->
  <substitutions>Ex([u:substitutions](relSLstar true (comp s (comp t v)) u)/\
                                   (relSLstar true (comp x' v) u)).
Intros s t v x' H;Pattern s t x';Apply case_SLcomp;Intros.
13:Assumption.
Apply PC_assenv_assenv.
Apply PC_assenv_mapenv.
Apply PC_assenv_shiftcons.
Apply PC_assenv_shiftlift1.
Apply PC_assenv_shiftlift2.
Apply PC_assenv_lift1.
Apply PC_assenv_lift2.
Apply PC_assenv_liftenv.
Apply PC_assenv_idl.
Apply PC1_assenv_idr.
Apply PC_assenv_ctxt_l;Assumption.
Apply PC1_assenv_ctxt_r;Assumption.
Save PC_assenv_ctxt_l.

(*** mapenv ***)

Goal (a:terms)(s:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (cons (env a id) (comp s id)) u)/\
     (relSLstar true (cons a s) u)). 
Exists (cons a s);Split;Red.
Apply star_trans1 with (cons a (comp s id)).
Apply SL_context_cons_t;Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Apply star_step1;Apply SL_context_cons_s;Apply SL_one_regle;
Apply regle_idr;Apply reg1_idr.
Apply star_refl.
Save PC_mapenv_idr.

Goal (a,a':terms)(s,t:substitutions)(relSL false a a')->
     <substitutions>Ex([u:substitutions]
            (relSLstar true (cons (env a t) (comp s t)) u)/\
            (relSLstar true (comp (cons a' s) t) u)). 
Exists (cons (env a' t) (comp s t));Split;Red;Apply star_step1.
Apply SL_context_cons_t;Apply SL_context_env_t;Assumption.
Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Save PC1_mapenv_ctxt_l.

Goal (a:terms)(s,s',t:substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (cons (env a t) (comp s t)) u)/\
       (relSLstar true (comp (cons a s') t) u)). 
Exists (cons (env a t) (comp s' t));Split;Red;Apply star_step1.
Apply SL_context_cons_s;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Save PC2_mapenv_ctxt_l.

Goal (a:terms)(s,t,t':substitutions)(relSL true t t')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (cons (env a t) (comp s t)) u)/\
       (relSLstar true (comp (cons a s) t') u)). 
Exists (cons (env a t') (comp s t'));Split;Red.
Apply star_trans1 with (cons (env a t') (comp s t)).
Apply SL_context_cons_t;Apply SL_context_env_s;Assumption.
Apply star_step1;Apply SL_context_cons_s;Apply SL_context_comp_r;Assumption.
Apply star_step1;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Save PC_mapenv_ctxt_r.

Goal (a:terms)(s,t,x':substitutions)(relSL true (cons a s) x')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (cons (env a t) (comp s t)) u)/\
       (relSLstar true (comp x' t) u)). 
Intros a s t x' H;Pattern x';Apply case_SLcons with a s;Intros.
3:Assumption.
Apply PC1_mapenv_ctxt_l;Assumption.
Apply PC2_mapenv_ctxt_l;Assumption.
Save PC_mapenv_ctxt_l.

(*** shiftcons ***)

Goal (a,a':terms)(s:substitutions)(relSL false a a')->
     <substitutions>Ex([u:substitutions]
          (relSLstar true s u)/\
          (relSLstar true (comp shift (cons a' s)) u)). 
Exists s;Split;Red.
Apply star_refl.
Apply star_step1;Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Save PC1_shiftcons_ctxt_r.

Goal (a:terms)(s,s':substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions]
          (relSLstar true s u)/\
          (relSLstar true (comp shift (cons a s')) u)).
Exists s';Split;Red;Apply star_step1.
Assumption.
Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Save PC2_shiftcons_ctxt_r.

Goal (a:terms)(s,x':substitutions)(relSL true (cons a s) x')->
     <substitutions>Ex([u:substitutions]
          (relSLstar true s u)/\
          (relSLstar true (comp shift x') u)).
Intros a s x' H;Pattern x';Apply case_SLcons with a s;Intros.
3:Assumption.
Apply PC1_shiftcons_ctxt_r with a;Assumption.
Apply PC2_shiftcons_ctxt_r;Assumption.
Save PC_shiftcons_ctxt_r.

(*** shiftlift1 ***)

Goal <substitutions>Ex([u:substitutions](relSLstar true (comp id shift) u)/\
                                        (relSLstar true (comp shift id) u)).
Exists shift;Split;Red;Apply star_step1.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Save PC_shiftlift1_liftid.

Goal (s,s':substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp s shift) u)/\
        (relSLstar true (comp shift (lift s')) u)).
Exists (comp s' shift);Split;Red;Apply star_step1.
Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_shiftlift1;Apply reg1_shiftlift1.
Save PC_shiftlift1_ctxt_r.

Goal (s,x':substitutions)(relSL true (lift s) x')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp s shift) u)/\
        (relSLstar true (comp shift x') u)).
Intros s x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC_shiftlift1_liftid.
Apply PC_shiftlift1_ctxt_r;Assumption.
Save PC_shiftlift1_ctxt_r'.

(*** shiftlift2 ***)

Goal (s,t:substitutions)<substitutions>Ex([u:substitutions]
      (relSLstar true (comp s (comp shift (lift t))) u)/\
      (relSLstar true (comp shift (lift (comp s t))) u)).
Exists (comp s (comp t shift));Split;Red.
Apply star_step1;Apply SL_context_comp_r;Apply SL_one_regle;
Apply regle_shiftlift1;Apply reg1_shiftlift1.
Apply star_trans1 with (comp (comp s t) shift).
Apply SL_one_regle;Apply regle_shiftlift1;Apply reg1_shiftlift1.
Apply star_step1;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_shiftlift2_lift1.

Goal (s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp s (comp shift (comp (lift t) v))) u)/\
     (relSLstar true (comp shift (comp (lift (comp s t)) v)) u)).
Exists (comp s (comp t (comp shift v)));Split;Red.
Apply star_step1;Apply SL_context_comp_r;Apply SL_one_regle;
Apply regle_shiftlift2;Apply reg1_shiftlift2.
Apply star_trans1 with (comp (comp s t) (comp shift v)).
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Apply star_step1;Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save PC_shiftlift2_lift2.

Goal (a:terms)(s,t:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp s (comp shift (cons a t))) u)/\
     (relSLstar true (comp shift (cons a (comp s t))) u)).
Exists (comp s t);Split;Red;Apply star_step1.
Apply SL_context_comp_r;Apply SL_one_regle;
Apply regle_shiftcons;Apply reg1_shiftcons.
Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Save PC_shiftlift2_liftenv.

Goal (t:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp id (comp shift t)) u)/\
     (relSLstar true (comp shift (comp id t)) u)).
Exists (comp shift t);Split;Red;Apply star_step1.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC_shiftlift2_liftid.

Goal (s:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp s (comp shift id))  u)/\
     (relSLstar true (comp shift (lift s)) u)).
Exists (comp s shift);Split;Red;Apply star_step1.
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply SL_one_regle;Apply regle_shiftlift1;Apply reg1_shiftlift1.
Save PC_shiftlift2_idr.

Goal (s,s',t:substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (comp s (comp shift t))  u)/\
       (relSLstar true (comp shift (comp (lift s') t)) u)).
Exists (comp s' (comp shift t));Split;Red;Apply star_step1.
Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Save PC1_shiftlift2_ctxt_r.

Goal (s,t,t':substitutions)(relSL true t t')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (comp s (comp shift t))  u)/\
       (relSLstar true (comp shift (comp (lift s) t')) u)).
Exists (comp s (comp shift t'));Split;Red;Apply star_step1.
Do 2 (Apply SL_context_comp_r);Assumption.
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Save PC2_shiftlift2_ctxt_r.

Goal (s,t,x':substitutions)(relSL true (comp (lift s) t) x')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (comp s (comp shift t))  u)/\
       (relSLstar true (comp shift x') u)).
Intros s t x' H;Pattern t x';Apply case_SLcomp2 with s;Intros.
7:Assumption.
Apply PC_shiftlift2_lift1.
Apply PC_shiftlift2_lift2.
Apply PC_shiftlift2_liftenv.
Apply PC_shiftlift2_idr.
Pattern s x'0;Apply case_SLlift;Intros.
3:Assumption.
Apply PC_shiftlift2_liftid.
Apply PC1_shiftlift2_ctxt_r;Assumption.
Apply PC2_shiftlift2_ctxt_r;Assumption.
Save PC_shiftlift2_ctxt_r.
  
(*** lift1 ***)

Goal (t:substitutions)
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp id t)) u)/\
                                  (relSLstar true (comp id (lift t)) u)).
Exists (lift t);Split;Red;Apply star_step1.
Apply SL_context_lift;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC1_lift1_liftid.

Goal (s:substitutions)
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp s id)) u)/\
                                  (relSLstar true (comp (lift s) id) u)).
Exists (lift s);Split;Red;Apply star_step1.
Apply SL_context_lift;Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Save PC2_lift1_liftid.

Goal (s,s',t:substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp s t)) u)/\
                                  (relSLstar true (comp (lift s') (lift t)) u)).
Exists (lift (comp s' t));Split;Red;Apply star_step1.
Apply SL_context_lift;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save PC_lift1_ctxt_l.

Goal (s,t,t':substitutions)(relSL true t t')->
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp s t)) u)/\
                                  (relSLstar true (comp (lift s) (lift t')) u)).
Exists (lift (comp s t'));Split;Red;Apply star_step1.
Apply SL_context_lift;Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save PC_lift1_ctxt_r.

Goal (s,t,x':substitutions)(relSL true (lift s) x')->
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp s t)) u)/\
                                  (relSLstar true (comp x' (lift t)) u)).
Intros s t x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC1_lift1_liftid.
Apply PC_lift1_ctxt_l;Assumption.
Save PC_lift1_ctxt_l'.

Goal (s,t,x':substitutions)(relSL true (lift t) x')->
     <substitutions>Ex([u:substitutions](relSLstar true (lift (comp s t)) u)/\
                                  (relSLstar true (comp (lift s) x') u)).
Intros a t x' H;Pattern t x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC2_lift1_liftid.
Apply PC_lift1_ctxt_r;Assumption.
Save PC_lift1_ctxt_r'.

(*** lift2 ***)

Goal (s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp s t)) (lift v)) u)/\
     (relSLstar true (comp (lift s) (lift (comp t v))) u)).
Exists (lift (comp s (comp t v)));Split;Red.
Apply star_trans1 with (lift (comp (comp s t) v)).
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Apply star_step1;Apply SL_context_lift;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save PC_lift2_lift1.

Goal (s,t1,t2,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp s t1)) (comp (lift t2) v)) u)/\
     (relSLstar true (comp (lift s) (comp (lift (comp t1 t2)) v))  u)).
Exists (comp (lift (comp s (comp t1 t2))) v);Split;Red.
Apply star_trans1 with (comp (lift (comp (comp s t1) t2)) v).
Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Apply star_step1;Apply SL_context_comp_l;Apply SL_context_lift;
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Save PC_lift2_lift2.

Goal (a:terms)(s,t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp s t)) (cons a v)) u)/\
     (relSLstar true (comp (lift s) (cons a (comp t v)))  u)).
Exists (cons a (comp s (comp t v)));Split;Red.
Apply star_trans1 with (cons a (comp (comp s t) v)).
Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Apply star_step1;Apply SL_context_cons_s;Apply SL_one_regle;
Apply regle_assenv;Apply reg1_assenv.
Apply star_step1;Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Save PC_lift2_liftenv.

Goal (t,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp id t)) v) u)/\
     (relSLstar true (comp id (comp (lift t) v))  u)).
Exists (comp (lift t) v);Split;Red;Apply star_step1.
Apply SL_context_comp_l;Apply SL_context_lift;Apply SL_one_regle;
Apply regle_idl;Apply reg1_idl.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC1_lift2_liftid.

Goal (s,v:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp s id)) v) u)/\
     (relSLstar true (comp (lift s) (comp id v))  u)).
Exists (comp (lift s) v);Split;Red;Apply star_step1.
Apply SL_context_comp_l;Apply SL_context_lift;Apply SL_one_regle;
Apply regle_idr;Apply reg1_idr.
Apply SL_context_comp_r;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC2_lift2_liftid.

Goal (s,t:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (comp (lift (comp s t)) id) u)/\
     (relSLstar true (comp (lift s) (lift t)) u)).
Exists (lift (comp s t));Split;Red;Apply star_step1.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save PC_lift2_idr.

Goal (s,s',t,v:substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions]
       (relSLstar true (comp (lift (comp s t)) v) u)/\
       (relSLstar true (comp (lift s') (comp (lift t) v)) u)).
Exists (comp (lift (comp s' t)) v);Split;Red;Apply star_step1.
Apply SL_context_comp_l;Apply SL_context_lift;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Save PC_lift2_ctxt_l.

Goal (s,t,t',v:substitutions)(relSL true t t')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp (lift (comp s t)) v) u)/\
        (relSLstar true (comp (lift s) (comp (lift t') v)) u)).
Exists (comp (lift (comp s t')) v);Split;Red;Apply star_step1.
Apply SL_context_comp_l;Apply SL_context_lift;Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Save PC1_lift2_ctxt_r.

Goal (s,t,v,v':substitutions)(relSL true v v')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp (lift (comp s t)) v) u)/\
        (relSLstar true (comp (lift s) (comp (lift t) v')) u)).
Exists (comp (lift (comp s t)) v');Split;Red;Apply star_step1.
Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Save PC2_lift2_ctxt_r.

Goal (s,t,v,x':substitutions)(relSL true (lift s) x')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp (lift (comp s t)) v) u)/\
        (relSLstar true (comp x'  (comp (lift t) v)) u)).
Intros s t v x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC1_lift2_liftid.
Apply PC_lift2_ctxt_l;Assumption.
Save PC_lift2_ctxt_l'. 

Goal (s,t,v,x':substitutions)(relSL true (comp (lift t) v) x')->
     <substitutions>Ex([u:substitutions]
        (relSLstar true (comp (lift (comp s t)) v) u)/\
        (relSLstar true (comp (lift s) x') u)).
Intros s t v x' H;Pattern v x';Apply case_SLcomp2 with t;Intros.
7:Assumption.
Apply PC_lift2_lift1.
Apply PC_lift2_lift2.
Apply PC_lift2_liftenv.
Apply PC_lift2_idr.
Pattern t x'0;Apply case_SLlift;Intros.
3:Assumption.
Apply PC2_lift2_liftid.
Apply PC1_lift2_ctxt_r;Assumption.
Apply PC2_lift2_ctxt_r;Assumption.
Save PC_lift2_ctxt_r.

(*** liftenv ***)

Goal (a:terms)(t:substitutions)<substitutions>Ex([u:substitutions]
     (relSLstar true (cons a (comp id t)) u)/\
     (relSLstar true (comp id (cons a t)) u)).
Exists (cons a t);Split;Red;Apply star_step1.
Apply SL_context_cons_s;Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC_liftenv_liftid.

Goal (a:terms)(s,s',t:substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions](relSLstar true (cons a (comp s t)) u)/\
                    (relSLstar true (comp (lift s') (cons a t)) u)).
Exists (cons a (comp s' t));Split;Red;Apply star_step1.
Apply SL_context_cons_s;Apply SL_context_comp_l;Assumption.
Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Save PC_liftenv_ctxt_l.

Goal (a,a':terms)(s,t:substitutions)(relSL false a a')->
     <substitutions>Ex([u:substitutions](relSLstar true (cons a (comp s t)) u)/\
                    (relSLstar true (comp (lift s) (cons a' t)) u)).
Exists (cons a' (comp s t));Split;Red;Apply star_step1.
Apply SL_context_cons_t;Assumption.
Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Save PC1_liftenv_ctxt_r.

Goal (a:terms)(s,t,t':substitutions)(relSL true t t')->
     <substitutions>Ex([u:substitutions](relSLstar true (cons a (comp s t)) u)/\
                    (relSLstar true (comp (lift s) (cons a t')) u)).
Exists (cons a (comp s t'));Split;Red;Apply star_step1.
Apply SL_context_cons_s;Apply SL_context_comp_r;Assumption.
Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Save PC2_liftenv_ctxt_r.

Goal (a:terms)(s,t,x':substitutions)(relSL true (lift s) x')->
     <substitutions>Ex([u:substitutions](relSLstar true (cons a (comp s t)) u)/\
                    (relSLstar true (comp x' (cons a t)) u)).
Intros a s t x' H;Pattern s x';Apply case_SLlift;Intros.
3:Assumption.
Apply PC_liftenv_liftid.
Apply PC_liftenv_ctxt_l;Assumption.
Save PC_liftenv_ctxt_l'.

Goal (a:terms)(s,t,x':substitutions)(relSL true (cons a t) x')->
     <substitutions>Ex([u:substitutions](relSLstar true (cons a (comp s t)) u)/\
                    (relSLstar true (comp (lift s) x') u)).
Intros a s t x' H;Pattern x';Apply case_SLcons with a t;Intros.
3:Assumption.
Apply PC1_liftenv_ctxt_r;Assumption.
Apply PC2_liftenv_ctxt_r;Assumption.
Save PC_liftenv_ctxt_r.

(*** idl ***)

Goal <substitutions>Ex([u:substitutions](relSLstar true id  u)/\
                    (relSLstar true id u)).
Exists id;Split;Red;Apply star_refl.
Save PC_idl_idr.

Goal (s,s':substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions](relSLstar true s  u)/\
                    (relSLstar true (comp id s') u)).
Exists s';Split;Red;Apply star_step1.
Assumption.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save PC_idl_ctxt_r.

(*** idr ***)

Goal (s,s':substitutions)(relSL true s s')->
     <substitutions>Ex([u:substitutions](relSLstar true s  u)/\
                    (relSLstar true (comp s' id) u)).
Exists s';Split;Red;Apply star_step1.
Assumption.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Save PC_idr_ctxt_l.

(*** liftid ***)

 (* aucune PC *)

(*** id ***)

Goal (a,a':terms)(relSL false a a')->
     <terms>Ex([u:terms](relSLstar false a  u)/\
                        (relSLstar false (env a' id) u)).
Exists a';Split;Red;Apply star_step1.
Assumption.
Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Save PC_id_ctxt_l.

Provide resoudPC_SL.

