
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


               (* theorie lambda-sigma-lift-calcul *) 

Require sigma_lift.


(* regle beta *)

Inductive Definition reg_beta: (b:bool)(TS b)->(TS b)->Prop 
= reg1_beta: (a,b:terms)(reg_beta false (app (lambda a) b) (env a (cons b id))).

(* systeme lambda-sigma-lift *)

Inductive Definition systemLSL: (b:bool)(TS b)->(TS b)->Prop
=  beta1: (M,N:terms)(reg_beta false M N)->(systemLSL false M N)
 | SL1: (b:bool)(M,N:(TS b))(systemSL b M N)->(systemLSL b M N). 

(* relation engendree par le systeme lambda-sigma-lift *)

Inductive Definition relLSL: (b:bool)(TS b)->(TS b)->Prop
=  LSL_one_regle: (b:bool)(M,N:(TS b))(systemLSL b M N)->(relLSL b M N)
 | LSL_context_app_l: (a,a',b:terms)
    (relLSL false a a')->(relLSL false (app a b) (app a' b))
 | LSL_context_app_r: (a,b,b':terms)(relLSL false b b')->
                                      (relLSL false (app a b) (app a b'))  
 | LSL_context_lambda: (a,a':terms)(relLSL false a a')->
                                      (relLSL false (lambda a) (lambda a'))
 | LSL_context_env_t: (a,a':terms)(s:substitutions)(relLSL false a a')->
                                               (relLSL false (env a s) (env a' s))
 | LSL_context_env_s: (a:terms)(s,s':substitutions)(relLSL true s s')->
					       (relLSL false (env a s) (env a s'))
 | LSL_context_cons_t: (a,a':terms)(s:substitutions)(relLSL false a a')->
	       (relLSL true (cons a s) (cons a' s)) 
 | LSL_context_cons_s: (a:terms)(s,s':substitutions)(relLSL true s s')->
			(relLSL true (cons a s) (cons a s'))
 | LSL_context_comp_l: (s,s',t:substitutions)(relLSL true s s')->
				         (relLSL true (comp s t) (comp s' t))
 | LSL_context_comp_r: (s,t,t':substitutions)(relLSL true t t')->
                                         (relLSL true (comp s t) (comp s t'))
 | LSL_context_lift: (s,s':substitutions)(relLSL true s s')->
                                         (relLSL true (lift s) (lift s')).

(* fermeture reflexive-transitive de la relation lambda-sigma-lift *)

Definition relLSLstar [b:bool] (star (TS b) (relLSL b)).

(* un exemple *)

Goal (relLSLstar false (lambda (app (lambda (app (var O)(var O))) 
                                    (lambda (app (var O)(var (S O))))))
                               (lambda (app (var O)(var O)))).
Red;Apply star_trans1 with (lambda (env (app (var O)(var O)) 
                                (cons (lambda (app (var O)(var (S O)))) id ))).
Apply LSL_context_lambda;Apply LSL_one_regle;Apply beta1;Apply reg1_beta.
Apply star_trans1 with (lambda (app (env (var O)(cons (lambda 
                                                    (app (var O)(var (S O)))) id))
                                        (env (var O) (cons (lambda 
                                              (app (var O)(var (S O)))) id)))).
Apply LSL_context_lambda;Apply LSL_one_regle;Apply SL1;
Apply regle_app;Apply reg1_app.
Apply star_trans1 with (lambda (app (lambda (app (var O)(var (S O))))
                     (env (var O) (cons (lambda (app (var O)(var (S O)))) id)))).
Apply LSL_context_lambda;Apply LSL_context_app_l;Apply LSL_one_regle;Apply SL1;
             Apply regle_fvarcons;Apply reg1_fvarcons.
Apply star_trans1 with (lambda (app (lambda (app (var O)(var (S O))))
                                    (lambda (app (var O)(var (S O)))))).
Apply LSL_context_lambda;Apply LSL_context_app_r;Apply LSL_one_regle;Apply SL1;
            Apply regle_fvarcons;Apply reg1_fvarcons.
Apply star_trans1 with (lambda (env (app (var O)(var (S O))) 
                                    (cons (lambda (app (var O)(var (S O)))) id))).
Apply LSL_context_lambda;Apply LSL_one_regle;Apply beta1;Apply reg1_beta.
Apply star_trans1 with (lambda (app (env (var O)(cons (lambda (app (var O)
                                                          (var (S O)))) id))
                              (env (var (S O))(cons (lambda (app (var O)
                                                            (var (S O)))) id)))).
Apply LSL_context_lambda;Apply LSL_one_regle;Apply SL1;Apply regle_app;
Apply reg1_app.
Apply star_trans1 with (lambda (app (lambda (app (var O)(var (S O))))
                             (env (var (S O))(cons (lambda (app (var O)
                                                (var (S O)))) id)))).
Apply LSL_context_lambda;Apply LSL_context_app_l;Apply LSL_one_regle;Apply SL1;
            Apply regle_fvarcons;Apply reg1_fvarcons.
Apply star_trans1 with (lambda (app (lambda (app (var O)(var (S O))))
                           (env (var O) id))).
Apply LSL_context_lambda;Apply LSL_context_app_r;Apply LSL_one_regle;Apply SL1;
            Apply regle_rvarcons;Apply reg1_rvarcons.
Apply star_trans1 with (lambda (env (app (var O)(var (S O)))
                  (cons (env (var O) id) id))). 
Apply LSL_context_lambda;Apply LSL_one_regle;Apply beta1;Apply reg1_beta.
Apply star_trans1 with (lambda (app (env (var O)(cons (env (var O) id) id))   
                                    (env (var (S O))(cons (env (var O) id) id)))).
Apply LSL_context_lambda;Apply LSL_one_regle;Apply SL1;Apply regle_app;
Apply reg1_app.
Apply star_trans1 with (lambda (app (env (var O) id)
                                    (env (var (S O))(cons (env (var O) id) id)))). 
Apply LSL_context_lambda;Apply LSL_context_app_l;Apply LSL_one_regle;Apply SL1;
           Apply regle_fvarcons;Apply reg1_fvarcons.
Apply star_trans1 with (lambda (app (env (var O) id)(env (var O) id))).
Apply LSL_context_lambda;Apply LSL_context_app_r;Apply LSL_one_regle;Apply SL1;
            Apply regle_rvarcons;Apply reg1_rvarcons.
Apply star_trans1 with (lambda (app (var O)(env (var O) id))).
Apply LSL_context_lambda;Apply LSL_context_app_l;Apply LSL_one_regle;Apply SL1;
            Apply regle_id;Apply reg1_id.
Apply star_trans1 with (lambda (app (var O)(var O))). 
Apply LSL_context_lambda;Apply LSL_context_app_r;Apply LSL_one_regle;Apply SL1;
            Apply regle_id;Apply reg1_id.
Apply star_refl.
Save exemple.

(* *)

Goal (a,a',b:terms)(relLSLstar false a a')->(relLSLstar false (app a b) (app a' b)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (app y b).
Apply LSL_context_app_l;Assumption.
Assumption.
Save LSLstar_context_app_l.

Goal (a,b,b':terms)(relLSLstar false b b')->(relLSLstar false (app a b) (app a b')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (app a y).
Apply LSL_context_app_r;Assumption.
Assumption.
Save LSLstar_context_app_r.

Goal (a,a',b,b':terms)(relLSLstar false a a')->(relLSLstar false b b')->
         (relLSLstar false (app a b) (app a' b')).
Intros;Red.
Apply star_trans with (app a' b).
Change (relLSLstar false (app a b) (app a' b)).
Apply LSLstar_context_app_l;Assumption.
Change (relLSLstar false (app a' b) (app a' b')).
Apply LSLstar_context_app_r;Assumption.
Save LSLstar_context_app.

Goal (a,a':terms)(relLSLstar false a a')->(relLSLstar false (lambda a) (lambda a')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (lambda y).
Apply LSL_context_lambda;Assumption.
Assumption.
Save LSLstar_context_lambda.

Goal (a,a':terms)(s:substitutions)(relLSLstar false a a')->
                                        (relLSLstar false (env a s) (env a' s)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (env y s).
Apply LSL_context_env_t;Assumption.
Assumption.
Save  LSLstar_context_env_t.

Goal (a:terms)(s,s':substitutions)(relLSLstar true s s')->
                                        (relLSLstar false (env a s) (env a s')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (env a y).
Apply LSL_context_env_s;Assumption.
Assumption.
Save  LSLstar_context_env_s.

Goal (a,a':terms)(s,s':substitutions)(relLSLstar false a a')->(relLSLstar true s s')->
                                        (relLSLstar false (env a s) (env a' s')).
Intros;Red.
Apply star_trans with (env a' s).
Change (relLSLstar false (env a s) (env a' s)).
Apply LSLstar_context_env_t;Assumption.
Change (relLSLstar false (env a' s) (env a' s')).
Apply LSLstar_context_env_s;Assumption.
Save LSLstar_context_env.

Goal (a,a':terms)(s:substitutions)(relLSLstar false a a')->
                (relLSLstar true (cons a s) (cons a' s)). 
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (cons y s).
Apply LSL_context_cons_t;Assumption.
Assumption.
Save LSLstar_context_cons_t.

Goal (a:terms)(s,s':substitutions)(relLSLstar true s s')->
                (relLSLstar true (cons a s) (cons a s')). 
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (cons a y).
Apply LSL_context_cons_s;Assumption.
Assumption.
Save LSLstar_context_cons_s.

Goal (a,a':terms)(s,s':substitutions)(relLSLstar false a a')->(relLSLstar true s s')->
                                        (relLSLstar true (cons a s) (cons a' s')).
Intros;Red.
Apply star_trans with (cons a' s).
Change (relLSLstar true (cons a s) (cons a' s)).
Apply LSLstar_context_cons_t;Assumption.
Change (relLSLstar true (cons a' s) (cons a' s')).
Apply LSLstar_context_cons_s;Assumption.
Save LSLstar_context_cons.

Goal (s,s',t:substitutions)(relLSLstar true s s')->
			  (relLSLstar true (comp s t) (comp s' t)).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (comp y t).
Apply LSL_context_comp_l;Assumption.
Assumption.
Save LSLstar_context_comp_l.

Goal (s,t,t':substitutions)(relLSLstar true t t')->
			  (relLSLstar true (comp s t) (comp s t')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (comp s y).
Apply LSL_context_comp_r;Assumption.
Assumption.
Save LSLstar_context_comp_r.

Goal (s,s',t,t':substitutions)(relLSLstar true t t')->(relLSLstar true s s')->
                                        (relLSLstar true (comp s t) (comp s' t')).
Intros;Red.
Apply star_trans with (comp s' t).
Change (relLSLstar true (comp s t) (comp s' t)).
Apply LSLstar_context_comp_l;Assumption.
Change (relLSLstar true (comp s' t) (comp s' t')).
Apply LSLstar_context_comp_r;Assumption.
Save LSLstar_context_comp.

Goal  (s,s':substitutions)(relLSLstar true s s')->
                                  (relLSLstar true (lift s) (lift s')).
Red;Induction 1;Intros.
Apply  star_refl.
Apply star_trans1 with (lift y).
Apply LSL_context_lift;Assumption.
Assumption.
Save LSLstar_context_lift.


Provide lambda_sigma_lift.
