
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                       (* Inversion de sigma_lift (relSL) *)

Require sigma_lift.


Definition invSL=[b:bool][M:(TS b)][N:(TS b)]
(<[b:bool]Prop>Match M with 
 (* var *) [n:nat] False
 (* app *) [M1:terms][P1:Prop][M2:terms][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]
                      ((relSL false M1 N1)/\<terms>M2=N2)\/
                      (<terms>M1=N1/\(relSL false M2 N2))
            (* lam *) [N1:terms][P1:Prop]False 
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions]
                      [P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False )
 (* lam *) [M1:terms][P1:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop](relSL false M1 N1)
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False  )
 (* env *) [M1:terms][P1:Prop][M2:substitutions][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat] 
                <nat>Ex([m:nat]<terms>M1=(var m)/\<nat>n=(S m)/\
                     <substitutions>M2=shift)
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                                  <substitutions>M2=(lift s)/\<nat>n=O)
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                            <substitutions>M2=(cons (var n) s))
             \/ (<terms>M1=(var n)/\<substitutions>M2=id)
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop] 
                <terms>Ex([a:terms]<terms>Ex([b:terms]<terms>M1=(app a b)
                 /\<terms>N1=(env a M2)/\<terms>N2=(env b M2)))
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                            <substitutions>M2=(cons (app N1 N2) s))
             \/ (<terms>M1=(app N1 N2)/\<substitutions>M2=id) 
            (* lam *) [N1:terms][P1:Prop]
                <terms>Ex([a:terms]<terms>M1=(lambda a)
                                 /\<terms>N1=(env a (lift M2)))
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                            <substitutions>M2=(cons (lambda N1) s))
             \/ (<terms>M1=(lambda N1)/\<substitutions>M2=id) 
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                <substitutions>Ex([s:substitutions]<terms>M1=(env N1 s)/\
                            <substitutions>N2=(comp s M2))   
             \/ <nat>Ex([n:nat]<terms>M1=(var n)/\
                   <substitutions>M2=(comp shift N2)/\<terms>N1=(var (S n)))
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                            <substitutions>M2=(cons (env N1 N2) s))
             \/ <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                      <substitutions>M2=(comp (lift s) N2)/\<terms>N1=(var O))
             \/ <nat>Ex([n:nat]<terms>Ex([a:terms]<terms>M1=(var (S n))/\
                  <substitutions>M2=(cons a N2)/\<terms>N1=(var n)))
             \/ <nat>Ex([n:nat]<substitutions>Ex([s:substitutions]
                <terms>M1=(var (S n))/\<substitutions>M2=(lift s)/\
                <terms>N1=(var n)/\<substitutions>N2=(comp s shift)))
             \/ <nat>Ex([n:nat]<substitutions>Ex([s:substitutions]
                  <substitutions>Ex([t:substitutions]<terms>M1=(var (S n))/\
                  <substitutions>M2=(comp (lift s) t)/\<terms>N1=(var n)/\
                  <substitutions>N2=(comp s (comp shift t)))))
             \/ (<terms>M1=(env N1 N2)/\<substitutions>M2=id)                   
             \/ ((relSL false M1 N1)/\<substitutions>M2=N2)
             \/ (<terms>M1=N1/\(relSL true M2 N2))
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]
             <substitutions>Ex([s:substitutions]<terms>M1=(var O)/\
                            <substitutions>M2=(cons (meta_X n) s))
             \/ (<terms>M1=(meta_X n)/\<substitutions>M2=id)
            (*  x  *) [n:nat]False )
 (* id  *) False
 (*  |  *) False 
 (*  .  *) [M1:terms][P1:Prop][M2:substitutions][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False 
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                      ((relSL false M1 N1)/\<substitutions>M2=N2)
                      \/ (<terms>M1=N1/\(relSL true M2 N2))
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False )
 (*  o  *) [M1:substitutions][P1:Prop][M2:substitutions][P2:Prop]  
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a id))
                   \/ (<substitutions>M1=id/\<substitutions>M2=id)
            (*  |  *) <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a shift))
                   \/ (<substitutions>M1=id/\<substitutions>M2=shift)
                   \/ (<substitutions>M1=shift/\<substitutions>M2=id)
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                  <terms>Ex([a:terms]<substitutions>Ex([s:substitutions]
                     <substitutions>M1=(cons a s)/\<terms>N1=(env a M2)/\
                     <substitutions>N2=(comp s M2)))
               \/ <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a (cons N1 N2)))
               \/ <substitutions>Ex([s:substitutions]
                     <substitutions>Ex([t:substitutions]
                     <substitutions>M1=(lift s)/\<substitutions>M2=(cons N1 t)
                        /\<substitutions>N2=(comp s t)))
               \/ (<substitutions>M1=id/\<substitutions>M2=(cons N1 N2))
               \/ (<substitutions>M1=(cons N1 N2)/\<substitutions>M2=id)  
            (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]
                 <substitutions>Ex([t:substitutions]
                  <substitutions>M1=(comp N1 t)/\<substitutions>N2=(comp t M2))    
              \/ <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a (comp N1 N2)))
              \/ (<substitutions>M1=shift/\<substitutions>M2=(lift N1)/\
                      <substitutions>N2=shift)
              \/ <substitutions>Ex([t:substitutions]<substitutions>M1=shift/\
                   <substitutions>M2=(comp (lift N1) t)/\
                   <substitutions>N2=(comp shift t))
              \/ <substitutions>Ex([s:substitutions] 
                 <substitutions>Ex([t:substitutions]<substitutions>M1=(lift s)/\
                    <substitutions>M2=(comp (lift t) N2)/\
                          <substitutions>N1=(lift (comp s t))))
              \/ (<substitutions>M1=id/\<substitutions>M2=(comp N1 N2))
              \/ (<substitutions>M1=(comp N1 N2)/\<substitutions>M2=id)
              \/ ((relSL true M1 N1)/\<substitutions>M2=N2)
              \/ (<substitutions>M1=N1/\(relSL true M2 N2)) 
            (* ||  *) [N1:substitutions][P1:Prop]
                 <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a (lift N1)))
              \/ <substitutions>Ex([s:substitutions] 
                 <substitutions>Ex([t:substitutions]<substitutions>M1=(lift s)/\
                 <substitutions>M2=(lift t)/\<substitutions>N1=(comp s t)))
              \/ (<substitutions>M1=id/\<substitutions>M2=(lift N1))
              \/ (<substitutions>M1=(lift N1)/\<substitutions>M2=id)
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat] 
                 <terms>Ex([a:terms]<substitutions>M1=shift/\
                        <substitutions>M2=(cons a (meta_x n)))
                   \/ (<substitutions>M1=id/\<substitutions>M2=(meta_x n))
                   \/ (<substitutions>M1=(meta_x n)/\<substitutions>M2=id) )    
 (* ||  *) [M1:substitutions][P1:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) <substitutions>M1=id
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions]
                      [P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop](relSL true M1 N1)
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
  (*  X  *) [n:nat]False
  (*  x  *) [n:nat]False ). 


Goal (b:bool)(M,N:(TS b))(systemSL b M N)->(invSL b M N).
Induction 1;Induction 1;Intros.
(* app *)
Simpl;Left;Exists a0;Exists b1;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* lambda *)
Simpl;Left;Exists a0;(* Auto *)Apply conj;Apply refl_equal.
(* clos *)
Simpl;Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
(* varshift1 *)
Simpl;Left;Exists n;(* Auto *)Apply conj;[Apply refl_equal|
Apply conj;Apply refl_equal].
(* varshift2 *)
Simpl;Right;Left;Exists n;(* Auto *)Apply conj;[Apply refl_equal|
Apply conj;Apply refl_equal].
(* fvarcons *)
Pattern a0;Apply terms_ind;Intros;Simpl.
 (* var *)
Do 2 Right;Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
 (* app *)
Right;Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
 (* lam *)
Right;Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
 (* env *)
Do 2 Right;Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
 (* X *)
Left;Exists s;(* Auto *)Apply conj;Apply refl_equal.
(* fvarlift1 *)
Simpl;Right;Left;Exists s;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* fvarlift2 *)
Simpl;Do 3 Right;Left;Exists s;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* rvarcons *)
Simpl;Do 4 Right;Left;Exists n;Exists a0;(* Auto *)Apply conj; 
[Apply refl_equal|Apply conj;Apply refl_equal].
(* rvarlift1 *)
Simpl;Do 5 Right;Left;Exists n;Exists s;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;[Apply refl_equal|Apply conj;Apply refl_equal]].
(* rvarlift2 *)
Simpl;Do 6 Right;Left;Exists n;Exists s;Exists t;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;[Apply refl_equal|Apply conj;Apply refl_equal]].
(* assenv *)
Simpl;Left;Exists t0;(* Auto *)Apply conj;Apply refl_equal.
(* mapenv *)
Simpl;Left;Exists a;Exists s0;(* Auto *)Apply conj; 
[Apply refl_equal|Apply conj;Apply refl_equal].
(* shiftcons *)
Pattern s0;Apply substitutions_ind;Intros;Simpl.
 (* id *)
Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
 (* | *)
Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
 (* . *)
Right;Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
 (* o *)
Right;Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
 (* || *)
Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
 (* x *)
Left;Exists a;(* Auto *)Apply conj;Apply refl_equal.
(* shiftlift1 *)
Simpl;Do 2 Right;Left;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* shiftlift2 *)
Simpl;Do 3 Right;Left;Exists t0;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* lift1 *)
Simpl;Right;Left;Exists s0;Exists t0;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* lift2 *)
Simpl;Do 4 Right;Left;Exists s0;Exists t0;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* liftenv *)
Simpl;Right;Right;Left;Exists s0;Exists t0;(* Auto *)Apply conj;
[Apply refl_equal|Apply conj;Apply refl_equal].
(* idl *)
Pattern s0;Apply substitutions_ind;Intros;Simpl.
 (* id *)
Right;(* Auto *)Apply conj;Apply refl_equal.
 (* | *)
Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* . *)
Do 3 Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* o *)
Do 5 Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* || *)
Do 2 Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* x *)
Right;Left;(* Auto *)Apply conj;Apply refl_equal.
(* idr *)
Pattern s0;Apply substitutions_ind;Intros;Simpl.
 (* id *)
Right;(* Auto *)Apply conj;Apply refl_equal.
 (* | *)
Right;Right;(* Auto *)Apply conj;Apply refl_equal.
 (* . *)
Do 4 Right;(* Auto *)Apply conj;Apply refl_equal.
 (* o *)
Do 6 Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* || *)
Do 3 Right;(* Auto *)Apply conj;Apply refl_equal.
 (* x *)
Right;Right;(* Auto *)Apply conj;Apply refl_equal.
(* liftid *)
Simpl;(* Auto *)Apply refl_equal.
(* id *)
Pattern a0;Apply terms_ind;Intros;Simpl.
 (* var *)
Do 3 Right;(* Auto *)Apply conj;Apply refl_equal.
 (* app *)
Do 2 Right;(* Auto *)Apply conj;Apply refl_equal.
 (* lam *)
Do 2 Right;(* Auto *)Apply conj;Apply refl_equal.
 (* env *)
Do 7 Right;Left;(* Auto *)Apply conj;Apply refl_equal.
 (* X *)
Right;(* Auto *)Apply conj;Apply refl_equal.
Save lemma1_inv_systemSL.

Goal (b:bool)(M,N:(TS b))(relSL b M N)->(invSL b M N).
Induction 1;Intros;Simpl.
(* systeme SL *)
Apply lemma1_inv_systemSL;Assumption.
(* contexte app droit *)
(* Auto *)Apply or_introl;Apply conj;[Assumption|Apply refl_equal].
(* contexte app gauche *)
(* Auto *)Apply or_intror;Apply conj;[Apply refl_equal|Assumption].
(* contexte lambda *)
(* Auto *)Assumption.
(* contexte env droit *)
Do 8 Right;Left;(* Auto *)Apply conj;[Assumption|Apply refl_equal].
(* contexte env gauche *)
Do 9 Right;(* Auto *)Apply conj;[Apply refl_equal|Assumption].
(* contexte cons droit *)
(* Auto *)Apply or_introl;Apply conj;[Assumption|Apply refl_equal].
(* contexte cons gauche *)
(* Auto *)Apply or_intror;Apply conj;[Apply refl_equal|Assumption].
(* contexte comp droit *)
Do 7 Right;Left;(* Auto *)Apply conj;[Assumption|Apply refl_equal].
(* contexte comp gauche *)
Do 8 Right;(* Auto *)Apply conj;[Apply refl_equal|Assumption].
(* contexte lift *)
(* Auto *)Assumption.
Save lemma1_invSL.

Provide inversionSL.







