
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)

      
                      (* egalite dans les termes-substitutions (TS) *)


Require TS.

(***********************************************)
(*          Predicats structure                *)
(***********************************************)

Definition Bvar= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]True
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Bapp= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]True
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Blambda= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]True
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Benv= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]True
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Bid= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)True
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Bshift= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)True
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Bcons= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]True
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Bcomp= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]True
(* ||  *)[s:substitutions][P:Prop]False
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

Definition Blift= [b:bool][U:(TS b)]
(<[b:bool]Prop>Match U with
(* var *)[n:nat]False
(* app *)[U1:terms][P1:Prop][U2:terms][P2:Prop]False
(* lam *)[U1:terms][P1:Prop]False
(* env *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(* id  *)False
(*  |  *)False
(*  .  *)[U1:terms][P1:Prop][s:substitutions][P2:Prop]False
(*  o  *)[s1:substitutions][P1:Prop][s2:substitutions][P2:Prop]False
(* ||  *)[s:substitutions][P:Prop]True
(*  X  *)[n:nat]False
(*  x  *)[n:nat]False).

(***********************************************)
(*            Inegalites dans TS               *)
(***********************************************)

Goal (n:nat)(a,b:terms)~<terms>(var n)=(app a b).
Red;Intros n a b H.
Change (Bapp false (var n));Rewrite H;Simpl;Trivial.
Save diff_var_app.

Goal (n:nat)(a:terms)~<terms>(var n)=(lambda a).
Red;Intros n a H.
Change (Blambda false (var n));Rewrite H;Simpl;Trivial.
Save diff_var_lambda.

Goal (n:nat)(a:terms)(s:substitutions)~<terms>(var n)=(env a s).
Red;Intros n a s H.
Change (Benv false (var n));Rewrite H;Simpl;Trivial.
Save diff_var_env.

Goal (a,b,c:terms)~<terms>(app a b)=(lambda c).
Red;Intros a b c H.
Change (Blambda false (app a b));Rewrite H;Simpl;Trivial.
Save diff_app_lambda.

Goal (a,b,c:terms)(s:substitutions)~<terms>(app a b)=(env c s).
Red;Intros a b c s H.
Change (Benv false (app a b));Rewrite H;Simpl;Trivial.
Save diff_app_env.

Goal (a,b:terms)(s:substitutions)~<terms>(lambda a)=(env b s).
Red;Intros a b s H.
Change (Benv false (lambda a));Rewrite H;Simpl;Trivial.
Save diff_lambda_env.

Goal ~<substitutions>id=shift.
Red;Intro H.
Change (Bshift true id);Rewrite H;Simpl;Trivial.
Save diff_id_shift.

Goal (a:terms)(s:substitutions)~<substitutions>id=(cons a s).
Red;Intros a s H.
Change (Bcons true id);Rewrite H;Simpl;Trivial.
Save diff_id_cons.

Goal (s,t:substitutions)~<substitutions>id=(comp s t).
Red;Intros s t H.
Change (Bcomp true id);Rewrite H;Simpl;Trivial.
Save diff_id_comp.

Goal (s:substitutions)~<substitutions>id=(lift s).
Red;Intros s H.
Change (Blift true id);Rewrite H;Simpl;Trivial.
Save diff_id_lift.

Goal (a:terms)(s:substitutions)~<substitutions>shift=(cons a s).
Red;Intros a s H.
Change (Bcons true shift);Rewrite H;Simpl;Trivial.
Save diff_shift_cons.

Goal (s,t:substitutions)~<substitutions>shift=(comp s t).
Red;Intros s t H.
Change (Bcomp true shift);Rewrite H;Simpl;Trivial.
Save diff_shift_comp.

Goal (s:substitutions)~<substitutions>shift=(lift s).
Red;Intros s H.
Change (Blift true shift);Rewrite H;Simpl;Trivial.
Save diff_shift_lift.

Goal (a:terms)(s,t,u:substitutions)~<substitutions>(cons a s)=(comp t u).
Red;Intros a s t u H.
Change (Bcomp true (cons a s));Rewrite H;Simpl;Trivial.
Save diff_cons_comp.

Goal (a:terms)(s,t:substitutions)~<substitutions>(cons a s)=(lift t).
Red;Intros a s t H.
Change (Blift true (cons a s));Rewrite H;Simpl;Trivial.
Save diff_cons_lift.

Goal (s,t,u:substitutions)~<substitutions>(comp s t)=(lift u).
Red;Intros s t u H.
Change (Blift true (comp s t));Rewrite H;Simpl;Trivial.
Save diff_comp_lift.

(***********************************************)
(*         Predicats destruction               *)
(***********************************************)

Definition Dvar= [m:nat][b:bool][U:(TS b)]
(<[b:bool]nat>Match U with
(* var *)[n:nat]n
(* app *)[U1:terms][P1:nat][U2:terms][P2:nat]m
(* lam *)[U1:terms][P1:nat]m
(* env *)[U1:terms][P1:nat][s:substitutions][P2:nat]m
(* id  *)m
(*  |  *)m
(*  .  *)[U1:terms][P1:nat][s:substitutions][P2:nat]m
(*  o  *)[s1:substitutions][P1:nat][s2:substitutions][P2:nat]m
(* ||  *)[s:substitutions][P:nat]m
(*  X  *)[n:nat]n
(*  x  *)[n:nat]n).

Definition Destruct1= [b:bool][U:(TS b)]
(<[b:bool](TS b)>Match U with
(* var *)var
(* app *)[U1:terms][P1:terms][U2:terms][P2:terms]U1
(* lam *)[U1:terms][P1:terms]U1
(* env *)[U1:terms][P1:terms][s:substitutions][P2:substitutions]U1
(* id  *)id 
(*  |  *)shift
(*  .  *)[U1:terms][P1:terms][s:substitutions][P2:substitutions]s
(*  o  *)[s1:substitutions][P1:substitutions][s2:substitutions]
         [P2:substitutions]s1
(* ||  *)[s:substitutions][P:substitutions]s
(*  X  *)meta_X
(*  x  *)meta_x ).

Definition Destruct2= [b:bool][U:(TS b)]
(<[b:bool](TS b)>Match U with
(* var *)var
(* app *)[U1:terms][P1:terms][U2:terms][P2:terms]U2
(* lam *)[U1:terms][P1:terms]U1
(* env *)[U1:terms][P1:terms][s:substitutions][P2:substitutions]U1
(* id  *)id
(*  |  *)shift
(*  .  *)[U1:terms][P1:terms][s:substitutions][P2:substitutions]s
(*  o  *)[s1:substitutions][P1:substitutions][s2:substitutions]
         [P2:substitutions]s2
(* ||  *)[s:substitutions][P:substitutions]s
(*  X  *)meta_X
(*  x  *)meta_x ).

Definition Dest_subst= [b:bool][U:(TS b)]
(<[b:bool]substitutions>Match U with
(* var *)[n:nat]id
(* app *)[U1:terms][P1:substitutions][U2:terms]
         [P2:substitutions]id
(* lam *)[U1:terms][P1:substitutions]id
(* env *)[U1:terms][P1:substitutions][s:substitutions]
         [P2:substitutions]s
(* id  *)id
(*  |  *)id
(*  .  *)[U1:terms][P1:substitutions][s:substitutions]
         [P2:substitutions]s
(*  o  *)[s1:substitutions][P1:substitutions][s2:substitutions]
         [P2:substitutions]s2
(* ||  *)[s:substitutions][P:substitutions]s
(*  X  *)[n:nat]id
(*  x  *)meta_x ).

Definition Dest_term= [b:bool][U:(TS b)]
(<[b:bool]terms>Match U with
(* var *)var
(* app *)[U1:terms][P1:terms][U2:terms][P2:terms]U1
(* lam *)[U1:terms][P1:terms]U1
(* env *)[U1:terms][P1:terms][s:substitutions][P2:terms]U1
(* id  *)(var O)
(*  |  *)(var O)
(*  .  *)[U1:terms][P1:terms][s:substitutions][P2:terms]U1
(*  o  *)[s1:substitutions][P1:terms][s2:substitutions]
         [P2:terms](var O)
(* ||  *)[s:substitutions][P:terms](var O)
(*  X  *)meta_X
(*  x  *)[n:nat](var O) ).


(***********************************************)
(*             Egalite dans TS                 *)
(***********************************************)

Goal (n1,n2:nat)<terms>(var n1)=(var n2)-><nat>n1=n2. 
Intros;Replace n1 with (Dvar n1 false (var n1)).
Replace n2 with (Dvar n1 false (var n2)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_var.

Goal (a1,b1,a2,b2:terms)<terms>(app a1 b1)=(app a2 b2)-><terms>a1=a2.
Intros;Replace a1 with (Destruct1 false (app a1 b1)).
Replace a2 with (Destruct1 false (app a2 b2)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_app1.

Goal (a1,b1,a2,b2:terms)<terms>(app a1 b1)=(app a2 b2)-><terms>b1=b2.
Intros;Replace b1 with (Destruct2 false (app a1 b1)).
Replace b2 with (Destruct2 false (app a2 b2)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_app2.

Goal (a,b:terms)<terms>(lambda a)=(lambda b)-><terms>a=b.
Intros;Replace a with (Destruct1 false (lambda a)).
Replace b with (Destruct1 false (lambda b)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_lambda.

Goal (a,b:terms)(s,t:substitutions)<terms>(env a s)=(env b t)-><terms>a=b.
Intros;Replace a with (Destruct1 false (env a s)).
Replace b with (Destruct1 false (env b t)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_env1.

Goal (a,b:terms)(s,t:substitutions)<terms>(env a s)=(env b t)->
                                                   <substitutions>s=t.
Intros;Replace s with (Dest_subst false (env a s)).
Replace t with (Dest_subst false (env b t)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_env2.

Goal (a,b:terms)(s,t:substitutions)<substitutions>(cons a s)=(cons b t)->
                                                        <terms>a=b.
Intros;Replace a with (Dest_term true (cons a s)).
Replace b with (Dest_term true (cons b t)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_cons1.

Goal (a,b:terms)(s,t:substitutions)<substitutions>(cons a s)=(cons b t)->
                                               <substitutions>s=t.
Intros;Replace s with (Destruct2 true (cons a s)).
Replace t with (Destruct2 true (cons b t)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_cons2.

Goal (s1,s2,t1,t2:substitutions)<substitutions>(comp s1 t1)=(comp s2 t2)->
                                <substitutions>s1=s2.
Intros;Replace s1 with (Destruct1 true (comp s1 t1 )).
Replace s2 with (Destruct1 true (comp s2 t2 )).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_comp1.

Goal (s1,s2,t1,t2:substitutions)<substitutions>(comp s1 t1)=(comp s2 t2)->
                                <substitutions>t1=t2.
Intros;Replace t1 with (Destruct2 true (comp s1 t1 )).
Replace t2 with (Destruct2 true (comp s2 t2 )).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_comp2.

Goal (s,t:substitutions)<substitutions>(lift s)=(lift t)->
                        <substitutions>s=t.
Intros;Replace s with (Destruct1 true (lift s)).
Replace t with (Destruct1 true (lift t)).
Elim H;(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
(* Trivial *)Apply refl_equal.
Save proj_lift.


Provide egaliteTS.



