
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)

 
    (* confluence locale de sigma-lift: determination des paires critiques *)


  (* L'idee est:
     partant d'un terme-substitution X, trouver tous ses "reduits" possibles
     par la relation sigma-lift (SL), c.a.d. tous les Y tq: X--SL-->Y.
     on prendra notamment pour X tous les membres gauches des regles de
     sigma-lift, ceci nous indique les paires critiques (PC) a resoudre     *)

Require egaliteTS.
Require inversionSL.

(*** (var n) SL ? ***)

Goal (n:nat)(M:terms)~(relSL false (var n) M).
Red;Intros n M H;Cut (invSL false (var n) M).
2:Apply lemma1_invSL;Assumption.
Induction 1.
Save case_SLvar.

(*** (app a b) SL ? ***)

Goal (P:terms->Prop)(a,b:terms)
 ((a':terms)(relSL false a a')->(P (app a' b)))->
 ((b':terms)(relSL false b b')->(P (app a b')))->
 (M:terms)(relSL false (app a b) M)->(P M).
Intros P a b H H0 M H1;Cut (invSL false (app a b) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Induction 3;Induction 1;Intros.
Elim H7;Apply H;Assumption.
Elim H6;Apply H0;Assumption.
(* lam *)
Induction 2.
(* env *)
Induction 2.
(* X *)
Induction 1.
Save case_SLapp.

(*** (lambda a) SL ? ***)

Goal (P:terms->Prop)(a:terms)
 ((a':terms)(relSL false a a')->(P (lambda a')))->
 (M:terms)(relSL false (lambda a) M)->(P M).
Intros P a H M H0;Cut (invSL false (lambda a) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Induction 3.
(* lambda *)
Unfold 2 invSL;Intros;Apply H;Assumption.
(* env *)
Induction 2.
(* X *)
Induction 1.
Save case_SLlambda.

(*** (env a s) SL ? ***)

Goal (P:terms->substitutions->terms->Prop)(a:terms)(s:substitutions)
 ((a1,b1:terms)(P (app a1 b1) s (app (env a1 s) (env b1 s))))->
 ((a1:terms)(P (lambda a1) s (lambda (env a1 (lift s)))))->
 ((a1:terms)(s1:substitutions)(P (env a1 s1) s (env a1 (comp s1 s))))->
 ((n:nat)(P (var n) shift (var (S n))))->
 ((n:nat)(s1:substitutions)(P (var n) (comp shift s1) (env (var (S n)) s1)))->
 ((a1:terms)(s1:substitutions)(P (var O) (cons a1 s1) a1))->
 ((s1:substitutions)(P (var O) (lift s1) (var O)))-> 
 ((s1,s2:substitutions)(P (var O) (comp (lift s1) s2) (env (var O) s2)))->
 ((n:nat)(a1:terms)(s1:substitutions)(P (var (S n)) (cons a1 s1) (env (var n) s1)))->
 ((n:nat)(s1:substitutions)(P (var (S n)) (lift s1) (env (var n) (comp s1 shift))))->
 ((n:nat)(s1,s2:substitutions)(P (var (S n)) (comp (lift s1) s2) 
                                   (env (var n) (comp s1 (comp shift s2)))))->
 (P a id a)->
 ((a':terms)(relSL false a a')->(P a s (env a' s)))->
 ((s':substitutions)(relSL true s s')->(P a s (env a s')))->
 (M:terms)(relSL false (env a s) M)->(P a s M).
Intros P a s;Intros;Cut (invSL false (env a s) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
 (* varshift1 *)
Do 2 (Induction 1);Induction 2;Intros.
Rewrite H20;Rewrite H19;Rewrite H17;Apply H2.
 (* fvarlift1 *)
Induction 1.
Do 2 (Induction 1);Induction 2;Intros.
Rewrite H21;Rewrite H20;Rewrite H18;Apply H5.
 (* fvarcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H20;Rewrite H19;Apply H4.
 (* id *)
Induction 1;Intros.
Elim H18;Rewrite H19;Apply H10.
(* app *)
 (* app *)
Induction 3.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H23;Rewrite H22;Rewrite H20;Apply H.
 (* fvarcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H21;Rewrite H20;Apply H4.
 (* id *)
Induction 1;Intros.
Rewrite H20;Elim H19;Apply H10.
(* lam *)
 (* lambda *)
Induction 2.
Do 2 (Induction 1);Intros.
Rewrite H19;Rewrite H18;Apply H0.
 (* fvarcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H20;Rewrite H19;Apply H4.
 (* id *)
Induction 1;Intros.
Rewrite H19;Elim H18;Apply H10.
(* env *)
 (* clos *)
Induction 2.
Do 2 (Induction 1);Intros.
Rewrite H19;Rewrite H18;Apply H1.
 (* varshift2 *)
Induction 1.
Do 2 (Induction 1);Induction 2;Intros.
Rewrite H22;Rewrite H21;Rewrite H19;Apply H3.
 (* fvarcons *) 
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H21;Rewrite H20;Apply H4.
 (* favrlift2 *)
Induction 1.
Do 2 (Induction 1);Induction 2;Intros.
Rewrite H24;Rewrite H23;Rewrite H21;Apply H6.
 (* rvarcons *)
Induction 1.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H26;Rewrite H25;Rewrite H23;Apply H7.
 (* rvarlift1 *)
Induction 1.
Do 3 (Induction 1);Do 2 (Induction 2);Intros.
Rewrite H29;Rewrite H28;Rewrite H26;Rewrite H24;Apply H8.
 (* rvarlift2 *)
Induction 1.
Do 4 (Induction 1);Do 2 (Induction 2);Intros.
Rewrite H31;Rewrite H30;Rewrite H28;Rewrite H26;Apply H9.
 (* id *)
Induction 1.
Induction 1;Intros.
Rewrite H25;Elim H24;Apply H10.
 (* contexte droit *)
Induction 1.
Induction 1;Intros.
Elim H26;Apply H11;Assumption.
 (* contexte gauche *)
Induction 1.
Induction 1;Intros.
Elim H25;Apply H12;Assumption.
(* X *)
Induction 1.
 (* fvarcons *)
Do 2 (Induction 1);Intros.
Rewrite H18;Rewrite H17;Apply H4.
 (* id *)
Induction 1;Intros.
Elim H16;Rewrite H17;Assumption.
Save case_SLenv.

(*** id SL ? ***)

Goal (M:substitutions)~(relSL true id M).
Red;Intros M H;Cut (invSL true id M).
2:Apply lemma1_invSL;Assumption.
Induction 1.
Save case_SLid.

(*** shift SL ? ***)

Goal (M:substitutions)~(relSL true shift M).
Red;Intros M H;Cut (invSL true shift M).
2:Apply lemma1_invSL;Assumption.
Induction 1.
Save case_SLshift.

(*** (cons a s) SL ? ***)

Goal (P:substitutions->Prop)(a:terms)(s:substitutions)
 ((a':terms)(relSL false a a')->(P (cons a' s)))->
 ((s':substitutions)(relSL true s s')->(P (cons a s')))->
 (M:substitutions)(relSL true (cons a s) M)->(P M).
Intros P a s H H0 M H1;Cut (invSL true (cons a s) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
Induction 1.
(* | *)
Induction 1.
(* . *)
Induction 2;Induction 1;Intros.
Elim H6;Apply H;Assumption.
Elim H5;Apply H0;Assumption.
(* o *)
Induction 3.
(* || *)
Induction 2.
(* x *)
Induction 1.
Save case_SLcons.

(*** (comp s t) SL ? ***)

Goal (P:substitutions->substitutions->substitutions->Prop)(s,t:substitutions)
 ((s1,s2:substitutions)(P (comp s1 s2) t (comp s1 (comp s2 t))))->
 ((a:terms)(s1:substitutions)(P (cons a s1) t (cons (env a t) (comp s1 t))))->
 ((a:terms)(t1:substitutions)(P shift (cons a t1) t1))->
 ((t1:substitutions)(P shift (lift t1) (comp t1 shift)))->
 ((t1,t2:substitutions)(P shift (comp (lift t1) t2) (comp t1 (comp  shift t2))))->
 ((s1,t1:substitutions)(P (lift s1) (lift t1) (lift (comp s1 t1))))->
 ((s1,t1,t2:substitutions)(P (lift s1) (comp (lift t1) t2) 
                          (comp (lift (comp s1 t1)) t2)))->
 ((a:terms)(s1,t1:substitutions)(P (lift s1) (cons a t1) (cons a (comp  s1 t1))))->
 (P id t t)->
 (P s id s)->
 ((s':substitutions)(relSL true s s')->(P s t (comp s' t)))->
 ((t':substitutions)(relSL true t t')->(P s t (comp s t')))->
 (M:substitutions)(relSL true (comp s t) M)->(P s t M).
Intros P s t;Intros;Cut (invSL true (comp s t) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
 (* shiftcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H15;Rewrite H16;Apply H1.
 (* idr, idl *)
Induction 1;Intros.
Rewrite H14;Pattern 2 id;Elim H15;Apply H7.
(* | *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H15;Rewrite H16;Apply H1.
 (* idl *)
Induction 1.
Induction 1;Intros.
Rewrite H15;Elim H16;Apply H7.
 (* idr *)
Induction 1;Intros.
Rewrite H16;Elim H15;Apply H8.
(* cons *)
 (* mapenv *)
Induction 2.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H17;Rewrite H20;Rewrite H19;Apply H0.
 (* shiftcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H17;Rewrite H18;Apply H1.
 (* liftenv *)
Induction 1.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H22;Rewrite H21;Rewrite H19;Apply H6.
 (* idl *)
Induction 1.
Induction 1;Intros.
Rewrite H18;Elim H19;Apply H7.
 (* idr *)
Induction 1;Intros.
Rewrite H19;Elim H18;Apply H8.
(* comp *)
Induction 3.
 (* assenv *)
Do 2 (Induction 1);Intros.
Rewrite H18;Rewrite H17;Apply H.
 (* shiftcons *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H18;Rewrite H19;Apply H1.
 (* shiftlift1 *)
Induction 1.
Induction 1;Induction 2;Intros.
Rewrite H21;Rewrite H20;Rewrite H18;Apply H2.
 (* shiftlift2 *)
Induction 1.
Do 2 (Induction 1);Induction 2;Intros.
Rewrite H23;Rewrite H22;Rewrite H20;Apply H3.
 (* lift2 *)
Induction 1.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H25;Rewrite H24;Rewrite H22;Apply H5.
 (* idl *)
Induction 1.
Induction 1;Intros.
Rewrite H21;Elim H22;Apply H7.
 (* idr *)
Induction 1.
Induction 1;Intros.
Rewrite H23;Elim H22;Apply H8.
 (* contexte gauche *)
Induction 1.
Induction 1;Intros.
Elim H24;Apply H9;Assumption.
 (* contexte droit *)
Induction 1;Intros.
Elim H23;Apply H10;Assumption.
(* lift *)
Induction 2.
 (* shiftcons *)
Do 2 (Induction 1);Intros.
Rewrite H17;Rewrite H16;Apply H1.
 (* lift1 *)
Induction 1.
Do 3 (Induction 1);Induction 2;Intros.
Rewrite H21;Rewrite H20;Rewrite H18;Apply H4.
 (* idl *)
Induction 1.
Induction 1;Intros.
Rewrite H17;Elim H18;Apply H7.
 (* idr *)
Induction 1;Intros.
Rewrite H18;Elim H17;Apply H8.
(* x *)
Induction 1.
Do 2 (Induction 1);Intros.
Rewrite H15;Rewrite H16;Apply H1.
 (* idl *)
Induction 1.
Induction 1;Intros.
Rewrite H15;Elim H16;Apply H7.
 (* idr *)
Induction 1;Intros.
Rewrite H16;Elim H15;Apply H8.
Save case_SLcomp.

(*** (lift s) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s:substitutions)
 (P id id )->
 ((s':substitutions)(relSL true s s')->(P s (lift s')))->
 (M:substitutions)(relSL true (lift s) M)->(P s M).
Intros P s H H0 M H1;Cut (invSL true (lift s) M).
2:Apply lemma1_invSL;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
Simpl;Intro H2;Rewrite H2;Assumption.
(* | *)
Induction 1.
(* . *)
Induction 2.
(* o *)
Induction 3.
(* || *)
Unfold 2 invSL;Intros;Apply H0;Assumption.
(* x *)
Induction 1.
Save case_SLlift.

(*** (env (lambda a) s) SL ? ***)

Goal (P:substitutions->terms->Prop)(a:terms)(s:substitutions)
 (P s (lambda (env a (lift s))))->
 (P id (lambda a))->
 ((x':terms)(relSL false (lambda a) x')->(P s (env x' s)))->
 ((s':substitutions)(relSL true s s')->(P s (env (lambda a) s')))->
 (M:terms)(relSL false (env (lambda a) s) M)->(P s M).
Intros.
Cut <terms>(lambda a)=(lambda a).
2:(* Auto *)Apply refl_equal.
Pattern 1 (lambda a) s M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_app_lambda a1 b1 a H4).
(* lambda *)
Rewrite (proj_lambda a1 a H4);Assumption.
(* clos *)Elim (diff_lambda_env a a1 s1 (sym_equal terms (env a1 s1) (lambda a) H4)).
(* varshift1 *)Elim (diff_var_lambda n a H4).
(* varshift2 *)Elim (diff_var_lambda n a H4).
(* fvarcons *)Elim (diff_var_lambda O a H4).
(* fvarlift1 *)Elim (diff_var_lambda O a H4).
(* fvarlift2 *)Elim (diff_var_lambda O a H4).
(* rvarcons *)Elim (diff_var_lambda (S n) a H4).
(* rvarlift1 *)Elim (diff_var_lambda (S n) a H4).
(* rvarlift2 *)Elim (diff_var_lambda (S n) a H4).
(* id *)
Assumption.
(* contexte gauche*)
Apply H1;Assumption.
(* contexte droit *)
Apply H2;Assumption.
Save case_SL_reg_lambda.

(*** (env (app a b) s) SL ? ***)

Goal (P:substitutions->terms->Prop)(a,b:terms)(s:substitutions)
 (P s (app (env a s) (env b s)))->
 (P id (app a b))->
 ((x':terms)(relSL false (app a b) x')->(P s (env x' s)))->
 ((s':substitutions)(relSL true s s')->(P s (env (app a b) s')))->
 (M:terms)(relSL false (env (app a b) s) M)->(P s M).
Intros.
Cut <terms>(app a b)=(app a b).
2:(* Auto *)Apply refl_equal.
Pattern 1 (app a b) s M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)
Rewrite (proj_app1 a1 b1 a b  H4);Rewrite (proj_app2 a1 b1 a b  H4);Assumption.
(* lambda *)Elim (diff_app_lambda a b a1 (sym_equal terms (lambda a1) (app a b) H4)).
(* clos *)Elim (diff_app_env a b a1 s1 (sym_equal terms (env a1 s1) (app a b) H4)).
(* varshift1 *)Elim (diff_var_app n a b H4).
(* varshift2 *)Elim (diff_var_app n a b H4).
(* fvarcons *)Elim (diff_var_app O a b H4).
(* fvarlift1 *)Elim (diff_var_app O a b H4).
(* fvarlift2 *)Elim (diff_var_app O a b H4).
(* rvarcons *)Elim (diff_var_app (S n) a b H4).
(* rvarlift1 *)Elim (diff_var_app (S n) a b H4).
(* rvarlift2 *)Elim (diff_var_app (S n) a b H4).
(* id *)
Assumption.
(* contexte gauche*)
Apply H1;Assumption.
(* contexte droit *)
Apply H2;Assumption.
Save case_SL_reg_app.

(*** (env (env a s) t) SL ? ***)

Goal (P:substitutions->terms->Prop)(a:terms)(s,t:substitutions)
 (P t (env a (comp s t)))->
 (P id (env a s))->
 ((x':terms)(relSL false (env a s) x')->(P t (env x' t)))->
 ((t':substitutions)(relSL true t t')->(P t (env (env a s) t')))->
 (M:terms)(relSL false (env (env a s) t) M)->(P t M).
Intros.
Cut <terms>(env a s)=(env a s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (env a s) t M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_app_env a1 b1 a s H4).
(* lambda *)Elim (diff_lambda_env a1 a s H4).
(* clos *)
Rewrite (proj_env1 a1 a s1 s H4);Rewrite (proj_env2 a1 a s1 s H4).
Assumption.
(* varshift1 *)Elim (diff_var_env n a s H4).
(* varshift2 *)Elim (diff_var_env n a s H4).
(* fvarcons *)Elim (diff_var_env O a s H4).
(* fvarlift1 *)Elim (diff_var_env O a s H4).
(* fvarlift2 *)Elim (diff_var_env O a s H4).
(* rvarcons *)Elim (diff_var_env (S n) a s H4).
(* rvarlift1 *)Elim (diff_var_env (S n) a s H4).
(* rvarlift2 *)Elim (diff_var_env (S n) a s H4).
(* id *)
Assumption.
(* contexte gauche*)
Apply H1;Assumption.
(* contexte droit *)
Apply H2;Assumption.
Save case_SL_clos.

(*** (env (var n) shift) SL ? ***)

Goal (P:terms->Prop)(n:nat)
 (P (var (S n)))->
 (M:terms)(relSL false (env (var n) shift) M)->(P M).
Intros.
Cut <terms>(var n)=(var n).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>shift=shift.
2:(* Auto *)Apply refl_equal.
Pattern 1 (var n) 1 shift M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app n a1 b1 (sym_equal terms (app a1 b1) (var n) H2)).
(* lambda *)Elim (diff_var_lambda n a1 (sym_equal terms (lambda a1) (var n) H2)).
(* clos *)Elim (diff_var_env n a1 s1 (sym_equal terms (env a1 s1) (var n) H2)).
(* varshift1 *)
Rewrite (proj_var n0 n H2);Assumption.
(* varshift2 *)Elim (diff_shift_comp shift s1 
                  (sym_equal substitutions (comp shift s1) shift H1)).
(* fvarcons *)Elim (diff_shift_cons a1 s1 
                       (sym_equal substitutions (cons a1 s1) shift H1)).
(* fvarlift1 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) shift H1)).
(* fvarlift2 *)Elim (diff_shift_comp (lift s1) s2 
                        (sym_equal substitutions (comp (lift s1) s2) shift H1)).
(* rvarcons *)Elim (diff_shift_cons a1 s1 
                      (sym_equal substitutions (cons a1 s1) shift H1)).
(* rvarlift1 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) shift H1)).
(* rvarlift2 *)Elim (diff_shift_comp (lift s1) s2 
                             (sym_equal substitutions (comp (lift s1) s2) shift H1)).
(* id *)Elim (diff_id_shift H1).
(* contexte gauche*)Elim (case_SLvar n a' H1).
(* contexte droit *)Elim (case_SLshift s' H1).
Save case_SL_varshift1.

(*** (comp shift s) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s:substitutions)
 ((a:terms)(s1:substitutions)(P (cons a s1) s1))->
 ((s1:substitutions)(P (lift s1) (comp s1 shift)))->
 ((s1,t:substitutions)(P (comp (lift s1) t) (comp s1 (comp shift t))))->
 (P id shift)->
 ((s':substitutions)(relSL true s s')->(P s (comp shift s')))->
 (M:substitutions)(relSL true (comp shift s) M)->(P s M).
Intros.
Cut <substitutions>shift=shift.
2:(* Auto *)Apply refl_equal.
Pattern 1 shift s M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)Elim (diff_shift_comp s1 s2 
                                   (sym_equal substitutions (comp s1 s2) shift H5)).
(* mapenv *)Elim (diff_shift_cons a s1 
                               (sym_equal substitutions (cons a s1) shift H5)).
(* shiftcons *)
Apply H.
(* shiftlift1 *)
Apply H0.
(* shiftlift2 *)
Apply H1.
(* lift1 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) shift H5)).
(* lift2 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) shift H5)).
(* liftenv *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) shift H5)).
(* idl *)Elim (diff_id_shift H5).
(* idr *)
Assumption.
(* contexte gauche *)Elim (case_SLshift s' H5).
(* contexte droit *)
Apply H3;Assumption.
Save case_SLcomp1.

(*** (env (var n) (comp shift s)) SL ? ***)

Goal (P:terms->Prop)(n:nat)(s:substitutions)
 (P (env (var (S n)) s))->
 ((x':substitutions)(relSL true (comp shift s) x')->(P (env (var n) x')))->
 (M:terms)(relSL false (env (var n) (comp shift s)) M)->(P M).
Intros.
Cut <terms>(var n)=(var n).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(comp shift s)=(comp shift s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var n) 1 (comp shift s) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app n a1 b1 (sym_equal terms (app a1 b1) (var n) H3)).
(* lambda *)Elim (diff_var_lambda n a1 (sym_equal terms (lambda a1) (var n) H3)).
(* clos *)Elim (diff_var_env n a1 s1 (sym_equal terms (env a1 s1) (var n) H3)).
(* varshift1 *)Elim (diff_shift_comp shift s H2).
(* varshift2 *)
Rewrite (proj_var n0 n H3);Rewrite (proj_comp2 shift shift s1 s H2);Assumption.
(* fvarcons *)Elim (diff_cons_comp a1 s1 shift s H2).
(* fvarlift1 *)Elim (diff_comp_lift shift s s1 
                             (sym_equal substitutions (lift s1) (comp shift s) H2)).
(* fvarlift2 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) 
                                shift (proj_comp1 (lift s1) shift s2 s H2))).
(* rvarcons *)Elim (diff_cons_comp a1 s1 shift s H2).
(* rvarlift1 *)Elim (diff_comp_lift shift s s1 
                           (sym_equal substitutions (lift s1) (comp shift s) H2)).
(* rvarlift2 *)Elim (diff_shift_lift s1 (sym_equal substitutions (lift s1) 
                                shift (proj_comp1 (lift s1) shift s2 s H2))).
(* id *)Elim (diff_id_comp shift s H2).
(* contexte gauche*)Elim (case_SLvar n a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_varshift2.

(*** (env (var O) (cons a s)) SL ? ***)

Goal (P:terms->Prop)(a:terms)(s:substitutions)
 (P a)->
 ((x':substitutions)(relSL true (cons a s) x')->(P (env (var O) x')))->
 (M:terms)(relSL false (env (var O) (cons a s)) M)->(P M).
Intros.
Cut <terms>(var O)=(var O).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(cons a s)=(cons a s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var O) 1 (cons a s) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app O a1 b1 (sym_equal terms (app a1 b1) (var O) H3)).
(* lambda *)Elim (diff_var_lambda O a1 (sym_equal terms (lambda a1) (var O) H3)).
(* clos *)Elim (diff_var_env O a1 s1 (sym_equal terms (env a1 s1) (var O) H3)).
(* varshift1 *)Elim (diff_shift_cons a s H2).
(* varshift2 *)Elim (diff_cons_comp a s shift s1 
                             (sym_equal substitutions (comp shift s1) (cons a s) H2)).
(* fvarcons *)Rewrite (proj_cons1 a1 a s1 s H2);Assumption.
(* fvarlift1 *)Elim (diff_cons_lift a s s1 
                             (sym_equal substitutions (lift s1) (cons a s) H2)).
(* fvarlift2 *)Elim (diff_cons_comp a s (lift s1) s2 
                 (sym_equal substitutions (comp (lift s1) s2) (cons a s) H2)).
(* rvarcons *)Elim (O_S n (sym_equal nat (S n) O (proj_var (S n) O H3))).
(* rvarlift1 *)Elim (diff_cons_lift a s s1 
                            (sym_equal substitutions (lift s1) (cons a s) H2)).
(* rvarlift2 *)Elim (O_S n (sym_equal nat (S n) O (proj_var (S n) O H3))).
(* id *)Elim (diff_id_cons a s H2).
(* contexte gauche*)Elim (case_SLvar O a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_fvarcons.

(*** (env (var O) (lift s)) SL ? ***)

Goal (P:terms->Prop)(s:substitutions)
 (P (var O))->
 ((x':substitutions)(relSL true (lift s) x')->(P (env (var O) x')))->
 (M:terms)(relSL false (env (var O) (lift s)) M)->(P M).
Intros.
Cut <terms>(var O)=(var O).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(lift s)=(lift s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var O) 1 (lift s) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app O a1 b1 (sym_equal terms (app a1 b1) (var O) H3)).
(* lambda *)Elim (diff_var_lambda O a1 (sym_equal terms (lambda a1) (var O) H3)).
(* clos *)Elim (diff_var_env O a1 s1 (sym_equal terms (env a1 s1) (var O) H3)).
(* varshift1 *)Elim (diff_shift_lift s H2).
(* varshift2 *)Elim (diff_comp_lift shift s1 s H2).
(* fvarcons *)Elim (diff_cons_lift a1 s1 s H2).
(* fvarlift1 *)Assumption.
(* fvarlift2 *)Elim (diff_comp_lift (lift s1) s2  s H2).
(* rvarcons *)Elim (diff_cons_lift a1 s1 s H2).
(* rvarlift1 *)Elim (O_S n (sym_equal nat (S n) O (proj_var (S n) O H3))).
(* rvarlift2 *)Elim (diff_comp_lift (lift s1) s2  s H2).
(* id *)Elim (diff_id_lift s H2).
(* contexte gauche*)Elim (case_SLvar O a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_fvarlift1.

(*** (comp (lift s) t) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s,t:substitutions)
 ((t1:substitutions)(P (lift t1) (lift (comp s t1))))->
 ((t1,t2:substitutions)(P (comp (lift t1) t2) (comp (lift (comp s t1)) t2)))->
 ((a:terms)(t1:substitutions)(P (cons a t1) (cons a (comp s t1))))->
 (P id (lift s))->
 ((x':substitutions)(relSL true (lift s) x')->(P t (comp x' t)))->
 ((t':substitutions)(relSL true t t')->(P t (comp (lift s) t')))->
 (M:substitutions)(relSL true (comp (lift s) t) M)->(P t M).
Intros.
Cut <substitutions>(lift s)=(lift s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (lift s) t M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)Elim (diff_comp_lift s1 s2 s H6).
(* mapenv *)Elim (diff_cons_lift a s1 s H6).
(* shiftcons *)Elim (diff_shift_lift s H6).
(* shiftlift1 *)Elim (diff_shift_lift s H6).
(* shiftlift2 *)Elim (diff_shift_lift s H6).
(* lift1 *)
Rewrite (proj_lift s1 s H6);Apply H.
(* lift2 *)
Rewrite (proj_lift s1 s H6);Apply H0.
(* liftenv *)
Rewrite (proj_lift s1 s H6);Apply H1.
(* idl *)Elim (diff_id_lift s H6).
(* idr *)
Assumption.
(* contexte gauche *)
Apply H3;Assumption.
(* contexte droit *)
Apply H4;Assumption.
Save case_SLcomp2.

(*** (env (var O) (comp (lift s) t)) SL ? ***)

Goal (P:terms->Prop)(s,t:substitutions)
 (P (env (var O) t))->
 ((x':substitutions)(relSL true (comp (lift s) t) x')->(P (env (var O) x')))->
 (M:terms)(relSL false (env (var O) (comp (lift s) t)) M)->(P M).
Intros.
Cut <terms>(var O)=(var O).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(comp (lift s) t)=(comp (lift s) t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var O) 1 (comp (lift s) t) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app O a1 b1 (sym_equal terms (app a1 b1) (var O) H3)).
(* lambda *)Elim (diff_var_lambda O a1 (sym_equal terms (lambda a1) (var O) H3)).
(* clos *)Elim (diff_var_env O a1 s1 (sym_equal terms (env a1 s1) (var O) H3)).
(* varshift1 *)Elim (diff_shift_comp (lift s) t H2).
(* varshift2 *)Elim (diff_shift_lift s (proj_comp1 shift (lift s) s1 t H2)).
(* fvarcons *)Elim (diff_cons_comp a1 s1 (lift s) t H2).
(* fvarlift1 *)Elim (diff_comp_lift (lift s) t s1 
                  (sym_equal substitutions (lift s1) (comp (lift s) t) H2)).
(* fvarlift2 *)
Rewrite (proj_comp2 (lift s1) (lift s) s2 t H2);Assumption.
(* rvarcons *)Elim (diff_cons_comp a1 s1 (lift s) t H2).
(* rvarlift1 *)Elim (diff_comp_lift (lift s) t s1 
                  (sym_equal substitutions (lift s1) (comp (lift s) t) H2)).
(* rvarlift2 *)Elim (O_S n (sym_equal nat (S n) O (proj_var (S n) O H3))).
(* id *)Elim (diff_id_comp (lift s) t H2).
(* contexte gauche*)Elim (case_SLvar O a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_fvarlift2.

(*** (env (var (S n)) (cons a s)) SL ? ***)

Goal (P:terms->Prop)(n:nat)(a:terms)(s:substitutions)
 (P (env (var n) s))->
 ((x':substitutions)(relSL true (cons a s) x')->(P (env (var (S n)) x')))->
 (M:terms)(relSL false (env (var (S n)) (cons a s)) M)->(P M).
Intros P n a s H H0 M H1.
Cut <terms>(var (S n))=(var (S n)).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(cons a s)=(cons a s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var (S n)) 1 (cons a s) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app (S n) a1 b1 (sym_equal terms (app a1 b1) (var (S n)) H3)).
(* lambda *)Elim (diff_var_lambda (S n) a1 
                       (sym_equal terms (lambda a1) (var (S n)) H3)).
(* clos *)Elim (diff_var_env (S n) a1 s1 (sym_equal terms (env a1 s1) (var (S n)) H3)).
(* varshift1 *)Elim (diff_shift_cons a s H2).
(* varshift2 *)Elim (diff_cons_comp a s shift s1 
                       (sym_equal substitutions (comp shift s1) (cons a s) H2)).
(* fvarcons *)Elim (O_S n (proj_var O (S n) H3)).
(* fvarlift1 *)Elim (diff_cons_lift a s s1 
                  (sym_equal substitutions (lift s1) (cons a s) H2)).
(* fvarlift2 *)Elim (diff_cons_comp a s (lift s1 ) s2
                       (sym_equal substitutions (comp (lift s1) s2) (cons a s) H2)).
(* rvarcons *)
Rewrite (eq_add_S n0 n (proj_var (S n0) (S n) H3)).
Rewrite (proj_cons2 a1 a s1 s H2);Assumption.
(* rvarlift1 *)Elim (diff_cons_lift a s s1 
                  (sym_equal substitutions (lift s1) (cons a s) H2)).
(* rvarlift2 *)Elim (diff_cons_comp a s (lift s1 ) s2
                       (sym_equal substitutions (comp (lift s1) s2) (cons a s) H2)).
(* id *)Elim (diff_id_cons a s H2).
(* contexte gauche*)Elim (case_SLvar (S n) a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_rvarcons.

(*** (env (var (S n)) (lift s)) SL ? ***)

Goal (P:terms->Prop)(n:nat)(s:substitutions)
 (P (env (var n) (comp s shift)))->
 ((x':substitutions)(relSL true (lift s) x')->(P (env (var (S n)) x')))->
 (M:terms)(relSL false (env (var (S n)) (lift s)) M)->(P M).
Intros P n s H H0 M H1.
Cut <terms>(var (S n))=(var (S n)).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(lift s)=(lift s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var (S n)) 1 (lift s) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app (S n) a1 b1 (sym_equal terms (app a1 b1) (var (S n)) H3)).
(* lambda *)Elim (diff_var_lambda (S n) a1 
                       (sym_equal terms (lambda a1) (var (S n)) H3)).
(* clos *)Elim (diff_var_env (S n) a1 s1 (sym_equal terms (env a1 s1) (var (S n)) H3)).
(* varshift1 *)Elim (diff_shift_lift s H2).
(* varshift2 *)Elim (diff_comp_lift shift s1 s H2).
(* fvarcons *)Elim (O_S n (proj_var O (S n) H3)).
(* fvarlift1 *)Elim (O_S n (proj_var O (S n) H3)).
(* fvarlift2 *)Elim (O_S n (proj_var O (S n) H3)).
(* rvarcons *)Elim (diff_cons_lift a1 s1 s H2).
(* rvarlift1 *)
Rewrite (eq_add_S n0 n (proj_var (S n0) (S n) H3)).
Rewrite (proj_lift s1 s H2);Assumption.
(* rvarlift2 *)Elim (diff_comp_lift (lift s1 ) s2 s H2).                   
(* id *)Elim (diff_id_lift s H2).
(* contexte gauche*)Elim (case_SLvar (S n) a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_rvarlift1.

(*** (env (var (S n)) (comp (lift s) t)) SL ? ***)

Goal (P:terms->Prop)(n:nat)(s,t:substitutions)
 (P (env (var n) (comp s (comp shift t))))->
 ((x':substitutions)(relSL true (comp (lift s) t) x')->(P (env (var (S n)) x')))->
 (M:terms)(relSL false (env (var (S n)) (comp (lift s) t)) M)->(P M).
Intros P n s t H H0 M H1.
Cut <terms>(var (S n))=(var (S n)).
2:(* Auto *)Apply refl_equal.
Cut <substitutions>(comp (lift s) t)=(comp (lift s) t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (var (S n)) 1 (comp (lift s) t) M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)Elim (diff_var_app (S n) a1 b1 (sym_equal terms (app a1 b1) (var (S n)) H3)).
(* lambda *)Elim (diff_var_lambda (S n) a1 
                       (sym_equal terms (lambda a1) (var (S n)) H3)).
(* clos *)Elim (diff_var_env (S n) a1 s1 (sym_equal terms (env a1 s1) (var (S n)) H3)).
(* varshift1 *)Elim (diff_shift_comp (lift s) t H2).
(* varshift2 *)Elim (diff_shift_lift s (proj_comp1 shift (lift s) s1 t H2)).
(* fvarcons *)Elim (diff_cons_comp a1 s1 (lift s) t H2).
(* fvarlift1 *)Elim (diff_comp_lift (lift s) t s1 
                  (sym_equal substitutions (lift s1) (comp (lift s) t) H2)).
(* fvarlift2 *)Elim (O_S n (proj_var O (S n) H3)).
(* rvarcons *)Elim (diff_cons_comp a1 s1 (lift s) t H2).
(* rvarlift1 *)Elim (diff_comp_lift (lift s) t s1 
                  (sym_equal substitutions (lift s1) (comp (lift s) t) H2)).
(* rvarlift2 *)
Rewrite (eq_add_S n0 n (proj_var (S n0) (S n) H3)).
Rewrite (proj_lift s1 s (proj_comp1 (lift s1) (lift s) s2 t H2)).
Rewrite (proj_comp2 (lift s1) (lift s) s2 t H2);Assumption.
(* id *)Elim (diff_id_comp (lift s) t H2).
(* contexte gauche*)Elim (case_SLvar (S n) a' H2).
(* contexte droit *)Apply H0;Assumption.
Save case_SL_rvarlift2.

(*** (comp (comp s t) u) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s,t,u:substitutions)
 (P u (comp s (comp t u)))->
 (P id (comp s t))->
 ((x':substitutions)(relSL true (comp s t) x')->(P u (comp x' u)))->
 ((u':substitutions)(relSL true u u')->(P u (comp (comp s t) u')))->
 (M:substitutions)(relSL true (comp (comp s t) u) M)->(P u M). 
Intros P s t u H H0 H1 H2 M H3.
Cut <substitutions>(comp s t)=(comp s t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (comp s t) u M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)
Rewrite (proj_comp1 s1 s s2 t H4).
Rewrite (proj_comp2 s1 s s2 t H4);Assumption.
(* mapenv *)Elim (diff_cons_comp a s1 s t H4).
(* shiftcons *)Elim (diff_shift_comp s t H4).
(* shiftlift1 *)Elim (diff_shift_comp s t H4).
(* shiftlift2 *)Elim (diff_shift_comp s t H4).
(* lift1 *)Elim (diff_comp_lift s t s1 
                       (sym_equal substitutions (lift s1) (comp s t)  H4)).
(* lift2 *)Elim (diff_comp_lift s t s1 
                       (sym_equal substitutions (lift s1) (comp s t)  H4)).
(* liftenv *)Elim (diff_comp_lift s t s1 
                       (sym_equal substitutions (lift s1) (comp s t)  H4)).
(* idl *)Elim (diff_id_comp s t H4).
(* idr *)
Assumption.
(* contexte gauche *)
Apply H1;Assumption.
(* contexte droit *)
Apply H2;Assumption.
Save case_SL_assenv.

(*** (comp (cons a s) t) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(a:terms)(s,t:substitutions)
 (P t (cons (env a t) (comp s t)))->
 (P id (cons a s))->
 ((x':substitutions)(relSL true (cons a s) x')->(P t (comp x' t)))->
 ((t':substitutions)(relSL true t t')->(P t (comp (cons a s) t')))->
 (M:substitutions)(relSL true (comp (cons a s) t) M)->(P t M). 
Intros P a s t H H0 H1 H2 M H3.
Cut <substitutions>(cons a s)=(cons a s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (cons a s) t M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)Elim (diff_cons_comp a s s1 s2 
              (sym_equal substitutions (comp s1 s2) (cons a s) H4)).
(* mapenv *)
Rewrite (proj_cons1 a0 a s1 s H4).
Rewrite (proj_cons2 a0 a s1 s H4);Assumption.
(* shiftcons *)Elim (diff_shift_cons a s H4).
(* shiftlift1 *)Elim (diff_shift_cons a s H4).
(* shiftlift2 *)Elim (diff_shift_cons a s H4).
(* lift1 *)Elim (diff_cons_lift a s s1 
                       (sym_equal substitutions (lift s1) (cons a s)  H4)).
(* lift2 *)Elim (diff_cons_lift a s s1 
                       (sym_equal substitutions (lift s1) (cons a s)  H4)).
(* liftenv *)Elim (diff_cons_lift a s s1 
                       (sym_equal substitutions (lift s1) (cons a s)  H4)).
(* idl *)Elim (diff_id_cons a s H4).
(* idr *)
Assumption.
(* contexte gauche *)
Apply H1;Assumption.
(* contexte droit *)
Apply H2;Assumption.
Save case_SL_mapenv.

(*** (comp shift (cons a s)) SL ? ***)

Goal (P:substitutions->Prop)(a:terms)(s:substitutions)
 (P s)->
 ((x':substitutions)(relSL true (cons a s) x')->(P (comp shift x')))->
 (M:substitutions)(relSL true (comp shift (cons a s)) M)->(P M). 
Intros P a s H H0 M H1.
Cut <substitutions>(cons a s)=(cons a s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (cons a s) M;Apply case_SLcomp1;Intros.
6:Assumption.
(* shiftcons *)
Rewrite (proj_cons1 a0 a s1 s H2).
Rewrite (proj_cons2 a0 a s1 s H2);Assumption.
(* shiftlift1 *)Elim (diff_cons_lift a s s1 
                       (sym_equal substitutions (lift s1) (cons a s)  H2)).
(* shiftlift2 *)Elim (diff_cons_comp a s (lift s1) t 
                      (sym_equal substitutions (comp (lift s1) t) (cons a s)  H2)).
(* idl *)Elim (diff_id_cons a s H2).
(* contexte gauche *)
Apply H0;Assumption.
Save case_SL_shiftcons.
 
(*** (comp shift (lift s)) SL ? ***)

Goal (P:substitutions->Prop)(s:substitutions)
 (P (comp s shift))->
 ((x':substitutions)(relSL true (lift s) x')->(P (comp shift x')))->
 (M:substitutions)(relSL true (comp shift (lift s)) M)->(P M). 
Intros P s H H0 M H1.
Cut <substitutions>(lift s)=(lift s).
2:(* Auto *)Apply refl_equal.
Pattern 1 (lift s) M;Apply case_SLcomp1;Intros.
6:Assumption.
(* shiftcons *)Elim (diff_cons_lift a s1 s H2).
(* shiftlift1 *)
Rewrite (proj_lift s1 s H2);Assumption.
(* shiftlift2 *)Elim (diff_comp_lift (lift s1) t s H2).
(* idl *)Elim (diff_id_lift s H2).
(* contexte gauche *)
Apply H0;Assumption.
Save case_SL_shiflift1.

(*** (comp shift (comp (lift s) t)) SL ? ***)

Goal (P:substitutions->Prop)(s,t:substitutions)
 (P (comp s (comp shift t)))->
 ((x':substitutions)(relSL true (comp (lift s) t) x')->(P (comp shift x')))->
 (M:substitutions)(relSL true (comp shift (comp (lift s) t)) M)->(P M). 
Intros P s t H H0 M H1.
Cut <substitutions>(comp (lift s) t)=(comp (lift s) t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (comp (lift s) t) M;Apply case_SLcomp1;Intros.
6:Assumption.
(* shiftcons *)Elim (diff_cons_comp a s1 (lift s) t H2).
(* shiftlift1 *)Elim (diff_comp_lift (lift s) t s1 
                      (sym_equal substitutions (lift s1) (comp (lift s) t) H2)).
(* shiftlift2 *)
Rewrite (proj_lift s1 s (proj_comp1 (lift s1) (lift s) t0 t H2)).
Rewrite (proj_comp2 (lift s1) (lift s) t0 t H2);Assumption.
(* idl *)Elim (diff_id_comp (lift s) t H2).
(* contexte gauche *)
Apply H0;Assumption.
Save case_SL_shiflift2.

(*** (comp (lift s) (lift t)) SL ? ***)

Goal (P:substitutions->Prop)(s,t:substitutions)
 (P (lift (comp s t)))->
 ((x':substitutions)(relSL true (lift s) x')->(P (comp x' (lift t))))->
 ((x':substitutions)(relSL true (lift t) x')->(P (comp (lift s) x')))->
 (M:substitutions)(relSL true (comp (lift s) (lift t)) M)->(P M).
Intros P s t H H0 H1 M H2.
Cut <substitutions>(lift t)=(lift t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (lift t) M;Apply case_SLcomp2 with s;Intros.
7:Assumption.
(* lift1 *)
Rewrite (proj_lift t1 t H3);Assumption.
(* lift2 *)Elim (diff_comp_lift (lift t1) t2 t H3).
(* liftenv *)Elim (diff_cons_lift a t1 t H3).
(* idr *)Elim (diff_id_lift t H3).
(* contexte gauche *)
Apply H0;Assumption.
(* contexte droit *)
Apply H1;Assumption.
Save case_SL_lift1.


(*** (comp (lift s) (comp (lift t) u)) SL ? ***)

Goal (P:substitutions->Prop)(s,t,u:substitutions)
 (P (comp (lift (comp s t)) u))->
 ((x':substitutions)(relSL true (lift s) x')->(P (comp x' (comp (lift t) u))))->
 ((x':substitutions)(relSL true (comp (lift t) u) x')->(P (comp (lift s) x')))->
 (M:substitutions)(relSL true (comp (lift s) (comp (lift t) u)) M)->(P M).
Intros P s t u H H0 H1 M H2.
Cut <substitutions>(comp (lift t) u)=(comp (lift t) u).
2:(* Auto *)Apply refl_equal.
Pattern 1 (comp (lift t) u) M;Apply case_SLcomp2 with s;Intros.
7:Assumption.
(* lift1 *)Elim (diff_comp_lift (lift t) u t1 
                 (sym_equal substitutions (lift t1) (comp (lift t) u) H3)).
(* lift2 *)
Rewrite (proj_lift t1 t (proj_comp1 (lift t1) (lift t) t2 u H3)).
Rewrite (proj_comp2 (lift t1) (lift t) t2 u H3);Assumption.
(* liftenv *)Elim (diff_cons_comp a t1 (lift t) u H3).
(* idr *)Elim (diff_id_comp (lift t) u H3).
(* contexte gauche *)
Apply H0;Assumption.
(* contexte droit *)
Apply H1;Assumption.
Save case_SL_lift2.

(*** (comp (lift s) (cons a t)) SL ? ***)

Goal (P:substitutions->Prop)(a:terms)(s,t:substitutions)
 (P (cons a (comp s t)))->
 ((x':substitutions)(relSL true (lift s) x')->(P (comp x' (cons a t))))->
 ((x':substitutions)(relSL true (cons a t) x')->(P (comp (lift s) x')))->
 (M:substitutions)(relSL true (comp (lift s) (cons a t)) M)->(P M).
Intros P a s t H H0 H1 M H2.
Cut <substitutions>(cons a t)=(cons a t).
2:(* Auto *)Apply refl_equal.
Pattern 1 (cons a t) M;Apply case_SLcomp2 with s;Intros.
7:Assumption.
(* lift1 *)Elim (diff_cons_lift a t t1 
                 (sym_equal substitutions (lift t1) (cons a t) H3)).
(* lift2 *)Elim (diff_cons_comp a t (lift t1) t2 
                 (sym_equal substitutions (comp (lift t1) t2) (cons a t) H3)).
(* liftenv *)
Rewrite (proj_cons1 a0 a t1 t H3).
Rewrite (proj_cons2 a0 a t1 t H3);Assumption.
(* idr *)Elim (diff_id_cons a t H3).
(* contexte gauche *)
Apply H0;Assumption.
(* contexte droit *)
Apply H1;Assumption.
Save case_SL_liftenv.

(*** (comp id s) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s:substitutions)
 (P s s)->
 (P id id)->
 ((s':substitutions)(relSL true s s')->(P s (comp id s')))->
 (M:substitutions)(relSL true (comp id s) M)->(P s M).
Intros P s H H0 H1 M H2.
Cut <substitutions>id=id.
2:(* Auto *)Apply refl_equal.
Cut <substitutions>s=s.
2:(* Auto *)Apply refl_equal.
Pattern 1 id 1 s M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)Elim (diff_id_comp s1 s2 
              (sym_equal substitutions (comp s1 s2) id H4)).
(* mapenv *)Elim (diff_id_cons a s1  
              (sym_equal substitutions (cons a s1) id H4)).
(* shiftcons *)Elim (diff_id_shift (sym_equal substitutions shift id H4)).
(* shiftlift1 *)Elim (diff_id_shift (sym_equal substitutions shift id H4)).
(* shiftlift2 *)Elim (diff_id_shift (sym_equal substitutions shift id H4)).
(* lift1 *)Elim (diff_id_lift s1 
                       (sym_equal substitutions (lift s1) id H4)).
(* lift2 *)Elim (diff_id_lift s1 
                       (sym_equal substitutions (lift s1) id H4)).
(* liftenv *)Elim (diff_id_lift s1 
                       (sym_equal substitutions (lift s1) id H4)).
(* idl *)
Assumption.
(* idr *)
Elim H3;Assumption.
(* contexte gauche *)
Elim (case_SLid s' H3).
(* contexte droit *)
Apply H1;Assumption.
Save case_SL_idl.

(*** (comp s id) SL ? ***)

Goal (P:substitutions->substitutions->Prop)(s:substitutions)
 (P s s)->
 ((s1,s2:substitutions)(P (comp s1 s2) (comp s1 (comp s2 id))))->
 ((a:terms)(s1:substitutions)(P (cons a s1) (cons (env a id) (comp s1 id))))->
 (P id id)->
 ((s':substitutions)(relSL true s s')->(P s (comp s' id)))->
 (M:substitutions)(relSL true (comp s id) M)->(P s M).
Intros P s H H0 H1 H2 H3 M H4.
Cut <substitutions>id=id.
2:(* Auto *)Apply refl_equal.
Cut <substitutions>s=s.
2:(* Auto *)Apply refl_equal.
Pattern 1 s 1 id M;Apply case_SLcomp;Intros.
13:Assumption.
(* assenv *)
Elim H5;Apply H0.
(* mapenv *)
Elim H5;Apply H1.
(* shiftcons *)Elim (diff_id_cons a t1 
                  (sym_equal substitutions (cons a t1) id H6)).
(* shiftlift1 *)Elim (diff_id_lift t1 
                   (sym_equal substitutions (lift t1) id H6)).
(* shiftlift2 *)Elim (diff_id_comp (lift t1) t2 
                    (sym_equal substitutions (comp (lift t1) t2) id H6)).
(* lift1 *)Elim (diff_id_lift t1 
                       (sym_equal substitutions (lift t1) id H6)).
(* lift2 *)Elim (diff_id_comp (lift t1) t2 
                    (sym_equal substitutions (comp (lift t1) t2) id H6)).
(* liftenv *)Elim (diff_id_cons a t1 
                  (sym_equal substitutions (cons a t1) id H6)).
(* idl *)
Elim H5;Assumption.
(* idr *)
Assumption.
(* contexte gauche *)
Apply H3;Assumption.
(* contexte droit *)
Elim (case_SLid t' H5).
Save case_SL_idr.

(*** (lift id ) SL ? ***)

Goal (P:substitutions->Prop)
 (P id)->
 (M:substitutions)(relSL true (lift id) M)->(P M).
Intros P H M H0.
Cut <substitutions>id=id.
2:(* Auto *)Apply refl_equal.
Pattern 1 id M;Apply case_SLlift;Intros.
3:Assumption.
(* liftid *)
Assumption.
(* contexte *)Elim (case_SLid s' H1).
Save case_SL_liftid.

(*** (env a id) SL ? ***)

Goal (P:terms->terms->Prop)(a:terms)
 (P a a)->
 ((a1,b1:terms)(P (app a1 b1) (app (env a1 id) (env b1 id))))->
 ((a1:terms)(P (lambda a1) (lambda (env a1 (lift id)))))->
 ((a1:terms)(s:substitutions)(P (env a1 s) (env a1 (comp s id))))->
 ((a':terms)(relSL false a a')->(P a (env a' id)))->
 (M:terms)(relSL false (env a id) M)->(P a M).
Intros P a H H0 H1 H2 H3 M H4.
Cut <substitutions>id=id.
2:(* Auto *)Apply refl_equal.
Pattern a 2 id M;Apply case_SLenv;Intros.
15:Assumption.
(* app *)
Apply H0.
(* lambda *)
Apply H1.
(* clos *)
Apply H2.
(* varshift1 *)Elim (diff_id_shift H5).
(* varshift2 *)Elim (diff_id_comp shift s1 H5).
(* fvarcons *)Elim (diff_id_cons a1 s1 H5).
(* fvarlift1 *)Elim (diff_id_lift s1 H5).
(* fvarlift2 *)Elim (diff_id_comp (lift s1) s2 H5).
(* rvarcons *)Elim (diff_id_cons a1 s1 H5).
(* rvarlift1 *)Elim (diff_id_lift s1 H5).
(* rvarlift2 *)Elim (diff_id_comp (lift s1) s2 H5).
(* id *)
Assumption.
(* contexte gauche*)
Apply H3;Assumption.
(* contexte droit *)
Elim (case_SLid s' H5).
Save case_SL_reg_id.


Provide determinePC_SL.

