
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                 (* Confluence du lambda-sigma-lift *)


Require terminaison_SL.
Require conf_strong_betapar.
Require conf_local_SL.
Require commutation.
Require Newman.
Require Yokouchi.


Goal (b:bool)(confluence (TS b) (relSL b)).
Intros b.
Apply Newman.
Apply relSL_noetherian.
Apply conf_local_SL.
Save confluence_SL.

Goal (b:bool)(strong_confluence (TS b) (slstar_bp_slstar b)).
Intro b;Unfold slstar_bp_slstar.
Change (strong_confluence (TS b) (Rstar_S_Rstar (TS b) (relSL b) (beta_par b))).
Apply Yokouchi.
Apply confluence_SL.
Apply relSL_noetherian.
Apply sconf_betapar.
Intros f g h H H0.
Unfold Rstar_S_Rstar.
Change <(TS b)>Ex([k:(TS b)](relSLstar b g k)/\(slstar_bp_slstar b h k)).
Apply commutation with f;Assumption.
Save strong_confluence_slbpsl.

Goal (b:bool)(confluence (TS b) (slstar_bp_slstar b)).
Intro b;Apply strong_conf_conf;Apply strong_confluence_slbpsl.
Save confluence_slbpsl.


(**********************************************)
(*        lambda-sigma-lift est confluent     *)
(**********************************************)

Theorem confluence_LSL: (b:bool)(confluence (TS b) (relLSL b)).
Goal.
Intro b;Apply inclus_conf with (slstar_bp_slstar b).
Apply relLSL_inclus_slbpsl.
Change (inclus (TS b) (slstar_bp_slstar b) (relLSLstar b)).
Apply slbpsl_inclus_relLSLstar.
Apply confluence_slbpsl.
Save.


Provide confluence_LSL.
