
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)

       
        (*  confluence du LSL-calcul:  beta_par est fortement confluente *)

Require sur_les_relations.
Require betapar.
Require egaliteTS.


Definition sconf [b:bool][N,N':(TS b)](z:(TS b))(beta_par b N z)->
  (<(TS b)>Ex([u:(TS b)](beta_par b N' u)/\(beta_par b z u))).

Goal (M,M':terms)(sconf false (lambda M) (lambda M'))->(sconf false M M').
Unfold sconf;Intros M M' H z H0.
Elim (H (lambda z)).
2:Apply lambda_bpar;Assumption.
Intros M_ H1;Elim H1;Intros H2 H3.
Cut <terms>M_=M_.
2:Trivial.
Pattern 1 M_;Apply case_blambda with M'.
2:Assumption.
Intros u1 H4.
Pattern M_;Apply case_blambda with z.
2:Assumption.
Intros u2 H5 H6.
Exists u1;Split.
Assumption.
Rewrite (proj_lambda u1 u2 H6);Assumption.
Save sconf_lambda_bpar.


(**********************************************)
(*  beta_par est fortement confluente         *)
(**********************************************)

Theorem sconf_betapar: (b:bool)(strong_confluence (TS b) (beta_par b)).
Goal.
Red;Red;Intros b x y z H;Generalize z;Elim H.
(* regle var *)
Intros n z0 H1;Pattern z0;Apply case_bvar with n.
2:Assumption.
Exists (var n);Split;Apply var_bpar.
(* regle id  *)
Intros z0 H1;Pattern z0;Apply case_bid.
2:Assumption.
Exists id;Split;Apply id_bpar.
(*  regle |  *)
Intros z0 H1;Pattern z0;Apply case_bshift.
2:Assumption.
Exists shift;Split;Apply shift_bpar.
(* regle app *)
Intros M N M' N' H0 H1 H2 H3 z0 H4.
Generalize H0 H1;Pattern z0;Apply case_bapp with M N.
3:Assumption.
(* 1-regle app *)
Intros M'' N'' H5 H6 H7 H8.
Elim (H3 N'' H6);Intros N_ H9;Elim H9;Intros H10 H11.
Elim (H1 M'' H5);Intros M_ H12;Elim H12;Intros H13 H14.
Exists (app M_ N_);Split;Apply app_bpar;Assumption.
(* 2-regle beta *)
Intros M1 M1'' N'' H5 H6 H7;Rewrite H5;Intros H8.
Pattern M';Apply case_blambda with M1.
2:Assumption.
Intros M1' H9 H10.
Elim (sconf_lambda_bpar M1 M1' H10 M1'' H6);Intros M1_ H11.
Elim H11;Intros H12 H13.
Elim (H3 N'' H7);Intros N_ H14;Elim H14;Intros H15 H16.
Exists (env M1_ (cons N_ id ));Split.
Apply beta_bpar;Assumption.
Apply env_bpar.
Assumption. 
Apply cons_bpar;[Assumption|Apply id_bpar].
(* regle lam *)
Intros M M' H0 H1 z0 H2;Pattern z0;Apply case_blambda with M.
2:Assumption.
Intros M'' H3;Elim (H1 M'' H3);Intros M_ H4;Elim H4;Intros H5 H6.
Exists (lambda M_);Split;Apply lambda_bpar;Assumption.
(* regle env *)
Intros M M' s s' H0 H1 H2 H3 z0 H4.
Pattern z0;Apply case_benv with M s.
2:Assumption.
Intros M'' s'' H5 H6.
Elim (H1 M'' H5);Intros M_ H7;Elim H7;Intros H8 H9.
Elim (H3 s'' H6);Intros s_ H10;Elim H10;Intros H11 H12.
Exists (env M_ s_);Split;Apply env_bpar;Assumption.
(* regle beta *)
Intros M N M' N' H0 H1 H2 H3 z0 H4.
Pattern z0;Apply case_bapp with (lambda M) N.
3:Assumption.
(* 1-regle app *)
Intros M1'' N'' H5 H6.
Pattern M1'';Apply case_blambda with M.
2:Assumption.
Intros M'' H7.
Elim (H1 M'' H7);Intros M_ H8;Elim H8;Intros H9 H10.
Elim (H3 N'' H6);Intros N_ H11;Elim H11;Intros H12 H13.
Exists (env M_ (cons N_ id ));Split.
Apply env_bpar.
Assumption. 
Apply cons_bpar;[Assumption|Apply id_bpar].
Apply beta_bpar;Assumption.
(* 2-regle beta *)
Intros M1 M1'' N'' H5 H6 H7;
Generalize H6;Elim (proj_lambda M M1 H5);Intro H8.
Elim (H1 M1'' H8);Intros M_ H9;Elim H9;Intros H10 H11.
Elim (H3 N'' H7);Intros N_ H12;Elim H12;Intros H13 H14.
Exists (env M_ (cons N_ id ));Split;
Apply env_bpar;[Assumption|Apply cons_bpar;[Assumption|Apply id_bpar]].
(* regle . *)
Intros M M' s s' H0 H1 H2 H3 z0 H4.
Pattern z0;Apply case_bcons with M s.
2:Assumption.
Intros M'' s'' H5 H6.
Elim (H1 M'' H5);Intros M_ H7;Elim H7;Intros H8 H9.
Elim (H3 s'' H6);Intros s_ H10;Elim H10;Intros H11 H12.
Exists (cons M_ s_);Split;Apply cons_bpar;Assumption.
(* regle || *)
Intros s s' H0 H1 z0 H2.
Pattern z0;Apply case_blift with s.
2:Assumption.
Intros s'' H3.
Elim (H1 s'' H3);Intros s_ H4;Elim H4;Intros H5 H6.
Exists (lift s_);Split;Apply lift_bpar;Assumption.
(* regle comp *)
Intros s s' t t' H0 H1 H2 H3 z0 H4.
Pattern z0;Apply case_bcomp with s t.
2:Assumption.
Intros s'' t'' H5 H6.
Elim (H1 s'' H5);Intros s_ H7;Elim H7;Intros H8 H9.
Elim (H3 t'' H6);Intros t_ H10;Elim H10;Intros H11 H12.
Exists (comp s_ t_);Split;Apply comp_bpar;Assumption.
(* regle X *)
Intros n z0 H1;Pattern z0;Apply case_bmetaX with n.
2:Assumption.
Exists (meta_X n);Split;Apply metaX_bpar.
(* regle x *)
Intros n z0 H1;Pattern z0;Apply case_bmetax with n.
2:Assumption.
Exists (meta_x n);Split;Apply metax_bpar.
Save.

Provide conf_strong_betapar.
