
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)



                             (* Confluence locale de sigma-lift *)

Require resoudPC_SL.


Definition local1 [b:bool][x,y:(TS b)](z:(TS b))(relSL b x z)->
                  <(TS b)>Ex([u:(TS b)](relSLstar b y u)/\(relSLstar b z u)).

(* app *)

Goal (b:bool)(x,y:(TS b))(reg_app b x y)->(local1 b x y).
Induction 1;Red;Intros a b0 s z H0.
Pattern s z;Apply case_SL_reg_app with a b0;Intros.
5:Assumption.
Exists (app (env a s) (env b0 s));Split;Red;Apply star_refl.
Apply PC_app_id.
Apply PC_app_ctxt_l;Assumption.
Apply PC_app_ctxt_r;Assumption.
Save local_app.

(* lambda *)

Goal (b:bool)(x,y:(TS b))(reg_lambda b x y)->(local1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern s z;Apply case_SL_reg_lambda with a;Intros.
5:Assumption.
Exists (lambda (env a (lift s)));Split;Red;Apply star_refl.
Apply PC_lambda_id.
Apply PC_lambda_ctxt_l;Assumption.
Apply PC_lambda_ctxt_r;Assumption.
Save local_lambda.

(* clos *)

Goal (b:bool)(x,y:(TS b))(reg_clos b x y)->(local1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern t z;Apply case_SL_clos with a s;Intros.
5:Assumption.
Exists (env a (comp s t));Split;Red;Apply star_refl.
Apply PC1_clos_id.
Apply PC_clos_ctxt_l;Assumption.
Apply PC_clos_ctxt_r;Assumption.
Save local_clos.

(* varshift1 *)

Goal (b:bool)(x,y:(TS b))(reg_varshift1 b x y)->(local1 b x y).
Induction 1;Red;Intros n z H0.
Pattern z;Apply case_SL_varshift1 with n;Intros.
2:Assumption.
Exists (var (S n));Split;Red;Apply star_refl.
Save local_varshift1.

(* varshift2 *)

Goal (b:bool)(x,y:(TS b))(reg_varshift2 b x y)->(local1 b x y).
Induction 1;Red;Intros n s z H0.
Pattern z;Apply case_SL_varshift2 with n s;Intros.
3:Assumption.
Exists (env (var (S n)) s);Split;Red;Apply star_refl.
Apply PC_varshift2_ctxt_r';Assumption.
Save local_varshift2.

(* fvarcons *)

Goal (b:bool)(x,y:(TS b))(reg_fvarcons b x y)->(local1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern z;Apply case_SL_fvarcons with a s;Intros.
3:Assumption.
Exists a;Split;Red;Apply star_refl.
Apply PC_fvarcons_ctxt_r with s;Assumption.
Save local_fvarcons.

(* fvarlift1 *)

Goal (b:bool)(x,y:(TS b))(reg_fvarlift1 b x y)->(local1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_SL_fvarlift1 with s;Intros.
3:Assumption.
Exists (var O);Split;Red;Apply star_refl.
Apply PC_fvarlift1_ctxt_r' with s;Assumption.
Save local_fvarlift1.


(* fvarlift2 *)

Goal (b:bool)(x,y:(TS b))(reg_fvarlift2 b x y)->(local1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_SL_fvarlift2 with s t;Intros.
3:Assumption.
Exists (env (var O) t);Split;Red;Apply star_refl.
Apply PC_fvarlift2_ctxt_r with s;Assumption.
Save local_fvarlift2.

(* rvarcons *)

Goal (b:bool)(x,y:(TS b))(reg_rvarcons b x y)->(local1 b x y).
Induction 1;Red;Intros n a s z H0.
Pattern z;Apply case_SL_rvarcons with n a s;Intros.
3:Assumption.
Exists (env (var n) s);Split;Red;Apply star_refl.
Apply PC_rvarcons_ctxt_r with a;Assumption.
Save local_rvarcons.

(* rvarlift1 *)

Goal (b:bool)(x,y:(TS b))(reg_rvarlift1 b x y)->(local1 b x y).
Induction 1;Red;Intros n s z H0.
Pattern z;Apply case_SL_rvarlift1 with n s;Intros.
3:Assumption.
Exists (env (var n) (comp s shift));Split;Red;Apply star_refl.
Apply PC_rvarlift1_ctxt_r';Assumption.
Save local_rvarlift1.

(* rvarlift2 *)

Goal (b:bool)(x,y:(TS b))(reg_rvarlift2 b x y)->(local1 b x y).
Induction 1;Red;Intros n s t z H0.
Pattern z;Apply case_SL_rvarlift2 with n s t;Intros.
3:Assumption.
Exists (env (var n) (comp s (comp shift t)));Split;Red;Apply star_refl.
Apply PC_rvarlift2_ctxt_r;Assumption.
Save local_rvarlift2.

(* assenv *)

Goal (b:bool)(x,y:(TS b))(reg_assenv b x y)->(local1 b x y).
Induction 1;Red;Intros s t u z H0.
Pattern u z;Apply case_SL_assenv with s t;Intros.
5:Assumption.
Exists (comp s (comp t u));Split;Red;Apply star_refl.
Apply PC2_assenv_idr.
Apply PC_assenv_ctxt_l;Assumption.
Apply PC2_assenv_ctxt_r;Assumption.
Save local_assenv.

(* mapenv *)

Goal (b:bool)(x,y:(TS b))(reg_mapenv b x y)->(local1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern t z;Apply case_SL_mapenv with a s;Intros.
5:Assumption.
Exists (cons (env a t) (comp s t));Split;Red;Apply star_refl.
Apply PC_mapenv_idr.
Apply PC_mapenv_ctxt_l;Assumption.
Apply PC_mapenv_ctxt_r;Assumption.
Save local_mapenv.

(* shiftcons *)

Goal (b:bool)(x,y:(TS b))(reg_shiftcons b x y)->(local1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern z;Apply case_SL_shiftcons with a s;Intros.
3:Assumption.
Exists s;Split;Red;Apply star_refl.
Apply PC_shiftcons_ctxt_r with a;Assumption.
Save local_shiftcons.

(* shiftlift1 *)

Goal (b:bool)(x,y:(TS b))(reg_shiftlift1 b x y)->(local1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_SL_shiflift1 with s;Intros.
3:Assumption.
Exists (comp s shift);Split;Red;Apply star_refl.
Apply PC_shiftlift1_ctxt_r';Assumption.
Save local_shiftlift1.

(* shiftlift2 *)

Goal (b:bool)(x,y:(TS b))(reg_shiftlift2 b x y)->(local1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_SL_shiflift2 with s t;Intros.
3:Assumption.
Exists (comp s (comp shift t));Split;Red;Apply star_refl.
Apply PC_shiftlift2_ctxt_r;Assumption.
Save local_shiftlift2.

(* lift1 *)

Goal (b:bool)(x,y:(TS b))(reg_lift1 b x y)->(local1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_SL_lift1 with s t;Intros.
4:Assumption.
Exists (lift (comp s t));Split;Red;Apply star_refl.
Apply PC_lift1_ctxt_l';Assumption.
Apply PC_lift1_ctxt_r';Assumption.
Save local_lift1.

(* lift2 *)

Goal (b:bool)(x,y:(TS b))(reg_lift2 b x y)->(local1 b x y).
Induction 1;Red;Intros s t u z H0.
Pattern z;Apply case_SL_lift2 with s t u;Intros.
4:Assumption.
Exists (comp (lift (comp s t)) u);Split;Red;Apply star_refl.
Apply PC_lift2_ctxt_l';Assumption.
Apply PC_lift2_ctxt_r;Assumption.
Save local_lift2.

(* liftenv *)

Goal (b:bool)(x,y:(TS b))(reg_liftenv b x y)->(local1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern z;Apply case_SL_liftenv with a s t;Intros.
4:Assumption.
Exists (cons a (comp s t));Split;Red;Apply star_refl.
Apply PC_liftenv_ctxt_l';Assumption.
Apply PC_liftenv_ctxt_r;Assumption.
Save local_liftenv.

(* idl *)

Goal (b:bool)(x,y:(TS b))(reg_idl b x y)->(local1 b x y).
Induction 1;Red;Intros s z H0.
Pattern s z;Apply case_SL_idl;Intros.
4:Assumption.
Exists s;Split;Red;Apply star_refl.
Apply PC_idl_idr.
Apply PC_idl_ctxt_r;Assumption.
Save local_idl.

(* idr *)

Goal (b:bool)(x,y:(TS b))(reg_idr b x y)->(local1 b x y).
Induction 1;Red;Intros s z H0.
Apply Ex_PQ;Pattern s z;Apply case_SL_idr;Intros.
6:Assumption.
Exists s;Split;Red;Apply star_refl.
Apply PC2_assenv_idr.
Apply PC_mapenv_idr.
Apply PC_idl_idr.
Apply Ex_PQ;Apply PC_idr_ctxt_l;Assumption.
Save local_idr.

(* liftid *)

Goal (b:bool)(x,y:(TS b))(reg_liftid b x y)->(local1 b x y).
Induction 1;Red;Intros z H0.
Pattern z;Apply case_SL_liftid;Intros.
2:Assumption.
Exists id;Split;Red;Apply star_refl.
Save local_liftid.

(* id *)

Goal (b:bool)(x,y:(TS b))(reg_id b x y)->(local1 b x y).
Induction 1;Red;Intros a z H0.
Apply Ex_PQ;Pattern a z;Apply case_SL_reg_id;Intros.
6:Assumption.
Exists a;Split;Red;Apply star_refl.
Apply PC_app_id.
Apply PC_lambda_id.
Apply PC1_clos_id.
Apply Ex_PQ;Apply PC_id_ctxt_l;Assumption.
Save local_id.

(* systeme SL *)

Goal (b:bool)(x,y:(TS b))(systemSL b x y)->(local1 b x y).
Induction 1;Intros.
Apply local_app;Assumption.
Apply local_lambda;Assumption.
Apply local_clos;Assumption.
Apply local_varshift1;Assumption.
Apply local_varshift2;Assumption.
Apply local_fvarcons;Assumption.
Apply local_fvarlift1;Assumption.
Apply local_fvarlift2;Assumption.
Apply local_rvarcons;Assumption.
Apply local_rvarlift1;Assumption.
Apply local_rvarlift2;Assumption.
Apply local_assenv;Assumption.
Apply local_mapenv;Assumption.
Apply local_shiftcons;Assumption.
Apply local_shiftlift1;Assumption.
Apply local_shiftlift2;Assumption.
Apply local_lift1;Assumption.
Apply local_lift2;Assumption.
Apply local_liftenv;Assumption.
Apply local_idl;Assumption.
Apply local_idr;Assumption.
Apply local_liftid;Assumption.
Apply local_id;Assumption.
Save local_systemSL.

Goal (b:bool)(x,y:(TS b))(relSL b x y)->(local1 b x y).
Induction 1.
(* systemSL *)
Intros;Apply local_systemSL;Assumption.
(* contexte app gauche *)
Red;Intros a a' b0 H0 H1 z H2.
Pattern z;Apply case_SLapp with a b0.
3:Assumption.
Intros a'' H3;Elim (H1 a'' H3);Intros a_ H4.
Elim H4;Intros H5 H6.
Exists (app a_ b0);Split;Apply SLstar_context_app_l;Assumption.
Intros b0' H3;Exists (app a' b0');Split.
Apply SLstar_context_app_r;Red;Apply star_step1;Assumption.
Apply SLstar_context_app_l;Red;Apply star_step1;Assumption.
(* contexte app droit *)
Red;Intros a b0 b0' H0 H1 z H2.
Pattern z;Apply case_SLapp with a b0.
3:Assumption.
Intros a' H3;Exists (app a' b0');Split.
Apply SLstar_context_app_l;Red;Apply star_step1;Assumption.
Apply SLstar_context_app_r;Red;Apply star_step1;Assumption.
Intros b0'' H3;Elim (H1 b0'' H3);Intros b0_ H4.
Elim H4;Intros H5 H6.
Exists (app a b0_);Split;Apply SLstar_context_app_r;Assumption.
(* contexte lambda *)
Red;Intros a a' H0 H1 z H2.
Pattern z;Apply case_SLlambda with a.
2:Assumption.
Intros a'' H3;Elim (H1 a'' H3);Intros a_ H4;Elim H4;Intros H5 H6.
Exists (lambda a_);Split;Apply SLstar_context_lambda;Assumption.
(* contexte env gauche *)
Red;Intros a a' s H0 H1 z H2.
Apply Ex_PQ;Generalize H0;Pattern a s z;Apply case_SLenv.
15:Assumption.
Intros;Apply PC_app_ctxt_l;Assumption.
Intros;Apply PC_lambda_ctxt_l;Assumption.
Intros;Apply PC_clos_ctxt_l;Assumption.
Intros n H3;Elim (case_SLvar n a' H3).
Intros n s1 H3;Elim (case_SLvar n a' H3).
Intros a1 s1 H3;Elim (case_SLvar O a' H3).
Intros s1 H3;Elim (case_SLvar O a' H3).
Intros s1 s2 H3;Elim (case_SLvar O a' H3).
Intros n a1 s1 H3;Elim (case_SLvar (S n) a' H3).
Intros n s1 H3;Elim (case_SLvar (S n) a' H3).
Intros n s1 s2 H3;Elim (case_SLvar (S n) a' H3).
Intros;Apply PC_id_ctxt_l;Assumption.
Intros a'' H3 H4;Elim (H1 a'' H3);Intros a_ H5;Elim H5;Intros H6 H7.
Exists (env a_ s);Split;Apply SLstar_context_env_t;Assumption.
Intros s' H3 H4;Exists (env a' s');Split;Red;Apply star_step1.
Apply SL_context_env_t;Assumption.
Apply SL_context_env_s;Assumption.
(* contexte env droit *)
Red;Intros a s s' H0 H1 z H2.
Apply Ex_PQ;Generalize H0;Pattern a s z;Apply case_SLenv.
15:Assumption.
Intros;Apply PC_app_ctxt_r;Assumption.
Intros;Apply PC_lambda_ctxt_r;Assumption.
Intros;Apply PC_clos_ctxt_r;Assumption.
Intros n H3;Elim (case_SLshift s' H3).
Intros;Apply PC_varshift2_ctxt_r';Assumption.
Intros;Apply PC_fvarcons_ctxt_r with s1;Assumption.
Intros;Apply PC_fvarlift1_ctxt_r' with s1;Assumption.
Intros;Apply PC_fvarlift2_ctxt_r with s1;Assumption.
Intros;Apply PC_rvarcons_ctxt_r with a1;Assumption.
Intros;Apply PC_rvarlift1_ctxt_r';Assumption.
Intros;Apply PC_rvarlift2_ctxt_r;Assumption.
Intro H3;Elim (case_SLid s' H3).
Intros a' H3 H4;Exists (env a' s');Split;Red;Apply star_step1.
Apply SL_context_env_s;Assumption.
Apply SL_context_env_t;Assumption.
Intros s'' H3 H4;Elim (H1 s'' H3);Intros s_ H5;Elim H5;Intros H6 H7.
Exists (env a s_);Split;Apply SLstar_context_env_s;Assumption.
(* contexte cons gauche *)
Red;Intros a a' s H0 H1 z H2.
Pattern z;Apply case_SLcons with a s.
3:Assumption.
Intros a'' H3;Elim (H1 a'' H3);Intros a_ H4;Elim H4;Intros H5 H6.
Exists (cons a_ s);Split;Apply SLstar_context_cons_t;Assumption.
Intros s' H3;Exists (cons a' s');Split;Red;Apply star_step1.
Apply SL_context_cons_s;Assumption.
Apply SL_context_cons_t;Assumption.
(* contexte cons droit *)
Red;Intros a s s' H0 H1 z H2.
Pattern z;Apply case_SLcons with a s.
3:Assumption.
Intros a' H3;Exists (cons a' s');Split;Red;Apply star_step1.
Apply SL_context_cons_t;Assumption.
Apply SL_context_cons_s;Assumption.
Intros s'' H3;Elim (H1 s'' H3);Intros s_ H4;Elim H4;Intros H5 H6.
Exists (cons a s_);Split;Apply SLstar_context_cons_s;Assumption.
(* contexte comp gauche *)
Red;Intros s s' t H0 H1 z H2.
Apply Ex_PQ;Generalize H0;Pattern s t z;Apply case_SLcomp.
13:Assumption.
Intros;Apply PC_assenv_ctxt_l;Assumption.
Intros;Apply PC_mapenv_ctxt_l;Assumption.
Intros a t1 H3;Elim (case_SLshift s' H3).
Intros t1 H3;Elim (case_SLshift s' H3).
Intros t1 t2 H3;Elim (case_SLshift s' H3).
Intros;Apply PC_lift1_ctxt_l';Assumption.
Intros;Apply PC_lift2_ctxt_l';Assumption.
Intros;Apply PC_liftenv_ctxt_l';Assumption.
Intro H3;Elim (case_SLid s' H3).
Intros;Apply PC_idr_ctxt_l;Assumption.
Intros s'' H3;Elim (H1 s'' H3);Intros s_ H4;Elim H4;Intros H5 H6.
Exists (comp s_ t);Split;Apply SLstar_context_comp_l;Assumption.
Intros t' H3;Exists (comp s' t');Split;Red;Apply star_step1.
Apply SL_context_comp_l;Assumption.
Apply SL_context_comp_r;Assumption.
(* contexte comp droit *)
Red;Intros s t t' H0 H1 z H2.
Apply Ex_PQ;Generalize H0;Pattern s t z;Apply case_SLcomp.
13:Assumption.
Intros;Apply PC2_assenv_ctxt_r;Assumption.
Intros;Apply PC_mapenv_ctxt_r;Assumption.
Intros;Apply PC_shiftcons_ctxt_r with a;Assumption.
Intros;Apply PC_shiftlift1_ctxt_r';Assumption.
Intros;Apply PC_shiftlift2_ctxt_r;Assumption.
Intros;Apply PC_lift1_ctxt_r';Assumption.
Intros;Apply PC_lift2_ctxt_r;Assumption.
Intros;Apply PC_liftenv_ctxt_r;Assumption.
Intros;Apply PC_idl_ctxt_r;Assumption.
Intro H3;Elim (case_SLid t' H3).
Intros s' H3;Exists (comp s' t');Split;Red;Apply star_step1.
Apply SL_context_comp_r;Assumption.
Apply SL_context_comp_l;Assumption.
Intros t'' H3;Elim (H1 t'' H3);Intros t_ H4;Elim H4;Intros H5 H6.
Exists (comp s t_);Split;Apply SLstar_context_comp_r;Assumption.
(* contexte lift *)
Red;Intros s s' H0 H1 z H2.
Generalize H0;Pattern s z;Apply case_SLlift.
3:Assumption.
Intro H3;Elim (case_SLid s' H3).
Intros s'' H3;Elim (H1 s'' H3);Intros s_ H4;Elim H4;Intros H5 H6.
Exists (lift s_);Split;Apply SLstar_context_lift;Assumption.
Save local_relSL.


(*************************************************************)
(*           sigma-lift est localement confluente            *)
(*************************************************************)


Theorem conf_local_SL: (b:bool)(local_confluence (TS b) (relSL b)).
Goal.
Red;Red;Intros b x y z H H0.
Generalize z H0.
Change (local1 b x y);Apply local_relSL;Assumption.
Save.


Provide conf_local_SL.
