
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)



              (*         complements d arithmetique            *)


Require Gt.
Require Mult.

Hint mult_n_O mult_n_Sm le_plus_plus. 

(* gt *)

Goal (n,m:nat)(gt n m)->(gt (S n) m).
(* Auto *)Intros;Apply le_gt_S;Apply lt_le_weak;Assumption.
Save gt_S_l.
Hint gt_S_l.

Goal (n,m:nat)(gt n (S m))->(gt n m).
(* Auto *)Intros;Unfold gt;Unfold lt;Apply lt_le_weak;Assumption.
Save gt_S_r.
Hint gt_S_r.
 
(* plus *)

Goal (n,m,p:nat)<nat>n=m-><nat>(plus p n)=(plus p m).
Intros;Elim p;Elim H;Intros;Apply refl_equal.
Save eq_plus_reg_r.
Hint eq_plus_reg_r.

Goal (n,m,p:nat)<nat>n=m-><nat>(plus n p)=(plus m p).
Intros;Elim p;Elim H;Intros;Apply refl_equal.
Save eq_plus_reg_l.
Hint eq_plus_reg_l.

Goal (n,m,p:nat)(gt n m)->(gt (plus n p) (plus m p)).
Intros;Elim (plus_sym p m);Elim (plus_sym p n).
(* Auto *)Apply gt_reg_l;Assumption.
Save gt_reg_r.
Hint gt_reg_r.

Goal (n,m,p,q:nat)(gt n m)->(gt p q)->(gt (plus n p)(plus m q)).
Induction 1;Intros;Simpl.(* Auto *)
Apply gt_S_l;Apply gt_reg_l;Assumption.
Apply gt_S_l;Apply H1;Assumption.
Save gt_plus_plus.
Hint gt_plus_plus.

Goal (p:nat)(gt p O)->(n:nat)(gt (plus p n) n).
Induction 1;Intros.
(* Auto *)Apply gt_S_n;Apply gt_Sn_n.
Simpl;(* Auto *)Apply gt_S_l;Apply H1.
Save gt_plus_l.
Hint gt_plus_l.

Goal (p:nat)(gt p O)->(n:nat)(gt (plus n p) n).
Intros;Elim (plus_sym p n);(* Auto *)Apply gt_plus_l;Assumption.
Save gt_plus_r.
Hint gt_plus_r.

Goal (n,m,p:nat)(gt n m)->(gt (plus n p) m).
(* Auto *)Intros;Unfold gt;Apply lt_plus_trans;Assumption.
Save gt_plus_trans_r.
Hint gt_plus_trans_r.

Goal (n,m,p:nat)(gt n m)->(gt (plus p n) m).
Intros;Elim (plus_sym n p);(* Auto *)Apply gt_plus_trans_r;Assumption.
Save gt_plus_trans_l.
Hint gt_plus_trans_l.

Goal (n:nat)<nat>(S n)=(plus n (S O)).
Induction n.
(* Auto *)Apply refl_equal.
Simpl;(* Auto *)Intros;Apply eq_S;Assumption.
Save S_plus.
Hint S_plus.
 
(* mult *)

Goal (n,m:nat)<nat>(mult n m)=(mult m n).
Induction n;Intros.
(* Auto *)Apply mult_n_O.
Simpl;Elim mult_n_Sm;Elim H;(* Auto *)Apply plus_sym;Trivial.
Save mult_sym.
Hint mult_sym.

Goal (n,m,p:nat)<nat>(mult n (mult m p))=(mult (mult n m) p).
Intros n m p;Elim n;Simpl.
(* Auto *)Apply refl_equal.
Intros y H;Rewrite mult_plus_distr;Elim H;(* Auto *)Apply refl_equal.
Save mult_assoc_l.
Hint mult_assoc_l.

Goal (n,m,p:nat)<nat>(mult n (mult m p))=(mult m (mult n p)).
Intros;Rewrite mult_assoc_l;Rewrite (mult_sym m n);
(* Auto *)Apply mult_assoc_l.
Save mult_permut.
Hint mult_permut. 

Goal (n,m,p:nat)<nat>(mult p (plus n m))=(plus (mult p n)(mult p m)).
Intros;Elim p.
(* Auto *)Apply plus_n_O.
Simpl;Intros;Rewrite H;Elim plus_assoc_l;Elim plus_assoc_l.
Pattern (plus (mult y n) (plus m (mult y m)));Elim plus_permute;Trivial.
Save mult_plus_distr_r.
Hint mult_plus_distr_r.

Goal (n:nat)<nat>(mult n (S(S O)))=(plus n n).
Induction n.
(* Auto *)Apply plus_n_O.
Intros;Simpl;Rewrite H;(* Auto *)Apply eq_S;Apply plus_n_Sm.
Save mult_n_2. 
Hint mult_n_2.
 
Goal (n:nat)<nat>n=(mult n (S O)).  
Induction n.
(* Auto *)Apply refl_equal.
Simpl;(* Auto *)Intros;Apply eq_S;Assumption.
Save mult_n_1. 
Hint mult_n_1.

Goal (n,m,p:nat)<nat>n=m-><nat>(mult p n)=(mult p m).
Intros;Elim p;Elim H;Intros;Apply refl_equal.
Save eq_mult_reg_r.
Hint eq_mult_reg_r.

Goal (n,m,p:nat)<nat>n=m-><nat>(mult n p)=(mult m p).
Intros;Elim p;Elim H;Intros;Apply refl_equal.
Save eq_mult_reg_l.
Hint eq_mult_reg_l.

Goal (p:nat)(gt p O)->(n,m:nat)(gt n m)->(gt (mult p n) (mult p m)).
Induction p;Intros.
Absurd (gt O O);(* Auto *)[Apply gt_antirefl|Assumption].
Elim (gt_O_eq y);Intros.
Simpl;Apply gt_plus_plus;(* Auto *)[Assumption|Apply H;Assumption].
Elim H2;Simpl;Elim (plus_n_O n);Elim (plus_n_O m);Trivial.
Save gt_mult_reg_l.
Hint gt_mult_reg_l.

Goal (p:nat)(gt p O)->(n,m:nat)(gt n m)->(gt (mult n p)(mult m p)).
Intros;Elim (mult_sym p n);Elim (mult_sym p m).
Apply gt_mult_reg_l;Assumption.
Save gt_mult_reg_r.
Hint gt_mult_reg_r.

Goal (p:nat)(gt p (S O))->(n:nat)(gt n O)->(gt (mult p n) n).
Induction p;Intros.
Absurd (gt O (S O));(* Auto *)[Apply le_not_gt;Apply le_O_n|Assumption].
Simpl;Apply gt_plus_r;Replace O with (mult y O).
(* Auto *)Apply gt_mult_reg_l;[Apply gt_S_n;Assumption|Assumption].
(* Auto *)Apply sym_equal;Apply mult_n_O.
Save gt_mult_l.
Hint gt_mult_l.

Goal (p:nat)(gt p (S O))->(n:nat)(gt n O)->(gt (mult n p) n).
Intros;Elim (mult_sym p n);Apply gt_mult_l;Assumption. 
Save gt_mult_r.
Hint gt_mult_r.

Goal (p:nat)(gt p O)->(n,m:nat)(gt n m)->(gt (mult p n) m).
Induction p;Intros;Simpl.
Absurd (gt O O);(* Auto *)[Apply gt_antirefl|Assumption].
Elim (gt_O_eq y);Intros.
(* Auto *)Apply gt_plus_trans_l;Apply H;Assumption.
Elim H2;Simpl;Elim plus_n_O;Assumption.
Save gt_mult_trans_r.
Hint gt_mult_trans_r.

Goal (p:nat)(gt p O)->(n,m:nat)(gt n m)->(gt (mult n p) m).
Intros;Elim (mult_sym p n);Apply gt_mult_trans_r;Assumption.
Save gt_mult_trans_l.
Hint gt_mult_trans_l.

(* power2: (power2 n)=2^n *)

Definition power2: nat->nat =
  [n:nat](<nat>Match n with 
            (* O *)     (S O)
            (* S *) [p:nat][power2p:nat](mult (S (S O)) power2p)).

Goal (n:nat)(gt (power2 n) O).
Induction n;Simpl;Intros.
Apply gt_Sn_n.
Elim plus_n_O;Apply gt_plus_trans_l;Assumption.
Save gt_power2_O.
Hint gt_power2_O.

 
Provide comparith.

