
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                 (*  SL commute avec B|| de la maniere suivante:
      
                                           B||
                                       x ---------> z
                                       |            |
                                    SL |            |SL*
                                       |            | 
                                       V            V
                                       y ----------> u
                                         SL*B||SL*              *)

Require egaliteTS.
Require SLstar_bpar_SLstar.
Require determinePC_SL.

Definition diag1=[b:bool][x:(TS b)][y:(TS b)](z:(TS b))(beta_par b x z)->
      <(TS b)>Ex([u:(TS b)] (slstar_bp_slstar b y u)/\(relSLstar b z u)).


(* les regles du systeme sigma-lift (SL) verifient le diagramme *)

Goal (b:bool)(x,y:(TS b))(reg_app b x y)->(diag1 b x y).
Induction 1;Red;Intros a b0 s z H0.
Pattern z;Apply case_benv with (app a b0) s.
2:Assumption.
Intros x' s' H1 H2;Pattern x';Apply case_bapp with a b0.
3:Assumption.
(* 1-regle B||: app *)
Intros a' b0' H3 H4;Exists (app (env a' s') (env b0' s'));Split.
 (* (a[s])(b0[s]) SL*B||SL* (a'[s'])(b0'[s']) *)
Apply betapar_slbpsl;Apply app_bpar;Apply env_bpar;Assumption.
 (* (a'b0')[s'] SL* (a'[s'])(b0'[s']) *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_app;Apply reg1_app.
(* 2-regle B||: beta *)
Intros a1 a1' b0' H3 H4 H5;Rewrite H3.
Exists (env a1' (cons (env b0' s') s'));Split.
 (* ((L a1)[s])(b0[s]) SL*B||SL* a1'[b0'[s'].s'] *)
Red;Apply comp_2rel with (app (lambda (env a1 (lift s))) (env b0 s)).
   (* ((L a1)[s])(b0[s]) SL* (L (a1[||S]))(b0[s]) *) 
Red;Apply star_step1.
Apply SL_context_app_l;Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
   (* (L (a1[||S]))(b0[s]) B|| (a1'[||s'])[b0'[s'].id] *)
Apply comp_2rel with (env (env a1' (lift s')) (cons (env b0' s') id)).
Apply beta_bpar.
Apply env_bpar;[Assumption|Apply lift_bpar;Assumption].
Apply env_bpar;Assumption.
   (* (a1'[||s'])[b0'[s'].id] SL* a1'[b0'[s'].s'] *)
Red;Apply star_trans1 with (env a1' (comp (lift s') (cons (env b0' s') id))).
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_trans1 with (env a1' (cons (env b0' s') (comp s' id))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Apply star_step1;Apply SL_context_env_s;Apply SL_context_cons_s.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
 (* (a1'[b0'id])[s'] SL* a1'[b0'[s'].s'] *)
Red;Apply star_trans1 with (env a1' (comp (cons b0' id) s')).
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Apply star_trans1 with (env a1' (cons (env b0' s') (comp id s'))).
Apply SL_context_env_s;Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Apply star_step1;Apply SL_context_env_s;Apply SL_context_cons_s.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save commut_app.

Goal (b:bool)(x,y:(TS b))(reg_lambda b x y)->(diag1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern z;Apply case_benv with (lambda a) s.
2:Assumption.
Intros x' s' H1 H2;Pattern x';Apply case_blambda with a.
2:Assumption.
Intros a' H3;Exists (lambda (env a' (lift s')));Split.
(* L(a[||s]) SL*B||*SL L(a'[||s']) *)
Apply betapar_slbpsl;Apply lambda_bpar;Apply env_bpar.
Assumption.
Apply lift_bpar;Assumption.
(* (L a0')[s'] SL* L(a0'[||s']) *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_lambda;Apply reg1_lambda.
Save commut_lambda.

Goal (b:bool)(x,y:(TS b))(reg_clos b x y)->(diag1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern z;Apply case_benv with (env a s) t.
2:Assumption.
Intros x' t' H1 H2;Pattern x';Apply case_benv with a s.
2:Assumption.
Intros a' s' H3 H4;Exists (env a' (comp s' t'));Split.
(*  a[sot] SL*B||SL* a'[s'ot'] *)
Apply betapar_slbpsl;Apply env_bpar;
[Assumption|Apply comp_bpar;Assumption].
(* (a'[s'])[t'] SL* a'[s'ot'] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_clos;Apply reg1_clos.
Save commut_clos.

Goal (b:bool)(x,y:(TS b))(reg_varshift1 b x y)->(diag1 b x y).
Induction 1;Red;Intros n z H0.
Pattern z;Apply case_benv with (var n) shift.
2:Assumption.
Intros x' s' H1 H2;Pattern x';Apply case_bvar with n.
2:Assumption.
Pattern s';Apply case_bshift.
2:Assumption.
Exists (var (S n));Split.
(* n+1 SL*B||SL* n+1 *)
Apply refl_slbpsl.
(* n[|] SL* n+1 *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_varshift1;Apply reg1_varshift1.
Save commut_varshift1.

Goal (b:bool)(x,y:(TS b))(reg_varshift2 b x y)->(diag1 b x y).
Induction 1;Red;Intros n s z H0.
Pattern z;Apply case_benv with (var n) (comp shift s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with n.
2:Assumption.
Pattern y';Apply case_bcomp with shift s.
2:Assumption.
Intros t' s' H3 H4;Pattern t';Apply case_bshift.
2:Assumption.
Exists (env (var (S n)) s');Split.
(* n+1[s] SL*B||SL* n+1[s'] *)
Apply betapar_slbpsl;Apply env_bpar;[Apply var_bpar|Assumption].
(* n[|os'] SL* n+1[s'] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_varshift2;Apply reg1_varshift2.
Save commut_varshift2.

Goal (b:bool)(x,y:(TS b))(reg_fvarcons b x y)->(diag1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern z;Apply case_benv with (var O) (cons a s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with O.
2:Assumption.
Pattern y';Apply case_bcons with a s.
2:Assumption.
Intros a' s' H3 H4;Exists a';Split.
(* a SL*B||SL* a' *)
Apply betapar_slbpsl;Assumption.
(* 0[a'.s'] SL* a' *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_fvarcons;Apply reg1_fvarcons.
Save commut_fvarcons.

Goal (b:bool)(x,y:(TS b))(reg_fvarlift1 b x y)->(diag1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_benv with (var O) (lift s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with O.
2:Assumption.
Pattern y';Apply case_blift with s.
2:Assumption.
Intros s' H3;Exists (var O);Split.
(* 0 SL*B||SL* 0 *)
Apply refl_slbpsl.
(* 0[||s'] SL* 0 *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_fvarlift1;Apply reg1_fvarlift1.
Save commut_fvarlift1.

Goal (b:bool)(x,y:(TS b))(reg_fvarlift2 b x y)->(diag1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_benv with (var O) (comp (lift s) t).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with O.
2:Assumption.
Pattern y';Apply case_bcomp with (lift s) t.
2:Assumption.
Intros z' t' H3 H4;Pattern z';Apply case_blift with s.
2:Assumption.
Intros s' H5;Exists (env (var O) t');Split.
(* 0[t] SL*B||SL* 0[t'] *)
Apply betapar_slbpsl;Apply env_bpar;[Apply var_bpar|Assumption].
(* 0[||s'ot'] SL* 0[t'] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_fvarlift2;Apply reg1_fvarlift2.
Save commut_fvarlift2.

Goal (b:bool)(x,y:(TS b))(reg_rvarcons b x y)->(diag1 b x y).
Induction 1;Red;Intros n a s z H0.
Pattern z;Apply case_benv with (var (S n)) (cons a s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with (S n).
2:Assumption.
Pattern y';Apply case_bcons with a s.
2:Assumption.
Intros a' s' H3 H4;Exists (env (var n) s');Split.
(* n[s] SL*B||SL* n[s'] *)
Apply betapar_slbpsl;Apply env_bpar;[Apply var_bpar|Assumption].
(* n+1[a'.s'] SL* n[s'] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_rvarcons;Apply reg1_rvarcons.
Save commut_rvarcons.

Goal (b:bool)(x,y:(TS b))(reg_rvarlift1 b x y)->(diag1 b x y).
Induction 1;Red;Intros n s z H0.
Pattern z;Apply case_benv with (var (S n)) (lift s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with (S n).
2:Assumption.
Pattern y';Apply case_blift with s.
2:Assumption.
Intros s' H3;Exists (env (var n) (comp s' shift));Split.
(* n[so|] SL*B||SL* n[s'o|] *)
Apply betapar_slbpsl;Apply env_bpar.
Apply var_bpar.
Apply comp_bpar;[Assumption|Apply shift_bpar].
(* n+1[||s'] SL* n[s'o|] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_rvarlift1;Apply reg1_rvarlift1.
Save commut_rvarlift1.

Goal (b:bool)(x,y:(TS b))(reg_rvarlift2 b x y)->(diag1 b x y).
Induction 1;Red;Intros n s t z H0.
Pattern z;Apply case_benv with (var (S n)) (comp (lift s) t).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bvar with (S n).
2:Assumption.
Pattern y';Apply case_bcomp with (lift s) t.
2:Assumption.
Intros z' t' H3 H4;Pattern z';Apply case_blift with s.
2:Assumption.
Intros s' H5;Exists (env (var n) (comp s' (comp shift t')));Split.
(* n[so(|ot)] SL*B||SL* n[s'o(|ot')] *)
Apply betapar_slbpsl;Apply env_bpar.
Apply var_bpar.
Apply comp_bpar;[Assumption|Apply comp_bpar;
[Apply shift_bpar|Assumption]].
(* n+1[||s'ot'] SL* n[s'o(|ot')] *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_rvarlift2;Apply reg1_rvarlift2.
Save commut_rvarlift2.

Goal (b:bool)(x,y:(TS b))(reg_assenv b x y)->(diag1 b x y).
Induction 1;Red;Intros s t u z H0.
Pattern z;Apply case_bcomp with (comp s t) u.
2:Assumption.
Intros x' u' H1 H2;Pattern x';Apply case_bcomp with s t.
2:Assumption.
Intros s' t' H3 H4;Exists (comp s' (comp t' u'));Split.
(* so(tou) SL*B||SL* s'o(t'ou') *)
Apply betapar_slbpsl;Apply comp_bpar;[Assumption|
Apply comp_bpar;[Assumption|Assumption]].
(*  (s'ot')ou' SL* s'o(t'ou') *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_assenv;Apply reg1_assenv.
Save commut_assenv.

Goal (b:bool)(x,y:(TS b))(reg_mapenv b x y)->(diag1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern z;Apply case_bcomp with (cons a s) t.
2:Assumption.
Intros x' t' H1 H2;Pattern x';Apply case_bcons with a s.
2:Assumption.
Intros a' s' H3 H4;Exists (cons (env a' t') (comp s' t'));Split.
(* a[t].(sot) SL*B||SL a'[t'].(s'ot') *)
Apply betapar_slbpsl;Apply cons_bpar.
Apply env_bpar;Assumption.
Apply comp_bpar;Assumption.
(* (a'.s')ot' SL* a'[t'].(s'ot') *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_mapenv;Apply reg1_mapenv.
Save commut_mapenv.

Goal (b:bool)(x,y:(TS b))(reg_shiftcons b x y)->(diag1 b x y).
Induction 1;Red;Intros a s z H0.
Pattern z;Apply case_bcomp with shift (cons a s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bshift.
2:Assumption.
Pattern y';Apply case_bcons with a s.
2:Assumption.
Intros a' s' H3 H4;Exists s';Split.
(* s SL*B||SL* s' *)
Apply betapar_slbpsl;Assumption.
(* shift o(a'.s') SL* s' *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_shiftcons;Apply reg1_shiftcons.
Save commut_shiftcons.

Goal (b:bool)(x,y:(TS b))(reg_shiftlift1 b x y)->(diag1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_bcomp with shift (lift s).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bshift.
2:Assumption.
Pattern y';Apply case_blift with s.
2:Assumption.
Intros s' H3;Exists (comp s' shift);Split.
(* so| SL*B||SL* s'o| *)
Apply betapar_slbpsl;Apply comp_bpar;[Assumption|Apply shift_bpar].
(* |o(|| s') SL* s'o| *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_shiftlift1;Apply reg1_shiftlift1.
Save commut_shiftlift1.

Goal (b:bool)(x,y:(TS b))(reg_shiftlift2 b x y)->(diag1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_bcomp with shift (comp (lift s) t).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_bshift.
2:Assumption.
Pattern y';Apply case_bcomp with (lift s) t.
2:Assumption.
Intros z' t' H3 H4;Pattern z';Apply case_blift with s.
2:Assumption.
Intros s' H5;Exists (comp s' (comp shift t'));Split.
(* so(|ot) SL*B||SL* s'o(|ot') *)
Apply betapar_slbpsl;Apply comp_bpar.
Assumption.
Apply comp_bpar;[Apply shift_bpar|Assumption].
(* (|| s')ot' SL* s'o(|ot') *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_shiftlift2;Apply reg1_shiftlift2.
Save commut_shiftlift2.

Goal (b:bool)(x,y:(TS b))(reg_lift1 b x y)->(diag1 b x y).
Induction 1;Red;Intros s t z H0.
Pattern z;Apply case_bcomp with (lift s) (lift t).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_blift with s.
2:Assumption.
Intros s' H3;Pattern y';Apply case_blift with t.
2:Assumption.
Intros t' H4;Exists (lift (comp s' t'));Split.
(* ||(sot) SL*B||SL* ||(s'ot') *)
Apply betapar_slbpsl;Apply lift_bpar;Apply comp_bpar;Assumption.
(* ||s' o ||t' SL* ||(s'ot') *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_lift1;Apply reg1_lift1.
Save commut_lift1.

Goal (b:bool)(x,y:(TS b))(reg_lift2 b x y)->(diag1 b x y).
Induction 1;Red;Intros s t u z H0.
Pattern z;Apply case_bcomp with (lift s) (comp (lift t) u).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_blift with s.
2:Assumption.
Intros s' H3;Pattern y';Apply case_bcomp with (lift t) u.
2:Assumption.
Intros z' u' H4 H5;Pattern z';Apply case_blift with t.
2:Assumption.
Intros t' H6;Exists (comp (lift (comp s' t')) u');Split.
(* ||(sot)ou SL*B||SL* ||(s'ot')ou' *) 
Apply betapar_slbpsl;Apply comp_bpar.
Apply lift_bpar;Apply comp_bpar;Assumption.
Assumption.
(* ||s'o(||t'ou') SL* ||(s'ot')ou' *) 
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_lift2;Apply reg1_lift2.
Save commut_lift2.

Goal (b:bool)(x,y:(TS b))(reg_liftenv b x y)->(diag1 b x y).
Induction 1;Red;Intros a s t z H0.
Pattern z;Apply case_bcomp with (lift s) (cons a t).
2:Assumption.
Intros x' y' H1 H2;Pattern x';Apply case_blift with s.
2:Assumption.
Intros s' H3;Pattern y';Apply case_bcons with a t.
2:Assumption.
Intros a' t' H4 H5;Exists (cons a' (comp s' t'));Split.
(* a.(sot) SL*B||SL* a'.(s'ot') *)
Apply betapar_slbpsl;Apply cons_bpar;[Assumption|Apply comp_bpar;Assumption].
(* ||s'o(a'.t') SL* a'.(s'ot') *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_liftenv;Apply reg1_liftenv.
Save commut_liftenv.

Goal (b:bool)(x,y:(TS b))(reg_idl b x y)->(diag1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_bcomp with id s.
2:Assumption.
Intros x' s' H1 H2;Pattern x';Apply case_bid.
2:Assumption.
Exists s';Split.
(* s SL*B||SL* s' *)
Apply betapar_slbpsl;Assumption.
(* idos' SL* s' *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_idl;Apply reg1_idl.
Save commut_idl.

Goal (b:bool)(x,y:(TS b))(reg_idr b x y)->(diag1 b x y).
Induction 1;Red;Intros s z H0.
Pattern z;Apply case_bcomp with s id.
2:Assumption.
Intros s' x' H1 H2;Pattern x';Apply case_bid.
2:Assumption.
Exists s';Split.
(* s SL*B||SL* s' *)
Apply betapar_slbpsl;Assumption.
(* s'oid SL* s' *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_idr;Apply reg1_idr.
Save commut_idr.

Goal (b:bool)(x,y:(TS b))(reg_liftid b x y)->(diag1 b x y).
Induction 1;Red;Intros z H0.
Pattern z;Apply case_blift with id.
2:Assumption.
Intros x' H1;Pattern x';Apply case_bid.
2:Assumption.
Exists id;Split.
(* id SL*B||SL* id *)
Apply betapar_slbpsl;Apply id_bpar.
(* ||id SL* id *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_liftid;Apply reg1_liftid.
Save commut_liftid.

Goal (b:bool)(x,y:(TS b))(reg_id b x y)->(diag1 b x y).
Induction 1;Red;Intros a z H0.
Pattern z;Apply case_benv with a id.
2:Assumption.
Intros a' x' H1 H2;Pattern x';Apply case_bid.
2:Assumption.
Exists a';Split.
(* a SLB||SL* a' *)
Apply betapar_slbpsl;Assumption.
(* a'[id] SL* a' *)
Red;Apply star_step1.
Apply SL_one_regle;Apply regle_id;Apply reg1_id.
Save commut_id.
 
Goal (b:bool)(x,y:(TS b))(systemSL b x y)->(diag1 b x y).
Induction 1;Intros.
Apply commut_app;Assumption.
Apply commut_lambda;Assumption.
Apply commut_clos;Assumption.
Apply commut_varshift1;Assumption.
Apply commut_varshift2;Assumption.
Apply commut_fvarcons;Assumption.
Apply commut_fvarlift1;Assumption.
Apply commut_fvarlift2;Assumption.
Apply commut_rvarcons;Assumption.
Apply commut_rvarlift1;Assumption.
Apply commut_rvarlift2;Assumption.
Apply commut_assenv;Assumption.
Apply commut_mapenv;Assumption.
Apply commut_shiftcons;Assumption.
Apply commut_shiftlift1;Assumption.
Apply commut_shiftlift2;Assumption.
Apply commut_lift1;Assumption.
Apply commut_lift2;Assumption.
Apply commut_liftenv;Assumption.
Apply commut_idl;Assumption.
Apply commut_idr;Assumption.
Apply commut_liftid;Assumption.
Apply commut_id;Assumption.
Save commut_systemSL.

(* lemmes techniques *)

Goal (P:terms->Prop)(a:terms)
     ((a':terms)(relSLstar false a a')->(P (lambda a')))->
     (M,N:terms)(relSLstar false N M)-><terms>N=(lambda a)->(P M).
Intros P a H M N H0;Generalize a H;Elim H0.
Intros x a0 H1 H2;Rewrite H2;Apply (H1 a0);Red;Apply star_refl.
Intros x y z H1 H2 H3 a0 H4 H5;Generalize H1;Rewrite H5;Intro H6.
Cut <terms>y=y.
2:Trivial.
Pattern 2 y;Apply case_SLlambda with a0.
2:Assumption.
Intros a0' H7 H8;Apply (H3 a0').
Intros a' H9;Apply H4;Red;Apply star_trans1 with a0';Assumption.
Assumption.
Save case_SLstar_lambda'.

Goal (P:terms->Prop)(a:terms)
      ((a':terms)(relSLstar false a a')->(P (lambda a')))->
      (M:terms)(relSLstar false (lambda a) M)->(P M).
Intros;Apply case_SLstar_lambda' with a (lambda a);Auto.
Save case_SLstar_lambda.

Goal (P:terms->Prop)(a:terms)
     ((a':terms)(slstar_bp_slstar false a a')->(P (lambda a')))->
     (M:terms)(slstar_bp_slstar false (lambda a) M)->(P M).
Intros P a H M H0.
Elim (comp_case terms (relSLstar false) (comp_rel terms (beta_par false) 
              (relSLstar false)) (lambda a) M H0).
Intros x H1;Elim H1;Intros H2.
Pattern x;Apply case_SLstar_lambda with a.
2:Assumption.
Intros a' H3 H4.
Elim (comp_case terms (beta_par false) (relSLstar false) (lambda a') M H4).
Intros y H5;Elim H5;Intros H6.
Pattern y;Apply case_blambda with a'.
2:Assumption.
Intros a'' H7 H8.
Pattern M;Apply case_SLstar_lambda with a''.
2:Assumption.
Intros a_ H9;Apply H.
Red;Apply comp_2rel with a'.
Assumption.
Apply comp_2rel with a'';Assumption.
Save case_slbpsl_lambda.

Goal (a,a':terms)(diag1 false (lambda a) (lambda a'))->(diag1 false a a').
Red;Intros a a' H z H0.
Elim (H (lambda z)).
2:Apply lambda_bpar;Assumption.
Intros u1 H1;Elim H1;Intros H2 H3.
Cut <terms>u1=u1.
2:Trivial.
Pattern 1 u1;Apply case_SLstar_lambda with z.
2:Assumption.
Intros z' H4;Pattern u1;Apply case_slbpsl_lambda with a'.
2:Assumption.
Intros a'' H5 H6;Exists a'';Split.
Assumption.
Elim (proj_lambda z' a'' H6);Assumption.
Save diag1_lambda.

Theorem commut: (b:bool)(x,y:(TS b))(relSL b x y)->(diag1 b x y).
Goal.
Induction 1;Intros.
(* regles de reecriture *)
Apply commut_systemSL;Assumption.
(* contexte app droit *)
Red;Intros z H2;Generalize H0 H1.
Pattern z;Apply case_bapp with a b0.
3:Assumption.
 (* regle B||: app *)
Intros a'' b0'' H3 H4 H5 H6.
Elim (H6 a'' H3);Intros a_ H7;Elim H7;Intros H8 H9.
Exists (app a_ b0'');Split.
Apply slbpsl_context_app_l;Assumption.
Apply SLstar_context_app_l;Assumption.
 (* regle B||: beta *)
Intros a1 a1'' b0'' H3 H4 H5;Rewrite H3.
Intro H6;Pattern a';Apply case_SLlambda with a1.
2:Assumption.
Intros a1' H7 H8.
Elim (diag1_lambda a1 a1' H8 a1'' H4);Intros a_ H9;Elim H9;Intros H10 H11.
Exists (env a_ (cons b0'' id));Split.
Apply slbpsl_context_beta_l;Assumption.
Apply SLstar_context_env_t;Assumption.
(* contexte app gauche *)
Red;Intros z H2;Pattern z;Apply case_bapp with a b0.
3:Assumption.
 (* regle B||: app *)
Intros a'' b0'' H3 H4.
Elim (H1 b0'' H4);Intros b0_ H5;Elim H5;Intros H6 H7.
Exists (app a'' b0_);Split.
Apply slbpsl_context_app_r;Assumption.
Apply SLstar_context_app_r;Assumption.
 (* regle B||: beta *)
Intros a1 a1'' b0'' H3 H4 H5;Rewrite H3.
Elim (H1 b0'' H5);Intros b0_ H6;Elim H6;Intros H7 H8.
Exists (env a1'' (cons b0_ id));Split.
Apply slbpsl_context_beta_r;Assumption.
Apply SLstar_context_env_s;Apply SLstar_context_cons_t;Assumption.
(* contexte lambda *)
Red;Intros z H2.
Pattern z;Apply case_blambda with a.
2:Assumption.
Intros a'' H3.
Elim (H1 a'' H3);Intros a_ H4;Elim H4;Intros H5 H6.
Exists (lambda a_);Split.
Apply slbpsl_context_lambda;Assumption.
Apply SLstar_context_lambda;Assumption.
(* contexte env droit *)
Red;Intros z H2.
Pattern z;Apply case_benv with a s.
2:Assumption.
Intros a'' s'' H3 H4.
Elim (H1 a'' H3);Intros a_ H5;Elim H5;Intros H6 H7.
Exists (env a_ s'');Split.
Apply slbpsl_context_env_t;Assumption.
Apply SLstar_context_env_t;Assumption.
(* contexte env gauche *)
Red;Intros z H2.
Pattern z;Apply case_benv with a s.
2:Assumption.
Intros a'' s'' H3 H4.
Elim (H1 s'' H4);Intros s_ H5;Elim H5;Intros H6 H7.
Exists (env a'' s_);Split.
Apply slbpsl_context_env_s;Assumption.
Apply SLstar_context_env_s;Assumption.
(* contexte cons droit *)
Red;Intros z H2.
Pattern z;Apply case_bcons with a s.
2:Assumption.
Intros a'' s'' H3 H4.
Elim (H1 a'' H3);Intros a_ H5;Elim H5;Intros H6 H7.
Exists (cons a_ s'');Split.
Apply slbpsl_context_cons_t;Assumption.
Apply SLstar_context_cons_t;Assumption.
(* contexte cons gauche *)
Red;Intros z H2.
Pattern z;Apply case_bcons with a s.
2:Assumption.
Intros a'' s'' H3 H4.
Elim (H1 s'' H4);Intros s_ H5;Elim H5;Intros H6 H7.
Exists (cons a'' s_);Split.
Apply slbpsl_context_cons_s;Assumption.
Apply SLstar_context_cons_s;Assumption.
(* contexte comp droit *)
Red;Intros z H2.
Pattern z;Apply case_bcomp with s t.
2:Assumption.
Intros s'' t'' H3 H4.
Elim (H1 s'' H3);Intros s_ H5;Elim H5;Intros H6 H7.
Exists (comp s_ t'');Split.
Apply slbpsl_context_comp_l;Assumption.
Apply SLstar_context_comp_l;Assumption.
(* contexte comp gauche *)
Red;Intros z H2.
Pattern z;Apply case_bcomp with s t.
2:Assumption.
Intros s'' t'' H3 H4.
Elim (H1 t'' H4);Intros t_ H5;Elim H5;Intros H6 H7.
Exists (comp s'' t_);Split.
Apply slbpsl_context_comp_r;Assumption.
Apply SLstar_context_comp_r;Assumption.
(* contexte lift *)
Red;Intros z H2.
Pattern z;Apply case_blift with s.
2:Assumption.
Intros s'' H3.
Elim (H1 s'' H3);Intros s_ H4;Elim H4;Intros H5 H6.
Exists (lift s_);Split.
Apply slbpsl_context_lift;Assumption.
Apply SLstar_context_lift;Assumption.
Save.


(***************************************************)
(*    SL verifie le diagramme ci-dessus            *)
(***************************************************)

Theorem commutation: (b:bool)(x,y,z:(TS b))(relSL b x y)->(beta_par b x z)->
       <(TS b)>Ex([u:(TS b)](relSLstar b z u)/\(slstar_bp_slstar b y u)).
Goal.
Intros b x y z H H0;Apply Ex_PQ;Generalize z H0.
Change (diag1 b x y).
Apply commut;Assumption.
Save.


Provide commutation.
