
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


         (* relation bata_par: Beta|| *)
          
Require TS.

Inductive Definition beta_par: (b:bool)(TS b)->(TS b)->Prop
=  var_bpar: (n:nat)(beta_par false (var n)(var n))
 | id_bpar: (beta_par true id id)
 | shift_bpar: (beta_par true shift shift)
 | app_bpar: (M,N,M',N':terms)(beta_par false M M')->(beta_par false N N')->
                               (beta_par false (app M N) (app M' N'))
 | lambda_bpar: (M,M':terms)(beta_par false M M')->
                      (beta_par false (lambda M) (lambda M'))
 | env_bpar: (M,M':terms)(s,s':substitutions)(beta_par false M M')->
             (beta_par true s s')->(beta_par false (env M s) (env M' s'))
 | beta_bpar: (M,N,M',N':terms)(beta_par false M M')->(beta_par false N N')->
                (beta_par false (app (lambda M) N) (env M' (cons N' id)))
 | cons_bpar:(M,M':terms)(s,s':substitutions)(beta_par false M M')->
            (beta_par true s s')->(beta_par true (cons M s) (cons M' s')) 
 | lift_bpar: (s,s':substitutions)(beta_par true s s')->
                           (beta_par true (lift s) (lift s'))
 | comp_bpar: (s,s',t,t':substitutions)(beta_par true s s')->
       (beta_par true t t')->(beta_par true (comp s t) (comp s' t'))
 | metaX_bpar: (n:nat)(beta_par false (meta_X n)(meta_X n))
 | metax_bpar: (n:nat)(beta_par true (meta_x n)(meta_x n)).

Goal (b:bool)(M:(TS b))(beta_par b M M).
Induction M;Intros.
(* var *)
Apply var_bpar.
(* app *)
Apply app_bpar;Assumption.
(* lam *)
Apply lambda_bpar;Assumption.
(* env *) 
Apply env_bpar;Assumption.
(* id  *)
Apply id_bpar.
(*  |  *)
Apply shift_bpar.
(*  .  *) 
Apply cons_bpar;Assumption.
(*  o  *) 
Apply comp_bpar;Assumption.
(* ||  *)
Apply lift_bpar;Assumption.
(*  X  *)
Apply metaX_bpar.
(*  x  *)
Apply metax_bpar. 
Save refl_betapar.

Definition betapar_inv=[b:bool][M:(TS b)][N:(TS b)]
(<[b:bool]Prop>Match M with 
 (* var *) [n:nat] (<[b:bool]Prop>Match N with 
                   (* var *) [m:nat]<nat>n=m
                   (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
                   (* lam *) [N1:terms][P1:Prop]False
                   (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
                   (* id  *) False
                   (*  |  *) False
                   (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False       
                   (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]False
                   (*  || *) [N1:substitutions][P1:Prop]False
                   (*  X  *) [n:nat]False
                   (*  x  *) [n:nat]False)
 (* app *) [M1:terms][P1:Prop][M2:terms][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]
                       (beta_par false M1 N1)/\(beta_par false M2 N2)                     
            (* lam *) [N1:terms][P1:Prop]False                               
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                      <terms>Ex([M3:terms] <terms>Ex([N3:terms]
                             <terms>M1=(lambda M3)/\(beta_par false M3 N1)/\
                             <substitutions>N2=(cons N3 id)/\(beta_par false M2 N3))) 
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions]
                      [P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
 (* lam *) [M1:terms][P1:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop](beta_par false M1 N1)
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
 (* env *) [M1:terms][P1:Prop][M2:substitutions][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False 
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                      (beta_par false M1 N1)/\(beta_par true M2 N2)
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
 (* id  *) (<[b:bool]Prop>Match N with 
           (* var *) [n:nat]False
           (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
           (* lam *) [N1:terms][P1:Prop]False
           (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
           (* id  *) True
           (*  |  *) False
           (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
           (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]False
           (*  || *) [N1:substitutions][P1:Prop]False
           (*  X  *) [n:nat]False
           (*  x  *) [n:nat]False)
 (*  |  *) (<[b:bool]Prop>Match N with 
           (* var *) [n:nat]False
           (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
           (* lam *) [N1:terms][P1:Prop]False
           (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
           (* id  *) False
           (*  |  *) True 
           (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
           (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]False
           (*  || *) [N1:substitutions][P1:Prop]False
           (*  X  *) [n:nat]False
           (*  x  *) [n:nat]False)          
 (*  .  *) [M1:terms][P1:Prop][M2:substitutions][P2:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False 
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]
                      (beta_par false M1 N1)/\(beta_par true M2 N2)   
            (*  o  *) [N1:substitutions][P1:Prop]
                      [N2:substitutions][P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
 (*  o  *) [M1:substitutions][P1:Prop][M2:substitutions][P2:Prop]  
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions]
                      [P2:Prop](beta_par true M1 N1)/\
                               (beta_par true M2 N2)
            (* ||  *) [N1:substitutions][P1:Prop]False
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False) 
 (* ||  *) [M1:substitutions][P1:Prop]
           (<[b:bool]Prop>Match N with 
            (* var *) [n:nat]False
            (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
            (* lam *) [N1:terms][P1:Prop]False
            (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (* id  *) False
            (*  |  *) False
            (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
            (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions]
                      [P2:Prop]False
            (* ||  *) [N1:substitutions][P1:Prop](beta_par true M1 N1)
            (*  X  *) [n:nat]False
            (*  x  *) [n:nat]False)
 (*  X  *) [n:nat] (<[b:bool]Prop>Match N with 
                   (* var *) [n:nat]False
                   (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
                   (* lam *) [N1:terms][P1:Prop]False
                   (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
                   (* id  *) False
                   (*  |  *) False
                   (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
                   (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]False
                   (*  || *) [N1:substitutions][P1:Prop]False
                   (*  X  *) [m:nat]<nat>n=m
                   (*  x  *) [m:nat]False)
 (*  x  *) [n:nat] (<[b:bool]Prop>Match N with 
                   (* var *) [n:nat]False
                   (* app *) [N1:terms][P1:Prop][N2:terms][P2:Prop]False 
                   (* lam *) [N1:terms][P1:Prop]False
                   (* env *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
                   (* id  *) False
                   (*  |  *) False
                   (*  .  *) [N1:terms][P1:Prop][N2:substitutions][P2:Prop]False
                   (*  o  *) [N1:substitutions][P1:Prop][N2:substitutions][P2:Prop]False
                   (*  || *) [N1:substitutions][P1:Prop]False
                   (*  X  *) [m:nat]False
                   (*  x  *) [m:nat]<nat>n=m)).

Goal (b:bool)(M,N:(TS b))(beta_par b M N)->(betapar_inv b M N).
Induction 1;Intros;Simpl.
(* var *)Trivial.
(* id  *)Trivial.
(*  |  *)Trivial.
(* app *)Split;Assumption.
(* lam *)Assumption.         
(* env *)Split;Assumption.
(* beta *)Exists M0;Exists N';(* Auto *)
Apply conj;[Apply refl_equal|Apply conj;
[Assumption|Apply conj;[Apply refl_equal|Assumption]]].
(*  . *)Split;Assumption.
(* || *)Assumption.
(* o  *)Split;Assumption.
(* X *)Trivial.
(* x *)Trivial.
Save lemma1_inv_betapar.

Goal (P:terms->Prop)(n:nat)
     (P (var n))->
     (M:terms)(beta_par false (var n) M)->(P M).
Intros P n H M H0;Cut (betapar_inv false (var n) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1;Assumption.
(* app *)
Induction 3.
(* lam *)
Induction 2.
(* env *)
Induction 2.
(* X *)Induction 1.
Save case_bvar.

Goal (P:terms->Prop)(a,b:terms)
     ((a',b':terms)(beta_par false a a')->(beta_par false b b')->(P (app a' b')))->
     ((a1,a1',b':terms)<terms>a=(lambda a1)->(beta_par false a1 a1')->
         (beta_par false b b')->(P (env a1' (cons b' id))))->
     (M:terms)(beta_par false (app a b) M)->(P M).
Intros P a b H H0 M H1;Cut (betapar_inv false (app a b) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Unfold 3 betapar_inv;Intros a' b' H2 H3 H4.
Elim H4;Intros H5 H6.
Apply H;Assumption.
(* lam *)
Induction 2.
(* env *)
Unfold 2 betapar_inv;Intros a1' H2 s H3.
Elim H3;Intros a1 H4;Elim H4;Intros b' H5.
Elim H5;Intros H6 H7;Elim H7;Intros H8 H9;Elim H9;Intros H10 H11.
Rewrite H6;Rewrite H10;Apply (H0 a1);Assumption.
(* X *)Induction 1.
Save case_bapp.

Goal (P:terms->Prop)(a:terms)
     ((a':terms)(beta_par false a a')->(P (lambda a')))->
     (M:terms)(beta_par false (lambda a) M)->(P M).
Intros P a H M H0;Cut (betapar_inv false (lambda a) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Induction 3.
(* lam *)
Unfold 2 betapar_inv;Intros a' H1 H2.
Apply H;Assumption.
(* env *)
Induction 2.
(* X *)Induction 1.
Save case_blambda.

Goal (P:terms->Prop)(a:terms)(s:substitutions)
     ((a':terms)(s':substitutions)(beta_par false a a')->(beta_par true s s')->
                  (P (env a' s')))->
     (M:terms)(beta_par false (env a s) M)->(P M).
Intros P a s H M H0;Cut (betapar_inv false (env a s) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Induction 3.
(* lam *)
Induction 2.
(* env *)
Unfold 2 betapar_inv;Intros a' H1  s' H2.
Elim H2;Intros;Apply H;Assumption.
(* X *)Induction 1.
Save case_benv.

Goal(P:substitutions->Prop)(P id)-> 
    (M:substitutions)(beta_par true id M)->(P M).
Intros P H M H0;Cut (betapar_inv true id M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
Intro;Assumption.
(* |  *)
Induction 1.
(* .  *)
Induction 2.
(*  o *)
Induction 3.
(* || *)
Induction 2.
(* x *)Induction 1.
Save case_bid.

Goal(P:substitutions->Prop)(P shift)-> 
    (M:substitutions)(beta_par true shift M)->(P M).
Intros P H M H0;Cut (betapar_inv true shift M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
Induction 1.
(* |  *)
Intro;Assumption.
(* .  *)
Induction 2.
(*  o *)
Induction 3.
(* || *)
Induction 2.
(* x *)Induction 1.
Save case_bshift.

Goal (P:substitutions->Prop)(a:terms)(s:substitutions)
     ((a':terms)(s':substitutions)(beta_par false a a')->(beta_par true s s')->
                  (P (cons a' s')))->
     (M:substitutions)(beta_par true (cons a s) M)->(P M).
Intros P a s H M H0;Cut (betapar_inv true (cons a s) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id  *)
Induction 1.
(*  |  *)
Induction 1.
(*  .  *)
Unfold 2 betapar_inv;Intros s' H1 a' H2.
Elim H2;Intros.
Apply H;Assumption.
(*  o  *)
Induction 3.
(*  || *)
Induction 2.
(* x *)Induction 1.
Save case_bcons.

Goal (P:substitutions->Prop)(s,t:substitutions)
     ((s',t':substitutions)(beta_par true s s')->(beta_par true t t')->
                  (P (comp s' t')))->
     (M:substitutions)(beta_par true (comp s t) M)->(P M).
Intros P s t H M H0;Cut (betapar_inv true (comp s t) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id  *)
Induction 1.
(*  |  *)
Induction 1.
(*  .  *)
Induction 2.
(*  o  *)
Unfold 3 betapar_inv.
Intros s' t' H1 H2 H3;Elim H3;Intros;Apply H;Assumption.
(*  || *)
Induction 2.
(* x *)Induction 1.
Save case_bcomp.

Goal (P:substitutions->Prop)(s:substitutions)
     ((s':substitutions)(beta_par true s s')->(P (lift s')))->
     (M:substitutions)(beta_par true (lift s) M)->(P M).
Intros P s H M H0;Cut (betapar_inv true (lift s) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id  *)
Induction 1.
(*  |  *)
Induction 1.
(*  .  *)
Induction 2.
(*  o  *)
Induction 3.
(*  || *)
Unfold 2 betapar_inv.
Intros s' H1 H2;Apply H;Assumption.
(* x *)Induction 1.
Save case_blift.

Goal (P:terms->Prop)(n:nat)
     (P (meta_X n))->
     (M:terms)(beta_par false (meta_X n) M)->(P M).
Intros P n H M H0;Cut (betapar_inv false (meta_X n) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply terms_ind.
(* var *)
Induction 1.
(* app *)
Induction 3.
(* lam *)
Induction 2.
(* env *)
Induction 2.
(* X *)Induction 1;Assumption.
Save case_bmetaX.

Goal(P:substitutions->Prop)(n:nat)
    (P (meta_x n))-> 
    (M:substitutions)(beta_par true (meta_x n) M)->(P M).
Intros P n H M H0;Cut (betapar_inv true (meta_x n) M).
2:Apply lemma1_inv_betapar;Assumption.
Pattern M;Apply substitutions_ind.
(* id *)
Induction 1.
(* |  *)
Induction 1.
(* .  *)
Induction 2.
(*  o *)
Induction 3.
(* || *)
Induction 2.
(* x *)Induction 1;Assumption.
Save case_bmetax.


Provide betapar.



