
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


         (* Theoreme utilise pour la preuve de
            confluence du lambda-sigma-lift-calcul *)

Require sur_les_relations.

Section Yokouchi.
 Variable A: Set.
 Variable R,S: A->A->Prop.
 Hypothesis C: (confluence A R).
 Hypothesis N: (noetherian A R).
 Hypothesis SC: (strong_confluence A S).
 Definition Rstar_S_Rstar (comp_rel A (star A R)(comp_rel A S (star A R))).
 Hypothesis commut1: (f,g,h:A)(R f h)->(S f g)->
                              <A>Ex([k:A](star A R g k)/\(Rstar_S_Rstar h k)).


   Goal (f,g,h:A)(star A R f g)->(Rstar_S_Rstar g h)->(Rstar_S_Rstar f h).
   Intros f g h H1 H2.
   Elim (comp_case A (star A R) (comp_rel A S (star A R)) g h H2).
   Intros f' H3;Elim H3;Intros H4 H5.
   Red;Apply comp_2rel with f'.
   Apply star_trans with g;Assumption.
   Assumption.
   Save comp_l.

   Goal (f,g,h:A)(Rstar_S_Rstar f g)->(star A R g h)->(Rstar_S_Rstar f h).
   Intros f g h H1 H2.
   Elim (comp_case A (star A R) (comp_rel A S (star A R)) f g H1).
   Intros f' H3;Elim H3;Intros H4 H5.
   Elim (comp_case A S (star A R) f' g H5).
   Intros f'' H6;Elim H6;Intros H7 H8.
   Red;Apply comp_2rel with f'.
   Assumption.
   Apply comp_2rel with f''.
   Assumption.
   Apply star_trans with g;Assumption.
   Save comp_r.

   Goal (f,g,h:A)(star A R f h)->(S f g)->
                              <A>Ex([k:A](star A R g k)/\(Rstar_S_Rstar h k)).
   Intro f;Pattern f;Apply (noetherian_induction A R N);
   Intros f0 H g h H1 H2.
   Elim (star_case A R f0 h H1);Intro H3.
   (* cas f0=h *)
   Exists g;Split. 
   Apply star_refl.
   Elim H3;Red;Apply comp_2rel with f0.
   Apply star_refl.
   Apply comp_2rel with g;[Assumption|Apply star_refl].
   (* cas f0 R f1 R* h *)
   Elim H3;Intros f1 H4;Elim H4;Intros H5 H6. 
   Cut <A>Ex([k:A](star A R g k)/\(Rstar_S_Rstar f1 k)).
   Intro H7;Elim H7;Intros g1 H8;Elim H8;Intros H9 H10.
   2:Apply commut1 with f0;Assumption.
   Cut <A>Ex([f2:A](star A R f1 f2)/\(comp_rel A S (star A R) f2 g1)).
   2:Apply comp_case;Assumption.
   Intro H11; Elim H11;Intros f2 H12;Elim H12;Intros H13 H14.
   Cut <A>Ex([f3:A](S f2 f3)/\(star A R f3 g1)).
   2:Apply comp_case;Assumption.
   Intro H15;Elim H15;Intros f3 H16;Elim H16;Intros H17 H18.
   Elim (C f1 h f2 H6 H13);Intros h1 H19;Elim H19;Intros H20 H21.
   Elim (H f2) with f3 h1.
   2:Apply comp_relplus;Apply comp_2rel with f1;Assumption.
   2:Assumption.
   2:Assumption.
   Intros h2 H22;Elim H22;Intros H23 H24.
   Elim (C f3 h2 g1 H23 H18);Intros k H25;Elim H25;Intros H26 H27.
   Exists k;Split.
   Apply star_trans with g1;Assumption.
   Apply comp_l with h1.
   Assumption.
   Apply comp_r with h2;Assumption.
   Save commut.


   Theorem Yokouchi: (strong_confluence A Rstar_S_Rstar).
   Goal.
   Unfold strong_confluence;Intro f;Pattern f;Apply (noetherian_induction1 A R N).
   Intros f0 H;Unfold strong_confluence';Intros g h H1 H2.
   Cut <A>Ex([u:A] (star A R f0 u)/\(comp_rel A S (star A R) u h)).
   2:Apply comp_case;Assumption.
   Intro H3;Elim H3;Intros f1 H4;Elim H4;Intros H5 H6.
   Cut <A>Ex([u:A] (star A R f0 u)/\(comp_rel A S (star A R) u g)).
   2:Apply comp_case;Assumption.
   Intro H7;Elim H7;Intros g1 H8;Elim H8;Intros H9 H10.
   Elim (star_case A R f0 f1 H5);Intro H11.
   Elim (star_case A R f0 g1 H9);Intro H12.
   (* cas f0 SR* h et f0 SR* h *)
   Generalize H6;Elim H11;Intro H6'.
   Generalize H10;Elim H12;Intro H10'.
   Elim (comp_case A S (star A R) f0 h H6');Intros f2 H13.
   Elim H13;Intros H14 H15.
   Elim (comp_case A S (star A R) f0 g H10');Intros g2 H16.
   Elim H16;Intros H17 H18.
   Elim (SC f0 f2 g2 H14 H17);Intros k1 H19;Elim H19;Intros H20 H21.
   Elim (commut g2 k1 g H18 H21);Intros k2 H22;Elim H22;Intros H23 H24.
   Elim (commut f2 k1 h H15 H20);Intros h1 H25;Elim H25;Intros H26 H27.
   Elim (C k1 h1 k2 H26 H23);Intros k H28;Elim H28;Intros H29 H30.
   Exists k;Split.
   Apply comp_r with k2;Assumption.
   Apply comp_r with h1;Assumption.
   (* cas f0 R* g1 SR* g et f0 SR* h *)
   Elim H12;Intros g2 H13;Elim H13;Intros H14 H15.   
   Generalize H6;Elim H11;Intro H6'.
   Elim (comp_case A S (star A R) f0 h H6');Intros f2 H16.
   Elim H16;Intros H17 H18. 
   Elim (commut1 f0 f2 g2 H14 H17);Intros k1 H19;Elim H19;Intros H20 H21.
   Elim (C f2 h k1 H18 H20);Intros h1 H22;Elim H22;Intros H23 H24.
   Elim (H g2 H14 g h1).
   2:Red;Apply comp_2rel with g1;Assumption. 
   2:Apply comp_r with k1;Assumption.
   Intros k H25;Elim H25;Intros H26 H27.
   Exists k;Split.
   Assumption.
   Apply comp_l with h1;Assumption.
   (* cas f0 RR* f1 SR* h et f0 R*SR* g *)
   Elim H11;Intros f2 H12;Elim H12;Intros H13 H14. 
   Elim (C f0 f2 g1).
   2:Apply star_trans1 with f2.
   2:Assumption.
   2:Apply star_refl.
   2:Assumption.
   Intros k1 H15;Elim H15;Intros H16 H17.
   Elim (comp_case A S (star A R) g1 g H10);Intros g2 H18.
   Elim H18;Intros H19 H20.
   Elim (commut g1 g2 k1 H17 H19);Intros k2 H21;Elim H21;Intros H22 H23.
   Elim (C g2 k2 g H22 H20);Intros k3 H24;Elim H24;Intros H25 H26.
   Elim (H f2 H13 h k3).
   2:Red;Apply comp_2rel with f1;Assumption.
   2:Apply comp_l with k1.
   2:Assumption.
   2:Apply comp_r with k2;Assumption.
   Intros k H27;Elim H27;Intros H28 H29.
   Exists k;Split.
   Apply comp_l with k3;Assumption.
   Assumption.
   Save.

End Yokouchi.


Provide Yokouchi.
