
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


              (* Termes et Substitutions *)



Inductive Definition TS: bool->Set
=   var:nat->(TS false)
  | app:(TS false)->(TS false)->(TS false)
  | lambda:(TS false)->(TS false)
  | env:(TS false)->(TS true)->(TS false)
  | id:(TS true)
  | shift:(TS true)
  | cons:(TS false)->(TS true)->(TS true)
  | comp:(TS true)->(TS true)->(TS true)
  | lift:(TS true)->(TS true)
  | meta_X:nat->(TS false)
  | meta_x:nat->(TS true).

Definition terms (TS false).

Definition substitutions (TS true).
 
(* Principe d induction pour les terms *)
 
Goal (terms->Prop)->(b:bool)(TS b)->Prop.
Intros P b;Elim b.
Exact [x:(TS true)]True.
Exact P.
Save Pterms.

Lemma terms_ind: (P:terms->Prop)
                 ((n:nat)(P (var n)))->
                 ((a,b:terms)(P a)->(P b)->(P (app a b)))->
                 ((a:terms)(P a)->(P (lambda a)))->
                 ((a:terms)(P a)->(s:substitutions)(P (env a s)))->
                 ((n:nat)(P (meta_X n)))->
                 (a:terms)(P a).
Goal.
Intros;Change (Pterms P false a);Elim a;Simpl;Auto.
Save.

(* Principe d induction pour les substitutions *)

Goal (substitutions->Prop)->(b:bool)(TS b)->Prop.
Intros P b;Elim b.
Exact P.
Exact [x:(TS false)]True.
Save Psubst.

Lemma substitutions_ind: (P:substitutions->Prop)
                         (P id)->
                         (P shift)->
                         ((s:substitutions)(P s)->(a:terms)(P (cons a s)))->
                         ((s,t:substitutions)(P s)->(P t)->(P (comp s t)))->
                         ((s:substitutions)(P s)->(P (lift s)))->
                         ((n:nat)(P (meta_x n)))->
                         (s:substitutions)(P s).
Goal.
Intros;Change (Psubst P true s);Elim s;Simpl;Auto.
Save.

Provide TS.



