
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)

         
                   (* relation SL* o B|| o SL* *)


Require lambda_sigma_lift.
Require betapar.

Definition slstar_bp_slstar= [b:bool]
 (comp_rel (TS b) (relSLstar b) (comp_rel (TS b) (beta_par b) (relSLstar b))).

Goal (a,a',b,b':terms)(beta_par false b b')->(slstar_bp_slstar false a a')->
            (slstar_bp_slstar false (app a b) (app a' b')).
Induction 2;Intros.
Red;Apply comp_2rel with (app y b).
Apply SLstar_context_app_l;Assumption.
Elim H2;Intros.
Apply comp_2rel with (app y0 b').
Apply app_bpar;Assumption.
Apply SLstar_context_app_l;Assumption.
Save slbpsl_context_app_l.

Goal (a,a',b,b':terms)(beta_par false a a')->(slstar_bp_slstar false b b')->
            (slstar_bp_slstar false (app a b) (app a' b')).
Induction 2;Intros.
Red;Apply comp_2rel with (app a y).
Apply SLstar_context_app_r;Assumption.
Elim H2;Intros.
Apply comp_2rel with (app a' y0).
Apply app_bpar;Assumption.
Apply SLstar_context_app_r;Assumption.
Save slbpsl_context_app_r.

Goal (a,b,a',b':terms)(beta_par false b b')->(slstar_bp_slstar false a a')->
        (slstar_bp_slstar false (app (lambda a) b) (env a' (cons b' id))).
Induction 2;Intros.
Red;Apply comp_2rel with (app (lambda y) b).
Apply SLstar_context_app_l;Apply SLstar_context_lambda;Assumption.
Elim H2;Intros.
Apply comp_2rel with (env y0 (cons b' id)).
Apply beta_bpar;Assumption.
Apply SLstar_context_env_t;Assumption.
Save slbpsl_context_beta_l.

Goal (a,b,a',b':terms)(beta_par false a a')->(slstar_bp_slstar false b b')->
      (slstar_bp_slstar false (app (lambda a) b) (env a' (cons b' id))).
Induction 2;Intros.
Red;Apply comp_2rel with (app (lambda a) y).
Apply SLstar_context_app_r;Assumption.
Elim H2;Intros.
Apply comp_2rel with (env a' (cons y0 id)).
Apply beta_bpar;Assumption.
Apply SLstar_context_env_s;Apply SLstar_context_cons_t;Assumption.
Save slbpsl_context_beta_r.

Goal (a,a':terms)(slstar_bp_slstar false a a')->
               (slstar_bp_slstar false (lambda a) (lambda a')).
Induction 1;Intros.
Red;Apply comp_2rel with (lambda y).
Apply SLstar_context_lambda;Assumption.
Elim H1;Intros.
Apply comp_2rel with (lambda y0).
Apply lambda_bpar;Assumption.
Apply SLstar_context_lambda;Assumption.
Save slbpsl_context_lambda .

Goal (a,a':terms)(s,s':substitutions)(beta_par true s s')->
   (slstar_bp_slstar false a a')->(slstar_bp_slstar false (env a s) (env a' s')).
Induction 2;Intros.
Red;Apply comp_2rel with (env y s).
Apply SLstar_context_env_t;Assumption.
Elim H2;Intros.
Apply comp_2rel with (env y0 s').
Apply env_bpar;Assumption.
Apply SLstar_context_env_t;Assumption.
Save slbpsl_context_env_t.

Goal (a,a':terms)(s,s':substitutions)(beta_par false a a')->
   (slstar_bp_slstar true s s')->(slstar_bp_slstar false (env a s) (env a' s')).
Induction 2;Intros.
Red;Apply comp_2rel with (env a y).
Apply SLstar_context_env_s;Assumption.
Elim H2;Intros.
Apply comp_2rel with (env a' y0).
Apply env_bpar;Assumption.
Apply SLstar_context_env_s;Assumption.
Save slbpsl_context_env_s.

Goal (a,a':terms)(s,s':substitutions)(beta_par true s s')->
   (slstar_bp_slstar false a a')->(slstar_bp_slstar true (cons a s) (cons a' s')).
Induction 2;Intros.
Red;Apply comp_2rel with (cons y s).
Apply SLstar_context_cons_t;Assumption.
Elim H2;Intros.
Apply comp_2rel with (cons y0 s').
Apply cons_bpar;Assumption.
Apply SLstar_context_cons_t;Assumption.
Save slbpsl_context_cons_t.

Goal (a,a':terms)(s,s':substitutions)(beta_par false a a')->
   (slstar_bp_slstar true s s')->(slstar_bp_slstar true (cons a s) (cons a' s')).
Induction 2;Intros.
Red;Apply comp_2rel with (cons a y).
Apply SLstar_context_cons_s;Assumption.
Elim H2;Intros.
Apply comp_2rel with (cons a' y0).
Apply cons_bpar;Assumption.
Apply SLstar_context_cons_s;Assumption.
Save slbpsl_context_cons_s.

Goal (s,s',t,t':substitutions)(beta_par true t t')->
   (slstar_bp_slstar true s s')->(slstar_bp_slstar true (comp s t) (comp s' t')).
Induction 2;Intros.
Red;Apply comp_2rel with (comp y t).
Apply SLstar_context_comp_l;Assumption.
Elim H2;Intros.
Apply comp_2rel with (comp y0 t').
Apply comp_bpar;Assumption.
Apply SLstar_context_comp_l;Assumption.
Save slbpsl_context_comp_l.

Goal (s,s',t,t':substitutions)(beta_par true s s')->
   (slstar_bp_slstar true t t')->(slstar_bp_slstar true (comp s t) (comp s' t')).
Induction 2;Intros.
Red;Apply comp_2rel with (comp s y).
Apply SLstar_context_comp_r;Assumption.
Elim H2;Intros.
Apply comp_2rel with (comp s' y0).
Apply comp_bpar;Assumption.
Apply SLstar_context_comp_r;Assumption.
Save slbpsl_context_comp_r.

Goal (s,s':substitutions)(slstar_bp_slstar true s s')->
               (slstar_bp_slstar true (lift s) (lift s')).
Induction 1;Intros.
Red;Apply comp_2rel with (lift y).
Apply SLstar_context_lift;Assumption.
Elim H1;Intros.
Apply comp_2rel with (lift y0).
Apply lift_bpar;Assumption.
Apply SLstar_context_lift;Assumption.
Save slbpsl_context_lift.

Goal (b:bool)(M,N:(TS b))(beta_par b M N)->(slstar_bp_slstar b M N).
Intros;Red;Apply comp_2rel with M.
Red;Apply star_refl.
Apply comp_2rel with N.
Assumption.
Red;Apply star_refl.
Save betapar_slbpsl.

Goal (b:bool)(M:(TS b))(slstar_bp_slstar b M M).
Intros;Apply betapar_slbpsl;Apply refl_betapar.
Save refl_slbpsl.

(* LSL inclus dans SL*B||SL* *)

Goal (b:bool)(inclus (TS b) (relLSL b) (slstar_bp_slstar b)).
Red;Induction 1.
(* systemLSL *)
Induction 1.
 (* regle beta *)
Induction 1;Intros a b1;Apply betapar_slbpsl;Apply beta_bpar;Apply refl_betapar.
 (* systemSL *)
Intros b1 M0 N0 H1;Red;Apply comp_2rel with N0.
Red;Apply star_step1;Apply SL_one_regle;Assumption.
Apply comp_2rel with N0;[Apply refl_betapar|Red;Apply star_refl].
(* contexte app gauche *)
Intros;Apply slbpsl_context_app_l;[Apply refl_betapar|Assumption].
(* contexte app droit *)
Intros;Apply slbpsl_context_app_r;[Apply refl_betapar|Assumption].
(* contexte lambda *)
Intros;Apply slbpsl_context_lambda;Assumption.
(* contexte env gauche *)
Intros;Apply slbpsl_context_env_t;[Apply refl_betapar|Assumption].
(* contexte env droit *)
Intros;Apply slbpsl_context_env_s;[Apply refl_betapar|Assumption].
(* contexte cons gauche *)
Intros;Apply slbpsl_context_cons_t;[Apply refl_betapar|Assumption].
(* contexte cons droit *)
Intros;Apply slbpsl_context_cons_s;[Apply refl_betapar|Assumption].
(* contexte comp gauche *)
Intros;Apply slbpsl_context_comp_l;[Apply refl_betapar|Assumption].
(* contexte comp droit *)
Intros;Apply slbpsl_context_comp_r;[Apply refl_betapar|Assumption].
(* contexte lift *)
Intros;Apply slbpsl_context_lift;Assumption.
Save relLSL_inclus_slbpsl.

(* SL*B||SL* inclus dans LSL* *)

Goal (b:bool)(inclus (TS b) (beta_par b) (relLSLstar b)).
Red;Induction 1;Intros.
(* var_bpar *)
Red;Apply star_refl.
(* id_bpar *)
Red;Apply star_refl.
(* shhift_bpar *)
Red;Apply star_refl.
(* app_bpar *)
Apply LSLstar_context_app;Assumption.
(* lambda_bpar *)
Apply LSLstar_context_lambda;Assumption.
(* env_bpar *)
Apply LSLstar_context_env;Assumption.
(* beta_bpar *)
Red;Apply star_trans1 with (env M (cons N id)).
Apply LSL_one_regle;Apply beta1;Apply reg1_beta.
Change (relLSLstar false (env M (cons N id)) (env M' (cons N' id))).
Apply LSLstar_context_env.
Assumption.
Apply LSLstar_context_cons;[Assumption|Red;Apply star_refl].
(* cons_bpar *)
Apply LSLstar_context_cons;Assumption.
(* lift_bpar *)
Apply LSLstar_context_lift;Assumption.
(* comp_bpar *)
Apply LSLstar_context_comp;Assumption.
(* metaX_bpar *)
Red;Apply star_refl.
(* metax_bpar *)
Red;Apply star_refl.
Save betapar_inclus_relSLstar.

Goal (b:bool)(inclus (TS b) (relSL  b) (relLSL b)).
Red;Induction 1;Intros.
Apply LSL_one_regle;Apply SL1;Assumption.
Apply LSL_context_app_l;Assumption.
Apply LSL_context_app_r;Assumption.
Apply LSL_context_lambda;Assumption.
Apply LSL_context_env_t;Assumption.
Apply LSL_context_env_s;Assumption.
Apply LSL_context_cons_t;Assumption.
Apply LSL_context_cons_s;Assumption.
Apply LSL_context_comp_l;Assumption.
Apply LSL_context_comp_r;Assumption.
Apply LSL_context_lift;Assumption.
Save relSL_inclus_relLSL.

Goal (b:bool)(inclus (TS b) (slstar_bp_slstar b) (relLSLstar b)).
Unfold slstar_bp_slstar;Intro b.
Apply inclus_comp.
(* SL* incl LSL* *)
Change (inclus (TS b) (star (TS b) (relSL b)) (star (TS b) (relLSL b))).
Apply inclus_reg_star;Apply relSL_inclus_relLSL.
Apply inclus_comp.
(* B|| incl LSL* *)
Apply betapar_inclus_relSLstar.
(* SL* incl LSL* *)
Change (inclus (TS b) (star (TS b) (relSL b)) (star (TS b) (relLSL b))).
Apply inclus_reg_star;Apply relSL_inclus_relLSL.
Intros;Red;Apply star_trans with y;Assumption.
Intros;Red;Apply star_trans with y;Assumption.
Save slbpsl_inclus_relLSLstar.


Provide SLstar_bpar_SLstar.

