
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


           (* Preuve de terminaison: polynome P2 *)
 
Require sigma_lift.
Require comparith.

Definition P2: (b:bool)(TS b)->nat= 
[b:bool][U:(TS b)](<[b:bool]nat>Match U with
      (* var *) [n:nat](S O)
      (* app *) [a:terms][P2a:nat][b:terms][P2b:nat](S (plus P2a P2b))
      (* lam *) [a:terms][P2a:nat](mult (S(S O)) P2a)
      (* env *) [a:terms][P2a:nat][s:substitutions][P2s:nat](mult P2a (S P2s))
      (*  id *) (S O)
      (*  |  *) (S O)
      (*  .  *) [a:terms][P2a:nat][s:substitutions][P2s:nat](S (plus P2a P2s))
      (*  o  *) [s:substitutions][P2s:nat][t:substitutions][P2t:nat]
                (mult P2s (S P2t))
      (*  || *) [s:substitutions][P2s:nat](mult (S(S(S(S O)))) P2s)
      (*  X  *) [n:nat](S O)
      (*  x  *) [n:nat](S O)   ).


Goal (b:bool)(M:(TS b))(gt (P2 b M) O).
Induction M;Simpl;Intros.
(* Auto *)Apply gt_Sn_n.
(* Auto *)Apply gt_Sn_O.
Elim plus_n_O;(* Auto *)Apply gt_plus_trans_r;Assumption.
(* Auto *)Apply gt_S_r;Apply gt_mult_trans_r;[Assumption|Apply le_gt_S;Assumption].
(* Auto *)Apply gt_Sn_n.
(* Auto *)Apply gt_Sn_n.
(* Auto *)Apply gt_Sn_O.
(* Auto *)Apply gt_S_r;Apply gt_mult_trans_r;[Assumption|Apply le_gt_S;Assumption].
(* Auto *)Apply gt_plus_trans_r;Assumption.
(* Auto *)Apply gt_Sn_n.
(* Auto *)Apply gt_Sn_n.
Save P2_pos.
Hint P2_pos.

Goal (b:bool)(M,N:(TS b))(reg_app b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Elim mult_plus_distr;Apply gt_n_S.
(* Auto *)Apply gt_plus_l;Apply P2_pos.
Save P2_app.

Goal (b:bool)(M,N:(TS b))(reg_lambda b M N)->(lt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (S(S O)) (mult (P2 false a) (S (mult (S(S(S(S O)))) (P2 true s)))))
           (mult (mult (S(S O)) (P2 false a)) (S (P2 true s)))).
Elim mult_assoc_r;Apply gt_mult_reg_l.
(* Auto *)Apply gt_S_r;Apply gt_mult_trans_l;[Apply P2_pos|Apply gt_Sn_n].
(* Auto *)Apply gt_n_S;Apply gt_mult_l;
[Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n|Apply P2_pos].
Save P2_lambda.

Goal (b:bool)(M,N:(TS b))(reg_clos b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl.
Elim mult_assoc_l;Apply gt_mult_reg_l.
Apply P2_pos.
Simpl;(* Auto *)Apply le_gt_S;Apply gt_le_S;Apply gt_plus_l;Apply P2_pos.
Save P2_clos.

Goal (b:bool)(M,N:(TS b))(reg_varshift1 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Simpl;(* Auto *)Intro;Apply gt_Sn_n.
Save P2_varshift1.

Goal (b:bool)(M,N:(TS b))(reg_varshift2 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Repeat (Elim plus_n_O);(* Auto *)Apply gt_Sn_n.
Save P2_varshift2.

Goal (b:bool)(M,N:(TS b))(reg_fvarcons b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Elim plus_n_O.
(*Auto *)Apply gt_S_r;Apply gt_S_l;Apply gt_n_S;Apply gt_plus_r;Apply P2_pos.
Save P2_fvarcons.

Goal (b:bool)(M,N:(TS b))(reg_fvarlift1 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (S O) (S (mult (S(S(S(S O)))) (P2 true s)))) (S O)).
Apply gt_mult_r.
Apply gt_n_S;Apply gt_mult_trans_r;(* Auto *)[Apply gt_Sn_O|Apply P2_pos].
Apply gt_Sn_n.
Save P2_fvarlift1.

Goal (b:bool)(M,N:(TS b))(reg_fvarlift2 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Repeat (Elim plus_n_O).
Apply gt_n_S;Apply gt_mult_trans_r;
[Apply gt_plus_trans_r;Apply P2_pos|Apply gt_Sn_n].
Save P2_fvarlift2.

Goal (b:bool)(M,N:(TS b))(reg_rvarcons b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Repeat (Elim plus_n_O).
(* Auto *)Apply gt_S_l;Apply gt_n_S;Apply gt_plus_l;Apply P2_pos.
Save P2_rvarcons.

Goal (b:bool)(M,N:(TS b))(reg_rvarlift1 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Repeat (Elim plus_n_O).
Elim mult_n_2;Apply gt_n_S;Apply gt_plus_trans_l;Apply gt_plus_l;Apply P2_pos.
Save P2_rvarlift1.

Goal (b:bool)(M,N:(TS b))(reg_rvarlift2 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (S O) (S (mult (mult (S(S(S(S O)))) (P2 true s))
            (S (P2 true t)))))
(mult (S O) (S (mult (P2 true s) (S (mult (S O) (S (P2 true t)))))))).
Unfold 1 mult;Unfold 3 mult;Unfold 4 mult;Repeat (Elim plus_n_O).
Apply gt_n_S;Repeat (Elim mult_n_Sm);Elim plus_assoc_l.
Apply gt_plus_plus.
Elim mult_assoc_l;Apply gt_mult_l;
(* Auto *)[Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n|
Apply gt_mult_trans_l;Apply P2_pos].
Elim mult_n_2;Elim mult_sym;Apply gt_mult_reg_r.
Apply P2_pos.
Apply gt_S_r;Apply gt_Sn_n.
Save P2_rvarlift2.

Goal (b:bool)(M,N:(TS b))(reg_assenv b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl.
Rewrite mult_assoc_r;Apply gt_mult_reg_l.
Apply P2_pos.
Simpl;(* Auto *)Apply le_gt_S;Apply gt_le_S;Apply gt_plus_l;Apply P2_pos.
Save P2_assenv.

Goal (b:bool)(M,N:(TS b))(reg_mapenv b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Elim mult_plus_distr.
Apply gt_n_S;Apply gt_plus_l;Apply P2_pos.
Save P2_mapenv.

Goal (b:bool)(M,N:(TS b))(reg_shiftcons b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl;Elim plus_n_O.
(* Auto *)Apply gt_S_r;Apply gt_S_l;Apply gt_n_S;Apply gt_plus_l;Apply P2_pos.
Save P2_shiftcons.

Goal (b:bool)(M,N:(TS b))(reg_shiftlift1 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (S O) (S (mult (S(S(S(S O)))) (P2 true s))))
           (mult (P2 true s) (S(S O)))).
Unfold 1 mult;Elim plus_n_O.
Apply gt_S_l;Elim mult_sym;Apply gt_mult_reg_r.
Apply P2_pos.
Apply gt_S_r;Apply gt_Sn_n.
Save P2_shiftlift1.

Goal (b:bool)(M,N:(TS b))(reg_shiftlift2 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (S O) (S (mult (mult (S(S(S(S O)))) (P2 true s)) 
        (S (P2 true t))))) 
       (mult (P2 true s) (S (mult (S O) (S (P2 true t)))))).
Unfold 1 mult;Elim plus_n_O;Unfold 4 mult;Elim plus_n_O.
Apply gt_S_l;Repeat (Elim mult_n_Sm);Elim plus_assoc_l.
Apply gt_plus_plus.
Elim mult_assoc_l;Apply gt_mult_l;(* Auto *)[Apply gt_S_r;Apply gt_S_r;
Apply gt_Sn_n|Apply gt_mult_trans_l;Apply P2_pos].
Elim mult_n_2;Elim mult_sym;Apply gt_mult_reg_r.
Apply P2_pos.
Apply gt_S_r;Apply gt_Sn_n.
Save P2_shiftlift2.

Goal (b:bool)(M,N:(TS b))(reg_lift1 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (mult (S(S(S(S O)))) (P2 true s)) 
           (S (mult (S(S(S(S O)))) (P2 true t))))
           (mult (S(S(S(S O)))) (mult (P2 true s)(S (P2 true t))))).
Elim mult_assoc_r;Apply gt_mult_reg_l.
Apply gt_mult_trans_r;[Apply gt_Sn_O|Apply P2_pos].
Apply gt_n_S;Apply gt_mult_l;
(* Auto *)[Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n|Apply P2_pos].
Save P2_lift1.

Goal (b:bool)(M,N:(TS b))(reg_lift2 b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (mult (S(S(S(S O)))) (P2 true s)) 
   (S (mult (mult (S(S(S(S O)))) (P2 true t)) (S (P2 true u)))))
       (mult (mult (S(S(S(S O)))) (mult (P2 true s) (S (P2 true t))))
         (S (P2 true u)))).
Elim mult_assoc_r;Elim mult_assoc_l;Apply gt_mult_reg_l.
(* Auto *)Apply gt_S_r;Apply gt_S_r;Apply gt_S_r;Apply gt_mult_trans_l;
[Apply P2_pos|Apply gt_Sn_n].
Apply gt_S_l;Apply gt_mult_reg_r.
Apply gt_Sn_O.
Apply gt_trans with (mult (S(S(S O))) (P2 true t)).
(* Auto *)Apply gt_mult_reg_r;[Apply P2_pos|Apply gt_Sn_n].
Simpl;Elim plus_n_O;Rewrite S_plus;Apply gt_reg_l.
Elim mult_n_2;(* Auto *)Apply gt_mult_trans_r;[Apply P2_pos|Apply gt_Sn_n].
Save P2_lift2.

Goal (b:bool)(M,N:(TS b))(reg_liftenv b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros.
Change (gt (mult (mult (S(S(S(S O)))) (P2 true s)) 
            (S(S (plus (P2 false a) (P2 true t)))))
           (S (plus (P2 false a) (mult (P2 true s) (S (P2 true t)))))).
Replace (S (S (plus (P2 false a) (P2 true t)))) 
  with (plus (P2 false a) (plus (P2 true t) (S(S O)))).
Rewrite S_plus;Rewrite mult_plus_distr_r.
Elim plus_assoc_l;Apply gt_plus_plus.
Apply gt_mult_l.
(* Auto *)Apply gt_S_r;Apply gt_S_r;Apply gt_mult_trans_l;
[Apply P2_pos|Apply gt_Sn_n].
Apply P2_pos.
Replace (plus (P2 true t) (S (S O))) 
  with (plus (plus (P2 true t) (S O)) (S O)).
Rewrite mult_plus_distr_r;Apply gt_plus_plus.
Elim S_plus;Elim mult_assoc_l.
Apply gt_mult_l.
(* Auto *)Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n.
(* Auto *)Apply gt_S_r;Apply gt_mult_trans_r;
[Apply P2_pos|Apply le_gt_S;Apply gt_le_S;Apply P2_pos].
Apply gt_mult_l.
(* Auto *)Apply gt_mult_trans_l;[Apply P2_pos|
Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n].
(* Auto *)Apply gt_Sn_n.
(* Auto *)Elim plus_n_Sm;Apply sym_equal;Apply S_plus.
Rewrite plus_assoc_l;Elim plus_n_Sm;Elim plus_n_Sm;
Elim plus_n_O;Apply refl_equal.
Save P2_liftenv.

Goal (b:bool)(M,N:(TS b))(reg_idl b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Simpl;Intros;Elim plus_n_O;Apply gt_Sn_n.
Save P2_idl.

Goal (b:bool)(M,N:(TS b))(reg_idr b M N)->(gt (P2 b M) (P2 b N)). 
Induction 1;Intros;Simpl;Apply gt_mult_r;[Apply gt_Sn_n|Apply P2_pos].
Save P2_idr.

Goal (b:bool)(M,N:(TS b))(reg_liftid b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl.
(* Auto *)Apply gt_S_r;Apply gt_S_r;Apply gt_Sn_n.
Save P2_liftid.

Goal (b:bool)(M,N:(TS b))(reg_id b M N)->(gt (P2 b M) (P2 b N)).
Induction 1;Intros;Simpl.
(* Auto *)Apply gt_mult_r;[Apply gt_Sn_n|Apply P2_pos].
Save P2_id.


Provide Pol2.
