
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


       (* Preuve de terminaison: Polynome P1 *)

Require sigma_lift.  
Require comparith.

Definition P1: (b:bool)(TS b)->nat = 
[b:bool][U:(TS b)](<[b:bool]nat>Match U with
  (* var *) [n:nat] (power2 (S n))
  (* app *) [a:terms][P1a:nat][b:terms][P1b:nat](plus P1a P1b)
  (* lam *) [a:terms][P1a:nat](plus P1a (S(S O)))
  (* env *) [a:terms][P1a:nat][s:substitutions][P1s:nat](mult P1a P1s)
  (*  id *) (S (S O)) 
  (*  |  *) (S (S O))
  (*  .  *) [a:terms][P1a:nat][s:substitutions][P1s:nat](plus P1a P1s)
  (*  o  *) [s:substitutions][P1s:nat][t:substitutions][P1t:nat]
            (mult P1s P1t)
  (*  || *) [s:substitutions][P1s:nat]P1s
  (*  X  *) [n:nat](S(S O))
  (*  x  *) [n:nat](S(S O))   ). 

Goal (b:bool)(M:(TS b))(gt (P1 b M) (S O)).
Induction M;Intros;Simpl.
(* var *)
Elim plus_n_O;Elim n;Simpl.
(* Auto *)Apply gt_Sn_n.
Intros;Elim plus_n_O;(* Auto *)Apply gt_plus_trans_r;Assumption.
(* app *)
(* Auto *)Apply gt_plus_trans_r;Assumption.
(* lam *)
(* Auto *)Apply gt_plus_trans_r;Assumption.
(* env *)
(* Auto *)Apply gt_mult_trans_r;[Apply gt_S_r;Assumption|Assumption].
(*  id *)
(* Auto *)Apply gt_Sn_n.
(*  |  *)
(* Auto *)Apply gt_Sn_n.
(*  .  *)
(* Auto *)Apply gt_plus_trans_r;Assumption.
(*  o  *)
(* Auto *)Apply gt_mult_trans_r;[Apply gt_S_r;Assumption|Assumption].
(*  || *)
Assumption.
(* Auto *)Apply gt_Sn_n.
(* Auto *)Apply gt_Sn_n.
Save gt_P1_1.
Hint gt_P1_1.

Goal (b:bool)(M,N:(TS b))(reg_app b M N)-> <nat>(P1 b M)=(P1 b N). 
Induction 1;Intros;Simpl;Apply mult_plus_distr.
Save P1_app.

Goal (b:bool)(M,N:(TS b))(reg_lambda b M N)->(gt (P1 b M) (P1 b N)). 
Induction 1;Intros;Simpl.
Rewrite mult_plus_distr;(* Auto *)Apply gt_reg_l;Apply gt_mult_r;
[Apply gt_P1_1|Apply gt_Sn_O].
Save P1_lambda.

Goal (b:bool)(M,N:(TS b))(reg_clos b M N)-><nat>(P1 b M)=(P1 b N). 
Induction 1;Intros;Simpl;Apply mult_assoc_r.
Save P1_clos.

Goal (b:bool)(M,N:(TS b))(reg_varshift1 b M N)-><nat>(P1 b M)=(P1 b N). 
Induction 1;Intros.
Change <nat>(mult (power2 (S n)) (S(S O)))=(mult (S(S O)) (power2 (S n))).
Apply mult_sym.
Save P1_varshift1.

Goal (b:bool)(M,N:(TS b))(reg_varshift2 b M N)-><nat>(P1 b M)=(P1 b N). 
Induction 1;Intros.
Change <nat>(mult (power2 (S n)) (mult (S(S O)) (P1 true s)))=
            (mult (mult (S(S O)) (power2 (S n))) (P1 true s)).
Elim mult_permut;Apply mult_assoc_l.
Save P1_varshift2.

Goal (b:bool)(M,N:(TS b))(reg_fvarcons b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl;Elim plus_n_O.
(* Auto *)Apply gt_plus_trans_r;Apply gt_plus_r;Apply gt_S_r;Apply gt_P1_1.
Save P1_fvarcons.

Goal (b:bool)(M,N:(TS b))(reg_fvarlift1 b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros.
Change (gt (mult (S(S O)) (P1 true s)) (S(S O))).
(* Auto *)Apply gt_mult_r;[Apply gt_P1_1|Apply gt_Sn_O].
Save P1_fvarlift1.

Goal (b:bool)(M,N:(TS b))(reg_fvarlift2 b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros.
Change (gt (mult (S(S O)) (mult (P1 true s) (P1 true t)))
           (mult (S(S O)) (P1 true t))).
(* Auto *)Apply gt_mult_reg_l;
[Apply gt_Sn_O|Apply gt_mult_l;[Apply gt_P1_1|Apply gt_S_r;Apply gt_P1_1]].
Save P1_fvarlift2.

Goal (b:bool)(M,N:(TS b))(reg_rvarcons b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros.
Change (gt (mult (mult (S(S O)) (power2 (S n))) (plus (P1 false a) (P1 true s)))
           (mult (power2 (S n)) (P1 true s))).
Rewrite mult_plus_distr_r;Apply gt_plus_trans_l;Apply gt_mult_reg_r.
(* Auto *)Apply gt_S_r;Apply gt_P1_1.
(* Auto *)Apply gt_mult_l;[Apply gt_Sn_n|Apply gt_power2_O].
Save P1_rvarcons.

Goal (b:bool)(M,N:(TS b))(reg_rvarlift1 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros.
Change <nat>(mult (mult (S(S O)) (power2 (S n))) (P1 true s))=
            (mult (power2 (S n)) (mult (P1 true s) (S(S O)))).
Elim mult_assoc_l;Elim (mult_permut (power2 (S n)) (S (S O)) (P1 true s)).
(* Auto *)Apply eq_mult_reg_r;Apply mult_sym.
Save P1_rvarlift1.

Goal (b:bool)(M,N:(TS b))(reg_rvarlift2 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros.
Change <nat>(mult (mult (S(S O)) (power2 (S n))) (mult (P1 true s) (P1 true t)))
           =(mult (power2 (S n)) (mult (P1 true s) (mult (S(S O)) (P1 true t)))).
Elim (mult_sym (power2 (S n)) (S(S O)));Elim mult_assoc_l.
(* Auto *)Apply eq_mult_reg_r;Apply mult_permut.
Save P1_rvarlift2.

Goal (b:bool)(M,N:(TS b))(reg_assenv b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Apply mult_assoc_r.
Save P1_assenv.

Goal (b:bool)(M,N:(TS b))(reg_mapenv b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Apply mult_plus_distr.
Save P1_mapenv.

Goal (b:bool)(M,N:(TS b))(reg_shiftcons b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl;Elim plus_n_O.
(* Auto *)Apply gt_plus_trans_r;Apply gt_plus_l;Apply gt_S_r;Apply gt_P1_1.
Save P1_shiftcons.

Goal (b:bool)(M,N:(TS b))(reg_shiftlift1 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Elim plus_n_O.
(* Auto *)Apply sym_equal;Apply mult_n_2.
Save P1_shiftlift1.

Goal (b:bool)(M,N:(TS b))(reg_shiftlift2 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Do 2 (Elim plus_n_O).
(* Auto *)Apply sym_equal;Apply mult_plus_distr_r.
Save P1_shiftlift2.

Goal (b:bool)(M,N:(TS b))(reg_lift1 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Apply refl_equal.
Save P1_lift1.

Goal (b:bool)(M,N:(TS b))(reg_lift2 b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Apply mult_assoc_l.
Save P1_lift2.

Goal (b:bool)(M,N:(TS b))(reg_liftenv b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl;Rewrite mult_plus_distr_r.
(* Auto *)Apply gt_reg_r;Apply gt_mult_l;
[Apply gt_P1_1|Apply gt_S_r;Apply gt_P1_1].
Save P1_liftenv.

Goal (b:bool)(M,N:(TS b))(reg_idl b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl;Elim plus_n_O.
(* Auto *)Apply gt_plus_r;Apply gt_S_r;Apply gt_P1_1.
Save P1_idl.

Goal (b:bool)(M,N:(TS b))(reg_idr b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl.
(* Auto *)Apply gt_mult_r;[Apply gt_Sn_n|Apply gt_S_r;Apply gt_P1_1].
Save P1_idr.

Goal (b:bool)(M,N:(TS b))(reg_liftid b M N)-><nat>(P1 b M)=(P1 b N).
Induction 1;Intros;Simpl;Apply refl_equal.
Save P1_liftid.

Goal (b:bool)(M,N:(TS b))(reg_id b M N)->(gt (P1 b M) (P1 b N)).
Induction 1;Intros;Simpl.
(* Auto *)Apply gt_mult_r;[Apply gt_Sn_n|Apply gt_S_r;Apply gt_P1_1].
Save P1_id.


Provide Pol1.
