
(*****************************************************************************)
(*          Projet Coq  - Calculus of Inductive Constructions V5.8           *)
(*****************************************************************************)
(*                                                                           *)
(*      Meta-theory of the explicit substitution calculus lambda-env         *)
(*      Amokrane Saibi                                                       *)
(*                                                                           *)
(*      September 1993                                                       *)
(*                                                                           *)
(*****************************************************************************)


                               (* Theoreme de Newman *)

Require sur_les_relations.

Section Newman.
 Variable A: Set.
 Variable R: A->A->Prop.
 Hypothesis N: (noetherian  A R).
 Hypothesis C: (local_confluence A R).

   Theorem Newman: (confluence A R).
   Goal.
   Unfold confluence;Intro x;Pattern x;Apply (noetherian_induction1 A R N).
   Intros y H1;Unfold confluence'.
   Intros y0 z H2 H3;Elim (star_case A R y z H3);Intro H4.
   Exists y0;Split.
   Apply star_refl.
   Rewrite <- H4;Assumption.
   Elim (star_case A R y y0 H2);Intro H5.
   Exists z;Split.
   Rewrite <- H5;Assumption.
   Apply star_refl.
   Elim H5;Intros y0' H6;Elim H6;Intros H7 H8.
   Elim H4;Intros z' H9;Elim H9;Intros H10 H11.
   Elim (C y y0' z' H7 H10);Intros y' H12.
   Elim H12;Intros H13 H14.
   Elim (H1 y0' H7 y0 y'  H8 H13);Intros y'' H15.
   Elim H15;Intros H16 H17.
   Elim (H1 z' H10 y'' z (star_trans A R  z' y' y'' H14 H17) H11).
   Intros u H18;Elim H18;Intros H19 H20.
   Exists u;Split.
   Apply star_trans with y'';Assumption.
   Assumption.
   Save.
End Newman.

Provide Newman.


